/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.IResultHolderListener;
import com.kingdee.eas.fi.rpt.app.QueryCommand;
import com.kingdee.eas.fi.rpt.app.QuerySolution;
import com.kingdee.eas.fi.rpt.app.ResultHolder;
import com.kingdee.eas.fi.rpt.app.WhereItem;
import java.math.BigDecimal;

public class CurrencyQuery
extends QuerySolution {
    public CurrencyQuery(QueryCommand qc) {
        super(qc);
    }

    public void add(String currencyNumber, AcctCalculaterExt acct) {
        ResultHolder rh = ResultHolder.createCommonAndShareModeResultHolder();
        rh.addIResultHolderListener(new ResultHolderListener(acct, currencyNumber));
        this.resultHolderSetConfig.addResultHolder(currencyNumber, rh);
    }

    @Override
    protected void initSolutionConfig() {
        String[] groupConditionField = new String[]{"FNumber"};
        this.resultHolderSetConfig.setGroupConditionField(groupConditionField);
        this.queryParamer.setStaticFromPart("T_BD_Currency");
        this.queryParamer.setStaticSelectField("FID ,FNumber,FPrecision");
    }

    private class ResultHolderListener
    extends IResultHolderListener {
        private AcctCalculaterExt acct;
        private String currencyNumber;

        public ResultHolderListener(AcctCalculaterExt _acct, String _currencyNumber) {
            this.acct = _acct;
            this.currencyNumber = _currencyNumber;
        }

        @Override
        public String[] getResultHolderOrderedSelectFields() {
            return new String[]{"FID", "FNumber", "FPrecision"};
        }

        @Override
        public Object setResultHolderOrderedSelectFieldsValueObjects(Object[] value) {
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)value[0].toString()));
            currency.setNumber(value[1].toString());
            if (currency.getNumber().equals("GLC") || currency.getNumber().equals("GRC")) {
                currency.setPrecision(this.acct.getCompany().getBaseCurrency().getPrecision());
            } else {
                currency.setPrecision(Integer.parseInt(value[2].toString()));
            }
            BigDecimal _DPV = new BigDecimal("0");
            currency.put("_DPV", (Object)_DPV.setScale(currency.getPrecision(), 4));
            this.acct.setCurrency(currency);
            return currency;
        }

        @Override
        public WhereItem generateWhereItem() {
            WhereItem whereItem = WhereItem.createModeOneWhereItem();
            whereItem.addItem("FNumber", this.currencyNumber);
            return whereItem;
        }

        @Override
        public void setResultHolderOrderedSharedObject(Object obj) {
            this.acct.setCurrency((CurrencyInfo)obj);
        }
    }
}

