/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class ExecuteBatch {
    public void executeBatch(Context ctx, List<String> executeSqls) throws SQLDataException {
        Statement st = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            for (int i = 0; i < executeSqls.size(); ++i) {
                st.addBatch(executeSqls.get(i));
                if ((i + 1) % 1000 != 0) continue;
                st.executeBatch();
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
    }

    public void executePreparedBatch(Context ctx, String preparedSql, int preparedParamSize, List<Object[]> paramsArray) throws SQLDataException {
        PreparedStatement ps = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(preparedSql);
            int size = paramsArray.size();
            for (int i = 0; i <= size; ++i) {
                for (int j = 1; j <= preparedParamSize; ++j) {
                    ps.setObject(j, paramsArray.get(i)[j - 1]);
                }
                ps.addBatch();
                if (i % 1000 != 0 && i + 1 <= size) continue;
                ps.executeBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }
}

