/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.rpt.AcctStruct;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.AbstractFunctionWebserviceFacadeControllerBean;
import com.kingdee.eas.fi.rpt.app.IFunctionBatchFetch;
import com.kingdee.eas.fi.rpt.batch.AcctBatchCalculaterNew;
import com.kingdee.eas.fi.rpt.batch.IParamBackFill;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class FunctionWebserviceFacadeControllerBean
extends AbstractFunctionWebserviceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.rpt.app.FunctionWebserviceFacadeControllerBean");

    @Override
    protected String[] _fetchData(Context ctx, String function, String[][] parameters) throws BOSException {
        GlUtils.updateBalance();
        IFunctionBatchFetch functionImpl = this.getFunctionImpl(ctx, function, parameters);
        if (functionImpl != null) {
            return (String[])functionImpl.execute();
        }
        return new String[]{"No supportted function. "};
    }

    private IFunctionBatchFetch getFunctionImpl(Context ctx, String name, String[][] parameters) {
        AcctBatchFetchImpl batch = null;
        if ("acct".equalsIgnoreCase(name)) {
            batch = new AcctBatchFetchImpl(ctx, parameters);
        }
        return batch;
    }

    class AcctCalculateBackFiller
    implements IBackfillHandler,
    IParamBackFill {
        private Throwable _exception;
        private BigDecimal _result;
        private Parameter param = new Parameter((Object[])new Variant[]{new Variant((Object)"0")}, "sheet1");

        public void setValue(Object value) {
            if (this._result == null) {
                this._result = new BigDecimal("0");
            }
            if (value instanceof BigDecimal) {
                this._result = this._result.add((BigDecimal)value);
            } else {
                try {
                    this._result = this._result.add(new BigDecimal(value.toString()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void setException(Throwable exception) {
            this._exception = exception;
            IErrorProvider errorProvider = ReportCalculateErrorProvider.getErrorProvider(exception.getClass());
            if (errorProvider != null && exception instanceof Exception) {
                Object object = errorProvider.getProperValue((Exception)exception).getValue();
            }
        }

        public Parameter getParameter() {
            return this.param;
        }

        public Throwable getException() {
            return this._exception;
        }

        public Object getValue() {
            if (this.param.getValue() != null) {
                Object value = this.param.getValue();
                if (value instanceof Exception) {
                    return "#BAD FUNCTION " + ((Exception)value).getMessage();
                }
                return value;
            }
            if (this._result == null) {
                if (this._exception != null) {
                    return "#BAD FUNCTION " + this._exception.getMessage();
                }
                return "0";
            }
            return this._result;
        }
    }

    class AcctBatchFetchImpl
    implements IFunctionBatchFetch {
        private Context ctx;
        private String[][] params;

        public AcctBatchFetchImpl(Context ctx, String[][] params) {
            this.ctx = ctx;
            this.params = params;
        }

        @Override
        public Object[] execute() {
            AcctBatchCalculaterNew batcher = new AcctBatchCalculaterNew(this.ctx);
            try {
                batcher.init();
            }
            catch (SQLException e1) {
                return null;
            }
            IBackfillHandler[] results = new IBackfillHandler[this.params.length];
            for (int i = 0; i < this.params.length; ++i) {
                String[] paramList = this.params[i];
                AcctStruct acct = null;
                try {
                    acct = new AcctStruct(paramList[0], paramList[1], BalanceTypeEnum.getEnum(paramList[2]), Integer.parseInt(paramList[3]), Integer.parseInt(paramList[4]), Integer.parseInt(paramList[5]), Integer.parseInt(paramList[6]), paramList[7].toUpperCase());
                }
                catch (Throwable e) {
                    results[i] = new AcctCalculateBackFiller();
                    results[i].setException((Throwable)new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED));
                    continue;
                }
                acct.setServerCtx(this.ctx);
                AcctCalculateBackFiller acctCalculateBackFiller = new AcctCalculateBackFiller();
                results[i] = acctCalculateBackFiller;
                acct.setBackFiller(acctCalculateBackFiller);
                if (paramList.length >= 9) {
                    String include = paramList[8];
                    boolean b = RptUtil.isTrue(include, false);
                    acct.setIncludeVoucher(b);
                } else {
                    acct.setIncludeVoucher(false);
                }
                acct.setCheckDataRight(false);
                try {
                    acct.check();
                    batcher.addFormula(acct);
                    continue;
                }
                catch (Exception e) {
                    acct.getBackFiller().setException((Throwable)e);
                }
            }
            batcher.isUseNewBatchLogic = true;
            DebugLogger.isDebug = false;
            batcher.setWhereSize(100);
            batcher.execute();
            try {
                batcher.clearUp();
            }
            catch (SQLException e) {
                logger.debug((Object)e.getMessage());
            }
            Object[] rs = new String[results.length];
            for (int i = 0; i < results.length; ++i) {
                rs[i] = results[i].getValue().toString();
            }
            return rs;
        }
    }
}

