/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.app.AbstractProfitAcctFindLedgerFacadeControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProfitAcctFindLedgerFacadeControllerBean
extends AbstractProfitAcctFindLedgerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.rpt.app.ProfitAcctFindLedgerFacadeControllerBean");
    private static final String TRUE = "1";

    @Override
    protected CompanyOrgUnitInfo _getProfitCompanyInfo(Context ctx, String profitCenterCompanyNumber) throws BOSException {
        CompanyOrgUnitInfo company = null;
        String sql = this.getProfitCompanySql(ctx, profitCenterCompanyNumber);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                company = new CompanyOrgUnitInfo();
                company.setName(rs.getString("FName_l1"), Locale.ENGLISH);
                company.setName(rs.getString("FName_l2"), Locale.SIMPLIFIED_CHINESE);
                company.setName(rs.getString("FName_l3"), Locale.TRADITIONAL_CHINESE);
                company.setIsProfitOrgUnit(true);
                company.setIsCompanyOrgUnit(false);
                company.setId(BOSUuid.read((String)rs.getString("FID")));
                company.setNumber(rs.getString("FNumber"));
                company.setIsBizUnit(TRUE.equals(rs.getString("FIsBizUnit")));
                if (!StringUtils.isEmpty((String)rs.getString("FIsOnlyUnion"))) {
                    company.setIsOnlyUnion(TRUE.equals(rs.getString("FIsOnlyUnion")));
                }
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rs.getString("FControlUnitID")));
                company.setCU(cu);
                if (!StringUtils.isEmpty((String)rs.getString("FAccountTableID"))) {
                    AccountTableInfo acTable = new AccountTableInfo();
                    acTable.setId(BOSUuid.read((String)rs.getString("FAccountTableID")));
                    acTable.setNumber(rs.getString("tableNumber"));
                    acTable.setSeparator(rs.getString("tableSeparator"));
                    company.setAccountTable(acTable);
                }
                if (!StringUtils.isEmpty((String)rs.getString("FAccountPeriodID"))) {
                    PeriodTypeInfo pti = new PeriodTypeInfo();
                    pti.setId(BOSUuid.read((String)rs.getString("FAccountPeriodID")));
                    company.setAccountPeriodType(pti);
                }
                if (!StringUtils.isEmpty((String)rs.getString("FLongNumber"))) {
                    company.setLongNumber(rs.getString("FLongNumber"));
                }
                company.put("DELEGATED_COMPANY_ID", (Object)rs.getString("FCompanyID"));
                company.put("DELEGATED_COMPANY_LONG_NUMBER", (Object)rs.getString("FCompanyLongNumber"));
            } else {
                company = new CompanyOrgUnitInfo();
                this.setVirutalProfitCenterInfoToAcct(ctx, profitCenterCompanyNumber, company);
                this.handleVirutalProfitCenter(ctx, company);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return company;
    }

    private String getProfitCompanySql(Context ctx, String profitCenterCompanyNumber) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT company.FName_l1 FName_l1,company.FName_l2 FName_l2,company.FName_l3 FName_l3, company.FIsBizUnit FIsBizUnit , company.FNumber FNumber , delegatedCompany.FIsOnlyUnion FIsOnlyUnion, \n");
        sb.append(" accountTable.FSeparator tableSeparator , delegatedCompany.FAccountTableID FAccountTableID , \n");
        sb.append(" company.FControlUnitID FControlUnitID , delegatedCompany.FId FCompanyID , delegatedCompany.FLongNumber FCompanyLongNumber , \n");
        sb.append(" delegatedCompany.FAccountPeriodID FAccountPeriodID , company.FID FID , company.FLongNumber FLongNumber , accountTable.FNumber tableNumber \n");
        sb.append(" FROM T_Org_ProfitCenter company \n");
        sb.append(" inner join t_org_UnitRelation ur on ur.FFromUnitId = company.fid \n");
        sb.append(" inner join T_Org_TypeRelation tr on tr.fid = ur.FTypeRelationID and tr.FFromType = 6 and tr.FToType = 1 \n");
        sb.append(" inner join T_ORG_Company delegatedCompany on delegatedCompany.fid = ur.FToUnitID \n");
        sb.append(" left outer join T_BD_AccountTable accountTable on accountTable.FID = delegatedCompany.FAccountTableID \n");
        sb.append("  WHERE company.FNumber = '" + profitCenterCompanyNumber + "'");
        return sb.toString();
    }

    public CompanyOrgUnitInfo handleVirutalProfitCenter(Context ctx, CompanyOrgUnitInfo company) throws BOSException {
        logger.error((Object)"start handle_virutal_profitCenter");
        if (company == null || company.isIsBizUnit()) {
            return company;
        }
        String profitCenterLongNumber = company.getLongNumber();
        String fiCompanyLongNumber = this.queryCommonFICompany(ctx, profitCenterLongNumber);
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add("id");
        selectors.add("isOnlyUnion");
        selectors.add("accountPeriod.id");
        selectors.add("accountTable.id");
        selectors.add("accountTable.number");
        selectors.add("accountTable.separator");
        selectors.add("accountPeriodType.id");
        if (fiCompanyLongNumber != null) {
            view.setFilter(new FilterInfo());
            view.getFilter().appendFilterItem("longNumber", (Object)fiCompanyLongNumber);
            logger.error((Object)("update ficompany filter:" + view));
            CompanyOrgUnitCollection fiCompanys = icompany.getCompanyOrgUnitCollection(view);
            if (!fiCompanys.isEmpty()) {
                CompanyOrgUnitInfo fiCompany = fiCompanys.get(0);
                logger.error((Object)("update_profitcenter_ficompany(" + fiCompany + ")"));
                company.setIsOnlyUnion(!company.isIsBizUnit());
                company.setAccountTable(fiCompany.getAccountTable());
                company.setAccountPeriodType(fiCompany.getAccountPeriodType());
                company.put("DELEGATED_COMPANY_ID", (Object)fiCompany.getId().toString());
                company.put("DELEGATED_COMPANY_LONG_NUMBER", (Object)fiCompanyLongNumber);
            }
        }
        logger.error((Object)"end handle_virutal_profitCenter");
        return company;
    }

    private String queryCommonFICompany(Context ctx, String profitCenterLongNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("\tSELECT \tdelegatedCompany.fLongNumber company_longNumber,company.FLongNumber profit_longNumber    \n");
        sql.append("\tFROM T_Org_ProfitCenter company    \n");
        sql.append("    INNER JOIN t_org_UnitRelation ur    \n");
        sql.append("        ON ur.FFromUnitId = company.fid    \n");
        sql.append("    INNER JOIN T_Org_TypeRelation tr    \n");
        sql.append("        ON ((tr.fid = ur.FTypeRelationID AND tr.FFromType = 6) AND    \n");
        sql.append("           tr.FToType = 1)    \n");
        sql.append("    INNER JOIN T_ORG_Company delegatedCompany    \n");
        sql.append("        ON delegatedCompany.fid = ur.FToUnitID    \n");
        sql.append("\tWHERE\t\n");
        sql.append(" company.FLongNumber like concat('").append(profitCenterLongNumber).append("', '!%') \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String fiCompanyLongNumber = null;
        try {
            if (rs.next()) {
                fiCompanyLongNumber = rs.getString("company_longNumber");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return fiCompanyLongNumber;
    }

    private void setVirutalProfitCenterInfoToAcct(Context ctx, String profitCenterCompanyNumber, CompanyOrgUnitInfo company) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT profit.FID FID,profit.FNumber FNumber,profit.FIsBizUnit FIsBizUnit,profit.FLongNumber FLongNumber, \n").append(" profit.FControlUnitID FControlUnitID \n").append(" FROM T_ORG_ProfitCenter profit \n").append(" WHERE profit.FIsBizUnit = 0 and profit.Fnumber = '" + profitCenterCompanyNumber + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                String profitNumber = rs.getString("FNumber");
                String longNumber = rs.getString("FLongNumber");
                String id = rs.getString("FID");
                boolean isbizunit = Boolean.valueOf(rs.getString("FIsBizUnit"));
                String cuID = rs.getString("FControlUnitID");
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)cuID));
                company.setId(BOSUuid.read((String)id));
                company.setNumber(profitNumber);
                company.setIsBizUnit(isbizunit);
                company.setLongNumber(longNumber);
                company.setIsProfitOrgUnit(true);
                company.setIsCompanyOrgUnit(false);
                company.setCU(cu);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }
}

