/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.eas.fi.rpt.app.QueryParameter;
import com.kingdee.eas.fi.rpt.app.WhereItem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class QueryCommand {
    private boolean canExecute = true;
    private static final int EXC_MODE_NONE = 1;
    private static final int EXC_MODE_TOWE = 2;
    private int EXC_MODE = 1;
    private Connection conn = null;
    private QueryParameter query = null;
    private int groupSize = 50;
    private ArrayList whereItemList = null;
    private int currentWhereItemIndex = 0;
    private PreparedStatement ps = null;
    private int preparedStatementParamIndex = 0;
    private WhereItem tempWhereItem = null;
    private String tempModeOneConstSQL = null;
    private String tempModeTwoConstSQL = null;
    private HashMap dymaticDomain = new HashMap(1);
    private boolean isNullWhereItemData;

    public void init(Connection con) {
        this.conn = con;
    }

    private void registQuery(QueryParameter _query) {
        this.query = _query;
        if (this.query == null) {
            this.canExecute = false;
            return;
        }
        this.whereItemList = this.query.getWhereItemList();
        if (this.whereItemList.size() <= 0) {
            this.canExecute = false;
            return;
        }
        this.tempWhereItem = (WhereItem)this.whereItemList.get(0);
        this.EXC_MODE = this.tempWhereItem.getWhereItemMode() == 1 ? 1 : 2;
        this.isNullWhereItemData = this.tempWhereItem.whereItemToWhereDataString() == null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(this.query.getSelectField());
        sql.append(" FROM ");
        sql.append(this.query.getStaticFromPart());
        if (this.EXC_MODE == 2) {
            this.tempModeTwoConstSQL = sql.toString();
        } else {
            sql.append(" WHERE ");
            if (this.query.getStaticWherePart().trim().length() > 0) {
                sql.append(this.query.getStaticWherePart());
                sql.append(" AND ");
            }
            this.tempModeOneConstSQL = sql.toString();
        }
        this.canExecute = true;
    }

    public void executeQuery(QueryParameter _query) throws SQLException {
        this.registQuery(_query);
        if (this.conn == null || !this.canExecute) {
            return;
        }
        this.initMaxQueryGroup();
        this.currentWhereItemIndex = 0;
        ResultSet rs = null;
        while (true) {
            try {
                rs = this.nextGroup();
                if (rs == null) {
                    return;
                }
                this.query.exportResultData(rs);
                continue;
            }
            finally {
                if (rs == null) continue;
                rs.close();
                continue;
            }
            break;
        }
    }

    private void initMaxQueryGroup() {
        if (this.tempWhereItem != null) {
            int usedCharCount = 200;
            usedCharCount += this.query.getSelectField().length();
            usedCharCount += this.query.getGroupbyPart().length();
            usedCharCount += this.query.getStaticFromPart().length();
            this.groupSize = (32768 - (usedCharCount += this.query.getStaticWherePart().length())) / this.tempWhereItem.OneItemIncreamentSize();
        }
    }

    private ResultSet nextGroup() throws SQLException {
        if (this.currentWhereItemIndex >= this.whereItemList.size()) {
            return null;
        }
        if (this.EXC_MODE == 2) {
            return this.excMode2();
        }
        return this.excBatch();
    }

    private ResultSet excNoBatch() throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.tempModeOneConstSQL);
        int i = 0;
        while (this.currentWhereItemIndex < this.whereItemList.size()) {
            if (i == 0) {
                sql.append("(");
            }
            if (i > 0) {
                sql.append(" OR ");
            }
            WhereItem item = (WhereItem)this.whereItemList.get(this.currentWhereItemIndex);
            sql.append(item.whereItemToWhereDataString());
            if (this.currentWhereItemIndex + 1 == this.whereItemList.size()) {
                sql.append(")");
            }
            ++this.currentWhereItemIndex;
            ++i;
        }
        sql.append(this.query.getGroupbyPart());
        Statement smt = this.conn.createStatement();
        return smt.executeQuery(sql.toString());
    }

    private ResultSet excBatch() throws SQLException {
        if (this.whereItemList.size() - this.currentWhereItemIndex < this.groupSize) {
            return this.excNoBatch();
        }
        this.bulidPreparedStatement();
        this.preparedStatementParamIndex = 1;
        int i = 0;
        while (i < this.groupSize) {
            WhereItem item = (WhereItem)this.whereItemList.get(this.currentWhereItemIndex);
            item.loadDataToPreparedStatement(this.preparedStatementParamIndex, this.ps);
            this.preparedStatementParamIndex += item.whereItemParamCount();
            ++i;
            ++this.currentWhereItemIndex;
        }
        return this.ps.executeQuery();
    }

    private ResultSet excMode2() throws SQLException {
        this.dymaticDomain.clear();
        StringBuffer sqlWhereBuf = new StringBuffer();
        StringBuffer autoFromPartBuf = new StringBuffer();
        for (int i = 0; this.currentWhereItemIndex < this.whereItemList.size() && i < this.groupSize; ++i) {
            WhereItem item = (WhereItem)this.whereItemList.get(this.currentWhereItemIndex);
            String whereItem = item.whereItemToWhereDataString();
            if (!this.isNullWhereItemData) {
                if (i == 0) {
                    sqlWhereBuf.append("(");
                }
                if (i > 0) {
                    sqlWhereBuf.append(" OR ");
                }
                sqlWhereBuf.append(item.whereItemToWhereDataString());
                if (i + 1 == this.groupSize || this.currentWhereItemIndex + 1 == this.whereItemList.size()) {
                    sqlWhereBuf.append(")");
                }
            }
            if (this.dymaticDomain.get(item.getDymaticFromPartFieldValue()) == null) {
                this.dymaticDomain.put(item.getDymaticFromPartFieldValue(), "ok");
                if (autoFromPartBuf.length() > 0) {
                    autoFromPartBuf.append(" union ");
                }
                autoFromPartBuf.append(" select ");
                autoFromPartBuf.append("'");
                autoFromPartBuf.append((String)item.getDymaticFromPartFieldValue());
                autoFromPartBuf.append("' as fnmb ");
            }
            ++this.currentWhereItemIndex;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.tempModeTwoConstSQL);
        sql.append(" inner join (");
        sql.append(autoFromPartBuf.toString());
        sql.append(") t on 1=1 WHERE ");
        if (this.query.getStaticWherePart().trim().length() > 0) {
            sql.append(this.query.getStaticWherePart());
            if (!this.isNullWhereItemData) {
                sql.append(" AND ");
            }
        }
        if (!this.isNullWhereItemData) {
            sql.append(sqlWhereBuf.toString());
        }
        sql.append(this.query.getGroupbyPart());
        Statement smt = this.conn.createStatement();
        String tmp = sql.toString();
        return smt.executeQuery(tmp);
    }

    private void bulidPreparedStatement() throws SQLException {
        if (this.currentWhereItemIndex == 0) {
            StringBuffer sql = new StringBuffer();
            sql.append(this.tempModeOneConstSQL);
            for (int i = 0; i < this.groupSize; ++i) {
                if (i == 0) {
                    sql.append("(");
                }
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(this.tempWhereItem.whereItemToWhereParamString());
                if (i + 1 != this.groupSize) continue;
                sql.append(") ");
            }
            sql.append(this.query.getGroupbyPart());
            this.ps = this.conn.prepareStatement(sql.toString());
        }
    }

    public static QueryParameter createQueryParameter() {
        return new QueryParameter();
    }
}

