/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.CompareValueType;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.BindingPropertyInfo;
import com.kingdee.eas.base.codingrule.CodingRuleEntryCollection;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.IIntermilNO;
import com.kingdee.eas.base.codingrule.IntermilNOCollection;
import com.kingdee.eas.base.codingrule.IntermilNOFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CheckSchemeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CheckSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICheckScheme;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IPostil;
import com.kingdee.eas.fi.rpt.IRptHistory;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PostilFactory;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptHistoryFactory;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.app.AbstractReportBaseControllerBean;
import com.kingdee.eas.fi.rpt.app.ExecuteBatch;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportBaseControllerBean
extends AbstractReportBaseControllerBean {
    private static Logger logger = Logger.getLogger(ReportBaseControllerBean.class);

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("update " + this.getMasterTable(ctx) + "  set");
        _sql.append(" FAuditedStatus = ?");
        _sql.append(",FAuditorId = ?");
        _sql.append(",FAuditedTime = ?");
        _sql.append(" where fid = ?");
        Object[] params = new Object[4];
        params[0] = new Integer(2);
        params[1] = ctx.getCaller().toString();
        Date date = new Date();
        long time = date.getTime();
        params[2] = new Timestamp(time);
        params[3] = pk.toString();
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    protected void savePlace(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ReportBaseInfo reportBaseInfo = (ReportBaseInfo)model;
        super._update(ctx, pk, (IObjectValue)reportBaseInfo);
    }

    protected void _checkUnaudit(Context ctx, IObjectPK pk, UserInfo auditor) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("committedStatus"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        ReportBaseInfo reportBase = this.getReportBaseInfo(ctx, pk);
        if (reportBase == null) {
            throw new RptAndTempException(new NumericExceptionSubItem("004", "RptIsDeleted"));
        }
        boolean isPublished = reportBase.getPublishedStatus().getValue() == 2;
        boolean isUnAudited = reportBase.getAuditedStatus().getValue() == 1;
        int commitStatus = reportBase.getCommittedStatus().getValue();
        if (isPublished) {
            throw new RptAndTempException(new NumericExceptionSubItem("004", "RptIsPublished"));
        }
        if (isUnAudited) {
            throw new RptAndTempException(new NumericExceptionSubItem("004", "RptIsUnAudited"));
        }
        if (commitStatus == 2) {
            throw new RptAndTempException(new NumericExceptionSubItem("004", "RptIsCommited"));
        }
        if (commitStatus == 3) {
            boolean isCslReport;
            int reportType = reportBase.getSourceType().getValue();
            boolean bl = isCslReport = reportType == 2 || reportType == 3 || reportType == 11 || reportType == 12 || reportType == 14 || reportType == 15;
            if (!(reportBase instanceof CslReportInfo && isCslReport && CslRptUtil.isCslTopLevelAtServer((Context)ctx, (CslReportInfo)((CslReportInfo)reportBase)))) {
                throw new RptAndTempException(new NumericExceptionSubItem("004", "RptIsGroupCommited"));
            }
        }
        if (reportBase.getAuditor() != null && !auditor.getId().toString().equals(reportBase.getAuditor().getId().toString()) && CslRptUtil.canUnAuditCheck((Context)ctx)) {
            throw new RptAndTempException(RptAndTempException.UNADITE_SAMECREATOR);
        }
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        if (!new ReportInfo().getBOSType().equals((Object)BOSUuid.read((String)pk.toString()).getType())) {
            this._checkUnaudit(ctx, pk, userInfo);
        }
        StringBuffer _sql = new StringBuffer("update " + this.getMasterTable(ctx) + "  set");
        _sql.append(" FAuditedStatus = ?");
        _sql.append(",FAuditorId = null");
        _sql.append(",FAuditedTime = null");
        _sql.append(" where fid = ?");
        Object[] params = new Object[]{new Integer(1), pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        DbUtil.execute((Context)ctx, (String)"update t_rpt_report set FAuditedStatus=?,FAuditorId=null,FAuditedTime=null where fcslreportid=?", (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    @Override
    protected HashMap _fetchInitData(Context ctx) throws BOSException {
        HashMap<String, CurrencyCollection> initHashMap = new HashMap<String, CurrencyCollection>();
        ICurrency initICurrcny = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewCurrency = new EntityViewInfo();
        SelectorItemCollection sicCurrency = viewCurrency.getSelector();
        sicCurrency.add(new SelectorItemInfo("id"));
        sicCurrency.add(new SelectorItemInfo("number"));
        sicCurrency.add(new SelectorItemInfo("name"));
        CurrencyCollection initCurrencyCollection = initICurrcny.getCurrencyCollection(viewCurrency);
        initHashMap.put("0", initCurrencyCollection);
        return initHashMap;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.isAllowUpdate(ctx, pk, model);
        this.checktempCodeDump(ctx, (ReportBaseInfo)model);
        boolean isAudite = this._isAudited(ctx, pk);
        if ((model instanceof ReportInfo || model instanceof CslReportInfo) && model.get("isSchemeUpdate") != null) {
            isAudite = false;
        }
        if (isAudite) {
            throw new RptAndTempException(RptAndTempException.CANNTUPDATE_AUDITED);
        }
        ReportBaseInfo reportBaseInfo = (ReportBaseInfo)model;
        this.isBookNull(reportBaseInfo);
        super._update(ctx, pk, (IObjectValue)reportBaseInfo);
        if (!(model instanceof ReportInfo || model instanceof TemplateInfo || model instanceof CslReportInfo)) {
            this.updateReportAttach(ctx, (IObjectValue)reportBaseInfo);
        }
    }

    protected boolean _isAudited(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReportBaseInfo reportBaseInfo = this.getReportBaseInfo(ctx, pk, this.getSelectorForAudit());
        return reportBaseInfo.getAuditedStatus() != null && reportBaseInfo.getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED) && this.isNotSingleRpt(reportBaseInfo);
    }

    private boolean isNotSingleRpt(ReportBaseInfo reportBaseInfo) {
        boolean result = true;
        if (reportBaseInfo.getSourceType().equals((Object)RptSrcTypeEnum.SINGLEEXTRACTDATA)) {
            result = false;
        }
        return result;
    }

    private SelectorItemCollection getSelectorForAudit() {
        SelectorItemCollection selectorForAudit = null;
        selectorForAudit = new SelectorItemCollection();
        selectorForAudit.add(new SelectorItemInfo("auditedStatus"));
        selectorForAudit.add(new SelectorItemInfo("sourceType"));
        return selectorForAudit;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.recycleNumberByOrg(ctx, pk);
        this._delete(ctx, pk, false);
    }

    protected void recycleNumberByOrg(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        boolean useIntermitNumber;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        ReportBaseInfo reportBase = (ReportBaseInfo)this.getValue(ctx, pk, sic);
        if (StringUtils.isEmpty((String)reportBase.getNumber())) {
            return;
        }
        CompanyOrgUnitInfo company = this.getCompanyForNumber(ctx, reportBase);
        if (null == company || null == company.getId()) {
            return;
        }
        String companyId = company.getId().toString();
        CodingRuleInfo codingRule = null;
        String orgUnitId = null;
        BindingPropertyInfo bindingProperty = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)reportBase, companyId, "sourceType");
        if (!isCodingRule) {
            isCodingRule = iCodingRuleManager.isExist((IObjectValue)reportBase, companyId);
        }
        if (isCodingRule && (codingRule = iCodingRuleManager.getCodingRule((IObjectValue)reportBase, companyId, "sourceType")) == null) {
            codingRule = iCodingRuleManager.getCodingRule((IObjectValue)reportBase, companyId);
        }
        if (codingRule != null) {
            orgUnitId = codingRule.getAppOrgUnit().getId().toString();
            bindingProperty = codingRule.getBindingProperty();
        }
        if (StringUtils.isEmpty(orgUnitId)) {
            orgUnitId = companyId;
        }
        if (!(useIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)reportBase, companyId, "sourceType"))) {
            useIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)reportBase, companyId);
        }
        if (isCodingRule && useIntermitNumber) {
            if (bindingProperty != null && bindingProperty.getPropertyName() != null) {
                iCodingRuleManager.recycleNumber((IObjectValue)reportBase, orgUnitId, bindingProperty.getPropertyName(), "", reportBase.getNumber());
            } else {
                iCodingRuleManager.recycleNumber((IObjectValue)reportBase, orgUnitId, reportBase.getNumber());
            }
        }
    }

    protected ICodingRuleManager getCodingRuleCtrl(Context ctx) throws BOSException {
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx);
    }

    private void deleteCommCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IRptHistory iRptHsitory = RptHistoryFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("report", (Object)pk.toString());
        FilterItemInfo filterItemInfo1 = new FilterItemInfo("auditedStatus", (Object)new Integer(2));
        filterInfo.getFilterItems().add(filterItemInfo);
        filterInfo.getFilterItems().add(filterItemInfo1);
        boolean extists = iRptHsitory.exists(filterInfo);
        if (extists) {
            throw new RptAndTempException(RptAndTempException.RPTHISTORYAUDIT);
        }
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ReportBaseInfo reportBaseInfo = (ReportBaseInfo)model;
        this.setRuleNumber(ctx, (ReportBaseInfo)model);
        this.checktempCodeDump(ctx, reportBaseInfo);
        this.isBookNull(reportBaseInfo);
        super._addnew(ctx, pk, (IObjectValue)reportBaseInfo);
        reportBaseInfo.put("id", pk.getKeyValue("id"));
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReportBaseInfo reportBaseInfo = (ReportBaseInfo)model;
        this.setRuleNumber(ctx, (ReportBaseInfo)model);
        this.checktempCodeDump(ctx, reportBaseInfo);
        this.isBookNull(reportBaseInfo);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)reportBaseInfo);
        reportBaseInfo.put("id", pk.getKeyValue("id"));
        return pk;
    }

    private void addReportAttach(Context ctx, ReportBaseInfo reportBaseInfo) throws BOSException, EASBizException {
        PostilCollection postilCollection = reportBaseInfo.getPostils();
        if (postilCollection != null && postilCollection.size() > 0) {
            IPostil iPostil = PostilFactory.getLocalInstance(ctx);
            int postilCollectionSize = postilCollection.size();
            for (int i = 0; i < postilCollectionSize; ++i) {
                PostilInfo postilInfo = postilCollection.get(i);
                postilInfo.setId(null);
                postilInfo.setReport(reportBaseInfo);
                iPostil.addnew((CoreBaseInfo)postilInfo);
            }
        }
    }

    private void updateReportAttach(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReportBaseInfo reportBaseInfo = (ReportBaseInfo)model;
        PostilCollection postilCollection = reportBaseInfo.getPostils();
        if (postilCollection != null && postilCollection.size() > 0) {
            IPostil iPostil = PostilFactory.getLocalInstance(ctx);
            int postilCollectionSize = postilCollection.size();
            for (int i = 0; i < postilCollectionSize; ++i) {
                ObjectStringPK pk;
                PostilInfo postilInfo = postilCollection.get(i);
                if (!postilInfo.getPostilType().equals((Object)PostilTypeEnum.REPORT)) continue;
                postilInfo.setReport(reportBaseInfo);
                if (postilInfo.getStatus() == 1) {
                    iPostil.addnew((CoreBaseInfo)postilInfo);
                    continue;
                }
                if (postilInfo.getStatus() == 2) {
                    pk = new ObjectStringPK();
                    pk.setKeyValue("id", (Object)postilInfo.getId().toString());
                    iPostil.update((IObjectPK)pk, (CoreBaseInfo)postilInfo);
                    continue;
                }
                if (postilInfo.getStatus() != 3) continue;
                pk = new ObjectStringPK();
                pk.setKeyValue("id", (Object)postilInfo.getId().toString());
                iPostil.delete((IObjectPK)pk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _publish(Context ctx, List pk) throws BOSException, EASBizException {
        IObjectPK objectPK = LogUtil.beginLog((Context)ctx, (String)(RptUtil.getReportResource("report", ctx.getOriginLocale()) + RptUtil.getReportResource("Report_Publish", ctx.getOriginLocale())), (BOSObjectType)new ReportInfo().getBOSType(), null, (String)this.getLogDetailString(this.getNumberListByPK(ctx, pk)));
        try {
            StringBuffer _sql = new StringBuffer("update " + this.getMasterTable(ctx) + "  set ");
            _sql.append(" fpublishedStatus=2");
            _sql.append(" where fid = ?");
            for (int i = 1; i < pk.size(); ++i) {
                _sql.append(" or fid = ?");
            }
            DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])pk.toArray());
        }
        finally {
            LogUtil.afterLog((Context)ctx, (IObjectPK)objectPK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _unPublish(Context ctx, List pk) throws BOSException, EASBizException {
        IObjectPK objectPK = LogUtil.beginLog((Context)ctx, (String)(RptUtil.getReportResource("report", ctx.getOriginLocale()) + RptUtil.getReportResource("Report_UnPublish", ctx.getOriginLocale())), (BOSObjectType)new ReportInfo().getBOSType(), null, (String)this.getLogDetailString(this.getNumberListByPK(ctx, pk)));
        try {
            StringBuffer _sql = new StringBuffer("update " + this.getMasterTable(ctx) + " set ");
            _sql.append(" fpublishedStatus=1");
            _sql.append(" where fid = ?");
            for (int i = 1; i < pk.size(); ++i) {
                _sql.append(" or fid = ?");
            }
            DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])pk.toArray());
        }
        finally {
            LogUtil.afterLog((Context)ctx, (IObjectPK)objectPK);
        }
    }

    private String getLogDetailString(IRowSet set) {
        StringBuffer sb = new StringBuffer();
        try {
            if (set.next()) {
                sb.append(set.getString("fnumber"));
            }
            while (set.next()) {
                sb.append(", ").append(set.getString("fnumber"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return sb.toString();
    }

    private IRowSet getNumberListByPK(Context ctx, List pk) throws BOSException {
        StringBuffer _sql = new StringBuffer("select fnumber from t_rpt_Report where");
        Object[] params = new Object[pk.size()];
        for (int i = 0; i < pk.size(); ++i) {
            params[i] = pk.get(i).toString();
            if (i == 0) {
                _sql.append(" fid= ?");
                continue;
            }
            _sql.append(" OR fid= ?");
        }
        return DbUtil.executeQueryNoTx((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    @Override
    protected String _getMasterTable(Context ctx) throws BOSException {
        return "";
    }

    @Override
    protected IRowSet _getTreeData(Context ctx, ArrayList selectArrayId, AuditedStatusEnum auditedStatus, IObjectPK companyPK, EntityViewInfo commonView, boolean isFirstPage, ArrayList pageIds, String permissionCondition, boolean isRemovePublish, PublicStatusEnum publicStatus) throws EASBizException, BOSException {
        List todoQueryID = null;
        todoQueryID = isFirstPage ? this.GetReportIDs(ctx, selectArrayId, auditedStatus, companyPK, 100, commonView, permissionCondition, isRemovePublish, publicStatus) : pageIds;
        if (todoQueryID.size() != 0) {
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.fi.rpt.app", "ReportQuery");
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            if (commonView == null) {
                commonView = new EntityViewInfo();
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(todoQueryID), CompareType.INCLUDE));
            if (commonView.getFilter() != null) {
                commonView.getFilter().mergeFilter(filterInfo, "AND");
            } else {
                commonView.setFilter(filterInfo);
            }
            commonView.setFilter(filterInfo);
            if (commonView.getSelector() != null) {
                commonView.getSelector().clear();
            }
            queryExecutor.setObjectView(commonView);
            queryExecutor.option().isAutoTranslateEnum = true;
            IRowSet rowset = queryExecutor.executeQuery();
            return rowset;
        }
        try {
            DynamicRowSet dynamicRowSet = new DynamicRowSet(1);
            dynamicRowSet.setColInfo(1, "field1", RptUtil.getResourceSince51("ColumnOne"), 1, null);
            return dynamicRowSet;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected List _getTreeDataIDs(Context ctx, ArrayList selectArrayId, AuditedStatusEnum auditedStatus, IObjectPK companyPK, EntityViewInfo commonView, String permissionCondition, boolean isRemovePublish) throws EASBizException, BOSException {
        return this.GetReportIDs(ctx, selectArrayId, auditedStatus, companyPK, 0, commonView, permissionCondition, isRemovePublish, null);
    }

    private int decodeOrgType(List lst) {
        int orgType = 1;
        if (lst != null && lst.size() > 0 && lst.get(lst.size() - 1) instanceof OrgType) {
            orgType = ((OrgType)lst.get(lst.size() - 1)).getValue();
            lst.remove(lst.size() - 1);
        }
        return orgType;
    }

    private List GetReportIDs(Context ctx, ArrayList selectArrayId, AuditedStatusEnum auditedStatus, IObjectPK companyPK, int top, EntityViewInfo commonView, String permissionCondition, boolean isRemovePublish, PublicStatusEnum publicStatus) throws BOSException, EASBizException {
        IRowSet idRowset = null;
        int orgType = this.decodeOrgType(selectArrayId);
        try {
            String companyid = null;
            companyid = companyPK == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : companyPK.toString();
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK currentUserPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            if (!StringUtils.isEmpty((String)permissionCondition) && permissionCondition.startsWith("not")) {
                String rptPermissionSQL = iPermission.getQueryPermissionSQL((IObjectPK)currentUserPK, (IObjectPK)new ObjectUuidPK(companyid), "rpt_report_view");
                permissionCondition = permissionCondition + " and Report.fid in (" + rptPermissionSQL + ")";
            }
            String dataRule = RptUtilForServer.getCommonDataRule(ctx, (IObjectPK)currentUserPK, (IObjectPK)new ObjectUuidPK(companyid), "rpt_report_view");
            StringBuffer filtersql = new StringBuffer();
            StringBuffer joinSql = new StringBuffer();
            StringBuffer groupItem = new StringBuffer();
            StringBuffer sorterItem = new StringBuffer();
            ArrayList<Object> myparam = new ArrayList<Object>();
            HashSet<String> joinedTable = new HashSet<String>(6);
            joinedTable.add("T_RPT_RPTTYPERELA");
            joinedTable.add("T_BD_CURRENCY");
            joinedTable.add("T_RPT_TEMPLATE");
            joinedTable.add("T_PM_USER");
            joinedTable.add("T_RPT_REPORTTYPE");
            joinedTable.add("T_RPT_RPTTYPESTD");
            this.simpleParseEntityView(ctx, commonView, filtersql, joinSql, groupItem, sorterItem, myparam, joinedTable);
            String groupString = groupItem.toString();
            String sorterString = sorterItem.toString();
            String language = "_" + ctx.getLocale().toString();
            groupString = groupString.replaceAll("Report.Fcurrency.name", "currency.Fname" + language);
            sorterString = sorterString.replaceAll("Report.Fcurrency.name", "currency.Fname" + language);
            groupString = groupString.replaceAll("Report.FsourceCurrency.name", "sourceCurrency.Fname" + language);
            sorterString = sorterString.replaceAll("Report.FsourceCurrency.name", "sourceCurrency.Fname" + language);
            groupString = groupString.replaceAll("Report.Ftemplate.name", "template.Fname");
            sorterString = sorterString.replaceAll("Report.Ftemplate.name", "template.Fname");
            groupString = groupString.replaceAll("Report.Ftemplate.versionNumber", "template.FVersionNumber");
            sorterString = sorterString.replaceAll("Report.Ftemplate.versionNumber", "template.FVersionNumber");
            groupString = groupString.replaceAll("Report.Fauditor.name", "auditor.Fname" + language);
            sorterString = sorterString.replaceAll("Report.Fauditor.name", "auditor.Fname" + language);
            groupString = groupString.replaceAll("Report.Fcreator.name", "creator.Fname" + language);
            sorterString = sorterString.replaceAll("Report.Fcreator.name", "creator.Fname" + language);
            groupString = groupString.replaceAll("Report.FlastUpdateUser.name", "lastUpdateUser.Fname" + language);
            sorterString = sorterString.replaceAll("Report.FlastUpdateUser.name", "lastUpdateUser.Fname" + language);
            groupString = groupString.replaceAll("Report.Fcommitor.name", "commitor.Fname" + language);
            sorterString = sorterString.replaceAll("Report.Fcommitor.name", "commitor.Fname" + language);
            groupItem = new StringBuffer(groupString);
            sorterItem = new StringBuffer(sorterString);
            String dbType = (String)ctx.get((Object)"dbType");
            if (selectArrayId == null || selectArrayId.size() == 0) {
                StringBuffer _sql = new StringBuffer(484);
                _sql.append(" select " + (top > 0 ? "top " + top : ""));
                if (3 != DbType.getValue((String)dbType) && 5 != DbType.getValue((String)dbType)) {
                    _sql.append(" Report.reportid,Report.count from (select ");
                }
                _sql.append(" Report.fid as reportid, min(d.fseq), sum(d.fseq), count(r.fid) as count  ").append(" from t_rpt_report Report left join T_RPT_RptTypeRela r on Report.FID = r.FReportID ").append(" left join T_BD_Currency currency on Report.FCurrencyID = currency.FID ").append(" left join T_BD_Currency sourceCurrency on Report.FSourceCurrencyID = sourceCurrency.FID ").append(" left join T_RPT_Template template on Report.FTemplateID = template.FID ").append(" left join T_PM_User creator on Report.FCreatorID = creator.FID ").append(" left join T_PM_User lastUpdateUser on Report.FLastUpdateUserID = lastUpdateUser.FID ").append(" left join T_PM_User auditor on Report.FAuditorID = auditor.FID ").append(" left join t_rpt_reporttype c on r.freporttypeid = c.fid  ").append(" left join t_rpt_rpttypestd d on c.ftypestandid = d.fid ").append(" left join t_csl_cslreport csl on report.fcslreportid = csl.fid ").append(" left join T_PM_User commitor on csl.fcommitorid = commitor.fid ").append(joinSql).append(" where (");
                if (filtersql.length() > 0) {
                    _sql.append("( " + filtersql + " ) and ");
                }
                _sql.append(" Report.FCompanyID = ? ");
                _sql.append(" and report.forgType = " + orgType + " ");
                myparam.add(companyid);
                if (auditedStatus != null) {
                    _sql.append("and Report.FAuditedStatus=? ");
                    myparam.add(new Integer(auditedStatus.getValue()));
                }
                if (!StringUtils.isEmpty((String)permissionCondition)) {
                    _sql.append(" and (Report.fid " + permissionCondition);
                    if (permissionCondition.startsWith("not")) {
                        _sql.append(" and Report.FPublicStatus =?)");
                        myparam.add(new Integer(1));
                    } else if (StringUtils.isEmpty((String)dataRule)) {
                        _sql.append(" or Report.FPublicStatus =?)");
                        myparam.add(new Integer(2));
                    } else {
                        _sql.append(")");
                    }
                }
                if (isRemovePublish) {
                    _sql.append(" and Report.FPublishedStatus = 1");
                }
                if (publicStatus != null) {
                    _sql.append(" and Report.FPublicStatus = " + publicStatus.getValue());
                }
                _sql.append(") and (not exists \r\n").append("(select r1.FID from t_rpt_reporttype t2,t_rpt_report r1,t_rpt_rpttypestd d1,T_RPT_RptTypeRela t1  \r\n").append("where  d1.fseq=1 and d1.fid= t2.FTypeStandID \r\n").append("and  t2.fid=t1.FReportTypeID and r1.fid=t1.FReportID and r1.FID = Report.fid))\r\n");
                _sql.append(" group by Report.fid ").append(groupItem).append(" having min(d.fseq)<>1 or sum(d.fseq) = 0 or count(r.fid)=0 ").append(sorterItem);
                if (3 != DbType.getValue((String)dbType) && 5 != DbType.getValue((String)dbType)) {
                    _sql.append(") Report");
                }
                idRowset = DbUtil.executeQuery((Context)ctx, (String)_sql.toString(), (Object[])myparam.toArray());
                DebugLogger.info(logger, "report execute kql", _sql);
                DebugLogger.info(logger, "params", myparam.toArray());
            } else {
                int selectArrayIdLength = selectArrayId.size();
                ArrayList<Object> params = new ArrayList<Object>(6);
                StringBuffer kqlBuffer = new StringBuffer();
                kqlBuffer.append(" select " + (top > 0 ? "top " + top : " "));
                if (3 != DbType.getValue((String)dbType) && 5 != DbType.getValue((String)dbType)) {
                    kqlBuffer.append(" Report.reportid,Report.count from (select ");
                }
                kqlBuffer.append(" Report.fid as reportid, count(c.fid) as count ");
                kqlBuffer.append(" from t_rpt_report Report \n");
                kqlBuffer.append(" inner join T_RPT_RptTypeRela r on Report.FID = r.FReportID \n");
                kqlBuffer.append(" left join T_BD_Currency currency on Report.FCurrencyID = currency.FID ");
                kqlBuffer.append(" left join T_BD_Currency sourceCurrency on Report.FSourceCurrencyID = sourceCurrency.FID ");
                kqlBuffer.append(" left join T_RPT_Template template on Report.FTemplateID = template.FID ");
                kqlBuffer.append(" left join T_PM_User creator on Report.FCreatorID = creator.FID ");
                kqlBuffer.append(" left join T_PM_User lastUpdateUser on Report.FLastUpdateUserID = lastUpdateUser.FID ");
                kqlBuffer.append(" left join T_PM_User auditor on Report.FAuditorID = auditor.FID ");
                kqlBuffer.append(" left join T_CSL_CslReport cslreport on Report.FCslReportID = cslreport.FID ");
                kqlBuffer.append(" left join T_PM_User commitor on cslreport.FCommitorId = commitor.FID ");
                kqlBuffer.append(" inner join t_rpt_reporttype c on r.freporttypeid = c.fid \n");
                kqlBuffer.append(joinSql).append(" where Report.FCompanyID = ? \n");
                kqlBuffer.append(" and Report.forgType = " + orgType + " ");
                kqlBuffer.append(" and r.FRelaType = ? \n ");
                if (filtersql.length() > 0) {
                    kqlBuffer.append("and (" + filtersql + ")");
                }
                params.add(companyid);
                params.add(new Integer(2));
                params.addAll(myparam);
                if (auditedStatus != null) {
                    kqlBuffer.append(" and Report.fauditedstatus =? \n");
                    params.add(new Integer(auditedStatus.getValue()));
                }
                kqlBuffer.append(" and c.fid in( ");
                for (int i = 0; i < selectArrayIdLength; ++i) {
                    params.add(selectArrayId.get(i).toString());
                    if (i == 0) {
                        kqlBuffer.append(" ? ");
                        continue;
                    }
                    kqlBuffer.append(" ,? ");
                }
                kqlBuffer.append(" ) \n");
                if (!StringUtils.isEmpty((String)permissionCondition)) {
                    kqlBuffer.append(" and (Report.fid " + permissionCondition);
                    if (permissionCondition.startsWith("not")) {
                        kqlBuffer.append(" and Report.FPublicStatus =?)");
                        params.add(new Integer(1));
                    } else if (StringUtils.isEmpty((String)dataRule)) {
                        kqlBuffer.append(" or Report.FPublicStatus =?)");
                        params.add(new Integer(2));
                    } else {
                        kqlBuffer.append(")");
                    }
                }
                if (isRemovePublish) {
                    kqlBuffer.append(" and Report.FPublishedStatus = 1");
                }
                if (publicStatus != null) {
                    kqlBuffer.append(" and Report.FPublicStatus = " + publicStatus.getValue());
                }
                kqlBuffer.append(" group by Report.fid \n ").append(groupItem);
                kqlBuffer.append(" having count(c.fid) = ? \n");
                kqlBuffer.append(sorterItem);
                if (3 != DbType.getValue((String)dbType) && 5 != DbType.getValue((String)dbType)) {
                    kqlBuffer.append(") Report");
                }
                params.add(new Integer(selectArrayIdLength));
                idRowset = DbUtil.executeQuery((Context)ctx, (String)kqlBuffer.toString(), (Object[])params.toArray());
                DebugLogger.info(logger, "report execute kql", kqlBuffer);
                DebugLogger.info(logger, "params", params.toArray());
            }
            ArrayList<String> retrievedID = new ArrayList<String>();
            while (idRowset.next()) {
                retrievedID.add(idRowset.getString(1));
            }
            return retrievedID;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void simpleParseEntityView(Context ctx, EntityViewInfo commonView, StringBuffer filtersql, StringBuffer joinSql, StringBuffer groupItem, StringBuffer sorterItem, ArrayList myparam, HashSet joinedTable) throws EASBizException {
        FilterInfo filter;
        if (commonView != null && (filter = commonView.getFilter()) != null && FilterUtility.hasFilterItem((FilterInfo)filter)) {
            String maskString = filter.getMaskString();
            String[] ss = null;
            if (StringUtils.isEmpty((String)maskString)) {
                ss = new String[]{""};
            } else {
                ss = maskString.split("#\\d*");
                if (ss.length == 0 && maskString.matches("#\\d*")) {
                    ss = new String[]{""};
                }
            }
            filtersql.append(ss[0]);
            FilterItemCollection cl = filter.getFilterItems();
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            for (int k = 0; k < cl.size(); ++k) {
                String s;
                FilterItemInfo fitem = cl.get(k);
                String property = fitem.getPropertyName();
                if (!(!property.equals("auditTime") && !property.equals("lastUpdateTime") || fitem.getCompareValue() instanceof Date || (fitem.getCompareType().equals((Object)CompareType.IS) || fitem.getCompareType().equals((Object)CompareType.ISNOT)) && CompareValueType.TYPE_EMPTY.equals(fitem.getCompareValue()))) {
                    this.isStringDate(fitem.getCompareValue().toString());
                }
                property = this.retouchOQLProperties(joinSql, joinedTable, loc, property);
                if ((fitem.getCompareType().equals((Object)CompareType.IS) || fitem.getCompareType().equals((Object)CompareType.ISNOT)) && CompareValueType.TYPE_EMPTY.equals(fitem.getCompareValue())) {
                    filtersql.append(property).append(" ");
                    if (fitem.getCompareType().equals((Object)CompareType.IS)) {
                        filtersql.append(" IS NULL ");
                    } else {
                        if (!fitem.getCompareType().equals((Object)CompareType.ISNOT)) continue;
                        filtersql.append(" IS NOT NULL ");
                    }
                    if (k + 1 >= ss.length) continue;
                    filtersql.append(ss[k + 1]);
                    continue;
                }
                filtersql.append(property).append(" ").append(fitem.getCompareType().getName()).append(" ? ");
                if (k + 1 < ss.length) {
                    filtersql.append(ss[k + 1]);
                }
                if (fitem.getCompareValue() instanceof Date) {
                    myparam.add(new java.sql.Date(((Date)fitem.getCompareValue()).getTime()));
                    continue;
                }
                Object obj = fitem.getCompareValue();
                if (obj instanceof String && (s = obj.toString()).startsWith("~9^Nz")) {
                    obj = s.substring(5);
                }
                myparam.add(obj);
            }
            SorterItemCollection sorter = commonView.getSorter();
            if (sorter != null && sorter.size() > 0) {
                for (int j = 0; j < sorter.size(); ++j) {
                    SorterItemInfo info = sorter.get(j);
                    String p = info.getPropertyName();
                    p = this.retouchOQLProperties(joinSql, joinedTable, loc, p);
                    if (j > 0) {
                        sorterItem.append(", ");
                    } else {
                        sorterItem.append(" ORDER BY ");
                    }
                    groupItem.append(", ").append(p);
                    sorterItem.append(p).append(" ").append(info.getSortType());
                }
            }
        }
    }

    private String retouchOQLProperties(StringBuffer joinSql, HashSet joinedTable, String loc, String property) throws ReportException {
        if (property.equalsIgnoreCase("auditTime")) {
            property = "Report.FauditedTime";
        } else if (property.equalsIgnoreCase("lastUpdateTime")) {
            property = "Report.FlastUpdateTime";
        } else if (property.equalsIgnoreCase("company.id")) {
            property = "Report.FCompanyID";
        } else if (property.equalsIgnoreCase("CU.id")) {
            property = "Report.FControlUnitID";
        } else if (property.equalsIgnoreCase("currency.id")) {
            property = "Report.FCurrencyID";
        } else if (property.equalsIgnoreCase("template.id")) {
            property = "Report.FTemplateID";
        } else if (property.equalsIgnoreCase("company.name")) {
            if (!joinedTable.contains("T_ORG_COMPANY")) {
                joinedTable.add("T_ORG_COMPANY");
                joinSql.append("inner join T_ORG_COMPANY company on company.FID = Report.FCompanyID ");
            }
            property = "company.FName_" + loc;
        } else if (property.equalsIgnoreCase("currency.number")) {
            property = "Report.FCurrencyID";
            if (!joinedTable.contains("T_BD_CURRENCY")) {
                joinedTable.add("T_BD_CURRENCY");
                joinSql.append("inner join T_BD_Currency currency on currency.FID = Report.FCurrencyID ");
            }
            property = "currency.FNumber";
        } else if (property.equalsIgnoreCase("template.number") || property.equalsIgnoreCase("templateNumber")) {
            property = "template.FNumber";
        } else if (property.equalsIgnoreCase("creator.name")) {
            if (!joinedTable.contains("T_PM_USER")) {
                joinedTable.add("T_PM_USER");
                joinSql.append("inner join T_PM_User on T_PM_User.FID = Report.FCreatorID ");
            }
            property = "creator.FName_" + loc;
        } else if (property.equalsIgnoreCase("orgRela.orgUnit.number")) {
            if (!joinedTable.contains("T_RPT_RPTORGRELA")) {
                joinedTable.add("T_RPT_RPTORGRELA");
                joinSql.append("LEFT OUTER JOIN T_RPT_RptOrgRela ORGRELA ON Report.FID = ORGRELA.FReportID ");
            }
            if (!joinedTable.contains("T_ORG_BASEUNIT")) {
                joinedTable.add("T_ORG_BASEUNIT");
                joinSql.append("LEFT OUTER JOIN T_ORG_BaseUnit ORGUNIT ON ORGRELA.FOrgUnitID = ORGUNIT.FID ");
            }
            property = "ORGUNIT.FNumber";
        } else {
            property = property.startsWith("Report.") ? property.replaceAll("Report\\.", "Report.F") : (property.equalsIgnoreCase("dataCollect.name") ? "Report.FDataCollectNumber" : "Report.F" + property);
        }
        return property;
    }

    private void isStringDate(String str) throws EASBizException {
        SimpleDateFormat sdf = new SimpleDateFormat();
        try {
            sdf.parse(str);
        }
        catch (ParseException e) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{"\"" + str + "\" " + RptUtil.getResourceSince51("DateNotRight")});
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model, boolean isVerifyPower) throws BOSException, EASBizException {
        this.checktempCodeDump(ctx, (ReportBaseInfo)model);
        if (isVerifyPower) {
            this._update(ctx, pk, (IObjectValue)((ReportBaseInfo)model));
        } else {
            this.isAllowUpdate(ctx, pk, model);
            super._update(ctx, pk, (IObjectValue)((ReportBaseInfo)model));
            this.updateReportAttach(ctx, model);
        }
    }

    @Override
    protected void _writePostil(Context ctx, IObjectPK multiApprovePk, IObjectPK reportPK) throws BOSException, EASBizException {
        IMultiApprove iMultiApprove = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo multiApproveInfo = iMultiApprove.getMultiApproveInfo(multiApprovePk);
        if (multiApproveInfo.getOpinion() == null || multiApproveInfo.getOpinion().length() == 0) {
            return;
        }
        PostilInfo postilInfo = new PostilInfo();
        postilInfo.setPostilType(PostilTypeEnum.REPORT);
        ReportInfo reportInfo = new ReportInfo();
        reportInfo.setId(BOSUuid.read((String)reportPK.toString()));
        postilInfo.setReport(reportInfo);
        postilInfo.setDescription(multiApproveInfo.getOpinion());
        postilInfo.setCreator(multiApproveInfo.getCreator());
        PostilFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)postilInfo);
    }

    public void checktempCodeDump(Context ctx, ReportBaseInfo reportBaseInfo) throws BOSException, RptAndTempException, EASBizException {
    }

    @Override
    protected IRowSet _getTreeCommitData(Context ctx, String companyID) throws BOSException, EASBizException {
        if (companyID == null) {
            companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.fi.rpt.app", "ReportGroupCommitQuery");
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        view.setFilter(filterInfo);
        queryExecutor.setObjectView(view);
        queryExecutor.option().isAutoTranslateEnum = true;
        return queryExecutor.executeQuery();
    }

    @Override
    protected boolean _existsAuditedReport(Context ctx, String companyId, int year, int period) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(year)));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(period)));
        filter.getFilterItems().add(new FilterItemInfo("auditedStatus", (Object)new Integer(2)));
        return this.exists(ctx, filter);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk, boolean force) throws BOSException, EASBizException {
        if (!force && this._isAudited(ctx, pk)) {
            throw new RptAndTempException(RptAndTempException.CANNTDEL_AUDITED);
        }
        if (!force) {
            this.deleteCommCheck(ctx, pk);
        }
        String id = pk.toString();
        LinkedList<String> batchSqls = new LinkedList<String>();
        batchSqls.add("DELETE FROM T_RPT_RptPostil WHERE FReportId = '" + id + "'");
        batchSqls.add("DELETE FROM t_rpt_rptTypeRela WHERE Freportid = '" + id + "'");
        batchSqls.add("DELETE FROM T_rpt_rptSheetPara WHERE freportid = '" + id + "'");
        batchSqls.add("DELETE FROM t_rpt_rptOrgRela WHERE Freportid = '" + id + "'");
        new ExecuteBatch().executeBatch(ctx, batchSqls);
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof ReportInfo || model instanceof CslReportInfo) {
            this.setRuleNumber(ctx, (ReportBaseInfo)model);
        }
        return super._save(ctx, model);
    }

    protected int setRuleNumber(Context ctx, ReportBaseInfo baseInfo) throws EASBizException, BOSException {
        String bindProp;
        if (baseInfo == null) {
            return -2;
        }
        if (baseInfo.getNumber() != null && baseInfo.getNumber().toString().trim().length() > 0) {
            return -3;
        }
        String number = null;
        ICodingRuleManager iCodingRuleManager = null;
        CodingRuleInfo codingRule = null;
        CompanyOrgUnitInfo company = this.getCompanyForNumber(ctx, baseInfo);
        if (null == company) {
            return -1;
        }
        String companyID = company.getId().toString();
        iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)baseInfo, companyID, bindProp = "sourceType");
        if (isCodingRule) {
            codingRule = iCodingRuleManager.getCodingRule((IObjectValue)baseInfo, companyID, bindProp);
        } else {
            isCodingRule = iCodingRuleManager.isExist((IObjectValue)baseInfo, companyID);
            if (isCodingRule) {
                codingRule = iCodingRuleManager.getCodingRule((IObjectValue)baseInfo, companyID);
                bindProp = null;
            }
        }
        if (isCodingRule && codingRule != null) {
            boolean existHD = false;
            existHD = bindProp == null ? iCodingRuleManager.isUseIntermitNumber((IObjectValue)baseInfo, companyID) : iCodingRuleManager.isUseIntermitNumber((IObjectValue)baseInfo, companyID, bindProp);
            if (existHD && this.exists(ctx, (IObjectPK)new ObjectUuidPK(baseInfo.getId()))) {
                ReportBaseInfo oldInfo = this.getReportBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(baseInfo.getId()));
                long intermiNo = this.getCodingRuleSN(ctx, codingRule, (IObjectValue)oldInfo, companyID, bindProp, oldInfo.getNumber());
                number = iCodingRuleManager.getNumber((IObjectValue)baseInfo, companyID, bindProp, null, intermiNo);
            } else {
                number = iCodingRuleManager.getNumber((IObjectValue)baseInfo, codingRule);
            }
        } else {
            return 0;
        }
        baseInfo.setNumber(number);
        return 1;
    }

    private long getCodingRuleSN(Context ctx, CodingRuleInfo codingRule, IObjectValue bizObject, String codingRuleOrgId, String bindProp, String number) {
        long codingRuleSN = -9999L;
        try {
            CodingRuleEntryCollection codingRuleEntryCollection;
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            iCodingRuleManager.recycleNumber(bizObject, codingRuleOrgId, bindProp, null, number);
            String codingRuleEntryID = null;
            if (codingRule != null && (codingRuleEntryCollection = codingRule.getCodingRuleEntrys()).size() >= 0) {
                for (int j = 0; j < codingRuleEntryCollection.size(); ++j) {
                    if (!"sn".equalsIgnoreCase(codingRuleEntryCollection.get(j).getCodeAttribute()) || codingRuleEntryCollection.get(j).getId() == null) continue;
                    codingRuleEntryID = codingRuleEntryCollection.get(j).getId().toString();
                }
            }
            if (codingRuleEntryID == null) {
                return codingRuleSN;
            }
            EntityViewInfo eviTemp = new EntityViewInfo();
            FilterInfo filterTemp = new FilterInfo();
            filterTemp.getFilterItems().add(new FilterItemInfo("codingRuleEntry.id", codingRuleEntryID));
            eviTemp.setFilter(filterTemp);
            IIntermilNO iIntermilNO = IntermilNOFactory.getLocalInstance((Context)ctx);
            IntermilNOCollection intermilNOCollection = iIntermilNO.getIntermilNOCollection(eviTemp);
            String findNumber = null;
            for (int i = 0; i < intermilNOCollection.size(); ++i) {
                findNumber = iCodingRuleManager.getNumber(bizObject, codingRuleOrgId, bindProp, null, intermilNOCollection.get(i).getSerialNumber());
                iCodingRuleManager.recycleNumber(bizObject, codingRuleOrgId, bindProp, null, findNumber);
                if (findNumber == null || !findNumber.equals(number)) continue;
                codingRuleSN = intermilNOCollection.get(i).getSerialNumber();
                break;
            }
        }
        catch (EASBizException e) {
            logger.debug((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.debug((Object)e.getMessage());
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
        }
        return codingRuleSN;
    }

    private CompanyOrgUnitInfo getCompanyForNumber(Context ctx, ReportBaseInfo baseInfo) throws EASBizException, BOSException {
        FullOrgUnitInfo company = baseInfo.getCompany();
        if (company == null || null == company.getId() || company.getId().toString().equals("")) {
            return null;
        }
        CompanyOrgUnitInfo org = MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType((OrgUnitInfo)company, ctx);
        return org;
    }

    @Override
    protected Map _updateScheme(Context ctx, IObjectValue report) throws BOSException, EASBizException {
        TemplateInfo template;
        ReportBaseInfo reportBase = (ReportBaseInfo)report;
        HashMap<String, RptOperationSchemaComp> newReport = new HashMap<String, RptOperationSchemaComp>();
        if (reportBase.get("isSchemeUpdate") != null && ((Boolean)reportBase.get("isSchemeUpdate")).booleanValue() && (template = reportBase.getTemplate()) != null) {
            try {
                String group = template.getGroup();
                ICheckScheme ischeme = CheckSchemeFactory.getLocalInstance((Context)ctx);
                CheckSchemeInfo scheme = ischeme.getCheckSchemeInfo("select group, book where group = '" + group + "'");
                Book templateBook = IOHelper.unpackBook(scheme.getBook());
                RptOperationSchemaComp temScheme = (RptOperationSchemaComp)templateBook.getUserObjectValue("Operationschema");
                newReport.put("Operationschema", temScheme);
                ObjectUuidPK pk = new ObjectUuidPK(reportBase.getId());
                Book book = reportBase.getBook();
                book.setAutoCalculate(false);
                book.setUserObject("operationSchemas", (Object)temScheme);
                byte[] data = IOHelper.packBook(book);
                reportBase.setData(data);
                if (reportBase instanceof CslReportInfo) {
                    String sql = "update T_CSL_CSLReport Set FData = ? , FIsSchemeUpdate = ? where FID = ? ";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{data, Boolean.FALSE, pk.toString()});
                } else {
                    String sql = "update T_RPT_Report Set FData = ? , FIsSchemeUpdate = ? where FID = ? ";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{data, Boolean.FALSE, pk.toString()});
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return newReport;
    }

    @Override
    protected Map _updateScheme(Context ctx, IObjectValue report, Object scheme) throws BOSException, EASBizException {
        if (scheme == null) {
            return new HashMap(0);
        }
        ReportBaseInfo reportBase = (ReportBaseInfo)report;
        HashMap<String, RptOperationSchemaComp> newReport = new HashMap<String, RptOperationSchemaComp>(2);
        if (reportBase.get("isSchemeUpdate") != null && ((Boolean)reportBase.get("isSchemeUpdate")).booleanValue()) {
            TemplateInfo template = reportBase.getTemplate();
            CheckSchemeInfo schemeInfo = (CheckSchemeInfo)scheme;
            if (template != null) {
                try {
                    Book templateBook = IOHelper.unpackBook(schemeInfo.getBook());
                    RptOperationSchemaComp temScheme = (RptOperationSchemaComp)templateBook.getUserObjectValue("Operationschema");
                    newReport.put("Operationschema", temScheme);
                    ObjectUuidPK pk = new ObjectUuidPK(reportBase.getId());
                    Book book = reportBase.getBook();
                    book.setAutoCalculate(false);
                    book.setUserObject("operationSchemas", (Object)temScheme);
                    byte[] data = IOHelper.packBook(book);
                    reportBase.setData(data);
                    if (reportBase instanceof CslReportInfo) {
                        String sql = "update T_CSL_CSLReport Set FData = ? , FIsSchemeUpdate = ? where FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{data, Boolean.FALSE, pk.toString()});
                    } else {
                        String sql = "update T_RPT_Report Set FData = ? , FIsSchemeUpdate = ? where FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{data, Boolean.FALSE, pk.toString()});
                    }
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return newReport;
    }

    private boolean isBookNull(ReportBaseInfo reportBaseInfo) throws BOSException {
        boolean isRpt = reportBaseInfo instanceof ReportInfo;
        boolean isCslRpt = reportBaseInfo instanceof CslReportInfo;
        boolean isSupportGroup = true;
        if (isRpt) {
            boolean bl = isSupportGroup = !IsSupportGroupReportEnum.NOTSUPPORT.equals((Object)((ReportInfo)reportBaseInfo).getIsSupportGroup());
        }
        if ((isRpt || isCslRpt) && (reportBaseInfo == null || reportBaseInfo.getData() == null || reportBaseInfo.getData().length <= 0)) {
            throw new BOSException("book is null.");
        }
        try {
            if ((isRpt && !isSupportGroup || isCslRpt) && reportBaseInfo.getBook().getSheetCount() <= 0) {
                throw new BOSException("SheetCount is 0.");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

