/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaCheckResultFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseFactory;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.ReportTypeFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.app.AbstractReportMaintainUIHandler;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReportMaintainUIHandler
extends AbstractReportMaintainUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        ObjectUuidPK currentCompanyID = new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)context).getId());
        String permissionContidion = PermissionFactory.getLocalInstance((Context)context).getQueryPermissionSQL(context.getCaller(), (IObjectPK)currentCompanyID, "rpt_report_view");
        permissionContidion = "in (" + permissionContidion + ")";
        IInitDataFacada iInitDataFacada = InitDataFacadaFactory.getLocalInstance(context);
        Map result = iInitDataFacada.initReportList(null);
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)context);
        CompanyOrgUnitInfo companyOrgUnitInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)currentCompanyID);
        CurrencyInfo baseCurrency = companyOrgUnitInfo.getBaseCurrency();
        if (baseCurrency != null && baseCurrency.getId() != null) {
            CurrencyFactory.getLocalInstance((Context)context).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("currCompanyID", currentCompanyID.toString());
        params.put("ReportTypeEnum", (Object)ReportTypeEnum.REPORT);
        Map typeAndStandard = ReportTypeFactory.getLocalInstance(context).getTypeAndStandard(params);
        IRowSet rowSet = null;
        EntityViewInfo view = new EntityViewInfo();
        if (request.getQuery() != null) {
            view.setFilter(this.prepareForQuery(context, request, request.getQuery().getFilter()));
        } else {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompanyID.toString()));
            filter.setMaskString("#0");
            view.setFilter(filter);
        }
        rowSet = ReportBaseFactory.getLocalInstance(context).getTreeData(null, null, (IObjectPK)currentCompanyID, view, true, null, permissionContidion, false, null);
        if (rowSet.next()) {
            String key = rowSet.getString("REPORT.ID");
            ObjectStringPK pk = new ObjectStringPK(key);
            boolean exists = ReportFactory.getLocalInstance(context).exists((IObjectPK)pk);
            if (exists) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("publishedStatus"));
                sic.add(new SelectorItemInfo("sourceType"));
                sic.add(new SelectorItemInfo("auditedStatus"));
                sic.add(new SelectorItemInfo("auditor.id"));
                ReportBaseInfo reportBaseInfo = ReportFactory.getLocalInstance(context).getReportBaseInfo((IObjectPK)pk, sic);
            }
        }
        rowSet.beforeFirst();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getLocalInstance((Context)context);
        EntityViewInfo ev = (EntityViewInfo)iQuery.getDefaultFilterInfo("com.kingdee.eas.fi.rpt.client.ReportMaintainUI", "com.kingdee.eas.fi.rpt.app.ReportQuery");
    }

    protected void buildTreeFilter(RequestContext request, Context context) throws Exception {
    }

    public FilterInfo prepareForQuery(Context context, RequestContext request, FilterInfo filter) throws EASBizException, BOSException {
        if (filter == null || filter.getFilterItems().size() == 0) {
            return filter;
        }
        StringBuffer sbFormula = new StringBuffer();
        int i = 0;
        HashSet<String> timeSet = new HashSet<String>();
        Iterator iterator = filter.getFilterItems().iterator();
        while (iterator.hasNext()) {
            FilterItemInfo item = (FilterItemInfo)iterator.next();
            if ("year".equals(item.getPropertyName()) || "period".equals(item.getPropertyName())) {
                timeSet.add(item.getPropertyName());
                continue;
            }
            if (!"cu.id".equalsIgnoreCase(item.getPropertyName())) continue;
            iterator.remove();
        }
        boolean firstSetTime = true;
        for (int index = 0; index < filter.getFilterItems().size(); ++index) {
            FilterItemInfo item = filter.getFilterItems().get(index);
            if ("company.id".equals(item.getPropertyName())) {
                String companyid = item.getCompareValue().toString();
                ObjectStringPK companyPK = new ObjectStringPK();
                companyPK.setKeyValue("id", (Object)companyid);
                CompanyOrgUnitFactory.getLocalInstance((Context)context).getCompanyOrgUnitInfo((IObjectPK)companyPK);
                if (i == 0) {
                    sbFormula.append("#" + i++);
                } else {
                    sbFormula.append(" and #" + i++);
                }
            }
            if ("orgRela.orgUnit.number".equals(item.getPropertyName())) {
                String orgNumber = item.getCompareValue().toString();
                String oql = "where number = '" + orgNumber + "'";
                FullOrgUnitFactory.getLocalInstance((Context)context).getDataBaseInfo(oql);
                if (i == 0) {
                    sbFormula.append("#" + i++);
                } else {
                    sbFormula.append(" and #" + i++);
                }
            }
            if ("template.number".equals(item.getPropertyName())) {
                if (i == 0) {
                    sbFormula.append("#" + i++);
                } else {
                    sbFormula.append(" and #" + i++);
                }
            }
            if ("template.id".equals(item.getPropertyName())) {
                String templateid = item.getCompareValue().toString();
                ObjectStringPK templatePK = new ObjectStringPK();
                templatePK.setKeyValue("id", (Object)templateid);
                TemplateInfo template = TemplateFactory.getLocalInstance(context).getTemplateInfo((IObjectPK)templatePK);
                if (i == 0) {
                    sbFormula.append("#" + i++);
                } else {
                    sbFormula.append(" and #" + i++);
                }
            }
            if ("sourceType".equals(item.getPropertyName())) {
                if (i == 0) {
                    sbFormula.append("#" + i++);
                } else {
                    sbFormula.append(" and #" + i++);
                }
            }
            if ("periodType".equals(item.getPropertyName())) {
                if (i == 0) {
                    sbFormula.append("#" + i++);
                } else {
                    sbFormula.append(" and #" + i++);
                }
            }
            if ("currency.id".equals(item.getPropertyName())) {
                if (i == 0) {
                    sbFormula.append("#" + i++);
                } else {
                    sbFormula.append(" and #" + i++);
                }
            }
            if (timeSet.contains(item.getPropertyName()) && firstSetTime) {
                if (timeSet.size() == 1) {
                    if (i == 0) {
                        sbFormula.append("#" + i++);
                    } else {
                        sbFormula.append(" and #" + i++);
                    }
                } else if (i == 0) {
                    sbFormula.append(" (#" + i++ + " or ( #" + i++ + " and #" + i++ + "))");
                } else {
                    sbFormula.append(" and (#" + i++ + " or ( #" + i++ + " and #" + i++ + "))");
                }
                firstSetTime = false;
            }
            if ("startDate".equals(item.getPropertyName())) {
                if (i == 0) {
                    sbFormula.append("#" + i++);
                } else {
                    sbFormula.append(" and #" + i++);
                }
            }
            if (!"endDate".equals(item.getPropertyName())) continue;
            if (i == 0) {
                sbFormula.append("#" + i++);
                continue;
            }
            sbFormula.append(" and #" + i++);
        }
        filter.setMaskString(sbFormula.toString());
        return filter;
    }

    protected void _handleActionRemove(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionRemove(request, response, context);
        String id = (String)request.get("newrpt_object_pk");
        String oql = "SELECT ID, PublicStatus, Creator WHERE ID = '" + id + "'";
        CoreBaseCollection rpts = ReportFactory.getLocalInstance(context).getCollection(oql);
        if (rpts == null || rpts.size() < 1) {
            return;
        }
        String permItem = "rpt_report_delete";
        ReportInfo report = (ReportInfo)rpts.get(0);
        if (report.getCreator().getId().toString().equals(context.getCaller().toString())) {
            return;
        }
        if (report.getPublicStatus().getValue() == 2) {
            return;
        }
        IPermission perm = PermissionFactory.getLocalInstance((Context)context);
        IObjectPK userPK = context.getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)context).getId());
        perm.checkDataPermission(userPK, (IObjectPK)orgPK, permItem, (IObjectPK)new ObjectUuidPK(report.getId()));
    }

    @Override
    protected void _handleActionPublish(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionHisReport(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionBatchPrint(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSumReportAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionReportFacture(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionBactchAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.handleGetAllSelectedReport(request, context);
        boolean needCheck = CSLParamUtil.isRptReceive001((Context)context);
        ArrayList ids = (ArrayList)request.get("selectIds");
        ReportCollection reports = this.getReportStatusById(context, ids);
        ArrayList<String> toCheck = new ArrayList<String>();
        ArrayList<String> committed = new ArrayList<String>();
        ArrayList<String> ReportIdList = new ArrayList<String>();
        IReport remoteInstance = ReportFactory.getLocalInstance(context);
        int j = reports.size();
        for (int i = 0; i < j; ++i) {
            ReportInfo report = reports.get(i);
            if (this.getIsAudit(report) || RptUtilForServer.editDataIsInWorkflow(context, response, report.getId().toString())) continue;
            if (needCheck) {
                toCheck.add(report.getId().toString());
                continue;
            }
            remoteInstance.submitWorkflow(BOSUuid.read((String)report.getId().toString()));
            committed.add(report.getNumber());
        }
        List checked = null;
        if (needCheck && toCheck.size() > 0) {
            checked = remoteInstance.reportBatchCheck(toCheck);
        }
        if (needCheck && checked != null && checked.size() > 0) {
            int i;
            ArrayList<Integer> temp = new ArrayList<Integer>();
            for (i = 0; i < checked.size(); ++i) {
                Map result;
                if (!(checked.get(i) instanceof Map) || (result = (Map)checked.get(i)) == null || result.get("REPORTID") == null) continue;
                temp.add(new Integer(i));
                String id = result.get("REPORTID").toString();
                ReportInfo r = this.getReportFromListWithId(reports, id);
                if (!((Boolean)result.get("CHECKPASSED")).booleanValue()) continue;
                remoteInstance.submitWorkflow(BOSUuid.read((String)id));
                if (r == null) continue;
                committed.add(r.getNumber());
                ReportIdList.add(r.getId().toString());
            }
            if (temp.size() > 0) {
                for (i = temp.size() - 1; i >= 0; --i) {
                    checked.remove((Integer)temp.get(i));
                }
            }
        }
        if (committed.size() > 0 && ReportIdList.size() > 0) {
            ItemFormulaCheckResultFactory.getLocalInstance((Context)context).batchDelete(ReportIdList);
        }
    }

    private ReportCollection getReportStatusById(Context context, ArrayList ids) throws BOSException {
        HashSet set = new HashSet(ids);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isSupportGroup"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("auditedStatus"));
        view.getSelector().add(new SelectorItemInfo("publishedStatus"));
        view.getSelector().add(new SelectorItemInfo("committedStatus"));
        view.getSelector().add(new SelectorItemInfo("sourceType"));
        view.getSelector().add(new SelectorItemInfo("cslReport"));
        view.getSelector().add(new SelectorItemInfo("year"));
        view.getSelector().add(new SelectorItemInfo("period"));
        view.getSelector().add(new SelectorItemInfo("PeriodType"));
        view.getSelector().add(new SelectorItemInfo("PublicStatus"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ReportCollection reports = ReportFactory.getLocalInstance(context).getReportCollection(view);
        return reports;
    }

    private boolean getIsAudit(ReportInfo reportInfo) throws Exception {
        if (reportInfo == null) {
            return false;
        }
        return reportInfo.getAuditedStatus() != null && reportInfo.getAuditedStatus().getValue() == 2;
    }

    private ReportInfo getReportFromListWithId(ReportCollection reports, String id) {
        int j = reports.size();
        for (int i = 0; i < j; ++i) {
            ReportInfo report = reports.get(i);
            if (!report.getId().toString().equalsIgnoreCase(id)) continue;
            return report;
        }
        return null;
    }

    public static boolean editDataIsInWorkflow(Context context, ResponseContext response, String editDataID) throws Exception {
        return RptUtilForServer.editDataIsInWorkflow(context, response, editDataID);
    }

    @Override
    protected void _handleActionBactchUnAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionBatchIndex(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionViewDoProccess(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionUnpublish(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionDiscreteAccredit(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionCommitReport(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.handleGetAllSelectedReport(request, context);
        ArrayList ids = (ArrayList)request.get("selectIds");
        ReportCollection reports = this.getReportStatusById(context, ids);
        boolean exist = this.checkExistsRequisition(context, (IObjectCollection)reports);
        if (exist) {
            return;
        }
        IReport ireport = ReportFactory.getLocalInstance(context);
        List listResult = null;
        ArrayList<Map> list = new ArrayList<Map>();
        ArrayList<String> ReportIdList = new ArrayList<String>();
        ArrayList<String> idList = new ArrayList<String>();
        if (reports != null && reports.size() > 0) {
            int j = reports.size();
            for (int i = 0; i < j; ++i) {
                ReportInfo report = reports.get(i);
                if (report.getIsSupportGroup() == null || report.getIsSupportGroup() == IsSupportGroupReportEnum.NOTSUPPORT || report.getSourceType().getValue() != 7 && report.getSourceType().getValue() != 10 || report.getCommittedStatus().getValue() == 2 || report.getCommittedStatus().getValue() == 3 || !this.getIsAudit(report) || RptUtilForServer.editDataIsInWorkflow(context, response, report.getId().toString())) continue;
                idList.add(report.getId().toString());
            }
            listResult = ireport.commitReportNew(idList);
            String msg = null;
            if (listResult != null && listResult.size() > 0) {
                for (int k = 0; k < listResult.size(); ++k) {
                    Map map = (Map)listResult.get(k);
                    String cslreportId = null;
                    if (map != null && map.size() > 0) {
                        list.add(map);
                    }
                    if (map != null && map.get("KEY_ID") != null) {
                        cslreportId = map.get("KEY_ID").toString();
                    }
                    if (cslreportId == null) continue;
                    ArrayList listTemp = this.getReportName(context, cslreportId);
                    if (!StringUtils.isEmpty(msg)) continue;
                    ReportIdList.add(cslreportId);
                    if (ReportIdList.size() <= 0) continue;
                    ItemFormulaCheckResultFactory.getLocalInstance((Context)context).batchDelete(ReportIdList);
                }
            }
        }
    }

    private ArrayList getReportName(Context context, String id) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer s = new StringBuffer();
        s.append("select name,number where id = '").append(id).append("'");
        CslReportInfo info = CslReportFactory.getLocalInstance((Context)context).getCslReportInfo(s.toString());
        list.add(info.getNumber());
        list.add(info.getName());
        return list;
    }

    private boolean checkExistsRequisition(Context context, IObjectCollection coll) throws Exception {
        List list = null;
        String p1 = ParamManager.getParamValue((Context)context, null, (String)"GR_CSL_CACHECK_001");
        if (!RptUtil.isTrue(p1)) {
            return false;
        }
        p1 = ParamManager.getParamValue((Context)context, (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)context).getId()), (String)"GLG01");
        if (!RptUtil.isTrue(p1)) {
            return false;
        }
        IVoucher iV = VoucherFactory.getLocalInstance((Context)context);
        for (ReportBaseInfo info : coll) {
            List checked;
            int period = info.getPeriod();
            int year = info.getYear();
            if (RptPeriodTypeEnum.MONTHLY != info.getPeriodType()) {
                Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)info.getPeriodType());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(periodLastDate);
                year = calendar.get(1);
                period = calendar.get(2) + 1;
            }
            list = checked = iV.requisitionCheckData(String.valueOf(year) + '.' + String.valueOf(period), 1, 2);
        }
        return list != null && list.size() > 0 && (Integer)list.get(0) != 0;
    }

    private boolean getIsPublish(ReportInfo reportInfo) {
        if (reportInfo == null) {
            return false;
        }
        PublishedStatusEnum status = reportInfo.getPublishedStatus();
        return status != null && status.getValue() == 2;
    }

    @Override
    protected void _handleActionUncommitReport(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionBatchManpowerAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionBatchManpowerUnAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSetForGroup(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionBatchDiscreteAccredit(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionMultiapprove(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionWorkFlowG(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionNextPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionAuditResult(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionGroupProcess(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionWeaveProgress(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionCover(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.handleGetAllSelectedReport(request, context);
    }

    private void handleGetAllSelectedReport(RequestContext request, Context context) throws BOSException, EASBizException {
        ArrayList selectIds = (ArrayList)request.get("selectIds");
        IReport ireport = ReportFactory.getLocalInstance(context);
        for (String id : selectIds) {
            ireport.exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        }
    }

    @Override
    protected void _handleActionItemDataInit(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionItemDataInitCover(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionEditSavePlace(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionWorkflowList(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSendingMessage(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionEdit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionEdit(request, response, context);
        String id = request.getId();
        String oql = "SELECT ID, PublicStatus, Creator WHERE ID = '" + id + "'";
        CoreBaseCollection rpts = ReportFactory.getLocalInstance(context).getCollection(oql);
        RptUtilForServer.editDataIsInWorkflow(context, response, id);
    }

    protected void _handleActionRefresh(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionRefresh(request, response, context);
        ArrayList getSelectedPath = (ArrayList)request.get("getSelectedPath");
        AuditedStatusEnum auditStatus = (AuditedStatusEnum)((Object)request.get("auditStatus"));
        EntityViewInfo getMainViewInfo = (EntityViewInfo)request.get("getMainViewInfo");
        boolean isRemovePublish = (Boolean)request.get("isRemovePublish");
        PublicStatusEnum publicStatus = (PublicStatusEnum)((Object)request.get("publicStatus"));
        ObjectUuidPK companyPK = new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)context).getId());
        String permissionContidion = (String)request.get("permissionContidion");
        IRowSet rowSet = ReportBaseFactory.getLocalInstance(context).getTreeData(getSelectedPath, auditStatus, (IObjectPK)companyPK, getMainViewInfo, true, null, permissionContidion, isRemovePublish, publicStatus);
    }

    @Override
    protected void _handleActionItemHisExchgRate(RequestContext request, ResponseContext response, Context context) throws Exception {
    }
}

