/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mobile.biz.AbstractBaseBizFunction;
import com.kingdee.eas.mobile.biz.BizFuncParamObj;
import com.kingdee.eas.mobile.biz.BizReturnObj;
import com.kingdee.eas.util.ResourceBase;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;

public class ReportMobileSupport
extends AbstractBaseBizFunction {
    public static final String QUERY_COMMAND = "FI";
    private Context ctx;

    public BizReturnObj executeSendAction(BizFuncParamObj paramObj) {
        this.ctx = paramObj.getCtx();
        QueryObject qo = new QueryObject();
        BizReturnObj rt = qo.calcFormula(paramObj);
        if (rt != null) {
            rt.setMustReply(true);
        }
        return rt;
    }

    boolean isNull(String s) {
        return s == null || s.trim().length() == 0;
    }

    boolean isNum(String s) {
        if (s == null || s.trim().length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(s);
        }
        catch (Throwable a) {
            return false;
        }
        return true;
    }

    String getParamErrorString() {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"paramCntError", (Locale)this.ctx.getOriginLocale());
    }

    BizReturnObj returnError(String msg) {
        BizReturnObj bizReturnObj = new BizReturnObj();
        bizReturnObj.setErrorText(msg);
        bizReturnObj.setSucceed(false);
        bizReturnObj.setMustReply(true);
        return bizReturnObj;
    }

    private CompanyOrgUnitInfo InitCompanyByNum(String num) throws BOSException {
        if (num == null || num.trim().length() == 0) {
            return null;
        }
        CompanyOrgUnitInfo org = null;
        ICompanyOrgUnit ie = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)num));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("name"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.id"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.precision"));
        CoreBaseCollection bc = ie.getCollection(ev);
        if (bc.size() == 1) {
            org = (CompanyOrgUnitInfo)bc.get(0);
        }
        return org;
    }

    private CurrencyInfo getCurrencyByNum(String num) throws BOSException {
        if (num == null || num.trim().length() == 0) {
            return null;
        }
        CurrencyInfo org = null;
        ICurrency ie = CurrencyFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)num));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        CoreBaseCollection bc = ie.getCollection(ev);
        if (bc.size() == 1) {
            org = (CurrencyInfo)bc.get(0);
        }
        return org;
    }

    private int getNum(String num) {
        return Integer.parseInt(num);
    }

    private Date getStartDate(int y, int p) {
        return RPTDateUtil.getPeriodFirstDate((int)y, (int)p, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
    }

    private Date getEndDate(int y, int p) {
        return RPTDateUtil.getPeriodLastDate((int)y, (int)p, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
    }

    String getErrorCompamyMsg() {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"OrgNumError", (Locale)this.ctx.getOriginLocale());
    }

    String getErrorCurrencyMsg() {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"curNumError", (Locale)this.ctx.getOriginLocale());
    }

    String getErroryearMsg() {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"yearError", (Locale)this.ctx.getOriginLocale());
    }

    String getErrorperiodMsg() {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"periodError", (Locale)this.ctx.getOriginLocale());
    }

    String getDateErrorString() {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"dateError", (Locale)this.ctx.getOriginLocale());
    }

    private class QueryObject {
        StringBuffer buf = new StringBuffer();
        int year;
        int period;
        Date st;
        Date ed;
        CurrencyInfo currency;
        CompanyOrgUnitInfo company;
        boolean includeInpost = false;

        private QueryObject() {
        }

        BizReturnObj queryValue() {
            ReportInfo reportInfo = new ReportInfo();
            reportInfo.setYear(this.year);
            reportInfo.setPeriod(new Integer(this.period).shortValue());
            reportInfo.setStartDate(this.st);
            reportInfo.setEndDate(this.ed);
            reportInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
            reportInfo.setCompany(this.company);
            reportInfo.setCurrency(this.currency);
            RptSheetParamInfo rptSheetParamInfo = new RptSheetParamInfo();
            rptSheetParamInfo.setIsIncludingUnposted(this.includeInpost);
            reportInfo.getSheetParam().add(rptSheetParamInfo);
            try {
                String value = ReportFactory.getLocalInstance(ReportMobileSupport.this.ctx).calcFomulaString((IObjectValue)reportInfo, this.buf.toString());
                BizReturnObj bizReturnObj = new BizReturnObj();
                bizReturnObj.setReturnText(value);
                bizReturnObj.setSucceed(true);
                bizReturnObj.setMustReply(true);
                return bizReturnObj;
            }
            catch (BOSException e) {
                BizReturnObj bizReturnObj = new BizReturnObj();
                bizReturnObj.setErrorText(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"10_ReportMobileSupport", (Locale)ReportMobileSupport.this.ctx.getOriginLocale()));
                bizReturnObj.setSucceed(false);
                bizReturnObj.setMustReply(true);
                return bizReturnObj;
            }
        }

        BizReturnObj calcFormula(BizFuncParamObj msg) {
            BizReturnObj rt;
            Date date = new Date();
            GregorianCalendar calender = new GregorianCalendar();
            calender.setTime(date);
            if (!msg.getCommand().toUpperCase().equals(ReportMobileSupport.QUERY_COMMAND)) {
                return null;
            }
            for (int i = 0; i < msg.getCommandParams().length; ++i) {
                if ("$year$".equalsIgnoreCase(msg.getCommandParams()[i])) {
                    msg.getCommandParams()[i] = Integer.toString(calender.get(1));
                }
                if ("$period$".equalsIgnoreCase(msg.getCommandParams()[i])) {
                    msg.getCommandParams()[i] = Integer.toString(calender.get(2) + 1);
                }
                if (!"$date$".equalsIgnoreCase(msg.getCommandParams()[i])) continue;
                SimpleDateFormat df = new SimpleDateFormat("YYYY-MM-DD");
                msg.getCommandParams()[i] = df.format(date);
            }
            if (msg.getCommandParams()[0].toUpperCase().equals("ACCT")) {
                if (msg.getCommandParams().length != 10) {
                    return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
                }
                this.buf.append("=acct");
                BizReturnObj rt2 = null;
                rt2 = this.buildFirstStringParam(msg);
                if (rt2 != null) {
                    return rt2;
                }
                rt2 = this.buildMidStringParam(msg, 2);
                if (rt2 != null) {
                    return rt2;
                }
                rt2 = this.buildMidStringParam(msg, 3);
                if (rt2 != null) {
                    return rt2;
                }
                rt2 = this.buildMidNumParam(msg, 4);
                if (rt2 != null) {
                    return rt2;
                }
                rt2 = this.buildMidNumParam(msg, 5);
                if (rt2 != null) {
                    return rt2;
                }
                rt2 = this.buildMidNumParam(msg, 6);
                if (rt2 != null) {
                    return rt2;
                }
                rt2 = this.buildMidNumParam(msg, 7);
                if (rt2 != null) {
                    return rt2;
                }
                rt2 = this.buildEndStringParam(msg);
                if (rt2 != null) {
                    return rt2;
                }
                rt2 = this.buildCompany(msg, 1);
                if (rt2 != null) {
                    return rt2;
                }
                rt2 = this.buildCurrency(msg, 8);
                if (rt2 != null) {
                    return rt2;
                }
                rt2 = this.buildYear(msg, 4);
                if (rt2 != null) {
                    return rt2;
                }
                rt2 = this.buildPeriod(msg, 5);
                if (rt2 != null) {
                    return rt2;
                }
                this.buildDate();
                return this.queryValue();
            }
            if (msg.getCommandParams()[0].toUpperCase().equals("ACCTAC")) {
                if (msg.getCommandParams().length != 11) {
                    return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
                }
                QueryObject bo = new QueryObject();
                this.buf.append("=acctac");
                rt = null;
                rt = this.buildFirstStringParam(msg);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 2);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 3);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 4);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidNumParam(msg, 5);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidNumParam(msg, 6);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidNumParam(msg, 7);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidNumParam(msg, 8);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildEndStringParam(msg);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildCompany(msg, 1);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildCurrency(msg, 9);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildYear(msg, 5);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildPeriod(msg, 6);
                if (rt != null) {
                    return rt;
                }
                this.buildDate();
                return this.queryValue();
            }
            if (msg.getCommandParams()[0].toUpperCase().equals("ACCTEXT")) {
                if (msg.getCommandParams().length != 10) {
                    return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
                }
                QueryObject bo = new QueryObject();
                this.buf.append("=acctext");
                rt = null;
                rt = this.buildFirstStringParam(msg);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 2);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 3);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 4);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 5);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 6);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 7);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildEndStringParam(msg);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildCompany(msg, 1);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildCurrency(msg, 6);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildYearPeriodData(msg, 7);
                if (rt != null) {
                    return rt;
                }
                return this.queryValue();
            }
            if (msg.getCommandParams()[0].toUpperCase().equals("AGE")) {
                if (msg.getCommandParams().length != 9) {
                    return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
                }
                QueryObject bo = new QueryObject();
                this.buf.append("=age");
                rt = null;
                rt = this.buildFirstStringParam(msg);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 2);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 3);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 4);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 5);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 6);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildEndStringParam(msg);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildCompany(msg, 1);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildCurrency(msg, 3);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildYearPeriodData(msg, 4);
                if (rt != null) {
                    return rt;
                }
                return this.queryValue();
            }
            if (msg.getCommandParams()[0].toUpperCase().equals("ACCTCASH")) {
                if (msg.getCommandParams().length != 9) {
                    return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
                }
                QueryObject bo = new QueryObject();
                this.buf.append("=acctcash");
                rt = null;
                rt = this.buildFirstStringParam(msg);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 2);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidStringParam(msg, 3);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidNumParam(msg, 4);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidNumParam(msg, 5);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildMidNumParam(msg, 6);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildEndStringParam(msg);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildCompany(msg, 1);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildCurrency(msg, 3);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildYear(msg, 4);
                if (rt != null) {
                    return rt;
                }
                rt = this.buildPeriod(msg, 5);
                if (rt != null) {
                    return rt;
                }
                this.buildDate();
                return this.queryValue();
            }
            return null;
        }

        BizReturnObj buildYear(BizFuncParamObj msg, int intdex) {
            this.year = ReportMobileSupport.this.getNum(msg.getCommandParams()[intdex]);
            if (this.year < 2000 && this.year > 3000) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getErroryearMsg());
            }
            return null;
        }

        BizReturnObj buildPeriod(BizFuncParamObj msg, int intdex) {
            this.period = ReportMobileSupport.this.getNum(msg.getCommandParams()[intdex]);
            if (this.period < 1 && this.period > 13) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getErrorperiodMsg());
            }
            return null;
        }

        BizReturnObj buildCompany(BizFuncParamObj msg, int intdex) {
            try {
                this.company = ReportMobileSupport.this.InitCompanyByNum(msg.getCommandParams()[intdex]);
            }
            catch (BOSException e) {
                return ReportMobileSupport.this.returnError(e.getMessage());
            }
            if (this.company == null) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getErrorCompamyMsg());
            }
            return null;
        }

        BizReturnObj buildCurrency(BizFuncParamObj msg, int intdex) {
            try {
                this.currency = ReportMobileSupport.this.getCurrencyByNum(msg.getCommandParams()[intdex]);
            }
            catch (BOSException e) {
                return ReportMobileSupport.this.returnError(e.getMessage());
            }
            if (this.currency == null) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getErrorCurrencyMsg());
            }
            return null;
        }

        BizReturnObj buildYearPeriodData(BizFuncParamObj msg, int index) {
            String datestr = msg.getCommandParams()[index];
            StringTokenizer stk = new StringTokenizer(datestr, "-");
            try {
                block6: for (int i = 0; i < 3; ++i) {
                    String tk = stk.nextToken();
                    int v = Integer.parseInt(tk);
                    switch (i) {
                        case 0: {
                            this.year = v;
                            continue block6;
                        }
                        case 1: {
                            this.period = v;
                            continue block6;
                        }
                    }
                }
                this.buildDate();
            }
            catch (Throwable e) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getDateErrorString());
            }
            return null;
        }

        void buildDate() {
            this.st = ReportMobileSupport.this.getStartDate(this.year, this.period);
            this.ed = ReportMobileSupport.this.getEndDate(this.year, this.period);
        }

        BizReturnObj buildFirstStringParam(BizFuncParamObj msg) {
            if (ReportMobileSupport.this.isNull(msg.getCommandParams()[1])) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
            }
            if ("null".equalsIgnoreCase(msg.getCommandParams()[1])) {
                this.buf.append("(\"\"");
            } else {
                this.buf.append("(\"" + msg.getCommandParams()[1] + "\"");
            }
            return null;
        }

        BizReturnObj buildEndStringParam(BizFuncParamObj msg) {
            if (ReportMobileSupport.this.isNull(msg.getCommandParams()[msg.getCommandParams().length - 2])) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
            }
            if ("null".equalsIgnoreCase(msg.getCommandParams()[msg.getCommandParams().length - 2])) {
                this.buf.append(",\"\")");
            } else {
                this.buf.append(",\"" + msg.getCommandParams()[msg.getCommandParams().length - 2] + "\")");
            }
            if (ReportMobileSupport.this.isNull(msg.getCommandParams()[msg.getCommandParams().length - 1])) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
            }
            if ("Y".equals(msg.getCommandParams()[msg.getCommandParams().length - 1].toUpperCase())) {
                this.includeInpost = true;
            } else if ("N".equals(msg.getCommandParams()[msg.getCommandParams().length - 1].toUpperCase())) {
                this.includeInpost = false;
            } else {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
            }
            return null;
        }

        BizReturnObj buildFirstNumParam(BizFuncParamObj msg) {
            if (!ReportMobileSupport.this.isNum(msg.getCommandParams()[1])) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
            }
            this.buf.append("(" + msg.getCommandParams()[1] + "");
            return null;
        }

        BizReturnObj buildEndNumParam(BizFuncParamObj msg) {
            if (!ReportMobileSupport.this.isNum(msg.getCommandParams()[msg.getCommandParams().length - 2])) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
            }
            this.buf.append("," + msg.getCommandParams()[msg.getCommandParams().length - 2] + ")");
            if (ReportMobileSupport.this.isNull(msg.getCommandParams()[msg.getCommandParams().length - 1])) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
            }
            if ("Y".equals(msg.getCommandParams()[msg.getCommandParams().length - 1].toUpperCase())) {
                this.includeInpost = true;
            } else if ("N".equals(msg.getCommandParams()[msg.getCommandParams().length - 1].toUpperCase())) {
                this.includeInpost = false;
            } else {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
            }
            return null;
        }

        BizReturnObj buildMidNumParam(BizFuncParamObj msg, int index) {
            if (!ReportMobileSupport.this.isNum(msg.getCommandParams()[index])) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
            }
            this.buf.append("," + msg.getCommandParams()[index] + "");
            return null;
        }

        BizReturnObj buildMidStringParam(BizFuncParamObj msg, int index) {
            if (ReportMobileSupport.this.isNull(msg.getCommandParams()[index])) {
                return ReportMobileSupport.this.returnError(ReportMobileSupport.this.getParamErrorString());
            }
            if ("null".equalsIgnoreCase(msg.getCommandParams()[index])) {
                this.buf.append(",\"\"");
            } else {
                this.buf.append(",\"" + msg.getCommandParams()[index] + "\"");
            }
            return null;
        }
    }
}

