/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.IRptCalcSchRela;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptCalcSchRelaCollection;
import com.kingdee.eas.fi.rpt.RptCalcSchRelaFactory;
import com.kingdee.eas.fi.rpt.RptCalcSchRelaInfo;
import com.kingdee.eas.fi.rpt.RptCalcSchemeCollection;
import com.kingdee.eas.fi.rpt.RptCalcSchemeInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.app.AbstractRptCalcSchemeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RptCalcSchemeControllerBean
extends AbstractRptCalcSchemeControllerBean {
    @Override
    protected void _caclSolu(Context ctx, String pk) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("caclSoluRela.report.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)pk.toString());
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        RptCalcSchemeCollection rptCalcSchemeColl = this.getRptCalcSchemeCollection(ctx, view);
        if (rptCalcSchemeColl == null || rptCalcSchemeColl.size() == 0) {
            return;
        }
        RptCalcSchemeInfo rptCalcSchemeInfo = rptCalcSchemeColl.get(0);
        if (rptCalcSchemeInfo.getCaclSoluRela() == null || rptCalcSchemeInfo.getCaclSoluRela().size() == 0) {
            return;
        }
        RptCalcSchRelaCollection rptCalcSchRelaCollection = rptCalcSchemeInfo.getCaclSoluRela();
        ctx.put((Object)"rptSchemeUserID", (Object)rptCalcSchemeInfo.getLastUpdateUser().getId());
        ctx.put((Object)"UserInfo", (Object)rptCalcSchemeInfo.getLastUpdateUser());
        ctx.setCaller((IObjectPK)new ObjectUuidPK(rptCalcSchemeInfo.getLastUpdateUser().getId()));
        IReport iReport = ReportFactory.getLocalInstance(ctx);
        for (int i = 0; i < rptCalcSchRelaCollection.size(); ++i) {
            iReport.backCacl((IObjectPK)new ObjectUuidPK(rptCalcSchRelaCollection.get(i).getReport().getId()));
        }
    }

    private void getReport(Context ctx, RptCalcSchemeInfo rptCalcSchemeInfo) throws BOSException, EASBizException {
        RptCalcSchRelaCollection soluRela = rptCalcSchemeInfo.getCaclSoluRela();
        if (soluRela == null || soluRela.size() == 0) {
            return;
        }
        for (int i = 0; i < soluRela.size(); ++i) {
            BOSUuid reportid = soluRela.get(i).getReport().getId();
            IReport iReport = ReportFactory.getLocalInstance(ctx);
            iReport.backCacl((IObjectPK)new ObjectUuidPK(reportid));
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RptCalcSchemeInfo rptCalcSchemeInfo = (RptCalcSchemeInfo)model;
        IObjectPK pk = super._addnew(ctx, (IObjectValue)rptCalcSchemeInfo);
        rptCalcSchemeInfo.setId(BOSUuid.read((String)pk.toString()));
        this.addAttach(ctx, rptCalcSchemeInfo);
        return pk;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RptCalcSchemeInfo rptCalcSchemeInfo = (RptCalcSchemeInfo)model;
        super._addnew(ctx, pk, (IObjectValue)rptCalcSchemeInfo);
        rptCalcSchemeInfo.setId(BOSUuid.read((String)pk.toString()));
        this.addAttach(ctx, rptCalcSchemeInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.delAttach(ctx, pk);
        RptCalcSchemeInfo rptCalcSchemeInfo = (RptCalcSchemeInfo)model;
        super._update(ctx, pk, (IObjectValue)rptCalcSchemeInfo);
        this.addAttach(ctx, rptCalcSchemeInfo);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.delAttach(ctx, pk);
        super._delete(ctx, pk);
    }

    private void delAttach(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null || pk.toString() == null || pk.toString().length() == 0) {
            return;
        }
        String oql = "where scheme = '" + pk.toString() + "'";
        IRptCalcSchRela iRptCalcSchRela = RptCalcSchRelaFactory.getLocalInstance(ctx);
        RptCalcSchRelaCollection coll = iRptCalcSchRela.getRptCalcSchRelaCollection(oql);
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                RptCalcSchRelaInfo aRptCalcSchRelaInfo = coll.get(i);
                if (aRptCalcSchRelaInfo.getId() == null) continue;
                String id = aRptCalcSchRelaInfo.getId().toString();
                ObjectUuidPK delpk = new ObjectUuidPK(id);
                iRptCalcSchRela.delete((IObjectPK)delpk);
            }
        }
    }

    private void addAttach(Context ctx, RptCalcSchemeInfo rptCalcSchemeInfo) throws BOSException, EASBizException {
        RptCalcSchRelaCollection relaColl = rptCalcSchemeInfo.getCaclSoluRela();
        if (relaColl == null || relaColl.size() == 0) {
            return;
        }
        IRptCalcSchRela iRptCalcSchRela = RptCalcSchRelaFactory.getLocalInstance(ctx);
        for (int i = 0; i < relaColl.size(); ++i) {
            RptCalcSchRelaInfo rptCalcSchRelaInfo = relaColl.get(i);
            rptCalcSchRelaInfo.setScheme(rptCalcSchemeInfo);
            iRptCalcSchRela.addnew((CoreBaseInfo)rptCalcSchRelaInfo);
        }
    }

    @Override
    protected void _delSoluUseName(Context ctx, String soluName) throws BOSException {
        StringBuffer _relaSql = new StringBuffer("delete T_Rpt_RptCalcSchRela where");
        _relaSql.append(" FSchemeID in (select fid from T_RPT_RptCalcScheme where Fname = ? and FCompanyID = ? )");
        StringBuffer _sql = new StringBuffer("delete T_RPT_RptCalcScheme where");
        _sql.append(" Fname= ? and FCompanyID = ?");
        Object[] params = new Object[]{soluName, ContextUtils.getCurrentCompany((Context)ctx)};
        DbUtil.execute((Context)ctx, (String)_relaSql.toString(), (Object[])params);
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RptCalcSchemeInfo info = (RptCalcSchemeInfo)super._getValue(ctx, pk);
        return info.getName();
    }

    @Override
    protected void _sendMessage(Context ctx, String Title, String Message, String OrgTree, String Company2, String PeriodType, boolean IncludePosted, String Currency2, String StartYear, String EndYear, String StartPeriod, String EndPeriod, String PhoneNumbers) throws BOSException, EASBizException {
        List formulas = this.collectFormulas(Message);
        OrgTreeInfo orgTreeInfo = this.getOrgTreeInfo(ctx, OrgTree);
        FullOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, Company2);
        CurrencyInfo currencyInfo = this.getCurrencyInfo(ctx, Currency2);
        RptPeriodTypeEnum periodTypeEnum = RptPeriodTypeEnum.getEnum((String)PeriodType);
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("IContextHandler_orgtree", orgTreeInfo);
        condition.put("IContextHandler_company", companyInfo);
        condition.put("IContextHandler_period_type", periodTypeEnum);
        condition.put("IContextHandler_INCLUDE_POSTED", IncludePosted ? "Y" : "N");
        condition.put("IContextHandler_currency", currencyInfo);
        condition.put("IContextHandler_begin_year", StartYear);
        condition.put("IContextHandler_end_year", EndYear);
        condition.put("IContextHandler_begin_period", StartPeriod);
        condition.put("IContextHandler_end_period", EndPeriod);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int[] period = RPTDateUtil.getPeriod((Date)calendar.getTime(), (RptPeriodTypeEnum)periodTypeEnum);
        condition.put("IContextHandler_year", new Integer(period[0]));
        condition.put("IContextHandler_period", new Short((short)period[1]));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        condition.put("IContextHandler_begin_date", dateFormat.format(calendar.getTime()));
        condition.put("IContextHandler_end_date", dateFormat.format(calendar.getTime()));
        Variant[] values = ReportFactory.getLocalInstance(ctx).calcFormulas(condition, formulas);
        Message = this.fillFormulaResult(Message, values);
        if (orgTreeInfo != null) {
            Message = Message.replaceAll("\\$OrgTree\\$", orgTreeInfo.getName());
        }
        if (companyInfo != null) {
            Message = Message.replaceAll("\\$Company\\$", companyInfo.getName());
        }
        if (currencyInfo != null) {
            Message = Message.replaceAll("\\$Currency\\$", currencyInfo.getName());
        }
        if (periodTypeEnum != null) {
            Message = Message.replaceAll("\\$PeriodType\\$", periodTypeEnum.getAlias());
        }
        if (String.valueOf(IncludePosted) != null) {
            Message = Message.replaceAll("\\$IncludePosted\\$", String.valueOf(IncludePosted));
        }
        String[] numbers = PhoneNumbers.split(",");
        for (int i = 0; i < numbers.length; ++i) {
            MsgUtil.mobileMsgSend((Context)ctx, (String)(Title + " " + Message), (int)10, (boolean)false, null, (String)numbers[i], null);
        }
    }

    private String fillFormulaResult(String message, Variant[] values) {
        String rex = "\\$\\s*=[^\\$]*\\$";
        Matcher matcher = Pattern.compile(rex).matcher(message);
        ArrayList<int[]> pos = new ArrayList<int[]>();
        while (matcher.find()) {
            pos.add(new int[]{matcher.start(), matcher.end()});
        }
        StringBuffer sb = new StringBuffer(message);
        for (int i = pos.size() - 1; i >= 0; --i) {
            int[] posArray = (int[])pos.get(i);
            sb.replace(posArray[0], posArray[1], values[i].toString());
        }
        return sb.toString();
    }

    private OrgTreeInfo getOrgTreeInfo(Context ctx, String OrgTree) throws BOSException {
        OrgTreeCollection orgTreeCollection = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeCollection("where number = '" + OrgTree + "' and type = 8 order by startDate desc,endDate desc ");
        if (orgTreeCollection != null && orgTreeCollection.size() > 0) {
            return orgTreeCollection.get(0);
        }
        return null;
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String currency) throws BOSException {
        CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("where number = '" + currency + "'");
        if (currencyCollection != null && currencyCollection.size() > 0) {
            return currencyCollection.get(0);
        }
        return null;
    }

    private FullOrgUnitInfo getCompanyInfo(Context ctx, String company) throws BOSException {
        FullOrgUnitCollection orgUnitCollection = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("where number = '" + company + "'");
        if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
            return orgUnitCollection.get(0);
        }
        return null;
    }

    private List collectFormulas(String message) {
        String rex = "\\$\\s*=[^\\$]*\\$";
        Matcher matcher = Pattern.compile(rex).matcher(message);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            String key = matcher.group();
            String formula = key.replaceAll("\\$", "");
            result.add(formula);
        }
        return result;
    }

    @Override
    protected Map _getProcessDef(Context ctx, String jobProcessDefId) throws BOSException, EASBizException {
        if (!jobProcessDefId.endsWith("BGJOBDEF")) {
            int endLength = jobProcessDefId.length() - "BGJOBDEF".length() + 1;
            String str = jobProcessDefId.substring(0, endLength);
            jobProcessDefId = jobProcessDefId + str + "BGJOBDEF";
        }
        String sql = "select t.fscheduleplan define, t.fvalidatetime valtime, t.fusecalendar iscal ,d.fproxyorgid org from t_job_trigger t inner join t_job_def d on d.fjobdefid = t.fjobdefid where t.fjobdefid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{jobProcessDefId});
        HashMap<String, Object> map = null;
        try {
            if (rs.next()) {
                map = new HashMap<String, Object>();
                map.put("rpt_cacl_scheme_define", rs.getString("define"));
                map.put("rpt_cacl_scheme_begintime", rs.getDate("valtime"));
                map.put("rpt_cacl_scheme_is_use_calendar ", rs.getString("iscal"));
                map.put("rpt_cacl_scheme_org", rs.getString("org"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return map;
    }
}

