/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.Account;
import com.kingdee.eas.fi.rpt.app.AccountCache;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptCalculaterDAO {
    private static Logger logger = Logger.getLogger(RptCalculaterDAO.class);
    public static final String REPORTACCOUNTCACHE = "REPORTACCOUNTCACHE";
    public static final String REPORTASSTACCTTYPECACHE = "REPORTASSTACCTTYPECACHE";
    public static final String REPORTCURRENCYCACHE = "REPORTCURRENCYCACHE";
    public static final String REPORTACCOUNTTABLECACHE = "REPORTACCOUNTTABLECACHE";
    public static final String REPORTCSGROUPCACHE = "REPORTCSGROUPCACHE";
    Context context;
    private String _accountTableCount = "SELECT count(FID) ct FROM T_BD_ACCT_CONTORL WHERE FDESTCU = ? AND FISDEFAULTFORREFER = 1";
    private static final String sqlAccountByNumber = "Select V.FID, V.FDc ,V.FIsLeaf, V.FLevel, max(company.FLevel) O_FLevel from T_Bd_AccountView V inner join T_ORG_Company company on company.fid = V.FCompanyID  where V.FNumber = ? and  V.FAccountTableID = ? and company.FID = ?";
    private static final String sqlQueryAssisType = "Select FNumber, FrealtionDataObject FtableName, FmappingFieldName FfieldName ,FUseLongNumber, FGlAsstActTypeGrpID groupID, FGroupTableName , FGroupMappingFieldName  from T_BD_AsstActType where ";

    public RptCalculaterDAO(Context ctx) {
        this.context = ctx;
    }

    public static final BigDecimal executeSUMQuery(Context ctx, String sql, String fvalue, Object[] params) throws BOSException {
        BigDecimal fValue2;
        BigDecimal returnValue = new BigDecimal("0.00");
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            ps = conn.prepareStatement(sql, 1003, 1007);
            DebugLogger.info(logger, "acct execute kql", sql);
            DebugLogger.info(logger, "params", params);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                BigDecimal fValue2 = rs.getBigDecimal(fvalue);
                if (fValue2 == null) continue;
                returnValue = returnValue.add(fValue2);
            }
            fValue2 = returnValue;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return fValue2;
    }

    public int getAccountTableCount(String cuID) throws BOSException {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        HashMap<String, Integer> acctTableCount;
        block6: {
            int n;
            Integer count;
            acctTableCount = (HashMap<String, Integer>)this.context.get((Object)REPORTACCOUNTTABLECACHE);
            if (acctTableCount == null) {
                acctTableCount = new HashMap<String, Integer>(3);
                this.context.put((Object)REPORTACCOUNTTABLECACHE, acctTableCount);
            }
            if ((count = (Integer)acctTableCount.get(cuID)) != null) {
                return count;
            }
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = EJBFactory.getQueryConnection((Context)this.context);
                ps = conn.prepareStatement(this._accountTableCount, 1003, 1007);
                ps.setObject(1, cuID);
                rs = ps.executeQuery();
                if (!rs.next()) break block6;
                int ct = rs.getInt("ct");
                acctTableCount.put(cuID, new Integer(ct));
                n = ct;
            }
            catch (Exception e) {
                try {
                    throw new SQLDataException(e.getMessage());
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return n;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        acctTableCount.put(cuID, new Integer(-1));
        return -1;
    }

    public Account getAccountByNumber(String acctNumber, String companyNumber) throws BOSException, ReportException {
        AccountCache cache = (AccountCache)this.context.get((Object)REPORTACCOUNTCACHE);
        Account acct = null;
        if (cache == null) {
            cache = new AccountCache();
            this.context.put((Object)REPORTACCOUNTCACHE, (Object)cache);
        }
        if (cache.containAccount(companyNumber, acctNumber)) {
            acct = cache.get(companyNumber, acctNumber);
            if (acct == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_noaccount", this.context.getLocale()) + " \"" + acctNumber + "\""});
            }
            return acct;
        }
        CompanyOrgUnitInfo company = RptUtilForServer.getCompanyOrgUnitInfoByNumber(this.context, companyNumber);
        acct = this._getAccountByNumber(acctNumber, company);
        cache.put(companyNumber, acctNumber, acct);
        if (acct == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_noaccount", this.context.getLocale()) + " \"" + acctNumber + "\""});
        }
        return acct;
    }

    public Account getAccountByNumber(String acctNumber, CompanyOrgUnitInfo company) throws BOSException, ReportException {
        String companyNumber;
        AccountCache cache = (AccountCache)this.context.get((Object)REPORTACCOUNTCACHE);
        Account acct = null;
        if (cache == null) {
            cache = new AccountCache();
            this.context.put((Object)REPORTACCOUNTCACHE, (Object)cache);
        }
        if (cache.containAccount(companyNumber = company.getNumber(), acctNumber)) {
            acct = cache.get(companyNumber, acctNumber);
            if (acct == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_noaccount", this.context.getLocale()) + " \"" + acctNumber + "\""});
            }
            return acct;
        }
        acct = this._getAccountByNumber(acctNumber, company);
        cache.put(companyNumber, acctNumber, acct);
        if (acct == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_noaccount", this.context.getLocale()) + " \"" + acctNumber + "\""});
        }
        return acct;
    }

    private Account _getAccountByNumber(String acctNumber, CompanyOrgUnitInfo company) throws BOSException, ReportException {
        Account account;
        if (company.getAccountTable() == null) {
            throw new ReportException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE);
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)this.context);
            String sql = sqlAccountByNumber;
            sql = sql + " GROUP BY V.FID, V.FDc ,V.FIsLeaf, V.FLevel";
            ps = conn.prepareStatement(sql, 1003, 1007);
            ps.setObject(1, acctNumber);
            ps.setObject(2, company.getAccountTable().getId().toString());
            ps.setObject(3, company.getId().toString());
            rs = ps.executeQuery();
            int lastLevel = 0;
            Account acct = null;
            while (rs.next()) {
                Account myacct = new Account();
                myacct.id = rs.getString(1);
                myacct.dc = rs.getInt(2);
                myacct.isLeaf = rs.getInt(3) == 1;
                myacct.level = rs.getInt(4);
                myacct.number = acctNumber;
                int ol = rs.getInt(5);
                if (ol < lastLevel) continue;
                acct = myacct;
                lastLevel = ol;
            }
            account = acct;
        }
        catch (Exception e) {
            try {
                throw new SQLDataException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return account;
    }

    private static final String[] getCompanyLongNumber(String sx) {
        String[] x = sx.split("!");
        String[] companyLongNumberSplit = new String[x.length];
        for (int i = 0; i < x.length; ++i) {
            String s = "";
            for (int j = 0; j <= i; ++j) {
                if (j != 0) {
                    s = s + '!';
                }
                s = s + x[j];
            }
            companyLongNumberSplit[i] = s;
        }
        return companyLongNumberSplit;
    }

    public Map getAsstActTypeByNumber(Set typeNumbers) throws BOSException, ReportException {
        HashMap asstAcctTypes = (HashMap)this.context.get((Object)REPORTASSTACCTTYPECACHE);
        if (asstAcctTypes == null) {
            asstAcctTypes = new HashMap(2);
            this.context.put((Object)REPORTASSTACCTTYPECACHE, asstAcctTypes);
        }
        return this._getAsstActTypeByNumber(typeNumbers, asstAcctTypes);
    }

    public AsstActType getAsstActTypeByNumber(String typeNumber) throws BOSException, ReportException {
        HashSet<String> typeNumbers = new HashSet<String>(2);
        typeNumbers.add(typeNumber);
        AsstActType result = (AsstActType)this.getAsstActTypeByNumber(typeNumbers).get(typeNumber);
        if (result == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_noitemtype", this.context.getLocale()) + " \"" + typeNumber + "\""});
        }
        return result;
    }

    private Map _getAsstActTypeByNumber(Set typeNumbers, Map typeCache) throws BOSException, ReportException {
        ArrayList<String> parameters = new ArrayList<String>(2);
        HashMap result = new HashMap(2);
        int i = 1;
        StringBuffer sql = new StringBuffer(sqlQueryAssisType);
        for (String strItemType : typeNumbers) {
            if (typeCache.containsKey(strItemType)) {
                result.put(strItemType, typeCache.get(strItemType));
                continue;
            }
            if (i > 1) {
                sql.append(" or ");
            }
            sql.append(" Fnumber = ? ");
            parameters.add(strItemType);
            ++i;
        }
        if (parameters.size() < 1) {
            return result;
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])parameters.toArray());
            while (rowSet.next()) {
                AsstActType type = new AsstActType();
                type.realtionDataObject = rowSet.getString("FtableName").toUpperCase();
                type.mappingFieldName = rowSet.getString("FfieldName").toUpperCase();
                type.number = rowSet.getString("FNumber");
                type.glAsstActTypeGrpID = rowSet.getString("groupID");
                type.groupTableName = rowSet.getString("FGroupTableName");
                type.useLongNumber = rowSet.getBoolean("FUseLongNumber");
                type.groupMappingFieldName = rowSet.getString("FGroupMappingFieldName");
                result.put(type.number, type);
                typeCache.put(type.number, type);
            }
        }
        catch (SQLException e) {
            throw new ReportException(ReportException.CALC_ERROR, (Throwable)e);
        }
        return result;
    }

    public CurrencyInfo getCurrencyByNumber(String currencyNumber) throws BOSException, ReportException {
        CurrencyInfo currency;
        HashMap<String, CurrencyInfo> cache = (HashMap<String, CurrencyInfo>)this.context.get((Object)REPORTCURRENCYCACHE);
        if (cache == null) {
            cache = new HashMap<String, CurrencyInfo>(2);
            this.context.put((Object)REPORTCURRENCYCACHE, cache);
        }
        if ((currency = (CurrencyInfo)cache.get(currencyNumber)) != null) {
            return currency;
        }
        int scale = 2;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)currencyNumber));
        SelectorItemCollection sic = view.getSelector();
        SelectorItemCollection sic_1 = new SelectorItemCollection();
        sic_1.add(new SelectorItemInfo("precision"));
        sic_1.add(new SelectorItemInfo("id"));
        sic_1.add(new SelectorItemInfo("number"));
        sic.addObjectCollection((IObjectCollection)sic_1);
        ICurrency cy = CurrencyFactory.getLocalInstance((Context)this.context);
        CurrencyCollection cyCol = cy.getCurrencyCollection(view);
        if (cyCol != null && cyCol.size() > 0) {
            currency = cyCol.get(0);
            scale = currency.getPrecision();
            scale = scale < 0 ? 0 : scale;
            currency.setPrecision(scale);
        }
        cache.put(currencyNumber, currency);
        if (currency == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_nocurrency", this.context.getLocale()) + " \"" + currencyNumber + "\""});
        }
        return currency;
    }

    public Map getGroupLongNumber(String[] numbers, String groupBrowseTableName) throws BOSException, ReportException {
        HashMap<String, GroupTreeNode> cache = (HashMap<String, GroupTreeNode>)this.context.get((Object)REPORTCSGROUPCACHE);
        if (cache == null) {
            cache = new HashMap<String, GroupTreeNode>(5);
            this.context.put((Object)REPORTCSGROUPCACHE, cache);
        }
        HashMap result = new HashMap(2);
        HashSet<String> toQuery = new HashSet<String>(2);
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = numbers[i];
            Object obj = cache.get(groupBrowseTableName + numbers[i]);
            if (obj != null) {
                result.put(numbers[i], obj);
                continue;
            }
            toQuery.add(numbers[i]);
        }
        if (toQuery.size() > 0) {
            Map map = this._getGroupLongNumber(toQuery.toArray(), groupBrowseTableName);
            for (String num : toQuery) {
                GroupTreeNode node = (GroupTreeNode)map.get(num);
                result.put(num, node);
                cache.put(groupBrowseTableName + num, node);
            }
        }
        return result;
    }

    private Map _getGroupLongNumber(Object[] numbers, String groupBrowseTableName) throws BOSException, ReportException {
        if (numbers == null || numbers.length < 1) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FNumber, FLongNumber, FLevel from ").append(groupBrowseTableName).append(" where");
        String[] params = new String[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            params[i] = numbers[i].toString().toUpperCase();
            if (i == 0) {
                sql.append(" FNumber = ? ");
                continue;
            }
            sql.append(" or FNumber = ? ");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])numbers);
            HashMap<Object, GroupTreeNode> result = new HashMap<Object, GroupTreeNode>(2);
            block3: while (rowSet.next()) {
                GroupTreeNode item = new GroupTreeNode();
                item.longNumber = rowSet.getString("FLongNumber");
                item.number = rowSet.getString("FNumber");
                item.level = rowSet.getInt("FLevel");
                for (int i = 0; i < numbers.length; ++i) {
                    if (!item.number.equalsIgnoreCase(numbers[i].toString())) continue;
                    result.put(numbers[i], item);
                    continue block3;
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"DataBaseErrorWhenFetchData", (Locale)this.context.getLocale()) + e.getMessage()});
        }
    }

    protected static void clearServerCache(Context ctx) throws BOSException {
        ctx.remove((Object)REPORTACCOUNTCACHE);
        ctx.remove((Object)REPORTASSTACCTTYPECACHE);
        ctx.remove((Object)REPORTCURRENCYCACHE);
        ctx.remove((Object)REPORTACCOUNTTABLECACHE);
        ctx.remove((Object)REPORTCSGROUPCACHE);
        ctx.remove((Object)"rptCurrencyCache");
        ctx.remove((Object)"rptComapany");
        ctx.remove((Object)"rptCurrency");
        ctx.remove((Object)"rptComapanyID");
        ctx.remove((Object)"rptCurrPeriodCache");
        ctx.remove((Object)"rptPeriodCache");
        ctx.remove((Object)"rptPeriod");
        ctx.remove((Object)"rptStartPeriodCache");
        ctx.remove((Object)"rptPeriod");
        ctx.remove((Object)"rptStartPeriodCache");
    }
}

