/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.app.SheetContainer;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class RptContainer {
    public static final int CACHESIZE = 5;
    public static final String RPTCACHEHEAD = "rpt";
    public static final String TMPCACHEHEAD = "tmp";
    private static RptContainer THIS = null;
    private boolean isCached = true;
    private HashMap codeCache = new HashMap(5);

    private RptContainer() {
    }

    public static RptContainer getInstance() {
        if (THIS == null) {
            THIS = new RptContainer();
        }
        return THIS;
    }

    public SheetContainer getReport(Context ctx, String name, String orgCode) throws BOSException {
        String hash = this.getHashValue(name, orgCode);
        SheetContainer res = this.findInCache(hash);
        if (res != null) {
            return res;
        }
        res = new SheetContainer(this.getReportRaw(ctx, name, orgCode), ctx);
        if (res == null) {
            return null;
        }
        return this.cacheUp(hash, res);
    }

    public SheetContainer getReport(Context ctx, String fiOrgUnit, int year, int period, String currency, String tempType, String tempCode, String groupTempType, int periodType) throws BOSException, EASBizException {
        String hash = this.getHashValue(fiOrgUnit, String.valueOf(year), String.valueOf(period), currency, tempType, tempCode);
        SheetContainer res = this.findInCache(hash);
        if (res != null) {
            return res;
        }
        if (tempType.trim().equals("1")) {
            res = new SheetContainer(this.getReportRaw(ctx, fiOrgUnit, year, period, currency, tempType, tempCode, periodType), ctx);
        } else if (tempType.trim().equals("99")) {
            res = new SheetContainer(this.getGroupReportRaw(ctx, fiOrgUnit, String.valueOf(year), String.valueOf(period), currency, tempType, tempCode), ctx);
        }
        if (res == null) {
            return null;
        }
        return this.cacheUp(hash, res);
    }

    public SheetContainer getReportCollection(Context ctx, String fiOrgUnit, int year, int period, String currency, String tempType, String tempCode, String groupTempType, int periodType) throws BOSException, EASBizException {
        String hash = "collection" + this.getHashValue(fiOrgUnit, String.valueOf(year), String.valueOf(period), currency, tempType, tempCode);
        SheetContainer res = this.findInCache(hash);
        if (res != null) {
            return res;
        }
        res = tempType.trim().equals("1") ? new SheetContainer((IObjectCollection)RptContainer.getReportCollection(ctx, fiOrgUnit, year, period, currency, tempType, tempCode, periodType), ctx) : (tempType.trim().equals("99") ? new SheetContainer((IObjectCollection)RptContainer.getGroupReportCollection(ctx, fiOrgUnit, String.valueOf(year), String.valueOf(period), currency, tempType, tempCode, "ACTUALDATA"), ctx) : new SheetContainer(CslRptUtil.getReportCollection((Context)ctx, (String)fiOrgUnit, (int)year, (int)period, (String)currency, (String)tempCode, (String)groupTempType), ctx));
        if (res == null) {
            return null;
        }
        return this.cacheUp(hash, res);
    }

    private ReportInfo getReportRaw(Context ctx, String name, String orgCode) throws BOSException {
        IReport iReport = ReportFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)name));
        filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)orgCode));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        CoreBaseCollection collection = iReport.getCollection(viewInfo);
        return collection.size() > 0 ? (ReportInfo)collection.getObject(0) : null;
    }

    private ReportInfo getReportRaw(Context ctx, String fiOrgUnit, int year, int period, String currency, String tempType, String tempCode, int periodType) throws BOSException {
        IReport iReport = ReportFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        fic.add(new FilterItemInfo("number", (Object)tempCode));
        fic.add(new FilterItemInfo("templateType", (Object)tempType));
        fic.add(new FilterItemInfo("company.number", (Object)fiOrgUnit));
        filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)new Integer(1)));
        viewInfo.getSelector().add(new SelectorItemInfo("periodtype"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        ITemplate itemplate = TemplateFactory.getLocalInstance(ctx);
        CoreBaseCollection templateColl = itemplate.getCollection(viewInfo);
        if (templateColl == null || templateColl.size() < 1) {
            return null;
        }
        TemplateInfo tinfo = (TemplateInfo)templateColl.get(0);
        fic.clear();
        fic.add(new FilterItemInfo("template.id", (Object)tinfo.getId().toString()));
        fic.add(new FilterItemInfo("currency.number", (Object)currency));
        fic.add(new FilterItemInfo("year", (Object)String.valueOf(year)));
        fic.add(new FilterItemInfo("period", (Object)String.valueOf(period)));
        viewInfo.getSelector().clear();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        CoreBaseCollection collection = iReport.getCollection(viewInfo);
        return collection.size() > 0 ? (ReportInfo)collection.getObject(0) : null;
    }

    public static CoreBaseCollection getReportCollectionForPublicTemplate(Context ctx, String fiOrgUnit, String year, String period, String currency, String tempType, String tempCode, String dataCollectNumber, String srcCurrency, boolean isAdjusted) throws BOSException, EASBizException {
        FullOrgUnitInfo company = null;
        CoreBaseCollection collection = new CoreBaseCollection();
        try {
            company = RptUtilForServer.getFullOrgUnitInfoByNumber(ctx, fiOrgUnit);
            if (company == null) {
                throw new ReportException(ReportException.FIND_COMPANY_ERROR);
            }
        }
        catch (BOSException e) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR, (Throwable)e);
        }
        boolean isSrcCurrencyNull = StringUtils.isEmpty((String)srcCurrency);
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder kqlBuilder = new StringBuilder();
        kqlBuilder.append(" SELECT TOP 1 REPORT.FID              \n").append(" FROM T_RPT_REPORT REPORT                       \n").append(" INNER JOIN T_RPT_TEMPLATE TEMPLATE             \n").append(" ON REPORT.FTemplateID = TEMPLATE.FID           \n").append(" INNER JOIN T_BD_CURRENCY CURRENCY              \n").append(" ON REPORT.FCurrencyID = CURRENCY.FID           \n");
        if (!isSrcCurrencyNull) {
            kqlBuilder.append(" INNER JOIN T_BD_CURRENCY SRCCURRENCY           \n");
            kqlBuilder.append(" ON REPORT.FsourceCurrencyId = SRCCURRENCY.FID  \n");
        }
        kqlBuilder.append(" WHERE REPORT.FCompanyID = ?          \n").append(" AND REPORT.FYear = ?                           \n").append(" AND REPORT.FPeriod = ?                         \n").append(" AND CURRENCY.FNumber = ?                       \n");
        if (!isSrcCurrencyNull) {
            kqlBuilder.append(" AND SRCCURRENCY.FNumber = ?      \n");
        }
        kqlBuilder.append(" AND TEMPLATE.FTemplateType = ?       \n").append(" AND TEMPLATE.FNumber = ?                       \n").append(" AND REPORT.FDataCollectNumber = ?              \n").append(" ORDER BY REPORT.FCreateTime DESC               \n");
        params.add(company.getId().toString());
        params.add(year);
        params.add(period);
        params.add(currency);
        if (!isSrcCurrencyNull) {
            params.add(srcCurrency);
        }
        params.add(tempType);
        params.add(tempCode);
        params.add(dataCollectNumber);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)kqlBuilder.toString(), (Object[])params.toArray());
            if (rs.next()) {
                String fid = rs.getString("FID");
                IReport iReport = ReportFactory.getLocalInstance(ctx);
                ReportInfo report = (ReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(fid));
                collection.add((CoreBaseInfo)report);
            }
        }
        catch (SQLException e) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("ErrorOccuredWhenFetchData") + e.getMessage()});
        }
        return collection;
    }

    public static CoreBaseCollection getReportCollectionForPublicTemplate(Context ctx, String fiOrgUnit, String year, String period, String currency, String tempType, String tempCode, String dataCollectNumber) throws BOSException, EASBizException {
        return RptContainer.getReportCollectionForPublicTemplate(ctx, fiOrgUnit, year, period, currency, tempType, tempCode, dataCollectNumber, null, false);
    }

    public static CoreBaseCollection getReportCollection(Context ctx, String fiOrgUnit, int year, int period, String currency, String tempType, String tempCode, int periodType, String srcCurrency, boolean isAdjusted) throws BOSException {
        IReport iReport = ReportFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        fic.add(new FilterItemInfo("number", (Object)tempCode));
        fic.add(new FilterItemInfo("templateType", (Object)tempType));
        fic.add(new FilterItemInfo("company.number", (Object)fiOrgUnit));
        filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)new Integer(1)));
        viewInfo.getSelector().add(new SelectorItemInfo("periodtype"));
        viewInfo.getSelector().add(new SelectorItemInfo("group"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        ITemplate itemplate = TemplateFactory.getLocalInstance(ctx);
        CoreBaseCollection templateColl = itemplate.getCollection(viewInfo);
        if (templateColl == null || templateColl.size() < 1) {
            return null;
        }
        TemplateInfo tinfo = (TemplateInfo)templateColl.get(0);
        fic.clear();
        fic.add(new FilterItemInfo("template.group", (Object)tinfo.getGroup()));
        fic.add(new FilterItemInfo("currency.number", (Object)currency));
        if (!StringUtils.isEmpty((String)srcCurrency)) {
            fic.add(new FilterItemInfo("sourceCurrency.number", (Object)srcCurrency));
        }
        fic.add(new FilterItemInfo("year", (Object)String.valueOf(year)));
        fic.add(new FilterItemInfo("period", (Object)String.valueOf(period)));
        viewInfo.getSelector().clear();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        SorterItemInfo s = new SorterItemInfo("createTime");
        s.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(s);
        viewInfo.setTopCount(1);
        CoreBaseCollection collection = iReport.getCollection(viewInfo);
        if (collection.size() > 1) {
            CoreBaseInfo info = collection.get(0);
            collection = new CoreBaseCollection();
            collection.add(info);
        }
        return collection.size() > 0 ? collection : null;
    }

    public static CoreBaseCollection getReportCollection(Context ctx, String fiOrgUnit, int year, int period, String currency, String tempType, String tempCode, int periodType) throws BOSException {
        return RptContainer.getReportCollection(ctx, fiOrgUnit, year, period, currency, tempType, tempCode, periodType, null, false);
    }

    public ReportInfo getGroupReportRaw(Context ctx, String fiOrgUnit, String year, String period, String currency, String tempType, String tempCode) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer();
        CompanyOrgUnitInfo company = null;
        try {
            company = RptUtilForServer.getCompanyOrgUnitInfoByNumber(ctx, fiOrgUnit);
        }
        catch (BOSException e) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR, (Throwable)e);
        }
        if (company == null) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR);
        }
        ArrayList<String> params = new ArrayList<String>();
        _sql.append(" select t.FID as FID from t_rpt_report t  \n").append(" inner join T_BD_Currency c on c.fid = t.FCurrencyID \n").append(" where \n").append(" ftemplateid in ( \n").append(" select * from (  \n").append(" SELECT DISTINCT TEMPLATE.FID \n").append(" from T_RPT_Template as TEMPLATE  \n").append(" inner join T_CSL_TempletDispense d on TEMPLATE.fid = d.FDispenseSrcID  \n").append(" where (d.FCompanyID = ? ) \n").append(" and TEMPLATE.fversionstatus = 1  \n").append(" and (TEMPLATE.FTemplateType = 6").append(" or TEMPLATE.FTemplateType=10) \n").append(" and Template.fnumber = ? \n").append(" and  \n").append(" TEMPLATE.fid not in( \n").append(" select t.FGroupTemplateID  \n").append(" from T_RPT_Template t where t.FCompanyID = ?  \n").append(" and t.FVersionStatus = 1 ").append(" and (t.FTemplateType = 2 or t.FTemplateType=12) ").append(" )  \n").append(" union   \n").append(" SELECT DISTINCT TEMPLATE.FID \n").append(" from T_RPT_Template TEMPLATE  \n").append(" inner join T_RPT_Template t2 on TEMPLATE.FGroup = t2.FGroup  \n").append(" inner join T_CSL_TempletDispense d on t2.fid = d.FDispenseSrcID  \n").append(" where TEMPLATE.fcompanyid = ?  \n").append(" and TEMPLATE.fversionstatus < 2 ").append(" and (TEMPLATE.FTemplateType = 2 or TEMPLATE.FTemplateType=12 ) \n").append(" and TEMPLATE.FPublishedStatus = 1 \n").append("  AND TEMPLATE.FVERSIONSTATUS = 1  \n").append("  and Template.fnumber = ? \n").append(" union   \n").append(" SELECT DISTINCT TEMPLATE.FID \n").append(" from T_RPT_Template TEMPLATE  \n").append(" inner join T_RPT_Template t2 on TEMPLATE.FGroup = t2.FGroup  \n").append(" inner join T_CSL_TempletDispense d on t2.fid = d.FDispenseSrcID  \n").append(" where d.fcompanyid = ?  \n").append(" and TEMPLATE.fversionstatus = 2 ").append(" and (TEMPLATE.FTemplateType = 6 or TEMPLATE.FTemplateType=10 ) \n").append(" and TEMPLATE.FPublishedStatus = 1 \n").append("  and Template.fnumber = ? \n").append(" )as tt  \n").append(" ) \n").append(" and t.FYear = ? \n").append(" and t.FPeriod = ? \n").append(" and c.FNumber = ? \n").append(" and t.FCompanyID = ? \n");
        params.add(company.getId().toString());
        params.add(tempCode);
        params.add(company.getId().toString());
        params.add(company.getId().toString());
        params.add(tempCode);
        params.add(company.getId().toString());
        params.add(tempCode);
        params.add(year);
        params.add(period);
        params.add(currency);
        params.add(company.getId().toString());
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)_sql.toString(), (Object[])params.toArray());
            if (rs.next()) {
                String fid = rs.getString("FID");
                IReport iReport = ReportFactory.getLocalInstance(ctx);
                ReportInfo report = (ReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(fid));
                return report;
            }
        }
        catch (Exception e) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"ErrorOccuredWhenFetchData", (Locale)ctx.getOriginLocale()) + e.getMessage()});
        }
        return null;
    }

    public static CoreBaseCollection getGroupReportCollection(Context ctx, String fiOrgUnit, String year, String period, String currency, String tempType, String tempCode, String dataCollectNumber, String srcCurrency, boolean isAdjusted) throws BOSException, EASBizException {
        IReport iReport;
        boolean isSrcCurrencyEmpty = StringUtils.isEmpty((String)srcCurrency);
        String report_id = (String)ctx.get((Object)"report_id");
        if (!StringUtils.isEmpty((String)report_id) && (iReport = ReportFactory.getLocalInstance(ctx)).exists((IObjectPK)new ObjectUuidPK(report_id))) {
            ReportInfo reportInfo = iReport.getReportInfo((IObjectPK)new ObjectUuidPK(report_id));
            String fiOrgUnitid = reportInfo.getCompany().getId().toString();
            FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(fiOrgUnitid));
            String rFiOrgUnit = orgUnitInfo.getNumber();
            String rYear = String.valueOf(reportInfo.getYear());
            String rPeriod = String.valueOf(reportInfo.getPeriod());
            String currencyid = reportInfo.getCurrency().getId().toString();
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
            String rCurrency = currencyInfo.getNumber();
            if (rFiOrgUnit.equals(fiOrgUnit) && rYear.equals(year) && rPeriod.equals(period) && rCurrency.equals(currency)) {
                CoreBaseCollection collection = new CoreBaseCollection();
                collection.add((CoreBaseInfo)reportInfo);
                return collection;
            }
        }
        StringBuffer _sql = new StringBuffer();
        FullOrgUnitInfo company = null;
        try {
            company = RptUtilForServer.getFullOrgUnitInfoByNumber(ctx, fiOrgUnit);
        }
        catch (BOSException e) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR, (Throwable)e);
        }
        if (company == null) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR);
        }
        ArrayList<String> params = new ArrayList<String>();
        _sql.append("select top 1 RPT.FID                                                 ").append("from t_csl_cslreport rpt                                                ").append("inner join t_rpt_template main on main.Fid = rpt.FTemplateid         ").append("inner join T_BD_Currency c on c.fid = rpt.FCurrencyID                ");
        if (!isSrcCurrencyEmpty) {
            _sql.append("inner join T_BD_Currency srcCu on srcCu.fid = rpt.FSourceCurrencyID    ");
            _sql.append("left join t_csl_cslreport adjustRpt on adjustRpt.fsourcerptid=rpt.fid and adjustRpt.fadjustStatus=1  \r\n");
        }
        _sql.append("where main.FGroup in (                                           ").append(" SELECT DISTINCT TEMPLATE.FGroup                                     ").append(" from T_RPT_Template TEMPLATE                                        ").append(" inner join T_RPT_Template t2 on TEMPLATE.FGroup = t2.FGroup         ").append(" inner join T_CSL_TempletDispense d on t2.fid = d.FDispenseSrcID     ").append(" where d.fcompanyid =  ? ").append(" and TEMPLATE.fversionstatus = 1                                     ").append(" and (TEMPLATE.FTemplateType = ?  )      ").append(" and TEMPLATE.FPublishedStatus = 1                                   ").append(" and Template.fnumber =  ?                                       ").append(")                                                                    ").append(" and rpt.FYear = ?                                                ").append(" and rpt.FPeriod = ?                                                 ").append(" and c.FNumber = ?                                              ");
        if (!isSrcCurrencyEmpty) {
            _sql.append(" and srcCu.FNumber = ?                                       ");
            if (isAdjusted) {
                _sql.append(" and (rpt.fadjustStatus=1 or (adjustRpt.fid is null and rpt.fadjustStatus=0))");
            } else {
                _sql.append(" and rpt.fadjustStatus=0");
            }
        }
        _sql.append(" and rpt.FCompanyID = ? ").append(" and rpt.FDataCollectNumber = ? ").append(" order by RPT.FCreateTime DESC                                       ");
        params.add(company.getId().toString());
        if (tempType.equals(String.valueOf(12))) {
            tempType = String.valueOf(10);
        }
        params.add(tempType);
        params.add(tempCode);
        params.add(year);
        params.add(period);
        params.add(currency);
        if (!isSrcCurrencyEmpty) {
            params.add(srcCurrency);
        }
        params.add(company.getId().toString());
        params.add(dataCollectNumber);
        try {
            CoreBaseCollection collection = new CoreBaseCollection();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)_sql.toString(), (Object[])params.toArray());
            while (rs.next()) {
                String fid = rs.getString("FID");
                ICslReport iReport2 = CslReportFactory.getLocalInstance((Context)ctx);
                CslReportInfo report = (CslReportInfo)iReport2.getValue((IObjectPK)new ObjectUuidPK(fid));
                collection.add((CoreBaseInfo)report);
            }
            if (collection.size() > 0) {
                CslReportInfo _report = (CslReportInfo)collection.get(0);
                collection = new CoreBaseCollection();
                collection.add((CoreBaseInfo)_report);
                return collection;
            }
            return null;
        }
        catch (Exception e) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"ErrorOccuredWhenFetchData", (Locale)ctx.getOriginLocale()) + e.getMessage()});
        }
    }

    public static CoreBaseCollection getGroupReportCollection(Context ctx, String fiOrgUnit, String year, String period, String currency, String tempType, String tempCode, String dataCollectNumber) throws BOSException, EASBizException {
        return RptContainer.getGroupReportCollection(ctx, fiOrgUnit, year, period, currency, tempType, tempCode, dataCollectNumber, null, false);
    }

    private SheetContainer cacheUp(String key, SheetContainer data) {
        return data;
    }

    private SheetContainer findInCache(String hash) {
        return null;
    }

    private String getHashValue(String name, String orgCode) {
        return RPTCACHEHEAD + name + orgCode;
    }

    private String getHashValue(String fiOrgUnit, String year, String period, String currency, String tempType, String tempCode) {
        return TMPCACHEHEAD + fiOrgUnit + year + period + currency + tempType + tempCode;
    }

    private int periodConvert(int reportPeriodType, int templatePeriodType, int year, int period) {
        if (reportPeriodType == -1 || reportPeriodType == templatePeriodType) {
            return period;
        }
        Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)reportPeriodType));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(periodLastDate);
        int month = calendar.get(2) + 1;
        switch (templatePeriodType) {
            case 1: {
                return calendar.get(6);
            }
            case 2: {
                return calendar.get(3);
            }
            case 3: {
                return month;
            }
            case 4: {
                return month < 4 ? 1 : (month < 7 ? 2 : (month < 10 ? 3 : 4));
            }
            case 5: {
                return month < 7 ? 1 : 2;
            }
            case 6: {
                return 1;
            }
        }
        return period;
    }
}

