/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.IIndexItem;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.IndexDataCollection;
import com.kingdee.eas.fi.rpt.IndexDataFactory;
import com.kingdee.eas.fi.rpt.IndexDataInfo;
import com.kingdee.eas.fi.rpt.IndexItemFactory;
import com.kingdee.eas.fi.rpt.IndexItemInfo;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.app.AbstractRptIndexFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Locale;

public class RptIndexFacadeControllerBean
extends AbstractRptIndexFacadeControllerBean {
    private static final long serialVersionUID = 902979233758865465L;

    @Override
    protected IndexItemInfo _getLatestIndexItem(Context ctx, String companyNum, String number, int rptSrcType) throws BOSException, EASBizException {
        return this.selfGetLatestIndexItem(ctx, companyNum, number, rptSrcType);
    }

    private IndexItemInfo selfGetLatestIndexItem(Context ctx, String companyNum, String number, int rptSrcType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)companyNum) || rptSrcType != 1 && rptSrcType != 6 && rptSrcType != 7) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select idx.fid fidxid, tmp.fid ftmpid from t_rpt_indexitem idx");
        sql.append("\t\tinner join t_rpt_template tmp on idx.ftemplateid = tmp.fid");
        sql.append("\t\tinner join t_org_company company on company.fid = idx.fcompanyid");
        sql.append("\t\t\twhere idx.fnumber = ? and company.fnumber = ? ");
        try {
            IRowSet rs = null;
            if (rptSrcType == 7) {
                sql.append(" and tmp.ftemplatetype = ? ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{number, companyNum, new Integer(2)});
            } else if (rptSrcType == 1 || rptSrcType == 6) {
                sql.append(" and (tmp.ftemplatetype = ? or tmp.ftemplatetype = ?) ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{number, companyNum, new Integer(1), new Integer(14)});
            }
            if (rs == null || !rs.next()) {
                return null;
            }
            String indexId = rs.getString("fidxid");
            String templateId = rs.getString("ftmpid");
            ITemplate iTemplate = TemplateFactory.getLocalInstance(ctx);
            IIndexItem iIndexItem = IndexItemFactory.getLocalInstance(ctx);
            IndexItemInfo indexItem = iIndexItem.getIndexItemInfo((IObjectPK)new ObjectUuidPK(indexId));
            IObjectPK templatePk = iTemplate.getLatestVersion((IObjectPK)new ObjectUuidPK(templateId));
            if (templatePk == null || templatePk != null && templatePk.toString().equals(templateId)) {
                return indexItem;
            }
            sql.setLength(0);
            sql.append("SELECT IDX.FID FIDXID FROM T_RPT_INDEXITEM IDX");
            sql.append("\tINNER JOIN  T_ORG_COMPANY COMPANY ON IDX.FCOMPANYID = COMPANY.FID");
            sql.append("\t\tWHERE IDX.FNUMBER = ? AND IDX.FTEMPLATEID = ? AND COMPANY.FNUMBER = ?");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{number, templatePk.toString(), companyNum});
            if (rs == null || !rs.next()) {
                return null;
            }
            return iIndexItem.getIndexItemInfo((IObjectPK)new ObjectUuidPK(rs.getString("FIDXID")));
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected String _getLatestIndexData(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        EntityViewInfo indexDataView = new EntityViewInfo();
        indexDataView.setFilter(filterInfo);
        indexDataView.getSelector().add(new SelectorItemInfo("indexValue"));
        SorterItemInfo sorter = new SorterItemInfo("startYear");
        sorter.setSortType(SortType.ASCEND);
        SorterItemInfo sorter2 = new SorterItemInfo("startPeriod");
        sorter2.setSortType(SortType.ASCEND);
        indexDataView.getSorter().add(sorter);
        indexDataView.getSorter().add(sorter2);
        IndexDataCollection indexDatas = IndexDataFactory.getLocalInstance(ctx).getIndexDataCollection(indexDataView);
        if (indexDatas.size() > 0) {
            Iterator it = indexDatas.iterator();
            BigDecimal sumIndexData = new BigDecimal("0.0");
            while (it.hasNext()) {
                try {
                    BigDecimal number = new BigDecimal(((IndexDataInfo)it.next()).getIndexValue());
                    sumIndexData = sumIndexData.add(number);
                }
                catch (Exception e) {
                    return "ERROR:" + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"SumIndexItemExistsNoneNumber", (Locale)ctx.getOriginLocale());
                }
            }
            return sumIndexData.toString();
        }
        return null;
    }

    @Override
    protected void _synVersionIndex(Context ctx, String oldTemplateId, String newTemplateId) throws BOSException, EASBizException {
        if (oldTemplateId == null || newTemplateId == null || oldTemplateId.length() == 0 || newTemplateId.length() == 0) {
            return;
        }
        IIndexItem indexFactory = IndexItemFactory.getLocalInstance(ctx);
        String getIndexItemSql = "SELECT FID ,FSHEETPARAM FROM T_RPT_INDEXITEM WHERE FTEMPLATEID = '" + oldTemplateId + "'";
        String getRptSheetSql = "SELECT TARGET.FID FROM T_RPT_RPTSHEETPARA ORIGEN,T_RPT_RPTSHEETPARA TARGET WHERE ORIGEN.FREPORTID = '" + oldTemplateId + "' AND TARGET.FREPORTID = '" + newTemplateId + "' AND ORIGEN.FSHEETID = TARGET.FSHEETID AND ORIGEN.FID = '";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getIndexItemSql);
        try {
            while (rs.next()) {
                String indexId = rs.getString(1);
                String oldSheetUuid = rs.getString(2);
                IndexItemInfo indexItem = indexFactory.getIndexItemInfo((IObjectPK)new ObjectUuidPK(indexId));
                IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)(getRptSheetSql + oldSheetUuid + "'"));
                if (!rs2.next()) continue;
                String newSheetUuid = rs2.getString(1);
                indexItem = (IndexItemInfo)indexItem.clone();
                indexItem.setId(null);
                indexItem.setTemplateId(newTemplateId);
                RptSheetParamInfo sheetParamInfo = new RptSheetParamInfo();
                sheetParamInfo.setId(BOSUuid.read((String)newSheetUuid));
                indexItem.setSheetParam(sheetParamInfo);
                indexFactory.addnew((CoreBaseInfo)indexItem);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected IObjectCollection _getLatestIndexDataExt(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        EntityViewInfo indexDataView = new EntityViewInfo();
        indexDataView.setFilter(filterInfo);
        indexDataView.getSelector().add(new SelectorItemInfo("indexValue"));
        indexDataView.getSelector().add(new SelectorItemInfo("startYear"));
        indexDataView.getSelector().add(new SelectorItemInfo("endYear"));
        indexDataView.getSelector().add(new SelectorItemInfo("startPeriod"));
        indexDataView.getSelector().add(new SelectorItemInfo("endPeriod"));
        indexDataView.getSelector().add(new SelectorItemInfo("reportID"));
        SorterItemInfo sorter = new SorterItemInfo("startYear");
        sorter.setSortType(SortType.ASCEND);
        SorterItemInfo sorter2 = new SorterItemInfo("startPeriod");
        sorter2.setSortType(SortType.ASCEND);
        indexDataView.getSorter().add(sorter);
        indexDataView.getSorter().add(sorter2);
        IndexDataCollection indexDatas = IndexDataFactory.getLocalInstance(ctx).getIndexDataCollection(indexDataView);
        return indexDatas;
    }
}

