/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class SheetContainer {
    boolean collectionMode = false;
    private ReportBaseInfo rptInfo = null;
    private final Context ctx;
    private IObjectCollection reports = null;
    private static final Logger log = Logger.getLogger((String)SheetContainer.class.getName());

    public SheetContainer(ReportBaseInfo report, Context ctx) {
        this.rptInfo = report;
        this.ctx = ctx;
    }

    public SheetContainer(IObjectCollection _reports, Context ctx) {
        this.reports = _reports;
        this.ctx = ctx;
    }

    public Object getSumCellValue(String sheetName, String cellName) throws ReportException {
        ReportBaseInfo old = this.rptInfo;
        if (this.reports == null || this.reports.size() == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        boolean isAllBigDecimal = true;
        boolean isAllInt = true;
        for (int i = 0; i < this.reports.size(); ++i) {
            this.rptInfo = (ReportBaseInfo)this.reports.getObject(i);
            Object temp = this.getCellValue(sheetName, cellName);
            if (temp != null && !(temp instanceof Integer)) {
                isAllInt = false;
            }
            if (temp != null && !(temp instanceof BigDecimal)) {
                isAllBigDecimal = false;
            }
            list.add(temp);
        }
        this.rptInfo = old;
        if (isAllInt) {
            int sum = 0;
            for (int j = 0; j < list.size(); ++j) {
                Object temp = list.get(j);
                if (temp == null) continue;
                sum += ((Integer)temp).intValue();
            }
            return new Integer(sum);
        }
        if (isAllBigDecimal) {
            BigDecimal sum = new BigDecimal("0");
            for (int j = 0; j < list.size(); ++j) {
                Object temp = list.get(j);
                if (temp == null) continue;
                sum = sum.add((BigDecimal)temp);
            }
            return sum;
        }
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < list.size(); ++j) {
            Object temp = list.get(j);
            if (temp == null) continue;
            if (temp instanceof Calendar) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                buf.append(format.format(((Calendar)temp).getTime()));
                continue;
            }
            buf.append(temp.toString());
        }
        return buf.toString();
    }

    public Sheet getSheet(String sheetName) throws ReportException {
        if (this.rptInfo == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("Report_Not_Exists", this.ctx.getOriginLocale())});
        }
        Book book = null;
        try {
            book = this.rptInfo.getBook();
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
            book = null;
        }
        if (book == null) {
            return null;
        }
        return book.getSheet(sheetName);
    }

    public Object getCellValue(String sheetName, String cellName) throws ReportException {
        Sheet sheet = this.getSheet(sheetName);
        if (sheet == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("Sheet_Not_Exists", this.ctx.getOriginLocale()) + " \"" + sheetName + "\""});
        }
        Rect pos = TableToolkit.range2xy(cellName);
        if (pos == null || !pos.isValid()) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("Cell_Not_Exists", this.ctx.getOriginLocale()) + " \"" + cellName + "\""});
        }
        pos.normalize();
        Range c = sheet.getRange(pos.getYBase(), pos.getXBase());
        if (c == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("Cell_Not_Exists", this.ctx.getOriginLocale()) + " \"" + cellName + "\""});
        }
        Variant var = c.getValue();
        return var.isEmpty() ? null : var.getValue();
    }
}

