/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class TemplateItemListSeparateHelper {
    private static final String REPORT_FIELDINFO_TREENUMBER = "FTreeNumber";
    private static final String REPORT_FIELDINFO_TREENAME = "FTreeName";
    private static final String REPORT_FIELDINFO_UNITNUMBER = "FUnitNumber";
    private static final String REPORT_FIELDINFO_UNITNAME = "FUnitName";
    private static final String REPORT_FIELDINFO_TARGETTEMPNUMBER = "FTargetTmpNumber";
    private static final String REPORT_FIELDINFO_TARGETTEMPNAME = "FTargetTmpName";
    private static final String REPORT_FIELDINFO_ITEMFORMULA = "FItemFormula";
    private static final String T1Version_SQL = " TO_INT(SUBSTRING(T1.FVERSIONNUMBER,1,CHARINDEX('.',T1.FVERSIONNUMBER)-1)) ";
    private static final String T2Version_SQL = " TO_INT(SUBSTRING(T2.FVERSIONNUMBER,1,CHARINDEX('.',T2.FVERSIONNUMBER)-1)) ";

    private TemplateItemListSeparateHelper() {
    }

    public static List forbid(Context ctx, List templateIdList, boolean isFreezed) throws BOSException {
        if (templateIdList == null) {
            return null;
        }
        String ids = CslRptUtil.changeIdList2String((List)templateIdList);
        if (isFreezed) {
            return TemplateItemListSeparateHelper.forbid(ctx, isFreezed, ids);
        }
        return TemplateItemListSeparateHelper.unForbid(ctx, ids);
    }

    private static List forbid(Context ctx, boolean isFreezed, String ids) throws BOSException {
        if (isFreezed) {
            StringBuffer sql = new StringBuffer();
            sql.append(" UPDATE T_RPT_TEMPLATE SET FISFREEZED = 1\t\r\n");
            sql.append(" WHERE FID IN (\t\t\t\t\t\t\t\t\r\n");
            sql.append(" SELECT T1.FID FROM T_RPT_TEMPLATE T1 \t\t\r\n");
            sql.append(" INNER JOIN T_RPT_TEMPLATE T2 ON T1.FGROUP = T2.FGROUP \r\n");
            sql.append(" WHERE T2.FID IN  (").append(ids).append(")");
            sql.append(" AND ").append(T1Version_SQL).append("<=").append(T2Version_SQL);
            sql.append(" ) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return null;
    }

    private static List unForbid(Context ctx, String ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT MAX(").append(T1Version_SQL).append(") MAXVERSION,\r\n");
        sql.append(T2Version_SQL).append(" CURVERSION,\t\t\r\n");
        sql.append("T2.FGROUP,T2.FID FROM T_RPT_TEMPLATE T1\t\r\n");
        sql.append("INNER JOIN T_RPT_TEMPLATE T2 ON T1.FGROUP = T2.FGROUP\t\t\t\t\r\n");
        sql.append("WHERE T1.FISFREEZED = 1 AND T2.FID IN (\t\t\t\r\n");
        sql.append(ids).append(")\t\r\n");
        sql.append("GROUP BY T2.FGROUP,T2.FID,T2.FVERSIONNUMBER\t\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            ResultBean resultBean = null;
            HashMap<String, ResultBean> rsMap = new HashMap<String, ResultBean>();
            ResultBeanCollection beanCollection = new ResultBeanCollection(8);
            while (rs.next()) {
                resultBean = new ResultBean();
                resultBean.maxVersion = rs.getInt("MAXVERSION");
                resultBean.curVserion = rs.getInt("CURVERSION");
                resultBean.templateGroup = rs.getString("FGROUP");
                resultBean.templateId = rs.getString("FID");
                rsMap.put(rs.getString("FID"), resultBean);
                beanCollection.add(resultBean);
            }
            TemplateItemListSeparateHelper.loadTemplateInfo(ctx, rsMap);
            List noPassList = TemplateItemListSeparateHelper.getNoPassList(beanCollection);
            List intermilList = TemplateItemListSeparateHelper.getIntermilVersionList(beanCollection);
            TemplateItemListSeparateHelper.remove(rsMap, noPassList, intermilList);
            ArrayList<String> result = new ArrayList<String>();
            String msg = TemplateItemListSeparateHelper.getNoPassResultString(ctx, noPassList);
            if (msg != null) {
                result.add(msg);
            }
            if ((msg = TemplateItemListSeparateHelper.getIntermilResultString(ctx, intermilList)) != null) {
                result.add(msg);
            }
            if (!rsMap.isEmpty()) {
                result.addAll(TemplateItemListSeparateHelper.checkItemFormulaDup(ctx, rsMap, beanCollection));
            }
            return result;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void remove(Map rsMap, List noPassList, List intermilList) {
        ResultBean resultBean2 = null;
        if (noPassList != null && !noPassList.isEmpty()) {
            for (ResultBean resultBean2 : noPassList) {
                rsMap.remove(resultBean2.templateId);
            }
        }
        if (intermilList != null && !intermilList.isEmpty()) {
            for (ResultBean resultBean2 : intermilList) {
                rsMap.remove(resultBean2.templateId);
            }
        }
    }

    private static void loadTemplateInfo(Context ctx, Map rsMap) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID,FNAME,FNUMBER,FTEMPLATETYPE FROM T_RPT_TEMPLATE ");
        sql.append(" WHERE FID IN (");
        sql.append(CslRptUtil.changeIdSet2String(rsMap.keySet()));
        sql.append(") ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ResultBean resultBean = null;
        while (rowSet.next()) {
            resultBean = (ResultBean)rsMap.get(rowSet.getString("FID"));
            resultBean.templateName = rowSet.getString("FNAME");
            resultBean.templateNumber = rowSet.getString("FNUMBER");
            resultBean.templateType = rowSet.getInt("FTEMPLATETYPE");
        }
    }

    private static void updateFreezeState(Context ctx, String templateId, boolean isFreezed) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_RPT_TEMPLATE SET FISFREEZED  = ");
        sql.append(isFreezed ? 1 : 0);
        sql.append(" WHERE FID = ? ");
        sql.append(" OR FGROUPTEMPLATEID = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{templateId, templateId});
    }

    private static void loadDispenseRecords(Context ctx, Map rsMap) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FCompanyID, FOrgBoundID,FDispenseSrcID from T_CSL_TempletDispense ");
        sql.append(" where FDispenseSrcID in (");
        sql.append(CslRptUtil.changeIdSet2String(rsMap.keySet()));
        sql.append(") and FSourceType = 1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Set<String> companyIds = null;
        ResultBean resultBean = null;
        String treeId = null;
        String unitId = null;
        while (rowSet.next()) {
            resultBean = (ResultBean)rsMap.get(rowSet.getString("FDispenseSrcID"));
            if (resultBean.mapOrgTree == null) {
                resultBean.mapOrgTree = new HashMap();
            }
            treeId = rowSet.getString("FOrgBoundID");
            unitId = rowSet.getString("FCompanyID");
            if (resultBean.mapOrgTree.containsKey(treeId)) {
                companyIds = (Set)resultBean.mapOrgTree.get(treeId);
            } else {
                companyIds = new HashSet();
                resultBean.mapOrgTree.put(treeId, companyIds);
            }
            if (companyIds.contains(unitId)) continue;
            companyIds.add(unitId);
        }
    }

    private static void insertItemList2Template(Context ctx, String templateId, Set hisTemplateIds) throws BOSException {
        if (hisTemplateIds.contains(templateId)) {
            StringBuffer sql = new StringBuffer();
            sql.append(" INSERT INTO  T_CSL_TEMPLETITEMLIST\tSELECT\t\r\n");
            sql.append(" DISTINCT FID, FTEMPLATEID,  FITEMNUMBER,\t\r\n");
            sql.append(" FITEMFORMULA,FKEYNUMBER,FYEAR,FPERIOD,\t\r\n");
            sql.append(" FDATAELEMENT, FVALUETYPE, FSHEETID,\t\r\n");
            sql.append(" FSHEETNAME, FCELLNAME,FPOSX,FPOSY,\t\t\r\n");
            sql.append(" FASSTACTTYPENUMBER \t\t\t\t\t\r\n");
            sql.append(" FROM T_CSL_HISTEMPLETITEMLIST\t\t\t\r\n");
            sql.append(" WHERE FTEMPLATEID = ?\t\t\t\t\t\r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{templateId});
        }
    }

    private static Set getHisTemplateIds(Context ctx, Map rsMap) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT FTEMPLATEID FROM T_CSL_HISTEMPLETITEMLIST");
        sql.append(" WHERE FTEMPLATEID IN (");
        sql.append(CslRptUtil.changeIdSet2String(rsMap.keySet()));
        sql.append(") ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> hisTemplateIds = new HashSet<String>();
        while (rowSet.next()) {
            hisTemplateIds.add(rowSet.getString("FTEMPLATEID"));
        }
        return hisTemplateIds;
    }

    private static List checkItemFormulaDup(Context ctx, Map rsMap, ResultBeanCollection beanCollection) throws BOSException, EASBizException, SQLException {
        ArrayList<String> list = new ArrayList<String>();
        TemplateItemListSeparateHelper.loadDispenseRecords(ctx, rsMap);
        Set hisTemplateIds = TemplateItemListSeparateHelper.getHisTemplateIds(ctx, rsMap);
        String pattern1 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_UnFreezed_CheckResult1", (Locale)ctx.getOriginLocale());
        ResultBean curBean = null;
        HashSet<String> passSet = new HashSet<String>();
        Iterator iterator = beanCollection.iterator();
        block0: while (iterator.hasNext()) {
            curBean = beanCollection.get(iterator.next());
            if (curBean == null || !curBean.needCheck) continue;
            TemplateItemListSeparateHelper.checkItemFormulaDup(ctx, curBean, hisTemplateIds, pattern1, list, passSet);
            while (curBean.next != null) {
                curBean = curBean.next;
                if (!curBean.needCheck) continue;
                if (curBean.pre != null && curBean.pre.isDup) {
                    list.add(TemplateItemListSeparateHelper.getTemplateDupString(ctx, curBean));
                    continue block0;
                }
                if (TemplateItemListSeparateHelper.checkDispenseRecord(curBean)) {
                    TemplateItemListSeparateHelper.updateFreezeState(ctx, curBean.templateId, false);
                    if (!hisTemplateIds.contains(curBean.templateId)) continue;
                    TemplateItemListSeparateHelper.insertItemList2Template(ctx, curBean.templateId, hisTemplateIds);
                    passSet.add(curBean.templateId);
                    continue;
                }
                TemplateItemListSeparateHelper.checkItemFormulaDup(ctx, curBean, hisTemplateIds, pattern1, list, passSet);
            }
        }
        if (!passSet.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            sql.append(" DELETE FROM T_CSL_HISTEMPLETITEMLIST\t\r\n");
            sql.append(" WHERE FTEMPLATEID IN\t(\t\t\t\t\r\n");
            sql.append(CslRptUtil.changeIdSet2String(passSet)).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return list;
    }

    private static boolean checkDispenseRecord(ResultBean curBean) {
        if (curBean == null || curBean.pre == null || curBean.mapOrgTree == null || curBean.pre.mapOrgTree == null) {
            return false;
        }
        Set curCompanyIds = null;
        Set perCompanyIds = null;
        Iterator iter = curBean.mapOrgTree.keySet().iterator();
        String treeId = null;
        while (iter.hasNext()) {
            treeId = (String)iter.next();
            if (curBean.pre.mapOrgTree.containsKey(treeId)) {
                curCompanyIds = (Set)curBean.mapOrgTree.get(treeId);
                perCompanyIds = (Set)curBean.pre.mapOrgTree.get(treeId);
                if (curCompanyIds == null || perCompanyIds == null) {
                    return false;
                }
                Iterator iter2 = curCompanyIds.iterator();
                while (iter2.hasNext()) {
                    if (perCompanyIds.contains(iter2.next())) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private static void checkItemFormulaDup(Context ctx, ResultBean curBean, Set hisTemplateIds, String pattern1, List list, Set passSet) throws BOSException, SQLException {
        if (curBean == null) {
            return;
        }
        TemplateItemListSeparateHelper.updateFreezeState(ctx, curBean.templateId, false);
        TemplateItemListSeparateHelper.insertItemList2Template(ctx, curBean.templateId, hisTemplateIds);
        boolean isDup = TemplateItemListSeparateHelper.checkSingleTemplateDispense(ctx, curBean, pattern1, list);
        if (isDup) {
            curBean.isDup = true;
            TemplateItemListSeparateHelper.updateFreezeState(ctx, curBean.templateId, true);
            if (hisTemplateIds.contains(curBean.templateId)) {
                StringBuffer sql = new StringBuffer();
                sql.append(" DELETE FROM T_CSL_TEMPLETITEMLIST\t\r\n");
                sql.append(" WHERE FTEMPLATEID = ?\t\t\t\t\r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curBean.templateId});
            }
        } else if (hisTemplateIds.contains(curBean.templateId)) {
            passSet.add(curBean.templateId);
        }
    }

    private static boolean checkSingleTemplateDispense(Context ctx, ResultBean resultBean, String pattern1, List list) throws BOSException, SQLException {
        boolean result = false;
        Map mapOrgTree = resultBean.mapOrgTree;
        if (mapOrgTree == null || mapOrgTree.isEmpty()) {
            return result;
        }
        boolean isCslTemplet = true;
        if (resultBean.templateType == 6 || resultBean.templateType == 10) {
            isCslTemplet = false;
        }
        Set companyIds = null;
        IRowSet rowSet = null;
        StringBuffer buf = new StringBuffer();
        Object[] params = new Object[]{resultBean.templateNumber, resultBean.templateName};
        buf.append(MessageFormat.format(pattern1, params));
        buf.append("\r\n");
        ITempletDispense templetDispense = TempletDispenseFactory.getLocalInstance((Context)ctx);
        Iterator iter = mapOrgTree.keySet().iterator();
        while (iter.hasNext()) {
            result = false;
            String treeId = (String)iter.next();
            companyIds = (Set)mapOrgTree.get(treeId);
            if (companyIds == null || companyIds.isEmpty()) continue;
            try {
                rowSet = templetDispense.checkSingleTemplateDispenseNew(treeId, new ArrayList(companyIds), resultBean.templateId, "UNFORBID");
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            if (rowSet != null && rowSet.size() > 0) {
                result = true;
                buf.append(TemplateItemListSeparateHelper.getOutputString(ctx, rowSet, isCslTemplet));
            }
            if (!result) continue;
            list.add(buf.toString());
        }
        return result;
    }

    private static List getNoPassList(ResultBeanCollection beanCollection) {
        ArrayList<ResultBean> noPassList = new ArrayList<ResultBean>(beanCollection.size());
        Iterator iterator = beanCollection.iterator();
        ResultBean bean = null;
        while (iterator.hasNext()) {
            bean = beanCollection.get(iterator.next());
            if (bean.maxVersion <= bean.curVserion) continue;
            noPassList.add(bean);
            bean.needCheck = false;
            while (bean.next != null) {
                bean = bean.next;
                bean.needCheck = false;
                noPassList.add(bean);
            }
        }
        return noPassList;
    }

    private static List getIntermilVersionList(ResultBeanCollection beanCollection) {
        ArrayList intermilList = new ArrayList(beanCollection.size());
        Iterator iterator = beanCollection.iterator();
        ResultBean bean = null;
        block0: while (iterator.hasNext()) {
            bean = beanCollection.get(iterator.next());
            if (bean.maxVersion > bean.curVserion) continue;
            while (bean.next != null) {
                if (bean.curVserion == bean.next.curVserion + 1) {
                    bean = bean.next;
                    continue;
                }
                TemplateItemListSeparateHelper.addIntermilList(intermilList, bean.next);
                continue block0;
            }
        }
        return intermilList;
    }

    private static void addIntermilList(List intermilList, ResultBean bean) {
        intermilList.add(bean);
        bean.needCheck = false;
        while (bean.next != null) {
            bean = bean.next;
            bean.needCheck = false;
            intermilList.add(bean);
        }
    }

    private static String getTemplateDupString(Context ctx, ResultBean curBean) {
        ResultBean dupBean = curBean.pre;
        String pattern1 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"760Template_UnFreezed01", (Locale)ctx.getOriginLocale());
        String pattern2 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"763Template_UnFreezed04", (Locale)ctx.getOriginLocale());
        StringBuffer str = new StringBuffer();
        str.append(MessageFormat.format(pattern1, curBean.templateNumber, curBean.templateName));
        str.append(MessageFormat.format(pattern2, dupBean.curVserion, curBean.curVserion));
        str.append("\r\n");
        while (curBean.next != null && curBean.next.needCheck) {
            curBean = curBean.next;
            str.append(MessageFormat.format(pattern1, curBean.templateNumber, curBean.templateName));
            str.append(MessageFormat.format(pattern2, dupBean.curVserion, curBean.curVserion));
            str.append("\r\n");
        }
        return str.toString();
    }

    private static String getNoPassResultString(Context ctx, List noPassList) {
        String pattern1 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"760Template_UnFreezed01", (Locale)ctx.getOriginLocale());
        String pattern2 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"761Template_UnFreezed02", (Locale)ctx.getOriginLocale());
        if (noPassList != null && !noPassList.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            ResultBean resultBean = null;
            for (int i = noPassList.size() - 1; i >= 0; --i) {
                resultBean = (ResultBean)noPassList.get(i);
                sb.append(MessageFormat.format(pattern1, resultBean.templateNumber, resultBean.templateName));
                sb.append(MessageFormat.format(pattern2, resultBean.maxVersion, resultBean.curVserion));
                sb.append("\r\n");
            }
            return sb.toString();
        }
        return null;
    }

    private static String getIntermilResultString(Context ctx, List intermilList) {
        String pattern1 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"760Template_UnFreezed01", (Locale)ctx.getOriginLocale());
        String pattern2 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"762Template_UnFreezed03", (Locale)ctx.getOriginLocale());
        if (intermilList != null && !intermilList.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            ResultBean resultBean = null;
            for (int i = intermilList.size() - 1; i >= 0; --i) {
                resultBean = (ResultBean)intermilList.get(i);
                sb.append(MessageFormat.format(pattern1, resultBean.templateNumber, resultBean.templateName));
                sb.append(MessageFormat.format(pattern2, resultBean.curVserion));
                sb.append("\r\n");
            }
            return sb.toString();
        }
        return null;
    }

    private static String getOutputString(Context ctx, IRowSet rs, boolean isCslTemplet) throws SQLException {
        if (rs == null) {
            return null;
        }
        StringBuffer report = new StringBuffer();
        ArrayList<String> listParams = new ArrayList<String>(3);
        int index = 0;
        StringBuffer keyString = new StringBuffer();
        HashMap<String, String> ls = new HashMap<String, String>();
        Object[] params = null;
        String line = null;
        String pattern2 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult2", (Locale)ctx.getOriginLocale());
        String pattern3 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult3", (Locale)ctx.getOriginLocale());
        String pattern4 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult4", (Locale)ctx.getOriginLocale());
        String pattern5 = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult5", (Locale)ctx.getOriginLocale());
        while (rs.next()) {
            keyString = new StringBuffer();
            if (!isCslTemplet) {
                keyString.append(rs.getString(REPORT_FIELDINFO_UNITNUMBER));
                keyString.append("!");
                keyString.append(rs.getString(REPORT_FIELDINFO_TARGETTEMPNUMBER));
            } else {
                keyString.append(rs.getString(REPORT_FIELDINFO_TREENUMBER));
                keyString.append("!");
                keyString.append(rs.getString(REPORT_FIELDINFO_TARGETTEMPNUMBER));
            }
            if (isCslTemplet && !ls.containsKey(keyString.toString()) || !isCslTemplet && index == 0) {
                params = new Object[]{rs.getString(REPORT_FIELDINFO_TREENUMBER), rs.getString(REPORT_FIELDINFO_TREENAME)};
                line = MessageFormat.format(pattern2, params);
                report.append(line);
            }
            if (!isCslTemplet && !ls.containsKey(keyString.toString())) {
                params = new Object[]{rs.getString(REPORT_FIELDINFO_UNITNUMBER), rs.getString(REPORT_FIELDINFO_UNITNAME)};
                line = MessageFormat.format(pattern3, params);
                report.append(line);
            }
            if (!ls.containsKey(keyString.toString())) {
                params = new Object[]{rs.getString(REPORT_FIELDINFO_TARGETTEMPNUMBER), rs.getString(REPORT_FIELDINFO_TARGETTEMPNAME)};
                line = MessageFormat.format(pattern4, params);
                report.append(line);
            }
            listParams.clear();
            listParams.add(rs.getString("FTrgtSheetname"));
            listParams.add(rs.getString("fTrgtCellName"));
            listParams.add(rs.getString(REPORT_FIELDINFO_ITEMFORMULA));
            params = new Object[]{rs.getString(REPORT_FIELDINFO_ITEMFORMULA)};
            line = MessageFormat.format(pattern5, listParams.toArray());
            report.append(line);
            report.append(" \r\n");
            if (!ls.containsKey(keyString.toString())) {
                ls.put(keyString.toString(), "");
            }
            ++index;
        }
        listParams.clear();
        listParams = null;
        String result = report.toString().replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n");
        return result;
    }

    public static void separate(Context ctx) throws BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FID FROM T_RPT_TEMPLATE WHERE FISFREEZED = 1");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("FID"));
            }
            if (!idSet.isEmpty()) {
                String ids = CslRptUtil.changeIdSet2String(idSet);
                sql.delete(0, sql.length());
                sql.append(" INSERT INTO T_CSL_HISTEMPLETITEMLIST \t\r\n");
                sql.append(" SELECT FID, FTEMPLATEID,  FITEMNUMBER,\t\r\n");
                sql.append(" FITEMFORMULA,FKEYNUMBER,FYEAR,FPERIOD,\t\r\n");
                sql.append(" FDATAELEMENT, FVALUETYPE, FSHEETID,\t\r\n");
                sql.append(" FSHEETNAME, FCELLNAME,FPOSX,FPOSY,\t\t\r\n");
                sql.append(" FASSTACTTYPENUMBER \t\t\t\t\t\r\n");
                sql.append(" FROM T_CSL_TEMPLETITEMLIST\t\t\t\t\r\n");
                sql.append(" WHERE FTEMPLATEID IN (\t\t\t\t\t\r\n");
                sql.append(ids).append(")");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.delete(0, sql.length());
                sql.append(" DELETE FROM T_CSL_TEMPLETITEMLIST\t\r\n");
                sql.append(" WHERE FTEMPLATEID IN (\t\t\t\t\r\n");
                sql.append(ids).append(")");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static void main(String[] args) {
        ResultBean bean1 = new ResultBean("1", 9);
        ResultBean bean2 = new ResultBean("2", 1);
        ResultBean bean3 = new ResultBean("3", 3);
        ResultBean bean4 = new ResultBean("4", 6);
        ResultBean bean5 = new ResultBean("1", 7);
        ResultBean bean6 = new ResultBean("3", 9);
        ResultBean bean7 = new ResultBean("2", 9);
        ResultBean bean8 = new ResultBean("4", 13);
        ResultBean bean9 = new ResultBean("5", 9);
        ResultBean bean10 = new ResultBean("2", 9);
        ResultBean bean11 = new ResultBean("2", 9);
        ResultBean bean12 = new ResultBean("3", 66);
        ResultBean bean13 = new ResultBean("4", 12);
        ResultBean bean14 = new ResultBean("2", 11);
        ResultBean bean15 = new ResultBean("4", 9);
        ResultBean bean16 = new ResultBean("1", 11);
        ResultBean bean17 = new ResultBean("1", 3);
        ResultBeanCollection beanCollection = new ResultBeanCollection(8);
        beanCollection.add(bean1);
        beanCollection.add(bean2);
        beanCollection.add(bean3);
        beanCollection.add(bean4);
        beanCollection.add(bean5);
        beanCollection.add(bean6);
        beanCollection.add(bean6);
        beanCollection.add(bean7);
        beanCollection.add(bean8);
        beanCollection.add(bean9);
        beanCollection.add(bean10);
        beanCollection.add(bean11);
        beanCollection.add(bean12);
        beanCollection.add(bean13);
        beanCollection.add(bean14);
        beanCollection.add(bean15);
        beanCollection.add(bean16);
        beanCollection.add(bean17);
        Iterator iterator = beanCollection.iterator();
        ResultBean bean = null;
        while (iterator.hasNext()) {
            bean = beanCollection.get(iterator.next());
            while (bean.next != null) {
                bean = bean.next;
            }
        }
    }

    private static class ResultBeanCollection {
        private Map map;
        private int size;

        ResultBeanCollection() {
            this.map = new HashMap();
            this.size = 0;
        }

        ResultBeanCollection(int size) {
            this.map = new HashMap(size);
            this.size = 0;
        }

        void add(ResultBean r) {
            ++this.size;
            if (this.map.containsKey(r.templateGroup)) {
                ResultBean bean = (ResultBean)this.map.get(r.templateGroup);
                this.insert(r, bean);
            } else {
                this.map.put(r.templateGroup, r);
            }
        }

        void insert(ResultBean r, ResultBean curBean) {
            if (curBean.curVserion == r.curVserion) {
                --this.size;
                return;
            }
            if (curBean.curVserion > r.curVserion) {
                ResultBean next = curBean.next;
                if (next == null) {
                    curBean.next = r;
                    r.pre = curBean;
                    r.next = next;
                } else if (next.curVserion < r.curVserion) {
                    curBean.next = r;
                    r.pre = curBean;
                    r.next = next;
                    next.pre = r;
                } else {
                    this.insert(r, next);
                }
            }
            if (curBean.curVserion < r.curVserion) {
                ResultBean pre = curBean.pre;
                if (pre == null) {
                    curBean.pre = r;
                    r.next = curBean;
                    r.pre = null;
                    this.map.put(r.templateGroup, r);
                } else if (pre.curVserion > r.curVserion) {
                    curBean.pre = r;
                    r.next = curBean;
                    r.pre = pre;
                    pre.next = r;
                } else {
                    this.insert(r, pre);
                }
            }
        }

        Iterator iterator() {
            return this.map.keySet().iterator();
        }

        ResultBean get(Object key) {
            return (ResultBean)this.map.get(key);
        }

        int size() {
            return this.size;
        }
    }

    private static class ResultBean {
        int maxVersion = 0;
        int curVserion = 0;
        String templateName;
        String templateNumber;
        String templateGroup;
        String templateId;
        int templateType;
        Map mapOrgTree;
        boolean isDup = false;
        boolean needCheck = true;
        ResultBean pre;
        ResultBean next;

        ResultBean(String templateGroup, int curVserion) {
            this.curVserion = curVserion;
            this.templateGroup = templateGroup;
        }

        ResultBean() {
        }

        public String toString() {
            return "templateGroup=" + this.templateGroup + "\tcurVserion=" + this.curVserion;
        }
    }
}

