/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.DisplayTemplateTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeCollection;
import com.kingdee.eas.fi.rpt.TemplateTypeFactory;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.app.AbstractTemplateTypeControllerBean;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TemplateTypeControllerBean
extends AbstractTemplateTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.rpt.app.TemplateTypeControllerBean");
    private static final BOSUuid ROOT_ID = BOSUuid.read((String)"111111111111111111111111111=");

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
        TemplateTypeInfo info = TemplateTypeFactory.getLocalInstance(ctx).getTemplateTypeInfo((IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()));
        FilterInfo lNfilter = new FilterInfo();
        lNfilter.getFilterItems().add(new FilterItemInfo("number", (Object)treeBaseInfo.getNumber()));
        if (info.innerGetParent() == null) {
            lNfilter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
        } else {
            FilterItemInfo filterItem = new FilterItemInfo("parent", (Object)info.innerGetParent().getId().toString(), CompareType.EQUALS);
            lNfilter.getFilterItems().add(filterItem);
        }
        lNfilter.getFilterItems().add(new FilterItemInfo("id", (Object)treeBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        StringBuffer maskString = new StringBuffer("#0 AND #1 AND #2");
        int reportType = info.getReportType().getValue();
        lNfilter.getFilterItems().add(new FilterItemInfo("reportType", (Object)new Integer(reportType)));
        maskString.append("and #2 ");
        if (74 == reportType) {
            lNfilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOrgUnitIdsIgnoreDisabled(ctx, info.getOrgUnit().getId().toString()), CompareType.INCLUDE));
            maskString.append("and #3 ");
        }
        lNfilter.setMaskString(maskString.toString());
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            lNfilter.mergeFilter(filterCU, "AND");
        }
        if (this.exists(ctx, lNfilter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeBaseInfo.getNumber()});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TemplateTypeInfo treeModel = (TemplateTypeInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        if (treeModel.innerGetParent() == null) {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
            StringBuffer maskString = new StringBuffer("#0 and #1 ");
            int reportType = treeModel.getReportType().getValue();
            filter.getFilterItems().add(new FilterItemInfo("reportType", (Object)new Integer(reportType)));
            maskString.append("and #2 ");
            if (74 == reportType) {
                String orgGroupId = treeModel.getOrgUnit().getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOrgUnitIdsIgnoreDisabled(ctx, orgGroupId), CompareType.INCLUDE));
                maskString.append("and #3 ");
            }
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                maskString.append(" and #").append(filter.getFilterItems().size() - 1);
            }
            filter.setMaskString(maskString.toString());
        } else {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            if (treeModel.innerGetParent().getId() != null) {
                filterItem = new FilterItemInfo("parent", (Object)treeModel.innerGetParent().getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1");
            }
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                if (treeModel.innerGetParent().getId() != null) {
                    filter.setMaskString("#0 and #1 and #2");
                } else {
                    filter.setMaskString("#0 and #1");
                }
            }
            int reportType = treeModel.getReportType().getValue();
            filter.getFilterItems().add(new FilterItemInfo("reportType", (Object)new Integer(reportType)));
            StringBuffer maskString = new StringBuffer(filter.getMaskString());
            int index = filter.getFilterItems().size() - 1;
            maskString.append(" and #").append(index++);
            if (74 == reportType) {
                String orgGroupId = treeModel.getOrgUnit().getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOrgUnitIdsIgnoreDisabled(ctx, orgGroupId), CompareType.INCLUDE));
                maskString.append(" and #").append(index++);
            }
            filter.setMaskString(maskString.toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        TemplateTypeCollection results = this.getTemplateTypeCollection(ctx, view);
        if (results != null && results.size() > 0) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeModel.getNumber()});
        }
    }

    @Override
    protected void _updateDisplayType(Context ctx, String currentId, String parentId, DisplayTemplateTypeEnum type) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String table = null;
        String field = "FDisplayTemplateTypeId";
        if (DisplayTemplateTypeEnum.ELIMINATION.equals((Object)type)) {
            table = "T_CSL_Elimination";
        } else if (DisplayTemplateTypeEnum.RPTNOTESINDEX.equals((Object)type)) {
            table = "T_CSL_ReportNotesIndex";
            field = "FdisplayIndexTypeId";
        } else if (DisplayTemplateTypeEnum.RPTNOTES.equals((Object)type)) {
            table = "T_CSL_ReportNotestemplate";
            field = "FDisplayTemplateTypeId";
        } else if (DisplayTemplateTypeEnum.SCENE.equals((Object)type)) {
            table = "T_CSL_Scene";
            field = "FDisplayTemplateTypeId";
        } else if (DisplayTemplateTypeEnum.ALALYZEINDEX.equals((Object)type)) {
            table = "T_CSL_AnalyzeIndex";
            field = "FIndexType";
        } else if (DisplayTemplateTypeEnum.ALALYZE.equals((Object)type)) {
            table = "T_CSL_RptQingAnalyze";
            field = "FDisplayAnalyzeTypeId";
        } else {
            table = "T_RPT_Template";
        }
        sql.append("update ").append(table).append(" set ").append(field).append("= ? \n").append(" where ").append(field).append(" = ? ");
        String sqlString = sql.toString();
        if (parentId == null) {
            sqlString = sqlString.replaceFirst("\\?", "NULL");
            Object[] params = new Object[]{currentId};
            DbUtil.execute((Context)ctx, (String)sqlString, (Object[])params);
        } else {
            Object[] params = new Object[]{parentId, currentId};
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        }
    }

    @Override
    protected void _moveDisplayTypeBatch(Context ctx, List templateIds, String targetType, DisplayTemplateTypeEnum type) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String table = null;
        String field = "FDisplayTemplateTypeId";
        if (DisplayTemplateTypeEnum.ELIMINATION.equals((Object)type)) {
            table = "T_CSL_Elimination";
        } else if (DisplayTemplateTypeEnum.RPTNOTESINDEX.equals((Object)type)) {
            table = "T_CSL_ReportNotesIndex";
            field = "FdisplayIndexTypeId";
        } else if (DisplayTemplateTypeEnum.RPTNOTES.equals((Object)type)) {
            table = "T_CSL_ReportNotestemplate";
            field = "FDisplayTemplateTypeId";
        } else if (DisplayTemplateTypeEnum.SCENE.equals((Object)type)) {
            table = "T_CSL_Scene";
            field = "FDisplayTemplateTypeId";
        } else if (DisplayTemplateTypeEnum.ALALYZEINDEX.equals((Object)type)) {
            table = "T_CSL_AnalyzeIndex";
            field = "FIndexType";
        } else if (DisplayTemplateTypeEnum.ALALYZE.equals((Object)type)) {
            table = "T_CSL_RptQingAnalyze";
            field = "FDisplayAnalyzeTypeId";
        } else {
            table = "T_RPT_Template";
        }
        sql.append("update ").append(table).append(" set ").append(field).append("= ? \n").append(" where FID in  \n ");
        sql.append(this.createInCondition(templateIds.iterator()));
        if (DisplayTemplateTypeEnum.GROUP.equals((Object)type) || DisplayTemplateTypeEnum.CSL.equals((Object)type)) {
            sql.append(" or FID in (select fid from t_rpt_template where fgrouptemplateid in ");
            sql.append(this.createInCondition(templateIds.iterator()));
            sql.append(")");
        }
        String sqlString = sql.toString();
        if (targetType == null) {
            sqlString = sqlString.replaceFirst("\\?", "NULL");
            DbUtil.execute((Context)ctx, (String)sqlString);
        } else {
            Object[] params = new Object[]{targetType};
            DbUtil.execute((Context)ctx, (String)sqlString, (Object[])params);
        }
    }

    private String createInCondition(Iterator iterator) {
        boolean first = true;
        StringBuffer sql = new StringBuffer("(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" '").append(iterator.next()).append("' ");
                first = false;
                continue;
            }
            sql.append(" ,'").append(iterator.next()).append("' ");
        }
        sql.append(") ");
        return sql.toString();
    }

    @Override
    protected void _addTypeBySubOrgGroup(Context ctx, TemplateTypeCollection sourceTypes, List subOrgGroupIds) throws BOSException, EASBizException {
        ArrayList<String> parentIds = new ArrayList<String>();
        Iterator i = sourceTypes.iterator();
        while (i.hasNext()) {
            TemplateTypeInfo info = (TemplateTypeInfo)i.next();
            if (info.getParent() != null) continue;
            parentIds.add(info.getId().toString());
        }
        List existIds = this._checkSubTypeNumber(ctx, parentIds, subOrgGroupIds);
        ArrayList<String> deleteIds = new ArrayList<String>();
        if (existIds != null && existIds.size() > 0) {
            Iterator i2 = existIds.iterator();
            while (i2.hasNext()) {
                String id = i2.next().toString();
                deleteIds.add(id);
                deleteIds.addAll(this.getAllChildrenIds(ctx, id));
            }
            this.deleteAll(ctx, deleteIds);
        }
        if (deleteIds.size() > 0) {
            String deleteSql = "update T_CSL_Elimination set FDisplayTemplateTypeId=NULL where FDisplayTemplateTypeId in " + this.createInCondition(deleteIds.iterator());
            DbUtil.execute((Context)ctx, (String)deleteSql);
        }
        Map indexedMap = this.indexByParent(sourceTypes);
        Iterator orgIterator = subOrgGroupIds.iterator();
        while (orgIterator.hasNext()) {
            FullOrgUnitInfo unit = new FullOrgUnitInfo();
            unit.setId(BOSUuid.read((String)orgIterator.next().toString()));
            List firstLevel = (List)indexedMap.get(ROOT_ID.toString());
            for (TemplateTypeInfo templateTypeInfo : firstLevel) {
                this.insert(ctx, templateTypeInfo, null, indexedMap, unit);
            }
        }
    }

    private void insert(Context ctx, TemplateTypeInfo sourceInfo, TemplateTypeInfo parent, Map infos, FullOrgUnitInfo unint) throws EASBizException, BOSException {
        List childreList = (List)infos.get(sourceInfo.getId().toString());
        BOSUuid newId = BOSUuid.create((BOSObjectType)sourceInfo.getBOSType());
        TemplateTypeInfo targetInfo = (TemplateTypeInfo)sourceInfo.clone();
        targetInfo.setId(newId);
        targetInfo.setOrgUnit(unint);
        if (targetInfo.getParent() != null) {
            targetInfo.setParent(parent);
        }
        targetInfo.setReportType(DisplayTemplateTypeEnum.ELIMINATION);
        TemplateTypeFactory.getLocalInstance(ctx).addnew(targetInfo);
        if (childreList != null) {
            for (TemplateTypeInfo childType : childreList) {
                this.insert(ctx, childType, targetInfo, infos, unint);
            }
        }
    }

    private Map indexByParent(TemplateTypeCollection types) {
        Iterator iterator = types.iterator();
        HashMap result = new HashMap(types.size());
        ArrayList<TemplateTypeInfo> firstLevelList = new ArrayList<TemplateTypeInfo>();
        String firstLevel = ROOT_ID.toString();
        result.put(firstLevel, firstLevelList);
        while (iterator.hasNext()) {
            TemplateTypeInfo type = (TemplateTypeInfo)iterator.next();
            if (type.getParent() == null) {
                firstLevelList.add(type);
                continue;
            }
            String parentId = type.getParent().getId().toString();
            ArrayList<TemplateTypeInfo> childrenList = (ArrayList<TemplateTypeInfo>)result.get(parentId);
            if (childrenList == null) {
                childrenList = new ArrayList<TemplateTypeInfo>();
                childrenList.add(type);
                result.put(parentId, childrenList);
                continue;
            }
            childrenList.add(type);
        }
        return result;
    }

    private void deleteAll(Context ctx, List deleteIds) throws BOSException {
        String sql = "delete from T_RPT_TemplateType where FID in " + this.createInCondition(deleteIds.iterator());
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private List getAllChildrenIds(Context ctx, String infoId) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        String selectInfo = "Select FLongNumber, FCONTROLUNITID, FReportType, FOrgUnitId from T_RPT_TemplateType where FID=?";
        Object[] param = new Object[]{infoId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectInfo, (Object[])param);
        try {
            if (!rowSet.next()) {
                return result;
            }
            String longNumber = rowSet.getString("FLongNumber");
            String cu = rowSet.getString("FCONTROLUNITID");
            int type = rowSet.getInt("FReportType");
            String orgUnitId = rowSet.getString("FOrgUnitId");
            StringBuffer sql = new StringBuffer();
            ArrayList<Object> params = new ArrayList<Object>();
            sql.append("select Fid from T_RPT_TemplateType \n");
            sql.append("where FLongNumber like ? \n");
            params.add(longNumber + "!%");
            sql.append("and FCONTROLUNITID = ? \n");
            params.add(cu);
            sql.append("and FReportType = ? \n");
            params.add(new Integer(type));
            if (74 == type) {
                sql.append("and FOrgUnitId in  \n");
                Set ids = this.getOrgUnitIdsIgnoreDisabled(ctx, orgUnitId);
                sql.append(this.createInCondition(ids.iterator()));
            }
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            while (row.next()) {
                result.add(row.getString("Fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected List _checkSubTypeNumber(Context ctx, List parentIds, List subOrgGroupIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String parentIdSql = this.createInCondition(parentIds.iterator());
        String subOrgIdSql = this.createInCondition(subOrgGroupIds.iterator());
        sql.append("select type.FID as id from T_RPT_TemplateType type \n").append("where type.FLongNumber in (\n").append("select t2.FLongNumber from T_RPT_TemplateType t2 \n").append("where t2.FId in ").append(parentIdSql).append(" \n").append(" )").append("and type.FOrgUnitId in ").append(subOrgIdSql);
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (row.next()) {
                result.add(row.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected TemplateTypeCollection _getTemplateTypeCollectionByOrgBound(Context ctx, EntityViewInfo view) throws BOSException {
        FilterInfo filter = view.getFilter();
        String orgUnitId = null;
        Iterator iterator = filter.getFilterItems().iterator();
        while (iterator.hasNext()) {
            FilterItemInfo item = (FilterItemInfo)iterator.next();
            if (!item.getPropertyName().equals("orgUnit.id")) continue;
            orgUnitId = (String)item.getCompareValue();
            iterator.remove();
            break;
        }
        Set ids = this.getOrgUnitIdsIgnoreDisabled(ctx, orgUnitId);
        FilterItemInfo idsFilter = new FilterItemInfo("orgUnit.id", (Object)ids, CompareType.INCLUDE);
        filter.getFilterItems().add(idsFilter);
        return this.getTemplateTypeCollection(ctx, view);
    }

    private Set getOrgUnitIdsIgnoreDisabled(Context ctx, String orgUnitId) throws BOSException, SQLDataException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select distinct structure.Funitid As id from T_ORG_structure structure  \t\n");
        sql.append("inner join T_ORG_Tree tree  on structure.FTreeId = tree.Fid\t \t\t\t\t\n");
        sql.append("inner join T_ORG_BaseUnit unit on unit.Fid = structure.FUnitid\t\t\t\t\n");
        sql.append("inner join T_ORG_BaseUnit unit2 on unit.Fnumber = unit2.Fnumber\t\t\t\t\n");
        sql.append("where tree.FNumber = (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("\tselect tree2.Fnumber from T_ORG_structure structure2 \t\t\t\t\t\n");
        sql.append("\tinner join T_ORG_Tree tree2  on structure2.FTreeId = tree2.Fid\t\t\t\n");
        sql.append("\twhere structure2.Funitid = ? )\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("and unit2.Fid = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("and tree.FType = 8\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        Object[] param = new Object[]{orgUnitId, orgUnitId};
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        HashSet<String> ids = new HashSet<String>();
        ids.add(orgUnitId);
        try {
            while (row.next()) {
                ids.add(row.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ids;
    }
}

