/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.app.IResultHolderListener;
import com.kingdee.eas.fi.rpt.app.QueryCommand;
import com.kingdee.eas.fi.rpt.app.QuerySolution;
import com.kingdee.eas.fi.rpt.app.ResultHolder;
import com.kingdee.eas.fi.rpt.app.WhereItem;

public class TreeNodeBatchQuery
extends QuerySolution {
    public TreeNodeBatchQuery(QueryCommand qc, String tbname) {
        super(qc);
        this.queryParamer.setStaticFromPart(tbname);
    }

    public void add(GroupTreeNode item) {
        if (item == null) {
            return;
        }
        ResultHolder rh = ResultHolder.createCommonAndNoShareModeResultHolder();
        rh.addIResultHolderListener(new ResultHolderListener(item));
        this.resultHolderSetConfig.addResultHolder(item.number, rh);
    }

    @Override
    protected void initSolutionConfig() {
        String[] groupConditionField = new String[]{"FNumber"};
        this.resultHolderSetConfig.setGroupConditionField(groupConditionField);
        this.queryParamer.setStaticSelectField("FNumber, FLongNumber, FLevel");
    }

    private class ResultHolderListener
    extends IResultHolderListener {
        GroupTreeNode _item = null;

        public ResultHolderListener(GroupTreeNode item) {
            this._item = item;
        }

        @Override
        public String[] getResultHolderOrderedSelectFields() {
            return new String[]{"FNumber", "FLongNumber", "FLevel"};
        }

        @Override
        public Object setResultHolderOrderedSelectFieldsValueObjects(Object[] value) {
            this._item.longNumber = value[1].toString();
            this._item.level = ((Number)value[2]).intValue();
            return this._item;
        }

        @Override
        public void setResultHolderOrderedSharedObject(Object obj) {
            this._item.longNumber = ((GroupTreeNode)obj).longNumber;
            this._item.level = ((GroupTreeNode)obj).level;
        }

        @Override
        public WhereItem generateWhereItem() {
            WhereItem where = WhereItem.createModeOneWhereItem();
            where.addItem("UPPER(FNumber)", this._item.number.toUpperCase());
            return where;
        }
    }
}

