/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.app.AccountItem;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.app.RptCalculaterDAO;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctCashCalcter {
    private ICalculateContextProvider context;
    private Context ServerCtx = null;
    private static final Logger logger = CoreUIObject.getLogger(AcctCashCalcter.class);
    ChecFmlParamPermissionUtil pmc;
    ArrayList list = new ArrayList();
    HashMap sortMap = new HashMap();
    private HashMap companyCache = new HashMap();
    Parameter _pma;

    public AcctCashCalcter(ICalculateContextProvider calContext, Context _serverCtx) {
        this.context = calContext;
        this.ServerCtx = _serverCtx;
        this.pmc = ChecFmlParamPermissionUtil.getInstance(calContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SortedParameterArray params) throws SQLException, ReportException, BOSException {
        for (int i = 0; i < params.size(); ++i) {
            AcctCashFlow item = new AcctCashFlow(params.getParameter(i));
            if (!item.init()) continue;
            this.list.add(item);
        }
        try {
            this.queryTableAndMapField();
        }
        catch (BOSException e) {
            for (AcctCashFlow item : this.list) {
                item.setValue(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"31_AcctCashCalcter", (Locale)this.ServerCtx.getOriginLocale()));
            }
        }
        this.getGroupLongNumber();
        this.queryInfo();
        this.sort();
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ServerCtx);
            this.queryValue(conn);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.debug((Object)e.getMessage());
                }
            }
        }
    }

    private String getAmountPart(int isPrimary, CashTypeEnum cashTypeEnum, String currency) {
        String coeffient = null;
        coeffient = isPrimary == 0 ? " Cash.FPrimaryCoeffient * " : " Cash.FSupplementaryCoeffient * ";
        if (cashTypeEnum.getValue() == 2) {
            return coeffient + "Cash.FOriginalAmount ";
        }
        if (cashTypeEnum.getValue() == 1 || cashTypeEnum.getValue() == 4) {
            return coeffient + "Cash.FLocalAmount ";
        }
        if (cashTypeEnum.getValue() == 3 || cashTypeEnum.getValue() == 5) {
            return coeffient + "Cash.FReportingAmount";
        }
        return null;
    }

    String builderSel(AcctCashFlow item) {
        StringBuffer buf = new StringBuffer();
        if (item.masterItem == 0) {
            if (item.isLeaf || !item.isLeaf && item.direction != CashFlowDirection.IN_OR_OUT) {
                buf.append(" sum( " + this.getAmountPart(item.masterItem, item._cashTypeEnum, item._currency) + ") cashValue");
            } else {
                buf.append(" sum( " + this.getAmountPart(item.masterItem, item._cashTypeEnum, item._currency) + " *(3-2*CashItem.FDirection)) cashValue");
            }
        } else {
            buf.append(" sum( " + this.getAmountPart(item.masterItem, item._cashTypeEnum, item._currency) + ") cashValue");
        }
        buf.append(this.builderExtSelect(item));
        return buf.toString();
    }

    String builderExtSelect(AcctCashFlow item) {
        StringBuffer buf = new StringBuffer();
        buf.append(" ,dyn.comLN as comLN  ");
        buf.append(" , dyn.nodeLN  as nodeLN ");
        return buf.toString();
    }

    String builderFrom(AcctCashFlow item, AccountItem accountItem) {
        StringBuffer sql = new StringBuffer("");
        sql.append(" From T_GL_CashflowRecord Cash ").append(" inner join T_BD_CashFlowItem CashItem on CashItem.FID=");
        if (item.masterItem == 0) {
            sql.append(" Cash.FPrimaryItemID ");
        } else if (item.masterItem == 1) {
            sql.append(" Cash.FSupplementaryItemID ");
        } else {
            sql.append(" Cash.FFullInfoItemID ");
        }
        if (!item._cashTypeEnum.equals((Object)CashTypeEnum.AS) && !item._cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            sql.append(" inner join T_GL_VoucherEntry ve on Cash.FEntryId = ve.FID");
        }
        sql.append(" inner join T_GL_Voucher voucher on voucher.FID = CASH.Fvoucherid").append(" inner join T_BD_Period period on period.FID = voucher.FPeriodID").append(" inner join T_Org_Company OrgUnit on OrgUnit.FID = voucher.FCompanyID");
        if (!item._cashTypeEnum.equals((Object)CashTypeEnum.AS) && !item._cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            sql.append(" inner join T_BD_Currency Currency on Currency.FID = ve.FCurrencyID");
        }
        if (item._project.items != null && item._project.items.size() > 0) {
            sql.append(" left join t_bd_assistanthg c on Cash.fassgrpid=c.fid  ");
            for (int i = 0; i < item._project.items.size(); ++i) {
                Item itm = (Item)item._project.items.get(i);
                sql.append(" left join " + itm.table + " " + itm.tableAis + " on " + itm.tableAis + ".fid=c." + itm.mapfield + " ");
            }
        }
        if (accountItem != null && accountItem.getAccountAsstItem().accounts != null) {
            sql.append(" inner join t_gl_voucherEntry vet on Cash.FOPPOSINGACCOUNTENTRYID=vet.FID");
            sql.append(" inner join T_BD_AccountView A_Acct on vet.FAccountID = A_Acct.FID ");
        }
        return sql.toString();
    }

    void exportResult(HashMap rtMap, ResultSet rs, String[] fields) throws SQLException {
        AcctCashFlow item2 = null;
        while (rs.next()) {
            StringBuffer key = new StringBuffer();
            for (int i = 0; i < fields.length; ++i) {
                if (i > 0) {
                    key.append("|");
                }
                key.append(rs.getObject(fields[i]).toString());
            }
            ArrayList tls = (ArrayList)rtMap.get(key.toString());
            if (tls == null) continue;
            for (AcctCashFlow item2 : tls) {
                item2.setValue(rs.getBigDecimal("cashValue"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queryValue(Connection conn) {
        ArrayList tempList = (ArrayList)this.sortMap.get("isProfit");
        this.sortMap.put("isProfit", null);
        if (tempList != null) {
            long current = System.currentTimeMillis();
            for (AcctCashFlow item : tempList) {
                try {
                    item.setValue(this.getRetainedProfits(this.ServerCtx, item.company, item._cashTypeEnum, item._currency, item._intYear, item._startPeriod, item._endPeriod, item._isincludingUnPosted));
                }
                catch (Exception e) {
                    item.setValue(e.getMessage());
                }
            }
        }
        Iterator it = this.sortMap.values().iterator();
        String tableName = this.creatTempTable();
        while (it.hasNext()) {
            tempList = (ArrayList)it.next();
            if (tempList == null || tempList.size() == 0) continue;
            long time = System.currentTimeMillis();
            ArrayList queryList = new ArrayList();
            HashMap rtMap = new HashMap();
            String[] fields = this.builderReturnVar((AcctCashFlow)((Object)tempList.get(0)), rtMap, tempList, queryList);
            long size = 60000L;
            AcctCashFlow acctCash = (AcctCashFlow)((Object)tempList.get(0));
            AccountItem accountItem = null;
            String acctItem = acctCash._acctItem;
            if (acctItem != null && acctItem.length() != 0) {
                try {
                    accountItem = new AccountItem(this.ServerCtx, acctItem, acctCash.company);
                }
                catch (ReportException e) {
                    acctCash.setException(e);
                    continue;
                }
                catch (BOSException e) {
                    acctCash.setException(e);
                    continue;
                }
            }
            String select = "select " + this.builderSel(acctCash);
            String from = " \r\n   " + this.builderFrom(acctCash, accountItem);
            ArrayList paramsLast = new ArrayList();
            String where = " \r\n  " + this.builderWhere(acctCash, accountItem, paramsLast);
            size -= (long)select.length();
            size -= (long)from.length();
            PreparedStatement ps = null;
            ResultSet rs = null;
            int psSize = (int)((size -= (long)where.length()) / (long)this.calcDynTableItemSize((AcctCashFlow)((Object)tempList.get(0))));
            try {
                int list_size;
                if (queryList.size() <= psSize) {
                    StringBuffer Buf = new StringBuffer();
                    time = System.currentTimeMillis();
                    this.insertTempTableData(tableName, queryList);
                    String sql = select + " " + from + " inner join " + tableName + "  dyn on 1=1 " + where;
                    ps = conn.prepareStatement(sql);
                    Object[] object = paramsLast.toArray();
                    for (int i = 0; i < object.length; ++i) {
                        ps.setObject(i + 1, object[i]);
                    }
                    rs = ps.executeQuery();
                    logger.info((Object)("acctCash:" + (System.currentTimeMillis() - time)));
                    this.exportResult(rtMap, rs, fields);
                    this.close(rs);
                    this.deleteTempTableData(tableName);
                    continue;
                }
                Iterator sit = queryList.iterator();
                for (list_size = queryList.size(); list_size >= psSize; list_size -= psSize) {
                    boolean cur = true;
                    int count = psSize;
                    this.insertTempTableData(tableName, queryList);
                    String sql = select + " " + from + " inner join " + tableName + "  dyn on 1=1 " + where;
                    ps = conn.prepareStatement(sql);
                    rs = ps.executeQuery();
                    this.exportResult(rtMap, rs, fields);
                    this.close(rs);
                    this.deleteTempTableData(tableName);
                }
                if (list_size <= 0) continue;
                this.insertTempTableData(tableName, queryList);
                String sql = select + " " + from + " inner join " + tableName + "  dyn on 1=1 " + where;
                ps = conn.prepareStatement(sql);
                rs = ps.executeQuery();
                this.exportResult(rtMap, rs, fields);
                this.close(rs);
                this.deleteTempTableData(tableName);
            }
            catch (Exception e) {
                for (AcctCashFlow item : tempList) {
                    item.setValue(e.getMessage());
                }
            }
            finally {
                this.close(ps);
                this.close(rs);
                ps = null;
                rs = null;
            }
        }
        TempTablePool.getInstance((Context)this.ServerCtx).releaseTable(tableName);
    }

    String[] builderReturnVar(AcctCashFlow item, HashMap map, ArrayList tempList, ArrayList queryList) {
        boolean currency = false;
        boolean op = false;
        ArrayList<String> tl = new ArrayList<String>();
        tl.add("comLN");
        tl.add("nodeLN");
        Iterator it = tempList.iterator();
        while (it.hasNext()) {
            StringBuffer buf = new StringBuffer();
            item = (AcctCashFlow)((Object)it.next());
            buf.append(item.company.getLongNumber() + "|");
            buf.append(item.node.getLongNumber());
            ArrayList<AcctCashFlow> lst = (ArrayList<AcctCashFlow>)map.get(buf.toString());
            if (lst == null) {
                lst = new ArrayList<AcctCashFlow>();
                map.put(buf.toString(), lst);
                queryList.add(item);
            }
            lst.add(item);
        }
        return tl.toArray(new String[tl.size()]);
    }

    String builderWhere(AcctCashFlow item, AccountItem accountItem, ArrayList paramsLast) {
        StringBuffer buf = new StringBuffer();
        buf.append(" \r\n where (  Cash.FVoucherID = voucher.FID and voucher.FBizStatus <>0 and  voucher.FBizStatus <>2 ");
        buf.append(" and CashItem.FIsLeaf=1  ");
        if (!item._isincludingUnPosted) {
            buf.append(" and voucher.FBizStatus=5");
        }
        if (item._intYear == item._intYear2) {
            buf.append(" and  ( period.FPeriodYear =" + item._intYear);
            if (item._startPeriod == item._endPeriod) {
                buf.append(" and period.FPeriodNumber =" + item._startPeriod + ")");
            } else {
                buf.append(" and period.FPeriodNumber >=" + item._startPeriod);
                buf.append(" and period.FPeriodNumber <= " + item._endPeriod + ")");
            }
        } else if (item._intYear < item._intYear2) {
            buf.append(" and (  (period.FPeriodYear =" + item._intYear + " and period.FPeriodNumber >=  " + item._startPeriod + " )  or ");
            buf.append("   ( period.FPeriodYear > " + item._intYear + "  and period.FPeriodYear < " + item._intYear2 + "  ) or ");
            buf.append(" (period.FPeriodYear = " + item._intYear2 + " and period.FPeriodNumber <=  " + item._endPeriod + ") )");
        } else {
            buf.append(" and  (1>2) ");
        }
        if (!item._cashTypeEnum.equals((Object)CashTypeEnum.AS) && !item._cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            buf.append(" and Currency.FNumber = '" + item._currency + "'");
        }
        buf.append(")");
        buf.append(" and(( OrgUnit.FLongNumber = dyn.comLN ");
        buf.append(" or charindex( dyn.comLNd ,OrgUnit.FLongNumber )=1 )");
        buf.append(" and (CashItem.FLongNumber =  dyn.nodeLN ");
        buf.append(" or charindex(dyn.nodeLNd,CashItem.FLongNumber )=1 ) ");
        if (item._project.items != null && item._project.items.size() > 0) {
            buf.append(" and (");
            for (int i = 0; i < item._project.items.size(); ++i) {
                Item itm = (Item)item._project.items.get(i);
                if (i > 0) {
                    buf.append("and ");
                }
                buf.append(" ( " + itm.getWheteItem() + " )");
            }
            buf.append(") ");
        }
        buf.append(")");
        if (accountItem != null && accountItem.getAccountAsstItem().accounts != null) {
            if (accountItem.getAccountAsstItem().startNumber.length() != 0) {
                buf.append(" and A_Acct.Fnumber >='" + accountItem.getAccountAsstItem().startNumber + "'");
            }
            if (accountItem.getAccountAsstItem().endNumber.length() != 0) {
                buf.append(" and A_Acct.Fnumber<='" + accountItem.getAccountAsstItem().endNumber + "'");
            }
        }
        boolean isDetailItem = true;
        StringBuffer sqlFromCluster = new StringBuffer();
        StringBuffer sqlWhereCluster = new StringBuffer();
        if (accountItem != null) {
            boolean bIncludeItem = accountItem.hasItem();
            StringBuffer[] itemFilters = null;
            StringBuffer[] itemFromCluster = null;
            ArrayList[] itemParams = null;
            if (bIncludeItem) {
                itemFilters = new StringBuffer[accountItem.itemSize()];
                itemFromCluster = new StringBuffer[accountItem.itemSize()];
                itemParams = new ArrayList[accountItem.itemSize()];
                sqlFromCluster.append(" inner join T_GL_VOUCHERASSISTRECORD vs on vs.FID=cash.FOPPVOUCHERASSISTRECORDID ");
                sqlFromCluster.append(" inner join T_BD_AssistantHG A_Hg on vs.FASSGRPID = A_HG.FID ");
                Set set = accountItem.itemSet();
                int iRow = 0;
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    AssistantItem asstItem;
                    itemFilters[iRow] = new StringBuffer();
                    itemFromCluster[iRow] = new StringBuffer();
                    itemParams[iRow] = new ArrayList(2);
                    String strItemType = (String)iter.next();
                    String strTableName = accountItem.getItemType((String)strItemType).realtionDataObject;
                    String strTableAlias = "A_AsstType" + iRow;
                    String strFieldName = accountItem.getItemType((String)strItemType).mappingFieldName;
                    String strNumber = accountItem.getItemType((String)strItemType).number;
                    if (accountItem.endAccount == null || accountItem.startAccount == null || accountItem.endAccount.number == null || accountItem.startAccount.number == null || !accountItem.endAccount.number.equalsIgnoreCase(accountItem.startAccount.number)) {
                        // empty if block
                    }
                    if ((asstItem = accountItem.getItem(strNumber)) == null) {
                        asstItem = accountItem.getItem(strNumber.toUpperCase());
                    }
                    itemFromCluster[iRow].append(" inner join " + strTableName + " " + strTableAlias);
                    itemFromCluster[iRow].append(" on A_Hg." + strFieldName + "=" + strTableAlias + ".FID ");
                    String groupTable = accountItem.getItemType((String)strItemType).groupTableName;
                    if (asstItem.groups != null && asstItem.groups.length > 0) {
                        if ("T_BD_CUSTOMER".equalsIgnoreCase(asstItem.itemType.realtionDataObject) || "T_BD_SUPPLIER".equalsIgnoreCase(asstItem.itemType.realtionDataObject)) {
                            String group = null;
                            group = "T_BD_CUSTOMER".equalsIgnoreCase(asstItem.itemType.realtionDataObject) ? "Customer" : "Supplier";
                            itemFilters[iRow].append(" and " + strTableAlias + ".FID in (");
                            AssistantGroup[] groups = asstItem.groups;
                            for (int gi = 0; gi < groups.length; ++gi) {
                                itemFilters[iRow].append(')');
                            }
                        } else if (!"T_BD_Material".equalsIgnoreCase(asstItem.itemType.realtionDataObject)) {
                            String groupTableAlias = "Group" + iRow;
                            itemFromCluster[iRow].append(" inner join " + groupTable + " " + groupTableAlias).append(" on " + strTableAlias + "." + accountItem.getItemType((String)strItemType).groupMappingFieldName + "=" + groupTableAlias + ".FID ");
                            AssistantGroup assistantGroup = asstItem.groups[0];
                        }
                    }
                    if (strNumber != null) {
                        strNumber = strNumber.toUpperCase();
                    }
                    if (asstItem != null) {
                        if (strTableName.equalsIgnoreCase("T_BD_GeneralAsstActType") || strTableName.equalsIgnoreCase("T_ORG_Admin") || strTableName.equalsIgnoreCase("T_BD_CashFlowItem")) {
                            if (strTableName.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                                itemFilters[iRow].append(" and " + strTableAlias + ".FGroupID=? ");
                                itemParams[iRow].add(accountItem.getItemType((String)strItemType).glAsstActTypeGrpID);
                            }
                            if (asstItem.startItem != null && asstItem.endItem != null) {
                                if (asstItem.startItem.longNumber != null && asstItem.startItem.longNumber.equals(asstItem.endItem.longNumber) && asstItem.startItem.longNumber.length() > 0) {
                                    itemFilters[iRow].append(" and (" + strTableAlias + ".FLongNumber = ? ");
                                    itemParams[iRow].add(asstItem.startItem.longNumber);
                                    itemFilters[iRow].append(" or " + strTableAlias + ".FLongNumber like ?) ");
                                    itemParams[iRow].add(asstItem.startItem.longNumber + "!%");
                                } else {
                                    if (asstItem.startItem.longNumber != null && asstItem.startItem.longNumber.length() > 0) {
                                        itemFilters[iRow].append(" and (" + strTableAlias + ".FLongNumber >= ? ");
                                        itemParams[iRow].add(asstItem.startItem.longNumber);
                                    }
                                    if (asstItem.endItem.longNumber != null && asstItem.endItem.longNumber.length() > 0) {
                                        itemFilters[iRow].append(" and " + strTableAlias + ".FLongNumber <= ?) ");
                                        itemParams[iRow].add(asstItem.endItem.longNumber + "z");
                                    }
                                }
                            }
                        } else if (asstItem.startItem != null && asstItem.startItem.number != null && asstItem.startItem.number.equals(asstItem.endItem.number) && asstItem.startItem.number.length() > 0) {
                            itemFilters[iRow].append(" and " + strTableAlias + ".FNumber = ? ");
                            itemParams[iRow].add(asstItem.startItem.number);
                        } else {
                            if (asstItem.startItem != null && asstItem.startItem.number != null && asstItem.startItem.number.length() > 0) {
                                itemFilters[iRow].append(" and (" + strTableAlias + ".FNumber >= ? ");
                                itemParams[iRow].add(asstItem.startItem.number);
                            }
                            if (asstItem.endItem != null && asstItem.endItem.number != null && asstItem.endItem.number.length() > 0) {
                                itemFilters[iRow].append(" and " + strTableAlias + ".FNumber <= ?) ");
                                itemParams[iRow].add(asstItem.endItem.number);
                            }
                        }
                    }
                    ++iRow;
                }
                if (iRow == 0) {
                    item.setException(new ReportException(ReportException.ACCTITEMTYPE_NOT_FOUND));
                }
            }
            StringBuffer sqlLast = new StringBuffer();
            sqlLast.append(sqlFromCluster);
            if (bIncludeItem) {
                int y = accountItem.itemSize();
                for (int x = 0; x < y; ++x) {
                    sqlLast.append(itemFromCluster[x]);
                    sqlWhereCluster.append(itemFilters[x]);
                    paramsLast.addAll(itemParams[x]);
                }
            }
            buf.insert(0, sqlLast);
            buf.append(sqlWhereCluster);
        }
        buf.append(" " + this.buliderGroupBy(item));
        return buf.toString();
    }

    int calcDynTableItemSize(AcctCashFlow item) {
        return this.buliderDynTableItem(item).length() + 10;
    }

    private String creatTempTable() {
        String tempateTable = "acctCashTempTable";
        String craeteTableSQL = "CREATE TABLE " + tempateTable + " (comLN varchar (200) NOT NULL,comLNd varchar (201) NOT NULL,nodeLN varchar (200) NOT NULL,nodeLNd varchar (201) NOT NULL)";
        try {
            tempateTable = TempTablePool.getInstance((Context)this.ServerCtx).createTempTable(craeteTableSQL);
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
        }
        return tempateTable;
    }

    private String insertTempTableData(String tempateTable, ArrayList queryList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        int spit = 400;
        for (int i = 0; i < queryList.size(); ++i) {
            if (i % spit == 0) {
                sql.append("insert into " + tempateTable);
            } else {
                sql.append(" union ");
            }
            sql.append(this.buliderDynTableItem((AcctCashFlow)((Object)queryList.get(i))));
            if (i % spit != spit - 1 && i != queryList.size() - 1) continue;
            DbUtil.execute((Context)this.ServerCtx, (String)sql.toString());
        }
        return tempateTable;
    }

    private void deleteTempTableData(String tempateTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete " + tempateTable);
        DbUtil.execute((Context)this.ServerCtx, (String)sql.toString());
    }

    String buliderDynTableItem(AcctCashFlow item) {
        StringBuffer buf = new StringBuffer();
        buf.append(" select '" + item.company.getLongNumber() + "' as comLN ,");
        buf.append("'" + item.company.getLongNumber() + "!'  as comLNd ,");
        buf.append("'" + item.node.getLongNumber() + "' as nodeLN ,");
        buf.append("'" + item.node.getLongNumber() + "!'  as nodeLNd ");
        return buf.toString();
    }

    String buliderGroupBy(AcctCashFlow item) {
        StringBuffer buf = new StringBuffer();
        buf.append("group by dyn.comLN ");
        buf.append(" , dyn.nodeLN ");
        return buf.toString();
    }

    void close(Object obj) {
        try {
            Method method = obj.getClass().getMethod("close", new Class[0]);
            method.invoke(obj, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void insertMap(StringBuffer key, AcctCashFlow item) {
        key.append("|" + item._intYear + "|");
        key.append(item._intYear2 + "|");
        key.append(item._startPeriod + "|");
        key.append(item._endPeriod + "|");
        key.append((Object)((Object)item._cashTypeEnum) + "|");
        if (!item._cashTypeEnum.equals((Object)CashTypeEnum.AS) && !item._cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            key.append(item._currency + "|");
        }
        key.append(item._acctItem + "|");
        key.append(item._project.getSortKey());
        ArrayList<AcctCashFlow> tempList = (ArrayList<AcctCashFlow>)this.sortMap.get(key.toString());
        if (tempList == null) {
            tempList = new ArrayList<AcctCashFlow>();
            this.sortMap.put(key.toString(), tempList);
        }
        tempList.add(item);
    }

    void sort() {
        for (AcctCashFlow item : this.list) {
            if (item.isProfit) {
                ArrayList<AcctCashFlow> tempList = (ArrayList<AcctCashFlow>)this.sortMap.get("isProfit");
                if (tempList == null) {
                    tempList = new ArrayList<AcctCashFlow>();
                    this.sortMap.put("isProfit", tempList);
                }
                tempList.add(item);
                continue;
            }
            StringBuffer key = new StringBuffer();
            if (item._isincludingUnPosted) {
                key.append("i");
            } else {
                key.append("k");
            }
            if (item.masterItem == 0) {
                key.append("p");
                if (item.isLeaf || !item.isLeaf && item.direction != CashFlowDirection.IN_OR_OUT) {
                    key.append("a");
                    if (item._cashTypeEnum.getValue() == 2) {
                        key.append("y");
                        this.insertMap(key, item);
                        continue;
                    }
                    if (item._cashTypeEnum.getValue() == 1 || item._cashTypeEnum.getValue() == 4) {
                        key.append("z");
                        this.insertMap(key, item);
                        continue;
                    }
                    if (item._cashTypeEnum.getValue() == 3 || item._cashTypeEnum.getValue() == 5) {
                        key.append("s");
                        this.insertMap(key, item);
                        continue;
                    }
                    item.setException(new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID));
                    continue;
                }
                key.append("b");
                if (item._cashTypeEnum.getValue() == 2) {
                    key.append("y");
                    this.insertMap(key, item);
                    continue;
                }
                if (item._cashTypeEnum.getValue() == 1 || item._cashTypeEnum.getValue() == 4) {
                    key.append("z");
                    this.insertMap(key, item);
                    continue;
                }
                if (item._cashTypeEnum.getValue() == 3 || item._cashTypeEnum.getValue() == 5) {
                    key.append("s");
                    this.insertMap(key, item);
                    continue;
                }
                item.setException(new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID));
                continue;
            }
            key.append("u");
            if (item._cashTypeEnum.getValue() == 2) {
                key.append("y");
                this.insertMap(key, item);
                continue;
            }
            if (item._cashTypeEnum.getValue() == 1 || item._cashTypeEnum.getValue() == 4) {
                key.append("z");
                this.insertMap(key, item);
                continue;
            }
            if (item._cashTypeEnum.getValue() == 3 || item._cashTypeEnum.getValue() == 5) {
                key.append("s");
                this.insertMap(key, item);
                continue;
            }
            item.setException(new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID));
        }
    }

    void queryInfo() {
        ArrayList<AcctCashFlow> newList = new ArrayList<AcctCashFlow>();
        Iterator<Object> it = this.list.iterator();
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("type"));
        ev.getSelector().add(new SelectorItemInfo("isLeaf"));
        ev.getSelector().add(new SelectorItemInfo("direction"));
        ev.getSelector().add(new SelectorItemInfo("isProfit"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.setFilter(new FilterInfo());
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        HashSet<String> set = new HashSet<String>();
        int count = 0;
        String fc = null;
        while (it.hasNext()) {
            AcctCashFlow item = (AcctCashFlow)((Object)it.next());
            ArrayList tempList = (ArrayList)map.get(item._project.projectCode);
            if (tempList == null) {
                if (++count == 1) {
                    fc = item._project.projectCode;
                }
                set.add(item._project.projectCode);
                tempList = new ArrayList();
                map.put(item._project.projectCode, tempList);
            }
            tempList.add(item);
        }
        if (set.size() == 0) {
            return;
        }
        if (count > 1) {
            ev.getFilter().getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        } else {
            ev.getFilter().getFilterItems().add(new FilterItemInfo("number", fc));
        }
        CoreBaseCollection c = null;
        try {
            c = CashFlowItemFactory.getLocalInstance((Context)this.ServerCtx).getCollection(ev);
        }
        catch (BOSException e) {
            for (ArrayList tempList : map.values()) {
                if (tempList == null) continue;
                for (AcctCashFlow item : tempList) {
                    item.setException(new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NotExistsCashFlowItem")}));
                }
            }
            this.list = newList;
            return;
        }
        for (CashFlowItemInfo info : c) {
            ArrayList tempList = (ArrayList)map.get(info.getNumber());
            if (tempList == null) continue;
            for (int i = 0; i < tempList.size(); ++i) {
                AcctCashFlow item = (AcctCashFlow)((Object)tempList.get(i));
                item.masterItem = info.getType().getValue();
                item.isLeaf = info.isIsLeaf();
                item.direction = info.getDirection();
                item.isProfit = info.isIsProfit();
                if (!item.company.isIsBizUnit() && item.masterItem != 0) {
                    item.setException((Throwable)((Object)new RptAndTempException(RptAndTempException.NOTSUPPORTORG)));
                    continue;
                }
                newList.add(item);
            }
            map.put(info.getNumber(), null);
        }
        for (ArrayList tempList : map.values()) {
            if (tempList == null) continue;
            for (AcctCashFlow item : tempList) {
                item.setException((Throwable)((Object)new RptAndTempException(RptAndTempException.ITEMISNULL)));
            }
        }
        this.list = newList;
    }

    void getGroupLongNumber() {
        ArrayList<AcctCashFlow> newList = new ArrayList<AcctCashFlow>();
        Iterator<Object> it = this.list.iterator();
        ArrayList<String> strList = new ArrayList<String>();
        HashMap<String, ArrayList<AcctCashFlow>> map = new HashMap<String, ArrayList<AcctCashFlow>>();
        while (it.hasNext()) {
            AcctCashFlow item = (AcctCashFlow)((Object)it.next());
            ArrayList<AcctCashFlow> tempList = (ArrayList<AcctCashFlow>)map.get(item._project.projectCode);
            if (tempList == null) {
                strList.add(item._project.projectCode);
                tempList = new ArrayList<AcctCashFlow>();
                map.put(item._project.projectCode, tempList);
            }
            tempList.add(item);
        }
        if (strList.size() == 0) {
            return;
        }
        RptCalculaterDAO dao = new RptCalculaterDAO(this.ServerCtx);
        Map longNumber = null;
        try {
            longNumber = dao.getGroupLongNumber(strList.toArray(new String[strList.size()]), "T_BD_CashFlowItem");
        }
        catch (Exception e) {
            for (ArrayList tempList : map.values()) {
                if (tempList == null) continue;
                for (AcctCashFlow item : tempList) {
                    item.setException(new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NotExistsCashFlowItem")}));
                }
            }
            this.list = newList;
            return;
        }
        for (Object key : map.keySet()) {
            AcctCashFlow item;
            int i;
            ArrayList tempList = (ArrayList)map.get(key);
            if (tempList == null) continue;
            GroupTreeNode node = (GroupTreeNode)longNumber.get(key.toString());
            if (node != null) {
                for (i = 0; i < tempList.size(); ++i) {
                    item = (AcctCashFlow)((Object)tempList.get(i));
                    item.node = node;
                    newList.add(item);
                }
                continue;
            }
            for (i = 0; i < tempList.size(); ++i) {
                item = (AcctCashFlow)((Object)tempList.get(i));
                item.setException(new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NotExistsCashFlowItem")}));
            }
        }
        this.list = newList;
    }

    private void queryTableAndMapField() throws BOSException {
        IAsstActType local = AsstActTypeFactory.getLocalInstance((Context)this.ServerCtx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.setFilter(new FilterInfo());
        HashMap<String, String> filterMap = new HashMap<String, String>();
        for (AcctCashFlow item : this.list) {
            if (item._project.items == null || item._project.items.size() <= 0) continue;
            for (Item itm : item._project.items) {
                if (filterMap.get(itm.type) != null) continue;
                filterMap.put(itm.type, " ");
                view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)itm.type));
            }
        }
        if (filterMap.keySet().size() == 0) {
            return;
        }
        Iterator it3 = view.getFilter().getFilterItems().iterator();
        int index = 0;
        StringBuffer mask = new StringBuffer();
        while (it3.hasNext()) {
            if (index > 0) {
                mask.append(" or ");
            }
            mask.append("#" + index);
            ++index;
            it3.next();
        }
        view.getFilter().setMaskString(mask.toString());
        HashMap<String, AsstActTypeInfo> queryMap = new HashMap<String, AsstActTypeInfo>();
        AsstActTypeCollection c = local.getAsstActTypeCollection(view);
        if (c != null && c.size() != 0) {
            for (AsstActTypeInfo info : c) {
                queryMap.put(info.getNumber(), info);
            }
        }
        ArrayList<AcctCashFlow> temp = new ArrayList<AcctCashFlow>();
        Iterator it = this.list.iterator();
        TableNameManager tm = new TableNameManager();
        while (it.hasNext()) {
            AcctCashFlow item = (AcctCashFlow)((Object)it.next());
            boolean add = true;
            if (item._project.items != null && item._project.items.size() > 0) {
                Iterator it2 = item._project.items.iterator();
                int itemIndex = 0;
                while (it2.hasNext()) {
                    Item itm = (Item)it2.next();
                    AsstActTypeInfo info = (AsstActTypeInfo)queryMap.get(itm.type);
                    if (info == null) {
                        item.setValue((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"32_AcctCashCalcter", (Locale)this.ServerCtx.getOriginLocale())}));
                        add = false;
                        break;
                    }
                    itm.mapfield = info.getMappingFieldName();
                    itm.table = info.getRealtionDataObject();
                    itm.tableAis = tm.TableAix(itm.table, itemIndex);
                    ++itemIndex;
                }
            }
            if (!add) continue;
            temp.add(item);
        }
        this.list = temp;
    }

    private int getSheet_StartPeriod() {
        return this.context.getReportVariables().getIntValue("StartPeriod", this.getCalculateSheetName(), 0);
    }

    private int getReport_PeriodType() {
        Integer period = (Integer)this.context.getReportAdapter().getReportProperty("PeriodType");
        if (period == null) {
            return -1;
        }
        return period;
    }

    private boolean isSheet_IncludePosted() {
        return this.context.getReportVariables().getBoolValue("IncludePosted", this.getCalculateSheetName(), false);
    }

    private int getSheet_StartYear() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("StartYear", this.getCalculateSheetName(), 0);
    }

    private int getSheet_EndPeriod() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("EndPeriod", this.getCalculateSheetName(), 0);
    }

    private int getReport_Year() {
        return (Integer)this.context.getReportAdapter().getReportProperty("Report.Year");
    }

    private int getReport_Period() {
        return (Integer)this.context.getReportAdapter().getReportProperty("Report.Period");
    }

    private String getCorrect_Currency_Number() {
        String currency = (String)this.context.getReportAdapter().getReportProperty("Currency.Number");
        return currency;
    }

    private String getSource_Currency_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("SourceCurrency.Number");
    }

    private String getOrgUnit_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("OrgUnit.Number");
    }

    private String getCompany_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("Company.Number");
    }

    private String getOrgTreeNumber() {
        OrgTreeInfo info;
        String orgTreeNumber = (String)this.context.getReportAdapter().getReportProperty("CSLReport_OrgTree_Number");
        if (orgTreeNumber == null && (info = (OrgTreeInfo)this.context.getServerContext().get((Object)"KEY_ORGTREE_INFO")) != null) {
            orgTreeNumber = info.getNumber();
        }
        return orgTreeNumber;
    }

    private BigDecimal getRetainedProfits(Context ctx, CompanyOrgUnitInfo company, CashTypeEnum cashTypeEnum, String currency, int intYear, int startPeriod, int endPeriod, boolean isincludingUnPosted) throws BOSException, EASBizException {
        BigDecimal bdReturn = null;
        StringBuffer sbSql = new StringBuffer("select ");
        if (cashTypeEnum.equals((Object)CashTypeEnum.Z) || cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount");
        } else if (cashTypeEnum.equals((Object)CashTypeEnum.S) || cashTypeEnum.equals((Object)CashTypeEnum.AS)) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) FAmount");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount");
        }
        sbSql.append(" from T_GL_Voucher voucher join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID join T_BD_AccountView account on ve.FAccountID = account.FID left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID ").append(" inner join T_BD_Currency Currency on Currency.FID = ve.FCurrencyID");
        sbSql.append(" ,T_BD_Period period");
        sbSql.append(" where voucher.FCompanyID = ?");
        sbSql.append(" and fdiffaccountid is null");
        sbSql.append(" and account.FPLType <> ?");
        sbSql.append(" and voucher.FPeriodID = period.FID");
        sbSql.append(" and period.FPeriodYear >= ?");
        sbSql.append(" and period.FPeriodNumber >= ?");
        sbSql.append(" and period.FPeriodYear <= ?");
        sbSql.append(" and period.FPeriodNumber <= ?");
        if (!cashTypeEnum.equals((Object)CashTypeEnum.AS) && !cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
            sbSql.append(" and Currency.FNumber = ?  ");
        }
        sbSql.append(" and voucher.FSourceType<>1 ");
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (isincludingUnPosted) {
            sbSql.append(",");
            sbSql.append(1);
            sbSql.append(",");
            sbSql.append(3);
        }
        sbSql.append(")");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ServerCtx);
            ps = conn.prepareStatement(sbSql.toString());
            int index = 1;
            ps.setString(index++, company.getId().toString());
            ps.setInt(index++, 0);
            ps.setInt(index++, intYear);
            ps.setInt(index++, startPeriod);
            ps.setInt(index++, intYear);
            ps.setInt(index++, endPeriod);
            if (!cashTypeEnum.equals((Object)CashTypeEnum.AS) && !cashTypeEnum.equals((Object)CashTypeEnum.AZ)) {
                ps.setString(index++, currency);
            }
            rs = ps.executeQuery();
            rs.next();
            bdReturn = rs.getBigDecimal("FAmount");
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bdReturn == null ? new BigDecimal(0.0) : bdReturn;
    }

    private CompanyOrgUnitInfo getCacheCompany(String fiOrgUnit) throws BOSException {
        if (this.companyCache.get(fiOrgUnit) == null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)fiOrgUnit, CompareType.EQUALS));
            ICompanyOrgUnit company = null;
            company = this.ServerCtx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
            CompanyOrgUnitCollection coms = company.getCompanyOrgUnitCollection(evi);
            if (coms != null && coms.size() > 0) {
                this.companyCache.put(fiOrgUnit, coms.get(0));
            }
        }
        return (CompanyOrgUnitInfo)this.companyCache.get(fiOrgUnit);
    }

    private String getCalculateSheetName() {
        return this._pma.getSheetName();
    }

    class Project {
        boolean hasItem = false;
        String projectCode = "";
        ArrayList items = new ArrayList();

        Project(String param) throws Exception {
            if (param.indexOf("|") < 0) {
                this.projectCode = param;
            } else {
                this.hasItem = true;
                ArrayList<String> list = new ArrayList<String>();
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < param.length(); ++i) {
                    if (param.charAt(i) == '|') {
                        list.add(buf.toString());
                        buf = new StringBuffer();
                    } else {
                        buf.append(param.charAt(i));
                    }
                    if (i != param.length() - 1) continue;
                    list.add(buf.toString());
                }
                if (list.size() % 2 == 1) {
                    String type = null;
                    for (int i = 0; i < list.size(); ++i) {
                        String str = (String)list.get(i);
                        if (i == 0) {
                            this.projectCode = str;
                            continue;
                        }
                        if (i % 2 == 0) {
                            Item item;
                            if (type == null || type.trim().length() == 0) {
                                throw new Exception("type is null");
                            }
                            if (str == null || str.trim().length() == 0) {
                                item = new Item();
                                item.type = type.trim();
                                this.items.add(item);
                                continue;
                            }
                            item = new Item();
                            item.type = type.trim();
                            if (str.indexOf(":") >= 0) {
                                item.setFrom(str.substring(0, str.indexOf(":")));
                                item.setTo(str.substring(str.indexOf(":") + 1));
                            } else {
                                item.setFrom(str);
                            }
                            this.items.add(item);
                            continue;
                        }
                        type = str;
                    }
                } else {
                    throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"2_ReportCaclControllerBean", (Locale)AcctCashCalcter.this.ServerCtx.getOriginLocale()));
                }
            }
            this.sortItems();
        }

        private void sortItems() {
            if (this.items != null && this.items.size() > 0) {
                HashMap<String, Item> map = new HashMap<String, Item>();
                ArrayList list = new ArrayList();
                for (int i = 0; i < this.items.size(); ++i) {
                    Item item = (Item)this.items.get(i);
                    map.put(item.type, item);
                }
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    list.add(map.get(it.next()));
                }
                this.items = list;
            }
        }

        String getSortKey() {
            StringBuffer buf = new StringBuffer();
            buf.append("|");
            if (this.items != null && this.items.size() > 0) {
                for (int i = 0; i < this.items.size(); ++i) {
                    Item item = (Item)this.items.get(i);
                    buf.append(item.toTFTString() + "|");
                }
            }
            return buf.toString();
        }
    }

    class Item {
        String type;
        String from = null;
        String to = null;
        String table;
        String mapfield;
        String tableAis;

        void setFrom(String f) {
            if (f == null || f.trim().length() == 0) {
                return;
            }
            this.from = f.trim();
        }

        void setTo(String f) {
            if (f == null || f.trim().length() == 0) {
                return;
            }
            this.to = f.trim();
        }

        boolean hasFromTo() {
            return this.from != null || this.to != null;
        }

        public String toTFTString() {
            return this.type + "|" + this.from + "|" + this.to;
        }

        String getWheteItem() {
            if (this.from == null && this.to == null) {
                return "( " + this.tableAis + ".fnumber IS NOT  NULL )";
            }
            if (this.from != null && this.to != null) {
                if (!this.from.equals(this.to)) {
                    return "( " + this.tableAis + ".fnumber>='" + this.from + "'  and  " + this.tableAis + ".fnumber<='" + this.to + "')";
                }
                return " " + this.tableAis + ".fnumber='" + this.from + "' ";
            }
            return " " + this.tableAis + ".fnumber='" + this.from + "' ";
        }
    }

    class AcctCashFlow
    extends FormulaValueBackfill {
        Project _project;
        String _currency;
        CashTypeEnum _cashTypeEnum;
        String _fiOrgUnit;
        boolean _isincludingUnPosted;
        int _intYear;
        int _intYear2;
        int _startPeriod;
        int _endPeriod;
        String _acctItem;
        CompanyOrgUnitInfo company;
        GroupTreeNode node;
        boolean isLeaf;
        CashFlowDirection direction;
        int masterItem;
        boolean isProfit;

        public AcctCashFlow(Parameter p) {
            super(p);
            this._project = null;
            this.company = null;
            this.node = null;
            this.isLeaf = false;
            this.direction = null;
            this.masterItem = -1;
            this.isProfit = false;
            this.setValue(new BigDecimal("0"));
        }

        boolean init() {
            try {
                Integer b;
                String acctItem;
                String FlowPorj;
                AcctCashCalcter.this._pma = this._param;
                Object[] params = this._param.getArgs();
                String fiOrgUnit = ((Variant)params[0]).getValue() == null ? null : ((Variant)params[0]).getValue().toString();
                String cashTypeEnumStr = ((Variant)params[1]).getValue() == null ? null : ((Variant)params[1]).getValue().toString();
                String currency = ((Variant)params[2]).getValue() == null ? null : ((Variant)params[2]).getValue().toString();
                int intYear = Integer.parseInt(((Variant)params[3]).getValue().toString());
                int startPeriod = Integer.parseInt(((Variant)params[4]).getValue().toString());
                int endPeriod = Integer.parseInt(((Variant)params[5]).getValue().toString());
                String string = FlowPorj = ((Variant)params[6]).getValue() == null ? null : ((Variant)params[6]).getValue().toString();
                if (params.length == 7) {
                    acctItem = "";
                } else {
                    String string2 = acctItem = ((Variant)params[7]).getValue() == null ? null : ((Variant)params[7]).getValue().toString();
                }
                if (!StringUtils.isEmpty((String)cashTypeEnumStr)) {
                    cashTypeEnumStr = cashTypeEnumStr.toUpperCase();
                }
                CashTypeEnum cashTypeEnum = CashTypeEnum.getEnum(cashTypeEnumStr);
                if (fiOrgUnit == null || fiOrgUnit.length() <= 0) {
                    fiOrgUnit = AcctCashCalcter.this.getCompany_Number();
                }
                if (AcctCashCalcter.this.pmc != null) {
                    try {
                        if (AcctCashCalcter.this.pmc != null) {
                            AcctCashCalcter.this.pmc.checkCompanyPermision(fiOrgUnit);
                        }
                    }
                    catch (Exception e) {
                        this.setException(e);
                        return false;
                    }
                }
                this.company = AcctCashCalcter.this.getCacheCompany(fiOrgUnit);
                if (this.company == null) {
                    this.setException(new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"33_AcctCashCalcter", (Locale)AcctCashCalcter.this.ServerCtx.getOriginLocale())}));
                    return false;
                }
                if (intYear <= 0 && (intYear += AcctCashCalcter.this.getSheet_StartYear()) <= 0) {
                    intYear += AcctCashCalcter.this.getReport_Year();
                }
                int intYear2 = intYear;
                if (startPeriod <= 0) {
                    if ((startPeriod += AcctCashCalcter.this.getSheet_StartPeriod()) <= 0) {
                        startPeriod += AcctCashCalcter.this.getReport_Period();
                    }
                    if (startPeriod <= 0) {
                        startPeriod += PeriodUtils.getMaxPeriodNumber((Context)AcctCashCalcter.this.ServerCtx, (int)(--intYear), (String)this.company.getId().toString());
                    }
                    if (AcctCashCalcter.this.getReport_PeriodType() > 0 && 3 != AcctCashCalcter.this.getReport_PeriodType()) {
                        Date periodLastDate = RPTDateUtil.getPeriodFirstDate((int)intYear, (int)startPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)AcctCashCalcter.this.getReport_PeriodType()));
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(periodLastDate);
                        intYear = calendar.get(1);
                        startPeriod = calendar.get(2) + 1;
                    }
                }
                if (endPeriod <= 0) {
                    if ((endPeriod += AcctCashCalcter.this.getSheet_EndPeriod()) <= 0) {
                        endPeriod += AcctCashCalcter.this.getReport_Period();
                    }
                    if (endPeriod <= 0) {
                        endPeriod += PeriodUtils.getMaxPeriodNumber((Context)AcctCashCalcter.this.ServerCtx, (int)(--intYear2), (String)this.company.getId().toString());
                    }
                    if (AcctCashCalcter.this.getReport_PeriodType() > 0 && 3 != AcctCashCalcter.this.getReport_PeriodType()) {
                        Calendar calendar = Calendar.getInstance();
                        Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)intYear2, (int)endPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)AcctCashCalcter.this.getReport_PeriodType()));
                        calendar.setTime(periodLastDate);
                        intYear2 = calendar.get(1);
                        endPeriod = calendar.get(2) + 1;
                    }
                }
                if ((b = (Integer)AcctCashCalcter.this.context.getReportAdapter().getReportProperty("SupportAdjustPeriodData")) != null && b == 1 && endPeriod == 12) {
                    endPeriod = PeriodUtils.getMaxPeriodNumber((Context)AcctCashCalcter.this.ServerCtx, (int)intYear2, (String)this.company.getId().toString());
                }
                if (currency == null || currency.length() <= 0) {
                    currency = AcctCashCalcter.this.getCorrect_Currency_Number();
                }
                boolean includeVoucher = AcctCashCalcter.this.isSheet_IncludePosted();
                this._currency = currency;
                this._cashTypeEnum = cashTypeEnum;
                this._fiOrgUnit = fiOrgUnit;
                this._isincludingUnPosted = includeVoucher;
                this._intYear = intYear;
                this._intYear2 = intYear2;
                this._startPeriod = startPeriod;
                this._endPeriod = endPeriod;
                this._acctItem = acctItem;
                if (StringUtils.isEmpty((String)this._currency)) {
                    this.setException(new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NeedCurrency")}));
                    return false;
                }
                if (StringUtils.isEmpty((String)FlowPorj)) {
                    Locale locale = ContextUtils.getOriginalLocaleFromEnv();
                    this.setException(new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NeedCashFlowItem", (Locale)locale)}));
                    return false;
                }
                if ((this._currency.equalsIgnoreCase("GLC") || this._currency.equalsIgnoreCase("GRC")) && (this._cashTypeEnum.equals((Object)CashTypeEnum.S) || this._cashTypeEnum.equals((Object)CashTypeEnum.Y) || this._cashTypeEnum.equals((Object)CashTypeEnum.Z))) {
                    this.setException(new ReportException(ReportException.CANNOT_CURRENCY));
                    return false;
                }
                if (this._cashTypeEnum.equals((Object)CashTypeEnum.AS) && !this._currency.equalsIgnoreCase("GRC")) {
                    this.setException(new ReportException(ReportException.ONLY_GRC));
                    return false;
                }
                if (this._cashTypeEnum.equals((Object)CashTypeEnum.AZ) && !this._currency.equalsIgnoreCase("GLC")) {
                    this.setException(new ReportException(ReportException.ONLY_GLC));
                    return false;
                }
                try {
                    this._project = new Project(FlowPorj);
                }
                catch (Exception e) {
                    this.setException(e);
                    return false;
                }
                return true;
            }
            catch (Throwable a) {
                this.setException(new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"34_AcctCashCalcter", (Locale)AcctCashCalcter.this.ServerCtx.getOriginLocale())}));
                return false;
            }
        }
    }

    class TableNameManager {
        int index = 0;
        HashMap map = new HashMap();

        TableNameManager() {
        }

        String TableAix(String tableName, int itemIdex) {
            if (this.map.get(tableName + itemIdex) == null) {
                this.map.put(tableName + itemIdex, tableName + "_" + itemIdex + "_" + this.index);
                ++this.index;
            }
            return this.map.get(tableName + itemIdex).toString();
        }
    }
}

