/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeCollection;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AcctStruct;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.AccountExt;
import com.kingdee.eas.fi.rpt.app.AcctBatchQueryServiceNew;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.AsstAccountChangeNewInfo;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.util.CachingMap;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AcctChangeAccountAsstActType {
    private static final Logger logger = CoreUIObject.getLogger(AcctChangeAccountAsstActType.class);
    private AcctBatchQueryServiceNew batchQueryService;
    private boolean isGroupByAccount;
    private Context ctx;
    private Map currentPeriodCache = new CachingMap();

    public AcctChangeAccountAsstActType(Context ctx, AcctBatchQueryServiceNew batchQueryService, boolean isGroupByAccount) {
        this.ctx = ctx;
        this.batchQueryService = batchQueryService;
        this.isGroupByAccount = isGroupByAccount;
    }

    private void changeAsstForAccumulateType(AcctCalculaterExt tempAcct, AsstAccountChangeCollection asstAccountChanges, List<Map<String, Object>> asstAccountBeforeChange, List<Map<String, Object>> asstAccountAfterChange, int changeYear, int changePeriod, List<AcctCalculaterExt> acctCalculaterExts) {
        String accountid = tempAcct.getAccountItem().startAccount.account.id;
        List<AsstActType> asstActTypeList = this.removeDup(this.getAsstActTypeByAsstChange(accountid, asstAccountBeforeChange, changeYear, changePeriod));
        List<AsstActType> asstActTypeAfterList = this.removeDup(this.getAsstActTypeByAsstChange(accountid, asstAccountAfterChange, changeYear, changePeriod));
        AccountExt account = tempAcct.getAccountItem().startAccount;
        List<AsstActType> itemTypes = this.removeDup(account.getItemTypes());
        if (asstAccountChanges.size() == 1 && this.isDiffActType(asstActTypeAfterList, itemTypes)) {
            this.changeAsstForAcct(tempAcct, asstActTypeAfterList);
            itemTypes = this.removeDup(account.getItemTypes());
        }
        if (itemTypes.size() > asstActTypeList.size()) {
            this.changeAsstForAcct(tempAcct, asstActTypeList);
        } else if (itemTypes.size() == asstActTypeList.size() && !this.ActTypeIsSame(asstActTypeList, itemTypes)) {
            this.getAcctByNewActType(tempAcct, asstAccountBeforeChange, changeYear, changePeriod, acctCalculaterExts);
        }
    }

    private boolean isDiffActType(List<AsstActType> asstActTypeAfterList, List<AsstActType> itemTypes) {
        if (asstActTypeAfterList.size() != itemTypes.size()) {
            return true;
        }
        ArrayList<AsstActType> acttypes = new ArrayList<AsstActType>();
        block0: for (AsstActType afterAsstActType : asstActTypeAfterList) {
            String afterNumber = afterAsstActType.number;
            for (AsstActType itemType : itemTypes) {
                String itemTypeNumber = itemType.number;
                if (!afterNumber.equals(itemTypeNumber)) continue;
                acttypes.add(itemType);
                continue block0;
            }
        }
        return asstActTypeAfterList.size() != acttypes.size();
    }

    private List<AsstActType> removeDup(List<AsstActType> itemTypes) {
        ArrayList<AsstActType> newItemTypes = new ArrayList<AsstActType>();
        for (AsstActType actType : itemTypes) {
            if (newItemTypes.contains(actType)) continue;
            newItemTypes.add(actType);
        }
        return newItemTypes;
    }

    private boolean ActTypeIsSame(List<AsstActType> asstActTypeList, List<AsstActType> itemTypes) {
        ArrayList<AsstActType> acttypes = new ArrayList<AsstActType>();
        block0: for (AsstActType asstActType : itemTypes) {
            String tempAcctActNumber = asstActType.number;
            for (AsstActType befAsstActType : asstActTypeList) {
                String befActNumber = befAsstActType.number;
                if (!tempAcctActNumber.equals(befActNumber)) continue;
                acttypes.add(asstActType);
                continue block0;
            }
        }
        return itemTypes.size() == acttypes.size();
    }

    private void getAcctByNewActType(AcctCalculaterExt tempAcct, List<Map<String, Object>> asstAccountAfterChange, int changeYear, int changePeriod, List<AcctCalculaterExt> acctCalculaterExts) {
        String accountid = tempAcct.getAccountItem().startAccount.account.id;
        List<AsstActType> asstActTypeList = this.getAsstActTypeByAsstChange(accountid, asstAccountAfterChange, changeYear, changePeriod);
        AcctStruct acctStruct = tempAcct.getStruct().copy();
        acctStruct.setAccountItem(tempAcct.getAccountItem().getAccountAsstItem().toOldString());
        AcctCalculaterExt acctext = this.newAcctCalculaterExt(acctStruct, tempAcct, asstActTypeList);
        acctCalculaterExts.add(acctext);
    }

    private void changeAsstForAcct(AcctCalculaterExt tempAcct, List<Map<String, Object>> asstAccountAfterChange, int changeYear, int changePeriod) {
        String accountid = tempAcct.getAccountItem().startAccount.account.id;
        List<AsstActType> asstActTypeList = this.getAsstActTypeByAsstChange(accountid, asstAccountAfterChange, changeYear, changePeriod);
        this.changeAsstForAcct(tempAcct, asstActTypeList);
    }

    private List<AsstActType> getAsstActTypeByAsstChange(String accountid, List<Map<String, Object>> asstAccountChange, int changeYear, int changePeriod) {
        ArrayList<AsstActType> asstActTypeList = new ArrayList<AsstActType>();
        for (Map<String, Object> map : asstAccountChange) {
            if (!map.containsKey(accountid)) continue;
            if (map.get(accountid) instanceof AsstAccountChangeNewInfo) {
                AsstAccountChangeNewInfo info = (AsstAccountChangeNewInfo)map.get(accountid);
                if (info.getYear() != changeYear || info.getPeriod() != changePeriod) continue;
                asstActTypeList.add(info.getAsstActType());
                continue;
            }
            if (!(map.get(accountid) instanceof List)) continue;
            List list = (List)map.get(accountid);
            for (int i = 0; i < list.size(); ++i) {
                AsstAccountChangeNewInfo info = (AsstAccountChangeNewInfo)list.get(i);
                if (info.getYear() != changeYear || info.getPeriod() != changePeriod) continue;
                asstActTypeList.add(info.getAsstActType());
            }
        }
        return asstActTypeList;
    }

    private void extendAcctByChangeAsst(AcctCalculaterExt tempAcct, List<Map<String, Object>> asstAccountChange, List<AcctCalculaterExt> acctCalculaterExts, boolean isMultiUnPosted, int changeYear, int changePeriod) {
        String accountid = tempAcct.getAccountItem().startAccount.account.id;
        List<AsstActType> asstActTypeList = this.getAsstActTypeByAsstChange(accountid, asstAccountChange, changeYear, changePeriod);
        AcctStruct acctStruct = tempAcct.getStruct().copy();
        int periodType = AcctUtils.getPeriodType(tempAcct.getBalanceType().getName());
        if (isMultiUnPosted && periodType != 2) {
            int acctYear = acctStruct.getStartYear();
            int acctPeriod = acctStruct.getStartPeriod();
            int acctYearEnd = acctStruct.getEndYear();
            int acctPeriodEnd = acctStruct.getEndPeriod();
            if (acctYear == acctYearEnd && acctPeriod == acctPeriodEnd) {
                --acctPeriodEnd;
                if (--acctPeriod == 0) {
                    acctPeriod = 12;
                    acctPeriodEnd = 12;
                    --acctYear;
                    --acctYearEnd;
                }
                acctStruct.setStartYear(acctYear);
                acctStruct.setEndYear(acctYearEnd);
                acctStruct.setStartPeriod(acctPeriod);
                acctStruct.setEndPeriod(acctPeriodEnd);
            }
        }
        acctStruct.setAccountItem(tempAcct.getAccountItem().getAccountAsstItem().toOldString());
        AcctCalculaterExt acctext = this.newAcctCalculaterExt(acctStruct, tempAcct, asstActTypeList);
        acctCalculaterExts.add(acctext);
    }

    private void extendAcctByChangeAsstNeedChangePeriod(AcctCalculaterExt tempAcct, List<Map<String, Object>> asstAccountChange, List<AcctCalculaterExt> acctCalculaterExts, boolean isMultiUnPosted, int changeYear, int changePeriod, boolean isSinglePeriod) {
        String accountid = tempAcct.getAccountItem().startAccount.account.id;
        List<AsstActType> asstActTypeList = this.getAsstActTypeByAsstChange(accountid, asstAccountChange, changeYear, changePeriod);
        AcctStruct acctStruct = tempAcct.getStruct().copy();
        int periodType = AcctUtils.getPeriodType(tempAcct.getBalanceType().getName());
        if (periodType != 2) {
            int startYear = acctStruct.getStartYear();
            int startPeriod = acctStruct.getStartPeriod();
            if ((startYear != changeYear || startPeriod != changePeriod) && --changePeriod == 0) {
                changePeriod = 12;
                --changeYear;
            }
            acctStruct.setEndYear(changeYear);
            acctStruct.setEndPeriod(changePeriod);
        } else if (isSinglePeriod) {
            acctStruct.setStartYear(changeYear);
            acctStruct.setStartPeriod(changePeriod);
        }
        acctStruct.setAccountItem(tempAcct.getAccountItem().getAccountAsstItem().toOldString());
        AcctCalculaterExt acctext = this.newAcctCalculaterExt(acctStruct, tempAcct, asstActTypeList);
        acctCalculaterExts.add(acctext);
    }

    private void changeAsstForAcct(AcctCalculaterExt tempAcct, List<AsstActType> asstActTypeList) {
        if (asstActTypeList != null) {
            HashMap<String, AssistantItemExt> items = new HashMap<String, AssistantItemExt>();
            boolean isclear = true;
            for (AsstActType asstActType : asstActTypeList) {
                AssistantItemExt object = new AssistantItemExt(asstActType.number);
                object.itemType = asstActType;
                items.put(asstActType.number, object);
                tempAcct.getAccountItem().setItemTypes(items);
                AccountExt account = tempAcct.getAccountItem().startAccount;
                ArrayList<AsstActType> itemTypes = account.getItemTypes();
                if (itemTypes == null) {
                    itemTypes = new ArrayList<AsstActType>();
                    account.setItemTypes(itemTypes);
                }
                if (isclear) {
                    itemTypes.clear();
                    isclear = false;
                }
                itemTypes.add(asstActType);
            }
        }
    }

    private void changeBlankAsstForAcct(AcctCalculaterExt tempAcct) {
        HashMap items = new HashMap();
        tempAcct.getAccountItem().setItemTypes(items);
        AccountExt account = tempAcct.getAccountItem().startAccount;
        ArrayList itemTypes = account.getItemTypes();
        if (itemTypes == null) {
            itemTypes = new ArrayList();
            account.setItemTypes(itemTypes);
        }
        itemTypes.clear();
    }

    private void extendAcctByBlankAsstNeedChangePeriod(AcctCalculaterExt tempAcct, List<AcctCalculaterExt> acctCalculaterExts, boolean isMultiUnPosted, int changeYear, int changePeriod, boolean isSinglePeriod) {
        AcctStruct acctStruct = tempAcct.getStruct().copy();
        int periodType = AcctUtils.getPeriodType(tempAcct.getBalanceType().getName());
        if (periodType != 2) {
            if (--changePeriod == 0) {
                changePeriod = 12;
                --changeYear;
            }
            acctStruct.setEndYear(changeYear);
            acctStruct.setEndPeriod(changePeriod);
        } else if (isSinglePeriod) {
            acctStruct.setStartYear(changeYear);
            acctStruct.setStartPeriod(changePeriod);
        }
        acctStruct.setAccountItem(tempAcct.getAccountItem().getAccountAsstItem().toOldString());
        List asstActTypeList = null;
        AcctCalculaterExt acctext = this.newAcctCalculaterExt(acctStruct, tempAcct, asstActTypeList);
        acctCalculaterExts.add(acctext);
    }

    private void extendAcctByBlankAsst(AcctCalculaterExt tempAcct, List<AcctCalculaterExt> acctCalculaterExts, boolean isMultiUnPosted) {
        AcctStruct acctStruct = tempAcct.getStruct().copy();
        int periodType = AcctUtils.getPeriodType(tempAcct.getBalanceType().getName());
        if (isMultiUnPosted && periodType != 2) {
            int acctYear = acctStruct.getStartYear();
            int acctPeriod = acctStruct.getStartPeriod();
            int acctYearEnd = acctStruct.getEndYear();
            int acctPeriodEnd = acctStruct.getEndPeriod();
            if (acctYear == acctYearEnd && acctPeriod == acctPeriodEnd) {
                --acctPeriodEnd;
                if (--acctPeriod == 0) {
                    acctPeriod = 12;
                    acctPeriodEnd = 12;
                    --acctYear;
                    --acctYearEnd;
                }
                acctStruct.setStartYear(acctYear);
                acctStruct.setEndYear(acctYearEnd);
                acctStruct.setStartPeriod(acctPeriod);
                acctStruct.setEndPeriod(acctPeriodEnd);
            }
        }
        acctStruct.setAccountItem(tempAcct.getAccountItem().getAccountAsstItem().toOldString());
        List asstActTypeList = null;
        AcctCalculaterExt acctext = this.newAcctCalculaterExt(acctStruct, tempAcct, asstActTypeList);
        acctCalculaterExts.add(acctext);
    }

    private boolean isMultiUnPosted(AcctCalculaterExt acct, PeriodInfo currentPeriod) throws BOSException {
        int periodType = AcctUtils.getPeriodType(acct.getBalanceType().getName());
        if (!(AcctUtils.isAccrualType(acct.getBalanceType().getName()) || periodType != 2 && periodType != 3)) {
            int endPeriodNumber = -99;
            int endPeriodYear = -99;
            if (periodType == 2) {
                endPeriodNumber = acct.getStruct().getStartPeriod();
                endPeriodYear = acct.getStruct().getStartYear();
            } else if (periodType == 3) {
                endPeriodNumber = acct.getStruct().getEndPeriod();
                endPeriodYear = acct.getStruct().getEndYear();
            }
            if (this.batchQueryService.isMultiUnPosted(acct, currentPeriod, endPeriodYear, endPeriodNumber)) {
                return true;
            }
        }
        return false;
    }

    private boolean isExtendAcctOrNot(AcctCalculaterExt tempAcct, List<Map<String, Object>> asstAccountChange, boolean isMultiUnPosted, int changeYear, int changePeriod) {
        String accountid = tempAcct.getAccountItem().startAccount.account.id;
        List<AsstActType> asstActTypeList = this.getAsstActTypeByAsstChange(accountid, asstAccountChange, changeYear, changePeriod);
        AccountExt account = tempAcct.getAccountItem().startAccount;
        List itemTypes = account.getItemTypes();
        if (itemTypes != null && itemTypes.size() > 0) {
            List asstActTypes = this.removeRepeatItemTypes(itemTypes);
            if (asstActTypeList.size() > asstActTypes.size()) {
                for (AsstActType asst : asstActTypeList) {
                    int size = asstActTypes.size();
                    for (int i = 0; i < size; ++i) {
                        AsstActType tempAsstActType = (AsstActType)asstActTypes.get(i);
                        if (!asst.number.equals(tempAsstActType.number)) continue;
                        return false;
                    }
                }
            } else if (asstActTypeList.size() < asstActTypes.size()) {
                for (AsstActType asst : asstActTypeList) {
                    int size = asstActTypes.size();
                    for (int i = 0; i < size; ++i) {
                        AsstActType tempAsstActType = (AsstActType)asstActTypes.get(i);
                        if (!asst.number.equals(tempAsstActType.number)) continue;
                        return false;
                    }
                }
            }
        } else if (asstActTypeList.size() > 0) {
            return false;
        }
        return true;
    }

    private boolean isExtendAcctOrNotIncludeMultiUnPosted(AcctCalculaterExt tempAcct, List<Map<String, Object>> asstAccountChange, boolean isMultiUnPosted, int changeYear, int changePeriod) {
        String accountid = tempAcct.getAccountItem().startAccount.account.id;
        List<AsstActType> asstActTypeList = this.getAsstActTypeByAsstChange(accountid, asstAccountChange, changeYear, changePeriod);
        if (isMultiUnPosted) {
            AccountExt account = tempAcct.getAccountItem().startAccount;
            List itemTypes = account.getItemTypes();
            if (itemTypes != null && itemTypes.size() > 0) {
                List asstActTypes = this.removeRepeatItemTypes(itemTypes);
                if (asstActTypeList.size() > asstActTypes.size()) {
                    for (AsstActType asst : asstActTypeList) {
                        int size = asstActTypes.size();
                        for (int i = 0; i < size; ++i) {
                            AsstActType tempAsstActType = (AsstActType)asstActTypes.get(i);
                            if (!asst.number.equals(tempAsstActType.number)) continue;
                            return false;
                        }
                    }
                } else if (asstActTypeList.size() < asstActTypes.size()) {
                    for (AsstActType asst : asstActTypeList) {
                        int size = asstActTypes.size();
                        for (int i = 0; i < size; ++i) {
                            AsstActType tempAsstActType = (AsstActType)asstActTypes.get(i);
                            if (!asst.number.equals(tempAsstActType.number)) continue;
                            return false;
                        }
                    }
                }
            } else if (asstActTypeList.size() > 0) {
                return false;
            }
        }
        return true;
    }

    private boolean isChangeAsstActTypeOrNot(AcctCalculaterExt tempAcct, List<Map<String, Object>> asstAccountChange, int changeYear, int changePeriod) {
        String accountid = tempAcct.getAccountItem().startAccount.account.id;
        List<AsstActType> asstActTypeList = this.getAsstActTypeByAsstChange(accountid, asstAccountChange, changeYear, changePeriod);
        AccountExt account = tempAcct.getAccountItem().startAccount;
        List itemTypes = account.getItemTypes();
        if (itemTypes != null && itemTypes.size() > 0) {
            List asstActTypes = this.removeRepeatItemTypes(itemTypes);
            if (asstActTypeList.size() < asstActTypes.size()) {
                for (AsstActType asst : asstActTypeList) {
                    int size = asstActTypes.size();
                    for (int i = 0; i < size; ++i) {
                        AsstActType tempAsstActType = (AsstActType)asstActTypes.get(i);
                        if (!asst.number.equals(tempAsstActType.number)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private List removeRepeatItemTypes(List<AsstActType> itemTypes) {
        ArrayList<AsstActType> asstActTypes = new ArrayList<AsstActType>();
        int size = itemTypes.size();
        for (int i = 0; i < size; ++i) {
            AsstActType tempAsstActType = itemTypes.get(i);
            if (asstActTypes.contains(tempAsstActType)) continue;
            asstActTypes.add(tempAsstActType);
        }
        return asstActTypes;
    }

    private AsstAccountChangeCollection getAsstAccountChangeCollection(AsstAccountChangeCollection accountByAsstAccountChanges, AcctCalculaterExt tempAcct) {
        ArrayList<AsstAccountChangeInfo> changes = new ArrayList<AsstAccountChangeInfo>();
        String accountid = tempAcct.getAccountItem().startAccount.account.id;
        for (AsstAccountChangeInfo info : accountByAsstAccountChanges) {
            if (!info.getAccount().getId().toString().equals(accountid)) continue;
            changes.add(info);
        }
        if (changes.size() == 1) {
            AsstAccountChangeCollection coll = new AsstAccountChangeCollection();
            coll.add((AsstAccountChangeInfo)changes.get(0));
            return coll;
        }
        if (changes.size() > 1) {
            if (this.isAccumulateType(tempAcct)) {
                return this.getChangeInfosToAccumulateType(tempAcct, changes);
            }
            return this.getAsstAccountChangeCollection(changes, tempAcct);
        }
        return null;
    }

    private AsstAccountChangeCollection getChangeInfosToAccumulateType(AcctCalculaterExt tempAcct, List<AsstAccountChangeInfo> changes) {
        AsstAccountChangeCollection asstAccountChanges = new AsstAccountChangeCollection();
        int acctYearStart = tempAcct.getStruct().getStartYear();
        int acctPeriodStart = tempAcct.getStruct().getStartPeriod();
        int acctYearEnd = tempAcct.getStruct().getEndYear();
        int acctPeriodEnd = tempAcct.getStruct().getEndPeriod();
        if (acctYearStart == acctYearEnd && acctPeriodStart == acctPeriodEnd) {
            int changePeriod;
            int changeYear;
            AsstAccountChangeInfo changeInfo = null;
            for (AsstAccountChangeInfo change : changes) {
                changeYear = change.getPeriod().getPeriodYear();
                changePeriod = change.getPeriod().getPeriodNumber();
                if (changeYear == acctYearEnd && acctPeriodEnd < changePeriod) {
                    if (changeInfo != null) {
                        int changeInfoYear = changeInfo.getPeriod().getPeriodYear();
                        int changeInfoPeriod = changeInfo.getPeriod().getPeriodNumber();
                        if (changeInfoYear != changeYear || changeInfoPeriod >= changePeriod) continue;
                        changeInfo = change;
                        continue;
                    }
                    changeInfo = change;
                    continue;
                }
                changeInfo = null;
                break;
            }
            if (changeInfo != null) {
                asstAccountChanges.add(changeInfo);
                return asstAccountChanges;
            }
            changeInfo = null;
            for (AsstAccountChangeInfo change : changes) {
                changeYear = change.getPeriod().getPeriodYear();
                changePeriod = change.getPeriod().getPeriodNumber();
                if (changeYear != acctYearEnd || acctPeriodEnd < changePeriod) continue;
                asstAccountChanges.add(change);
            }
        }
        return asstAccountChanges;
    }

    private AsstAccountChangeCollection getAsstAccountChangeCollection(List<AsstAccountChangeInfo> changes, AcctCalculaterExt tempAcct) {
        AsstAccountChangeCollection asstAccountChanges = new AsstAccountChangeCollection();
        int acctYearStart = tempAcct.getStruct().getStartYear();
        int acctPeriodStart = tempAcct.getStruct().getStartPeriod();
        int acctYearEnd = tempAcct.getStruct().getEndYear();
        int acctPeriodEnd = tempAcct.getStruct().getEndPeriod();
        if (acctYearStart == acctYearEnd && acctPeriodStart == acctPeriodEnd) {
            int changePeriod;
            int changeYear;
            for (AsstAccountChangeInfo change : changes) {
                changeYear = change.getPeriod().getPeriodYear();
                changePeriod = change.getPeriod().getPeriodNumber();
                if (changeYear != acctYearEnd || acctPeriodEnd != changePeriod) continue;
                asstAccountChanges.add(change);
                return asstAccountChanges;
            }
            for (AsstAccountChangeInfo change : changes) {
                changeYear = change.getPeriod().getPeriodYear();
                changePeriod = change.getPeriod().getPeriodNumber();
                if (acctYearEnd >= changeYear && (changeYear != acctYearEnd || acctPeriodEnd >= changePeriod)) continue;
                asstAccountChanges.add(change);
                return asstAccountChanges;
            }
            asstAccountChanges.add(changes.get(changes.size() - 1));
        } else if (acctYearStart == acctYearEnd && acctPeriodStart < acctPeriodEnd) {
            for (AsstAccountChangeInfo change : changes) {
                int changeYear = change.getPeriod().getPeriodYear();
                int changePeriod = change.getPeriod().getPeriodNumber();
                if (changeYear != acctYearEnd || !(acctPeriodStart < changePeriod && changePeriod < acctPeriodEnd || acctPeriodStart == changePeriod && changePeriod < acctPeriodEnd || acctPeriodStart < changePeriod && changePeriod == acctPeriodEnd) && acctPeriodEnd >= changePeriod) continue;
                asstAccountChanges.add(change);
            }
            return asstAccountChanges;
        }
        return asstAccountChanges;
    }

    public List<AcctCalculaterExt> acctsInAsstAccountChange(List<AcctCalculaterExt> formulas, AsstAccountChangeCollection accountByAsstAccountChanges) throws EASBizException, BOSException {
        Iterator<AcctCalculaterExt> it = formulas.iterator();
        ArrayList<AcctCalculaterExt> acctCalculaterExts = new ArrayList<AcctCalculaterExt>();
        List<Map<String, Object>> asstAccountBeforeChange = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> asstAccountAfterChange = new ArrayList<Map<String, Object>>();
        while (it.hasNext()) {
            AcctCalculaterExt tempAcct = it.next();
            if (tempAcct.getOrgType().equals((Object)OrgType.ProfitCenter) || tempAcct.isException()) continue;
            String accountid = tempAcct.getAccountItem().startAccount.account.id;
            AsstAccountChangeCollection asstAccountChanges = this.getAsstAccountChangeCollection(accountByAsstAccountChanges, tempAcct);
            if (asstAccountChanges == null) continue;
            for (AsstAccountChangeInfo info : asstAccountChanges) {
                int changeYear = info.getPeriod().getPeriodYear();
                int changePeriod = info.getPeriod().getPeriodNumber();
                if (!info.getAccount().getId().toString().equals(accountid)) continue;
                int acctYear = tempAcct.getStruct().getStartYear();
                int acctPeriod = tempAcct.getStruct().getStartPeriod();
                int acctYearEnd = tempAcct.getStruct().getEndYear();
                int acctPeriodEnd = tempAcct.getStruct().getEndPeriod();
                PeriodInfo periodInfo = this.batchQueryService.getCurrentPeriodInfo(tempAcct.getCompany());
                int currentYear = periodInfo.getPeriodYear();
                int currentPeriod = periodInfo.getPeriodNumber();
                PeriodInfo startPeriodInfo = this.getStartPeriodInfo(tempAcct.getCompany());
                int startYear = startPeriodInfo.getPeriodYear();
                int startPeriod = startPeriodInfo.getPeriodNumber();
                boolean isMultiUnPosted = this.isMultiUnPosted(tempAcct, periodInfo);
                if (acctYear == acctYearEnd && acctPeriod == acctPeriodEnd) {
                    if (this.isAccumulateType(tempAcct)) {
                        if (acctYear > changeYear || changeYear == acctYear && acctPeriod >= changePeriod) {
                            if (info.getAfter() != null) {
                                if (asstAccountBeforeChange.size() == 0) {
                                    asstAccountBeforeChange = this.getAsstAccountChange(formulas, true);
                                }
                                if (info.getBefore() == null) {
                                    this.changeBlankAsstForAcct(tempAcct);
                                    continue;
                                }
                                if (asstAccountAfterChange.size() == 0) {
                                    asstAccountAfterChange = this.getAsstAccountChange(formulas, false);
                                }
                                this.changeAsstForAccumulateType(tempAcct, asstAccountChanges, asstAccountBeforeChange, asstAccountAfterChange, changeYear, changePeriod, acctCalculaterExts);
                                continue;
                            }
                            asstAccountAfterChange = this.changeAfterAsstType(formulas, asstAccountAfterChange, tempAcct, info, changeYear, changePeriod);
                            continue;
                        }
                        asstAccountBeforeChange = this.changeBeforeAsstType(formulas, asstAccountBeforeChange, tempAcct, info, changeYear, changePeriod);
                        continue;
                    }
                    if (!this.isAccumulateType(tempAcct) && changeYear == acctYear && changePeriod == acctPeriod) {
                        if (isMultiUnPosted) {
                            if (asstAccountBeforeChange.size() == 0) {
                                asstAccountBeforeChange = this.getAsstAccountChange(formulas, true);
                            }
                            if (info.getBefore() != null) {
                                if (this.isExtendAcctOrNotIncludeMultiUnPosted(tempAcct, asstAccountBeforeChange, isMultiUnPosted, changeYear, changePeriod)) {
                                    this.extendAcctByChangeAsst(tempAcct, asstAccountBeforeChange, acctCalculaterExts, isMultiUnPosted, changeYear, changePeriod);
                                    continue;
                                }
                                if (!this.isChangeAsstActTypeOrNot(tempAcct, asstAccountBeforeChange, changeYear, changePeriod)) continue;
                                this.changeAsstForAcct(tempAcct, asstAccountBeforeChange, changeYear, changePeriod);
                                continue;
                            }
                            AccountExt account = tempAcct.getAccountItem().startAccount;
                            List itemTypes = account.getItemTypes();
                            if (itemTypes == null || itemTypes.size() <= 0) continue;
                            this.extendAcctByBlankAsst(tempAcct, acctCalculaterExts, isMultiUnPosted);
                            continue;
                        }
                        if (tempAcct.getBalanceType().equals((Object)BalanceTypeEnum.JC) || tempAcct.getBalanceType().equals((Object)BalanceTypeEnum.DC) || tempAcct.getBalanceType().equals((Object)BalanceTypeEnum.C)) {
                            if (startYear == changeYear && startPeriod == changePeriod) {
                                asstAccountAfterChange = this.changeAfterAsstType(formulas, asstAccountAfterChange, tempAcct, info, changeYear, changePeriod);
                                continue;
                            }
                            asstAccountBeforeChange = this.changeBeforeAsstType(formulas, asstAccountBeforeChange, tempAcct, info, changeYear, changePeriod);
                            continue;
                        }
                        asstAccountAfterChange = this.changeAfterAsstType(formulas, asstAccountAfterChange, tempAcct, info, changeYear, changePeriod);
                        continue;
                    }
                    if (!this.isAccumulateType(tempAcct) && (acctYear < changeYear || acctYear == changeYear && acctPeriod < changePeriod)) {
                        if ((tempAcct.getBalanceType().equals((Object)BalanceTypeEnum.JC) || tempAcct.getBalanceType().equals((Object)BalanceTypeEnum.DC) || tempAcct.getBalanceType().equals((Object)BalanceTypeEnum.C)) && startYear == changeYear && startPeriod == changePeriod) {
                            asstAccountAfterChange = this.changeAfterAsstType(formulas, asstAccountAfterChange, tempAcct, info, changeYear, changePeriod);
                            continue;
                        }
                        asstAccountBeforeChange = this.changeBeforeAsstType(formulas, asstAccountBeforeChange, tempAcct, info, changeYear, changePeriod);
                        continue;
                    }
                    if (this.isAccumulateType(tempAcct) || changeYear != acctYear || acctPeriod <= changePeriod || !isMultiUnPosted || (currentYear != changeYear || currentPeriod >= changePeriod) && currentYear >= changeYear) continue;
                    if (asstAccountBeforeChange.size() == 0) {
                        asstAccountBeforeChange = this.getAsstAccountChange(formulas, true);
                    }
                    boolean isSinglePeriod = true;
                    if (info.getBefore() != null) {
                        if (this.isExtendAcctOrNot(tempAcct, asstAccountBeforeChange, isMultiUnPosted, changeYear, changePeriod)) {
                            this.extendAcctByChangeAsstNeedChangePeriod(tempAcct, asstAccountBeforeChange, acctCalculaterExts, isMultiUnPosted, changeYear, changePeriod, isSinglePeriod);
                            continue;
                        }
                        if (!this.isChangeAsstActTypeOrNot(tempAcct, asstAccountBeforeChange, changeYear, changePeriod)) continue;
                        this.changeAsstForAcct(tempAcct, asstAccountBeforeChange, changeYear, changePeriod);
                        continue;
                    }
                    this.extendAcctByBlankAsstNeedChangePeriod(tempAcct, acctCalculaterExts, isMultiUnPosted, changeYear, changePeriod, isSinglePeriod);
                    continue;
                }
                if (acctYear >= acctYearEnd && (acctYear != acctYearEnd || acctPeriod >= acctPeriodEnd)) continue;
                if (acctYearEnd < changeYear || acctYearEnd == changeYear && acctPeriodEnd < changePeriod) {
                    asstAccountBeforeChange = this.changeBeforeAsstType(formulas, asstAccountBeforeChange, tempAcct, info, changeYear, changePeriod);
                    continue;
                }
                if ((acctYear >= changeYear || changeYear >= acctYearEnd) && (acctYear != changeYear || acctPeriod > changePeriod || acctYearEnd != changeYear || changePeriod > acctPeriodEnd) || currentYear == changeYear && changePeriod <= currentPeriod || changeYear < currentYear) continue;
                boolean isSinglePeriod = false;
                if (info.getBefore() != null) {
                    if (asstAccountBeforeChange.size() == 0) {
                        asstAccountBeforeChange = this.getAsstAccountChange(formulas, true);
                    }
                    if (!this.isExtendAcctOrNot(tempAcct, asstAccountBeforeChange, isMultiUnPosted, changeYear, changePeriod)) continue;
                    this.extendAcctByChangeAsstNeedChangePeriod(tempAcct, asstAccountBeforeChange, acctCalculaterExts, isMultiUnPosted, changeYear, changePeriod, isSinglePeriod);
                    continue;
                }
                this.extendAcctByBlankAsstNeedChangePeriod(tempAcct, acctCalculaterExts, isMultiUnPosted, changeYear, changePeriod, isSinglePeriod);
            }
        }
        if (acctCalculaterExts.size() > 0) {
            formulas.addAll(acctCalculaterExts);
        }
        return formulas;
    }

    private boolean isAccumulateType(AcctCalculaterExt tempAcct) {
        return tempAcct.getBalanceType().equals((Object)BalanceTypeEnum.JL) || tempAcct.getBalanceType().equals((Object)BalanceTypeEnum.DL) || tempAcct.getBalanceType().equals((Object)BalanceTypeEnum.SL);
    }

    private List<Map<String, Object>> changeBeforeAsstType(List<AcctCalculaterExt> formulas, List<Map<String, Object>> asstAccountBeforeChange, AcctCalculaterExt tempAcct, AsstAccountChangeInfo info, int changeYear, int changePeriod) {
        if (info.getBefore() != null) {
            if (asstAccountBeforeChange.size() == 0) {
                asstAccountBeforeChange = this.getAsstAccountChange(formulas, true);
            }
            this.changeAsstForAcct(tempAcct, asstAccountBeforeChange, changeYear, changePeriod);
        } else {
            this.changeBlankAsstForAcct(tempAcct);
        }
        return asstAccountBeforeChange;
    }

    private List<Map<String, Object>> changeAfterAsstType(List<AcctCalculaterExt> formulas, List<Map<String, Object>> asstAccountAfterChange, AcctCalculaterExt tempAcct, AsstAccountChangeInfo info, int changeYear, int changePeriod) {
        if (info.getAfter() != null) {
            if (asstAccountAfterChange.size() == 0) {
                asstAccountAfterChange = this.getAsstAccountChange(formulas, false);
            }
            this.changeAsstForAcct(tempAcct, asstAccountAfterChange, changeYear, changePeriod);
        } else {
            this.changeBlankAsstForAcct(tempAcct);
        }
        return asstAccountAfterChange;
    }

    private List<Map<String, Object>> getAsstAccountChange(List<AcctCalculaterExt> formulas, boolean beforeChange) {
        Iterator<AcctCalculaterExt> it = formulas.iterator();
        ArrayList<String> accountidList = new ArrayList<String>();
        ArrayList<Map<String, Object>> asstAccountChanges = new ArrayList<Map<String, Object>>();
        while (it.hasNext()) {
            AcctCalculaterExt tempAcct = it.next();
            if ((tempAcct.isSelectSheetParam() || this.isGroupByAccount || !AcctUtils.isJDType(tempAcct.getBalanceType().getName())) && (!tempAcct.getIsIncludeLeafAsstItem() && !tempAcct.getIsIncludeSubAsstItem() || !tempAcct.getAccountItem().isDetailAccount()) || tempAcct.getAccountItem().hasItem() || !tempAcct.getAccountItem().isSingleAccount()) continue;
            accountidList.add(tempAcct.getAccountItem().startAccount.account.id);
        }
        String accountids = CslRptUtil.changeIdList2String(accountidList);
        String join = "INNER JOIN T_BD_AsstAccount asstAccount ON asstAccountChange.FAfterID = asstAccount.FID \n";
        if (beforeChange) {
            join = "INNER JOIN T_BD_AsstAccount asstAccount ON asstAccountChange.FBeforeid = asstAccount.FID \n";
        }
        String sql = "SELECT asstAccountChange.FAccountID FAccountID,period.FPeriodYear periodYear,period.FPeriodNumber periodNumber,asstActType.FNumber FNumber,asstActType.FRealtionDataObject FTableName,               \nasstActType.FMappingFieldName FFieldName,asstActType.FGLAsstActTypeGrpID FGlAsstActTypeGrpID ,asstActType.FIsforcompany IsForcompany,           \nasstActType.FGroupTableName FGroupTableName,asstActType.FGroupMappingFieldName FGroupMappingFieldName ,asstActType.FUseLongNumber useLongNumber \nFROM T_BD_AsstAccountChange asstAccountChange \n" + join + "INNER JOIN T_BD_AsstActGroupDetail rel ON asstAccount.FID = rel.FAsstAccountID                          \nINNER JOIN T_BD_AsstActType asstActType ON asstActType.FID = rel.FAsstActTypeID                         \nINNER JOIN T_BD_Period period ON asstAccountChange.FPeriodID = period.Fid \nWHERE asstAccountChange.FAccountID in (" + accountids + ") \n";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rowSet.next()) {
                String accountid = rowSet.getString("FAccountID");
                int year = rowSet.getInt("periodYear");
                int period = rowSet.getInt("periodNumber");
                AsstActType asstActType = new AsstActType();
                asstActType.mappingFieldName = rowSet.getString("FFieldName");
                asstActType.number = rowSet.getString("FNumber");
                asstActType.realtionDataObject = rowSet.getString("FTableName");
                asstActType.glAsstActTypeGrpID = rowSet.getString("FGlAsstActTypeGrpID");
                asstActType.groupTableName = rowSet.getString("FGroupTableName");
                asstActType.groupMappingFieldName = rowSet.getString("FGroupMappingFieldName");
                asstActType.useLongNumber = rowSet.getBoolean("useLongNumber");
                AsstAccountChangeNewInfo asstAccountChangeNewInfo = new AsstAccountChangeNewInfo();
                asstAccountChangeNewInfo.setAccountid(accountid);
                asstAccountChangeNewInfo.setYear(year);
                asstAccountChangeNewInfo.setPeriod(period);
                asstAccountChangeNewInfo.setAsstActType(asstActType);
                HashMap<String, AsstAccountChangeNewInfo> map = new HashMap<String, AsstAccountChangeNewInfo>();
                if (asstAccountChanges.size() > 0) {
                    for (Map map2 : asstAccountChanges) {
                        if (map2.containsKey(accountid)) {
                            if (map2.get(accountid) instanceof AsstAccountChangeNewInfo) {
                                AsstAccountChangeNewInfo info = (AsstAccountChangeNewInfo)map2.get(accountid);
                                int year1 = info.getYear();
                                int period1 = info.getPeriod();
                                if (year == year1 && period == period1) {
                                    ArrayList<AsstAccountChangeNewInfo> moreThanOneAsstActType = new ArrayList<AsstAccountChangeNewInfo>();
                                    moreThanOneAsstActType.add(info);
                                    moreThanOneAsstActType.add(asstAccountChangeNewInfo);
                                    map2.put(accountid, moreThanOneAsstActType);
                                    continue;
                                }
                                map.put(accountid, asstAccountChangeNewInfo);
                                continue;
                            }
                            if (!(map2.get(accountid) instanceof List)) continue;
                            List moreThanOneAsstActType = (List)map2.get(accountid);
                            AsstAccountChangeNewInfo info = (AsstAccountChangeNewInfo)moreThanOneAsstActType.get(0);
                            int year1 = info.getYear();
                            int period1 = info.getPeriod();
                            if (year == year1 && period == period1) {
                                moreThanOneAsstActType.add(asstAccountChangeNewInfo);
                                map2.put(accountid, moreThanOneAsstActType);
                                continue;
                            }
                            map.put(accountid, asstAccountChangeNewInfo);
                            continue;
                        }
                        map.put(accountid, asstAccountChangeNewInfo);
                    }
                    asstAccountChanges.add(map);
                    continue;
                }
                map.put(accountid, asstAccountChangeNewInfo);
                asstAccountChanges.add(map);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            for (int i = 0; i < formulas.size(); ++i) {
                AcctCalculaterExt acct = formulas.get(i);
                acct.setACCTValue(ex);
            }
        }
        return asstAccountChanges;
    }

    private AcctCalculaterExt newAcctCalculaterExt(AcctStruct acctStruct, AcctCalculaterExt acctExt, List asstActTypeList) {
        HashMap items;
        AcctCalculaterExt expandAcctExt = new AcctCalculaterExt(acctStruct, acctExt.getStruct().getBackFiller());
        boolean isclear = true;
        AccountExt accountext = null;
        try {
            expandAcctExt.getAccountItem().parseAcctItem(acctStruct.getAccountItem());
            accountext = acctExt.getAccountItem().startAccount.clone();
        }
        catch (ReportException ex) {
            expandAcctExt.setACCTValue((Object)ex);
        }
        catch (ParseException ex) {
            expandAcctExt.setACCTValue((Object)new ReportException(ReportException.ACCOUNT_PARSE_ERROR));
        }
        expandAcctExt.getAccountItem().getItemTypes().clear();
        if (asstActTypeList != null) {
            items = new HashMap();
            for (AsstActType asstActType : asstActTypeList) {
                if (accountext == null) continue;
                ArrayList<AsstActType> itemTypes = accountext.getItemTypes();
                if (itemTypes == null) {
                    itemTypes = new ArrayList<AsstActType>();
                    accountext.setItemTypes(itemTypes);
                }
                if (isclear) {
                    itemTypes.clear();
                    isclear = false;
                }
                itemTypes.add(asstActType);
            }
        } else {
            items = new HashMap();
            expandAcctExt.getAccountItem().setItemTypes(items);
            if (accountext != null) {
                ArrayList itemTypes = accountext.getItemTypes();
                if (itemTypes == null) {
                    itemTypes = new ArrayList();
                    accountext.setItemTypes(itemTypes);
                }
                itemTypes.clear();
            }
        }
        expandAcctExt.getAccountItem().startAccount = accountext;
        expandAcctExt.getAccountItem().endAccount = accountext;
        expandAcctExt.setItemHasWildcar(acctExt.isItemHasWildcar());
        expandAcctExt.setCurrency(acctExt.getCurrency());
        expandAcctExt.setCompany(acctExt.getCompany());
        expandAcctExt.setAcctBatchQueryService(acctExt.getAcctBatchQueryService());
        expandAcctExt.setContext(acctExt.getContext());
        expandAcctExt.setAccountTable(acctExt.getAccountTable());
        expandAcctExt.setCorrectAccountTable(acctExt.isCorrectAccountTable());
        return expandAcctExt;
    }

    private PeriodInfo getStartPeriodInfo(CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        String companyID = companyOrgUnitInfo.getId().toString();
        PeriodInfo period = (PeriodInfo)this.currentPeriodCache.get(companyID);
        if (period == null) {
            boolean isBizUnit = companyOrgUnitInfo.isIsBizUnit();
            period = companyOrgUnitInfo.isIsProfitOrgUnit() && companyOrgUnitInfo.get("DELEGATED_COMPANY_ID") instanceof String ? (isBizUnit ? PcaUtils.getStartPeriod((Context)this.ctx, (String)companyID) : AcctChangeAccountAsstActType.getSubCompanyMinStartPeriod(this.ctx, companyOrgUnitInfo)) : (isBizUnit ? GlUtils.getStartPeriod((Context)this.ctx, (String)companyID) : AcctChangeAccountAsstActType.getSubCompanyMinStartPeriod(this.ctx, companyOrgUnitInfo));
            this.currentPeriodCache.put(companyID, period);
        }
        return period;
    }

    private static PeriodInfo getSubCompanyMinStartPeriod(Context ctx, CompanyOrgUnitInfo comapny) throws BOSException, EASBizException {
        String join = " INNER JOIN T_ORG_COMPANY company ON ctrol.FCompanyID = company.FID \n";
        Integer name = new Integer(SystemEnum.GENERALLEDGER.getValue());
        if (comapny.isIsProfitOrgUnit()) {
            join = " INNER JOIN T_ORG_PROFITCENTER company ON ctrol.FProfitCenterID = company.FID \n";
            name = new Integer(1006);
        }
        StringBuffer kqlBuffer = new StringBuffer();
        kqlBuffer.append("SELECT period.FID FID,period.FNumber FNumber,period.FperiodYear periodYear,period.FperiodNumber periodNumber \n");
        kqlBuffer.append(" FROM T_BD_SYSTEMSTATUSCTROL ctrol INNER JOIN T_BD_SYSTEMSTATUS status ON ctrol.FSystemStatusID = status.FID               \n");
        kqlBuffer.append(" INNER JOIN T_BD_PERIOD period ON ctrol.FStartPeriodID = period.FID                                                 \n");
        kqlBuffer.append(join);
        kqlBuffer.append(" WHERE status.FName = ? AND company.FLongNumber like ? AND company.FIsBizUnit = 1 AND ctrol.FIsStart = 1 ORDER BY period.FNumber");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(name);
        params.add(comapny.getLongNumber() + "!%");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)kqlBuffer.toString(), (Object[])params.toArray());
        PeriodInfo periodInfo = null;
        try {
            if (rs.next()) {
                periodInfo = new PeriodInfo();
                periodInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                periodInfo.setNumber(rs.getInt("FNumber"));
                periodInfo.setPeriodYear(rs.getInt("periodYear"));
                periodInfo.setPeriodNumber(rs.getInt("periodNumber"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (periodInfo == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"23_AcctUtils", (Locale)ctx.getOriginLocale())});
        }
        return periodInfo;
    }
}

