/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.CompanyQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.ProfitCenterQuerySolution;
import java.sql.Connection;
import java.util.Map;
import org.apache.log4j.Logger;

public class CompanyQuerySorter {
    private static final Logger logger = Logger.getLogger(CompanyQuerySorter.class);
    protected Connection _conn;
    protected Context ctx;
    private Map companyCache = null;
    private CompanyQuerySolution companyQuery;
    private ProfitCenterQuerySolution delegateCompanyQuery;

    public CompanyQuerySorter(Context ctx, Connection _conn) {
        this.ctx = ctx;
        this._conn = _conn;
    }

    public void add(String compNumber, AcctCalculaterExt acct) throws Exception {
        if (OrgType.Company.equals((Object)acct.getStruct().getOrgType())) {
            if (this.companyQuery == null) {
                this.companyQuery = new CompanyQuerySolution(this._conn);
            }
            this.companyQuery.add(compNumber, acct);
            return;
        }
        if (OrgType.ProfitCenter.equals((Object)acct.getStruct().getOrgType())) {
            if (this.delegateCompanyQuery == null) {
                this.delegateCompanyQuery = new ProfitCenterQuerySolution(this._conn);
            }
            this.delegateCompanyQuery.add(compNumber, acct);
            return;
        }
    }

    public void exec() throws Exception {
        if (this.companyQuery != null) {
            this.companyQuery.setCompanyCache(this.companyCache);
            this.companyQuery.exec();
        }
        if (this.delegateCompanyQuery != null) {
            this.delegateCompanyQuery.setCompanyCache(this.companyCache);
            this.delegateCompanyQuery.exec();
            this.delegateCompanyQuery.handleVirutalProfitCenter(this.ctx);
        }
    }

    public void setOrgCache(Map companyCache) {
        this.companyCache = companyCache;
    }
}

