/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.batchquery.IObjectBulider;
import com.kingdee.eas.fi.rpt.batchquery.IQueryObject;
import com.kingdee.eas.fi.rpt.batchquery.Solution;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectField;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectFieldCollection;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItem;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItems;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

public class CurrencyQuerySolution
extends Solution {
    private Map currencyCache = null;

    public CurrencyQuerySolution(Connection _conn) {
        super(_conn);
    }

    @Override
    public WhereItems configStaticWherePart() {
        return null;
    }

    @Override
    public String configFromPart() {
        return "T_BD_Currency";
    }

    @Override
    public boolean configAutoItemIsNeedGroupBy() {
        return false;
    }

    @Override
    public IObjectBulider configDefaultObjectBuilder() {
        return new ObjectBulider();
    }

    public void add(String currencyNumber, AcctCalculaterExt acct) throws Exception {
        this.configQueryObjectToSolution(new Currency(acct, currencyNumber));
    }

    @Override
    public void afterExec() throws SQLException, Exception {
        this.rm.clearResultHouders();
        this.getQueryManager().getExportResultManager().clearFilterMap();
        this.sql.getWherePart().getAutoPartList().clear();
    }

    public void setCurrencyCache(Map currencyCache) {
        this.currencyCache = currencyCache;
    }

    class Currency
    extends IQueryObject {
        private AcctCalculaterExt acctExt;
        private String Number;

        public Currency(AcctCalculaterExt acct, String currencyNumber) {
            this.acctExt = acct;
            this.Number = currencyNumber;
        }

        @Override
        public WhereItems configWhereItems() {
            WhereItems w = new WhereItems();
            w.addItem(new WhereItem("FNumber", this.Number));
            return w;
        }

        @Override
        public SelectFieldCollection configSelectFields() {
            SelectFieldCollection sc = new SelectFieldCollection();
            sc.addSelectField(new SelectField("FID", "FID"));
            sc.addSelectField(new SelectField("FNumber", "FNumber"));
            sc.addSelectField(new SelectField("FPrecision", "FPrecision"));
            return sc;
        }

        @Override
        public void fillValueObject(Object value) {
            CurrencyInfo currency = (CurrencyInfo)value;
            CurrencyInfo currencyClone = new CurrencyInfo();
            currencyClone.setId(currency.getId());
            currencyClone.setNumber(currency.getNumber());
            currencyClone.setPrecision(currency.getPrecision());
            BigDecimal dpv = new BigDecimal("0");
            currencyClone.put("_DPV", (Object)dpv.setScale(currency.getPrecision(), 4));
            if (this.acctExt.getCompany() != null && (((CurrencyInfo)value).getNumber().equals("GLC") || ((CurrencyInfo)value).getNumber().equals("GRC"))) {
                Integer p1;
                if (currencyClone.getNumber().equals("GLC")) {
                    if (this.acctExt.getCompany().get("GLC") != null && (p1 = (Integer)this.acctExt.getCompany().get("GLC")) != null) {
                        currencyClone.setPrecision(p1.intValue());
                        BigDecimal _DPV = new BigDecimal("0");
                        currencyClone.put("_DPV", (Object)_DPV.setScale(currencyClone.getPrecision(), 4));
                    }
                } else {
                    p1 = (Integer)this.acctExt.getCompany().get("GRC");
                    if (p1 != null) {
                        currencyClone.setPrecision(p1.intValue());
                        BigDecimal _DPV = new BigDecimal("0");
                        currencyClone.put("_DPV", (Object)_DPV.setScale(currencyClone.getPrecision(), 4));
                    }
                }
            }
            this.acctExt.setCurrency(currencyClone);
            String cacheKey = null;
            cacheKey = this.acctExt.getCompany() != null && (this.acctExt.getCurrency().getNumber().equalsIgnoreCase("GLC") || this.acctExt.getCurrency().getNumber().equalsIgnoreCase("GRC")) ? this.acctExt.getCompany().getNumber() + "|" + this.acctExt.getCurrency().getNumber().toUpperCase() : this.acctExt.getCurrency().getNumber().toUpperCase();
            if (CurrencyQuerySolution.this.currencyCache != null && !CurrencyQuerySolution.this.currencyCache.containsKey(cacheKey)) {
                CurrencyQuerySolution.this.currencyCache.put(cacheKey, this.acctExt.getCurrency());
            }
        }

        @Override
        public void fillValueList(Object[] value) {
        }
    }

    class ObjectBulider
    implements IObjectBulider {
        ObjectBulider() {
        }

        @Override
        public Object bulider(Object[] value) throws Exception {
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)value[0].toString()));
            currency.setNumber(value[1].toString());
            currency.setPrecision(Integer.parseInt(value[2].toString()));
            BigDecimal _DPV = new BigDecimal("0");
            currency.put("_DPV", (Object)_DPV.setScale(currency.getPrecision(), 4));
            return currency;
        }

        @Override
        public String[] getOrderedSelectedFields() {
            return new String[]{"FID", "FNumber", "FPrecision"};
        }
    }
}

