/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.eas.fi.rpt.app.AccountExt;
import com.kingdee.eas.fi.rpt.app.AccountItemExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ItemQueryByAccount {
    private static final String sql = "SELECT account.FID FAccountID,asstActType.FNumber FNumber,asstActType.FRealtionDataObject FTableName,               \nasstActType.FMappingFieldName FFieldName,asstActType.FGLAsstActTypeGrpID FGlAsstActTypeGrpID ,asstActType.FIsforcompany IsForcompany,           \nasstActType.FGroupTableName FGroupTableName,asstActType.FGroupMappingFieldName FGroupMappingFieldName ,asstActType.FUseLongNumber useLongNumber \nFROM T_BD_AccountView account INNER JOIN T_BD_AsstAccount asstAccount ON account.FCaa = asstAccount.FID \nINNER JOIN T_BD_AsstActGroupDetail rel ON asstAccount.FID = rel.FAsstAccountID                          \nINNER JOIN T_BD_AsstActType asstActType ON asstActType.FID = rel.FAsstActTypeID                         \nWHERE account.FID IN \n";
    private Map todoQuery;
    private final Connection _conn;
    private static final int PARAM_BATCH_SIZE = 500;

    public ItemQueryByAccount(Connection conn) {
        this._conn = conn;
        this.todoQuery = new HashMap();
    }

    public void add(AccountItemExt acctitem) {
        this.add(acctitem.endAccount);
        this.add(acctitem.startAccount);
    }

    protected void add(AccountExt account) {
        if (account == null || account.account == null || account.account.id == null) {
            return;
        }
        ArrayList<AccountExt> object = (ArrayList<AccountExt>)this.todoQuery.get(account.account.id);
        if (object == null) {
            object = new ArrayList<AccountExt>();
            this.todoQuery.put(account.account.id, object);
        }
        object.add(account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws SQLException {
        if (this.todoQuery.keySet().size() < 1) {
            return;
        }
        Iterator it = this.todoQuery.keySet().iterator();
        int paramCount = 1;
        boolean isFirst = true;
        StringBuffer inKqlBuffer = new StringBuffer();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        ArrayList paramList = new ArrayList();
        try {
            while (it.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    inKqlBuffer.append(',');
                }
                inKqlBuffer.append('?');
                paramList.add(it.next());
                if (++paramCount <= 500 && it.hasNext()) continue;
                StringBuffer kqlBuffer = new StringBuffer();
                kqlBuffer.append(sql);
                kqlBuffer.append('(');
                kqlBuffer.append(inKqlBuffer);
                kqlBuffer.append(')');
                stmt = this._conn.prepareStatement(kqlBuffer.toString());
                for (int i = 0; i < paramList.size(); ++i) {
                    String acctId = (String)paramList.get(i);
                    stmt.setObject(i + 1, acctId);
                }
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    AsstActType asstActType = new AsstActType();
                    asstActType.mappingFieldName = resultSet.getString("FFieldName");
                    asstActType.number = resultSet.getString("FNumber");
                    asstActType.realtionDataObject = resultSet.getString("FTableName");
                    asstActType.glAsstActTypeGrpID = resultSet.getString("FGlAsstActTypeGrpID");
                    asstActType.groupTableName = resultSet.getString("FGroupTableName");
                    asstActType.groupMappingFieldName = resultSet.getString("FGroupMappingFieldName");
                    asstActType.useLongNumber = resultSet.getBoolean("useLongNumber");
                    String acct = resultSet.getString("FAccountID");
                    List lst = (List)this.todoQuery.get(acct);
                    for (int i = 0; i < lst.size(); ++i) {
                        AccountExt account = (AccountExt)lst.get(i);
                        ArrayList<AsstActType> itemTypes = account.getItemTypes();
                        if (itemTypes == null) {
                            itemTypes = new ArrayList<AsstActType>();
                            account.setItemTypes(itemTypes);
                        }
                        itemTypes.add(asstActType);
                    }
                }
                isFirst = true;
                paramCount = 1;
                paramList.clear();
                inKqlBuffer.delete(0, inKqlBuffer.length());
            }
        }
        finally {
            DBUtil.closeResultSet(resultSet);
            DBUtil.closeStatement(stmt);
        }
    }
}

