/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.fi.newrpt.AnalysisReportNewCollection;
import com.kingdee.eas.fi.newrpt.AnalysisReportNewFactory;
import com.kingdee.eas.fi.newrpt.IAnalysisReportNew;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BrefBatchCalculater {
    private static Logger logger = Logger.getLogger((String)BrefBatchCalculater.class.getName());
    private ICalculateContextProvider calCulateContext;
    private Context serverContext;
    private String splitStr = ";;";

    public BrefBatchCalculater(ICalculateContextProvider context, Context serverCtx) {
        this.calCulateContext = context;
        this.serverContext = serverCtx;
    }

    public void execute(SortedParameterArray params) {
        Map<String, List<Bref>> groupMap = this.groupBref(params);
        this.getDataByGroup(groupMap);
        groupMap.clear();
    }

    private void getDataByGroup(Map<String, List<Bref>> groupMap) {
        List<Bref> Brefs = null;
        try {
            AnalysisReportNewCollection coll = null;
            byte[] data = null;
            HashMap<String, Object> fetchDataMap = new HashMap<String, Object>();
            IAnalysisReportNew ianalysisRpt = AnalysisReportNewFactory.getLocalInstance((Context)this.serverContext);
            for (String key : groupMap.keySet()) {
                fetchDataMap.clear();
                Brefs = groupMap.get(key);
                if (Brefs.isEmpty()) continue;
                coll = ianalysisRpt.getAnalysisReportNewCollection("select data where bhkOrgUnit.name='" + key.split(this.splitStr)[0] + "' and year=" + key.split(this.splitStr)[1] + " and isStart=1 and analysisRptType=5");
                if (coll != null && coll.size() > 0) {
                    data = coll.get(0).getData();
                    this.getFetchDataMap(fetchDataMap, Brefs);
                    BookIOUtil.loadSomeCellValues((byte[])data, fetchDataMap);
                    logger.info((Object)("Bref get value:" + fetchDataMap.toString()));
                    this.setValue(fetchDataMap, Brefs);
                    continue;
                }
                this.setException(Brefs, EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"382_BrefBatchCalculater") + key.split(this.splitStr)[0] + EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"383_BrefBatchCalculater"));
            }
            fetchDataMap.clear();
        }
        catch (Exception ex) {
            logger.error((Object)"handle error.", (Throwable)ex);
            this.setException(Brefs, ex.getMessage());
        }
    }

    private void setValue(Map<String, Object> fetchDataMap, List<Bref> Brefs) {
        Object obj = null;
        for (Bref Bref2 : Brefs) {
            obj = fetchDataMap.get(Bref2.getCellAdress());
            if (obj == null || "".equals(obj.toString())) {
                obj = Variant.nullVariant;
            }
            Bref2.param.setValue(obj);
        }
    }

    private void getFetchDataMap(Map<String, Object> fetchDataMap, List<Bref> Brefs) {
        for (Bref Bref2 : Brefs) {
            fetchDataMap.put(Bref2.getCellAdress(), null);
        }
    }

    private void setException(List<Bref> Brefs, String message) {
        for (Bref Bref2 : Brefs) {
            Bref2.isException = true;
            Bref2.param.setValue((Object)new SyntaxErrorException(128L, (Object)message));
        }
    }

    private Map<String, List<Bref>> groupBref(SortedParameterArray params) {
        HashMap<String, List<Bref>> groupBrefMap = new HashMap<String, List<Bref>>();
        Bref bref = null;
        String key = null;
        ArrayList<Bref> Brefs = null;
        for (int i = 0; i < params.size(); ++i) {
            bref = new Bref(params.getParameter(i));
            if (bref.isException) continue;
            key = bref.benchmarkingName + this.splitStr + bref.year;
            Brefs = (ArrayList<Bref>)groupBrefMap.get(key);
            if (Brefs == null) {
                Brefs = new ArrayList<Bref>();
            }
            Brefs.add(bref);
            groupBrefMap.put(key, Brefs);
        }
        return groupBrefMap;
    }

    private class Bref {
        String benchmarkingName = null;
        int year = 0;
        int period = 0;
        String sheetName = null;
        String cellName = null;
        boolean isException = false;
        Parameter param = null;

        public Bref(Parameter param) {
            this.param = param;
            Object[] args = param.getArgs();
            this.initArgs(args);
        }

        private void initArgs(Object[] args) {
            if (args.length != 5) {
                this.isException = true;
                this.param.setValue((Object)new SyntaxErrorException(128L, (Object)"args count is not right."));
            } else {
                this.benchmarkingName = String.valueOf(args[0]);
                this.year = Integer.valueOf(args[1].toString());
                this.period = Integer.valueOf(args[2].toString());
                this.sheetName = String.valueOf(args[3]);
                this.cellName = String.valueOf(args[4]);
                if (StringUtils.isEmpty((String)this.sheetName)) {
                    this.isException = true;
                    this.param.setValue((Object)new SyntaxErrorException(128L, (Object)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"102_SheetNameCantNull")));
                }
                if (StringUtils.isEmpty((String)this.cellName)) {
                    this.isException = true;
                    this.param.setValue((Object)new SyntaxErrorException(128L, (Object)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"103_cellNameCantNull")));
                }
            }
        }

        public String getCellAdress() {
            return (this.sheetName + "!" + this.cellName).toUpperCase();
        }

        public boolean isException() {
            return this.isException;
        }
    }
}

