/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fi.rpt.batch.IInnerChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyFilter {
    private Map[] properties;
    private PropertyComparator comparator;
    private PropertyEqualsComparator equalsComparator;
    private IInnerChecker innerChecker;
    private List propertyList;
    private Map cache;

    public PropertyFilter(List propertyMapList) {
        this.properties = new Map[propertyMapList.size()];
        for (int i = 0; i < this.properties.length; ++i) {
            this.properties[i] = (Map)propertyMapList.get(i);
        }
        this.comparator = new PropertyComparator();
        this.equalsComparator = new PropertyEqualsComparator();
        this.cache = new HashMap();
    }

    public PropertyFilter() {
        this.comparator = new PropertyComparator();
        this.equalsComparator = new PropertyEqualsComparator();
        this.cache = new HashMap();
    }

    public void setPropertyMapList(List propertyMapList) {
        this.cache.clear();
        this.propertyList = propertyMapList;
        this.properties = new Map[propertyMapList.size()];
        for (int i = 0; i < this.properties.length; ++i) {
            this.properties[i] = (Map)propertyMapList.get(i);
        }
    }

    private Map[] sort(Map[] array, String field) {
        Map[] newArray = new Map[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        this.comparator.setCompareField(field);
        Arrays.sort(newArray, this.comparator);
        return newArray;
    }

    public Map[] getPropertyMapByConditions(FilterInfo conditions) {
        Map[] cached = (Map[])this.cache.get(conditions.toString());
        if (cached != null) {
            return cached;
        }
        Map[] result = this.filterEquals(conditions);
        if (result.length == 0) {
            return result;
        }
        int conditionSize = conditions.getFilterItems().size();
        for (int i = 0; i < conditionSize; ++i) {
            String key = conditions.getFilterItems().get(i).getPropertyName();
            if ((result = this.sort(result, key)) == null || result.length == 0) {
                return new Map[0];
            }
            result = this.binarySearch(conditions.getFilterItems().get(i), result);
        }
        this.cache.put(conditions.toString(), result);
        return result;
    }

    private Map[] filterEquals(FilterInfo conditions) {
        HashMap<String, Object> compareValue = new HashMap<String, Object>();
        Iterator iterator = conditions.getFilterItems().iterator();
        while (iterator.hasNext()) {
            FilterItemInfo filterItem = (FilterItemInfo)iterator.next();
            if (!filterItem.getCompareType().equals((Object)CompareType.EQUALS)) continue;
            compareValue.put(filterItem.getPropertyName(), filterItem.getCompareValue());
            iterator.remove();
        }
        this.equalsComparator.setKeys(compareValue.keySet());
        Arrays.sort(this.properties, this.equalsComparator);
        int index = Arrays.binarySearch(this.properties, compareValue, this.equalsComparator);
        ArrayList<Map> resultList = new ArrayList<Map>();
        if (index >= 0) {
            if (this.innerChecker == null || this.innerChecker != null && this.innerChecker.isInnerCheckPassed(this.properties[index])) {
                resultList.add(this.properties[index]);
            }
            for (int left = index - 1; left >= 0; --left) {
                Map leftMap = this.properties[left];
                if (this.equalsComparator.compare(leftMap, compareValue) != 0 || this.innerChecker != null && (this.innerChecker == null || !this.innerChecker.isInnerCheckPassed(leftMap))) continue;
                resultList.add(leftMap);
            }
            for (int right = index + 1; right < this.properties.length; ++right) {
                Map rightMap = this.properties[right];
                if (this.equalsComparator.compare(rightMap, compareValue) != 0 || this.innerChecker != null && (this.innerChecker == null || !this.innerChecker.isInnerCheckPassed(rightMap))) continue;
                resultList.add(rightMap);
            }
        }
        Map[] result = new Map[resultList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Map)resultList.get(i);
        }
        return result;
    }

    private Map[] binarySearch(FilterItemInfo filterItemInfo, Map[] result) {
        String key = filterItemInfo.getPropertyName();
        CompareType compareType = filterItemInfo.getCompareType();
        Object compareValue = filterItemInfo.getCompareValue();
        if (compareType.equals((Object)CompareType.EQUALS)) {
            return this.searchEquals(result, key, compareValue);
        }
        if (compareType.equals((Object)CompareType.EMPTY)) {
            return this.searchEmpty(result, key);
        }
        if (compareType.equals((Object)CompareType.LESS)) {
            return this.searchLess(result, key, compareValue);
        }
        if (compareType.equals((Object)CompareType.LESS_EQUALS)) {
            return this.searchLessEquals(result, key, compareValue);
        }
        if (compareType.equals((Object)CompareType.GREATER)) {
            return this.searchGreater(result, key, compareValue);
        }
        if (compareType.equals((Object)CompareType.GREATER_EQUALS)) {
            return this.searchGreaterEquals(result, key, compareValue);
        }
        return null;
    }

    private Map[] searchLessEquals(Map[] array, String key, Object compareValue) {
        this.comparator.setCompareField(key);
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        tempMap.put(key, compareValue);
        int low = 0;
        int high = array.length - 1;
        int index = -1;
        while (low <= high) {
            int mid = low + high >> 1;
            Map midVal = array[mid];
            int cmp = this.comparator.compare(midVal, tempMap);
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) continue;
            index = mid;
            break;
        }
        ArrayList<Map> resultList = new ArrayList<Map>();
        if (index != -1) {
            resultList.add(array[index]);
            for (int left = index - 1; left >= 0; --left) {
                Map leftMap = array[left];
                Comparable leftValue = (Comparable)leftMap.get(key);
                if (leftValue == null || leftValue.compareTo(compareValue) > 0) continue;
                resultList.add(leftMap);
            }
            for (int right = index + 1; right < array.length; ++right) {
                Map rightMap = array[right];
                Comparable rightValue = (Comparable)rightMap.get(key);
                if (rightValue == null || rightValue.compareTo(compareValue) > 0) continue;
                resultList.add(rightMap);
            }
        }
        Map[] result = new Map[resultList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Map)resultList.get(i);
        }
        return result;
    }

    private Map[] searchLess(Map[] array, String key, Object compareValue) {
        this.comparator.setCompareField(key);
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        tempMap.put(key, compareValue);
        int low = 0;
        int high = array.length - 1;
        int index = -1;
        while (low <= high) {
            int mid = low + high >> 1;
            Map midVal = array[mid];
            int cmp = this.comparator.compare(midVal, tempMap);
            if (cmp >= 0) {
                high = mid - 1;
                continue;
            }
            if (cmp >= 0) continue;
            index = mid;
            break;
        }
        ArrayList<Map> resultList = new ArrayList<Map>();
        if (index != -1) {
            resultList.add(array[index]);
            for (int left = index - 1; left >= 0; --left) {
                Map leftMap = array[left];
                Comparable leftValue = (Comparable)leftMap.get(key);
                if (leftValue == null || leftValue.compareTo(compareValue) >= 0) continue;
                resultList.add(leftMap);
            }
            for (int right = index + 1; right < array.length; ++right) {
                Map rightMap = array[right];
                Comparable rightValue = (Comparable)rightMap.get(key);
                if (rightValue == null || rightValue.compareTo(compareValue) >= 0) continue;
                resultList.add(rightMap);
            }
        }
        Map[] result = new Map[resultList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Map)resultList.get(i);
        }
        return result;
    }

    private Map[] searchGreaterEquals(Map[] array, String key, Object compareValue) {
        this.comparator.setCompareField(key);
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        tempMap.put(key, compareValue);
        int low = 0;
        int high = array.length - 1;
        int index = -1;
        while (low <= high) {
            int mid = low + high >> 1;
            Map midVal = array[mid];
            int cmp = this.comparator.compare(midVal, tempMap);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) continue;
            index = mid;
            break;
        }
        ArrayList<Map> resultList = new ArrayList<Map>();
        if (index != -1) {
            resultList.add(array[index]);
            for (int left = index - 1; left >= 0; --left) {
                Map leftMap = array[left];
                Comparable leftValue = (Comparable)leftMap.get(key);
                if (leftValue == null || leftValue.compareTo(compareValue) < 0) continue;
                resultList.add(leftMap);
            }
            for (int right = index + 1; right < array.length; ++right) {
                Map rightMap = array[right];
                Comparable rightValue = (Comparable)rightMap.get(key);
                if (rightValue == null || rightValue.compareTo(compareValue) < 0) continue;
                resultList.add(rightMap);
            }
        }
        Map[] result = new Map[resultList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Map)resultList.get(i);
        }
        return result;
    }

    private Map[] searchGreater(Map[] array, String key, Object compareValue) {
        this.comparator.setCompareField(key);
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        tempMap.put(key, compareValue);
        int low = 0;
        int high = array.length - 1;
        int index = -1;
        while (low <= high) {
            int mid = low + high >> 1;
            Map midVal = array[mid];
            int cmp = this.comparator.compare(midVal, tempMap);
            if (cmp <= 0) {
                low = mid + 1;
                continue;
            }
            if (cmp <= 0) continue;
            index = mid;
            break;
        }
        ArrayList<Map> resultList = new ArrayList<Map>();
        if (index != -1) {
            resultList.add(array[index]);
            for (int left = index - 1; left >= 0; --left) {
                Map leftMap = array[left];
                Comparable leftValue = (Comparable)leftMap.get(key);
                if (leftValue == null || leftValue.compareTo(compareValue) <= 0) continue;
                resultList.add(leftMap);
            }
            for (int right = index + 1; right < array.length; ++right) {
                Map rightMap = array[right];
                Comparable rightValue = (Comparable)rightMap.get(key);
                if (rightValue == null || rightValue.compareTo(compareValue) <= 0) continue;
                resultList.add(rightMap);
            }
        }
        Map[] result = new Map[resultList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Map)resultList.get(i);
        }
        return result;
    }

    private Map[] searchEmpty(Map[] result, String key) {
        return this.searchEquals(result, key, null);
    }

    private Map[] searchEquals(Map[] array, String key, Object compareValue) {
        this.comparator.setCompareField(key);
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        tempMap.put(key, compareValue);
        int index = Arrays.binarySearch(array, tempMap, this.comparator);
        ArrayList<Map> resultList = new ArrayList<Map>();
        if (index >= 0) {
            resultList.add(array[index]);
            for (int left = index - 1; left >= 0; --left) {
                Map leftMap = array[left];
                Object leftValue = leftMap.get(key);
                if (leftValue == null || !leftValue.equals(compareValue)) continue;
                resultList.add(leftMap);
            }
            for (int right = index + 1; right < array.length; ++right) {
                Map rightMap = array[right];
                Object rightValue = rightMap.get(key);
                if (rightValue == null || !rightValue.equals(compareValue)) continue;
                resultList.add(rightMap);
            }
        }
        Map[] result = new Map[resultList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Map)resultList.get(i);
        }
        return result;
    }

    public void setInnerChecker(IInnerChecker innerChecker) {
        this.cache.clear();
        this.innerChecker = innerChecker;
    }

    public List getPropertyList() {
        return this.propertyList;
    }

    private class PropertyEqualsComparator
    implements Comparator {
        private Set keys;

        private PropertyEqualsComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 == null && arg1 == null) {
                return 0;
            }
            if (arg0 == arg1) {
                return 0;
            }
            if (!(arg0 instanceof Map) || !(arg1 instanceof Map)) {
                return -1;
            }
            Map map1 = (Map)arg0;
            Map map2 = (Map)arg1;
            String compareValue1 = new String();
            String compareValue2 = new String();
            for (String key : this.keys) {
                compareValue1 = compareValue1 + map1.get(key);
                compareValue2 = compareValue2 + map2.get(key);
            }
            return compareValue1.compareTo(compareValue2);
        }

        public void setKeys(Set keys) {
            this.keys = keys;
        }
    }

    private class PropertyComparator
    implements Comparator {
        private String compareField;

        private PropertyComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 == null && arg1 == null) {
                return 0;
            }
            if (arg0 == arg1) {
                return 0;
            }
            Map map1 = (Map)arg0;
            Map map2 = (Map)arg1;
            Comparable value1 = (Comparable)map1.get(this.compareField);
            Comparable value2 = (Comparable)map2.get(this.compareField);
            if (value1 == null) {
                return 1;
            }
            if (value2 == null) {
                return -1;
            }
            return value1.compareTo(value2);
        }

        public void setCompareField(String compareField) {
            this.compareField = compareField;
        }
    }
}

