/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RefBatchCalculater {
    private static Logger logger = Logger.getLogger(RefBatchCalculater.class);
    private Map formulas = null;
    private Context context = null;
    private ICalculateContextProvider calContext;
    private static final int BATCH_SIZE = 500;
    private static final String SPLIT = "@&@";
    private int batchSize;
    private BatchHelper batchHelper;

    public RefBatchCalculater(ICalculateContextProvider calContext, Context _serverCtx) {
        this.calContext = calContext;
        this.context = _serverCtx;
        this.batchHelper = new BatchHelper(calContext, _serverCtx);
    }

    private void initFormulas(SortedParameterArray params) {
        this.formulas = new HashMap(params.size());
        for (int i = 0; i < params.size(); ++i) {
            Ref ref = new Ref(params.getParameter(i));
            if (ref.exp != null) {
                FormulaValueBackfill backFill = new FormulaValueBackfill(params.getParameter(i));
                backFill.setException((Throwable)ref.exp);
                continue;
            }
            String key = ref.companyNumber + SPLIT + ref.reportNumber;
            ArrayList<Ref> group = (ArrayList<Ref>)this.formulas.get(key);
            if (group == null) {
                group = new ArrayList<Ref>();
                this.formulas.put(key, group);
            }
            group.add(ref);
        }
    }

    public void execute(SortedParameterArray params) {
        try {
            this.setBatchSize(500);
            this.initBatchSize("REF_BATCH_SIZE");
            this.initFormulas(params);
            IReport iReport = ReportFactory.getLocalInstance(this.calContext.getServerContext());
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("data"));
            viewInfo.getSelector().add(new SelectorItemInfo("company.number"));
            StringBuffer mask = new StringBuffer();
            int count = 0;
            int maskIndex = 0;
            String companyNumber = null;
            String reportNumber = null;
            Iterator it = this.formulas.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String[] numbers = key.split(SPLIT);
                companyNumber = numbers[0];
                reportNumber = numbers[1];
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)reportNumber));
                filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)companyNumber));
                if (maskIndex > 1) {
                    mask.append(" OR ");
                }
                mask.append("(#").append(maskIndex++).append(" AND #").append(maskIndex++).append(")");
                if (++count <= 500 && it.hasNext()) continue;
                filter.setMaskString(mask.toString());
                CoreBaseCollection rs = iReport.getCollection(viewInfo);
                this.exportData(rs);
                filter.getFilterItems().clear();
                mask.delete(0, mask.length());
                maskIndex = 0;
                count = 0;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getStackTrace());
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)("#BAD FUNCTION " + ex.getMessage()));
            }
        }
    }

    private void exportData(CoreBaseCollection rs) {
        for (int x = 0; rs != null && x < rs.size(); ++x) {
            Ref ref;
            int i;
            ReportInfo rpt = (ReportInfo)rs.get(x);
            String key = rpt.getCompany().getNumber() + SPLIT + rpt.getNumber();
            List group = (List)this.formulas.get(key);
            this.saveDataToFile(rpt);
            byte[] data = rpt.getData();
            HashMap map = new HashMap();
            for (i = 0; group != null && i < group.size(); ++i) {
                ref = (Ref)group.get(i);
                String cellRefName = ref.sheetName + "!" + ref.cellName;
                map.put(cellRefName.toUpperCase(), null);
            }
            try {
                BookIOUtil.loadSomeCellValues((byte[])data, map);
            }
            catch (Exception e) {
                for (int i2 = 0; i2 < group.size(); ++i2) {
                    Ref ref2 = (Ref)group.get(i2);
                    ref2.formulaValue.setException((Throwable)e);
                }
                continue;
            }
            for (i = 0; group != null && i < group.size(); ++i) {
                ref = (Ref)group.get(i);
                Object object = map.get((ref.sheetName + "!" + ref.cellName).toUpperCase());
                if (object == null || "".equals(object.toString())) {
                    ref.formulaValue.setValue((Object)Variant.nullVariant);
                    continue;
                }
                ref.formulaValue.setValue(object);
            }
        }
    }

    private void saveDataToFile(ReportInfo reportInfo) {
        String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
        if (!StringUtils.isEmpty((String)easInstanceHome) && DebugLogger.isDebug) {
            try {
                IOHelper.saveDataToFile(reportInfo.getData(), easInstanceHome + "/Ref[" + reportInfo.getCompany().getNumber() + "][" + reportInfo.getNumber() + "].data");
            }
            catch (Exception e) {
                logger.error((Object)e.getStackTrace());
            }
        }
    }

    private String makeValidOrgcode(String orgCode) {
        if (this.calContext != null && (orgCode == null || orgCode.length() < 1)) {
            String ci = null;
            if (this.calContext != null) {
                ci = (String)this.calContext.getReportAdapter().getReportProperty("Company.Number");
            }
            return ci;
        }
        return orgCode;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void initBatchSize(String key) {
        String sql = "select FValue From T_CSL_CSLParam where FKey = ? ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.calContext.getServerContext(), (String)sql, (Object[])new Object[]{key});
            if (rowSet.next()) {
                String stringSize = rowSet.getString("FValue");
                this.setBatchSize(Integer.parseInt(stringSize));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Ref {
        String reportNumber;
        String companyNumber;
        String sheetName;
        String cellName;
        FormulaValueBackfill formulaValue;
        Exception exp = null;

        public Ref(Parameter param) {
            Object[] params = param.getArgs();
            params = param.getArgs()[0] instanceof Object[] ? (Object[])param.getArgs()[0] : param.getArgs();
            this.initRef((String)((Variant)params[0]).getValue(), (String)((Variant)params[1]).getValue(), (String)((Variant)params[2]).getValue(), (String)((Variant)params[3]).getValue());
            this.formulaValue = new FormulaValueBackfill(param);
            if (this.exp != null) {
                this.formulaValue.setException((Throwable)this.exp);
            } else {
                this.formulaValue.setValue((Object)Variant.nullVariant);
            }
        }

        private void initRef(String org, String rptNumber, String sheetName, String cellName) {
            this.reportNumber = rptNumber;
            this.companyNumber = RefBatchCalculater.this.makeValidOrgcode(org);
            this.sheetName = sheetName;
            this.cellName = cellName;
            try {
                RefBatchCalculater.this.batchHelper.checkCompanyPermision(this.companyNumber);
            }
            catch (Exception e) {
                this.exp = e;
                return;
            }
            if (StringUtils.isEmpty((String)this.reportNumber)) {
                this.exp = new ReportException(ReportException.REF_REPORT_NUMBER_NOT_NULL);
                return;
            }
            if (StringUtils.isEmpty((String)this.sheetName)) {
                this.exp = new ReportException(ReportException.REF_SHEET_NAME_NOT_NULL);
                return;
            }
            if (StringUtils.isEmpty((String)this.cellName)) {
                this.exp = new ReportException(ReportException.REF_CELL_NAME_NOT_NULL);
                return;
            }
        }
    }
}

