/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acct.quantity;

import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.FormulaMatcher;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.MatcherHashMap;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.SimpleStringUtil;
import com.kingdee.eas.fi.rpt.batch.acct.quantity.VouchQuantityFormula;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import java.math.BigDecimal;
import java.util.Collection;

public class VouchQuantityCombine
implements IFormulaCombinationPreparedState {
    private MatcherHashMap values = new MatcherHashMap(1);

    @Override
    public boolean isPrepared(IFormulaCalculator formulaParam) {
        return true;
    }

    @Override
    public Object getFormulaResultValue(IFormulaCalculator formulaParam) {
        VouchQuantityFormula formula = (VouchQuantityFormula)formulaParam;
        FormulaMatcher matcher = new FormulaMatcher();
        matcher.setCompany(formula.getCompany().getLongNumber());
        matcher.addAccount(formula.getAccount().startAccount.getAccountNumber(), formula.getAccount().endAccount.getAccountNumber());
        matcher.addPeriod(formula.getStartYear() + SimpleStringUtil.prefix(formula.getStartPeriod()), formula.getEndYear() + SimpleStringUtil.prefix(formula.getEndPeriod()));
        AcctountAsstItemParser.AsstItem[] asstItems = formula.getAccount().getAccountAsstItem().asstItems;
        if (asstItems != null) {
            for (int i = 0; i < asstItems.length; ++i) {
                String type = asstItems[i].asstTypeNumber;
                String startNumber = asstItems[i].startNumber;
                String endNumber = asstItems[i].endNumber;
                matcher.addAssistant(type, startNumber, endNumber);
            }
        }
        matcher.setCurrency(formula.getCurrency().getId().toString());
        Collection findedValues = this.values.getValue(matcher);
        BigDecimal sum = new BigDecimal("0");
        for (Object value : findedValues) {
            if (!(value instanceof Number)) continue;
            sum = sum.add(new BigDecimal(((Number)value).toString()));
        }
        return sum;
    }

    @Override
    public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
        return true;
    }

    public void put(FormulaMatcher matcher, BigDecimal value) {
        this.values.put(matcher, value);
    }

    public void reset() {
        this.values.clear();
    }
}

