/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.ICompareStyle;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.SQLStringWrapper;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCash;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashCombineState;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashSortState;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashTempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.acctcash.IBaseAcctCashHandler;
import com.kingdee.eas.fi.rpt.batch.acctcash.ITimeCondition;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.DefaultTempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValue;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableFieldItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableValue;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableValueItem;
import com.kingdee.eas.fi.rpt.jdbc.SqlParameter;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AcctCashBatchProccessor
implements ITempTableSQLProcessor,
IBatchSQLSorterProcessor,
ICompareStyle {
    private static final int ORACLE_IDENTIFIER_LIMIT = 30;
    public static final String REGEX_SEPARATOR_LEFT = "@_REGEX@_";
    public static final String REGEX_SEPARATOR_RIGHT = "_@REGEX_@";
    private static final String NULL_STRING_PARAM = "";
    private int batchSize;
    private AcctCashSortState sortState;
    private String selectPart;
    private String fromPart;
    private SQLStringWrapper constantWherePart;
    private String groupByPart;
    private IFormulaCombinationPreparedState combineState;
    private ITempTableValueInsertProcessor tempTableValueInsertProcessor;
    private TempTableField tempTableField;
    private static final String NVARCHAR_250 = "nvarchar(250)";
    private static final String NVARCHAR_80 = "nvarchar(80)";
    private String[] IndexResultSetFields;
    private int indexCompareStyle;

    public AcctCashBatchProccessor(int batchSize) {
        this.batchSize = batchSize;
        this.combineState = new AcctCashCombineState();
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append(this.getSelectPart());
    }

    private String innerBuildSelectPart() {
        String tableAlias;
        StringBuffer sql = new StringBuffer();
        String coeffient = NULL_STRING_PARAM;
        if (this.sortState.getCashFlowItemType() == CashFlowItemType.MASTER_TABLE_ITEM) {
            coeffient = " Cash.FPrimaryCoeffient * ";
        } else if (this.sortState.getCashFlowItemType() == CashFlowItemType.SECONDARY_TABLE_ITEM) {
            coeffient = " Cash.FSupplementaryCoeffient * ";
        }
        if (this.sortState.getCashFlowItemType() == CashFlowItemType.MASTER_TABLE_ITEM) {
            if (this.sortState.isLeafCashFlowItem() || !this.sortState.isLeafCashFlowItem() && this.sortState.getCashFlowDirection() != CashFlowDirection.IN_OR_OUT) {
                sql.append("Select sum(").append(coeffient).append(" Cash.FOriginalAmount ) OriginalAmount ");
                sql.append(" , sum(").append(coeffient).append(" Cash.FLocalAmount ) LocalAmount ");
                sql.append(" , sum(").append(coeffient).append(" Cash.FReportingAmount ) ReportingAmount ");
            } else {
                sql.append(" Select sum( ").append(coeffient).append(" Cash.FOriginalAmount*(3-2*CashItem.FDirection)) OriginalAmount ");
                sql.append(" ,sum( ").append(coeffient).append(" Cash.FLocalAmount*(3-2*CashItem.FDirection)) LocalAmount ");
                sql.append(" ,sum( ").append(coeffient).append(" Cash.FReportingAmount*(3-2*CashItem.FDirection)) ReportingAmount ");
            }
        } else {
            sql.append("Select sum(").append(coeffient).append(" Cash.FOriginalAmount ) OriginalAmount ");
            sql.append(" , sum(").append(coeffient).append(" Cash.FLocalAmount ) LocalAmount ");
            sql.append(" , sum(").append(coeffient).append(" Cash.FReportingAmount ) ReportingAmount ");
        }
        if (this.sortState.getCompanyNumber() == null) {
            sql.append(" , voucher.FCompanyID OrgID ");
        }
        sql.append(" , CashItem.FID CashItemID ");
        if (!this.sortState.isForIncashFlow()) {
            if (this.sortState.getSingleCashFlowAsstActItem() != null) {
                for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                    tableAlias = this.validateTableAlias(itemType[0]);
                    sql.append(" , A_AsstType").append(tableAlias).append(".");
                    if (itemType[1] == "FLongNumber") {
                        sql.append("FLongNumber").append(" AsstActItem").append(tableAlias).append(" ");
                        continue;
                    }
                    sql.append("FNumber").append(" AsstActItem").append(tableAlias).append(" ");
                }
            }
        } else {
            sql.append(" , InnerCompany.FNumber CashFlowItemAsstNumber ");
        }
        if (this.sortState.isNeedAccount() && this.sortState.getOppAccount() == null) {
            sql.append(" , A_Acct.Fnumber AccountNumber ");
        }
        if (this.sortState.getSingleOppAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleOppAsstActItem()) {
                tableAlias = "Op" + this.validateTableAlias(itemType[0]);
                sql.append(" , A_AsstType").append(tableAlias).append(".FNumber AsstActItem").append(tableAlias).append(" ");
            }
        }
        if (this.sortState.isMultiCurrency()) {
            sql.append(" , Currency.FNumber CurrencyNumber ");
        }
        return sql.toString();
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(this.getFromPart());
    }

    private String innerBuildFromPart() {
        String tableAlias;
        AsstActType item;
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append(" From T_GL_CashflowRecord Cash ");
        sql.append(" inner join T_GL_Voucher voucher on Cash.FVoucherID = voucher.FID");
        sql.append(" inner join T_BD_Period period on period.FID = voucher.FPeriodID ");
        sql.append(" inner join T_BD_CashFlowItem CashItem on CashItem.FID = ");
        if (this.sortState.getCashFlowItemType() == CashFlowItemType.MASTER_TABLE_ITEM) {
            sql.append(" Cash.FPrimaryItemID ");
        } else if (this.sortState.getCashFlowItemType() == CashFlowItemType.SECONDARY_TABLE_ITEM) {
            sql.append(" Cash.FSupplementaryItemID ");
        } else {
            sql.append(" Cash.FFullInfoItemID ");
        }
        if (this.sortState.isUseTempTableScheme() && !this.sortState.isBizCompany()) {
            sql.append(" inner join T_ORG_Company company on  voucher.FCompanyID = company.Fid ");
        }
        if (this.sortState.isUseTempTableScheme() && this.sortState.getCurrencyNumber() != null || this.sortState.isMultiCurrency() || this.sortState.getCurrencyNumber() != null) {
            sql.append(" inner join T_BD_Currency Currency on Cash.FCurrencyID = Currency.FID ");
        }
        if (this.sortState.getCashFlowAsstActTypeList() != null) {
            sql.append(" inner join t_bd_assistanthg c on Cash.fassgrpid=c.fid  ");
            for (i = 0; i < this.sortState.getCashFlowAsstActTypeList().size(); ++i) {
                AssistantGroup[] groups;
                item = (AsstActType)this.sortState.getCashFlowAsstActTypeList().get(i);
                if (this.sortState.isForIncashFlow()) {
                    if (item.realtionDataObject.equalsIgnoreCase("t_bd_supplier") || item.realtionDataObject.equalsIgnoreCase("t_bd_customer")) {
                        sql.append(" inner join ").append(item.realtionDataObject).append(" CashFlowItemAsstActType on CashFlowItemAsstActType.fid = c.").append(item.mappingFieldName).append(" ");
                        sql.append(" inner join t_org_company InnerCompany  on InnerCompany.fid = CashFlowItemAsstActType.FInternalCompanyID ");
                        continue;
                    }
                    sql.append(" inner join ").append(item.realtionDataObject).append(" InnerCompany on InnerCompany.fid = c.").append(item.mappingFieldName).append(" ");
                    continue;
                }
                tableAlias = this.validateTableAlias(item.number);
                sql.append(" inner join ").append(item.realtionDataObject).append(" A_AsstType").append(tableAlias).append(" on A_AsstType").append(tableAlias).append(".fid = c.").append(item.mappingFieldName).append(" ");
                if (this.sortState.getCashFlowGroupMap() == null || (groups = (AssistantGroup[])this.sortState.getCashFlowGroupMap().get(item.number)) == null || groups.length <= 0) continue;
                this.buildAssistantGroupFromPart(sql, item, groups, NULL_STRING_PARAM);
            }
        }
        if (this.sortState.isNeedAccount()) {
            sql.append(" inner join T_BD_AccountView A_Acct on Cash.FOppAccountID = A_Acct.FID ");
        }
        if (this.sortState.getOppAsstActTypeList() != null) {
            sql.append(" inner join T_BD_AssistantHG A_Hg on Cash.FOppASSGRPID = A_HG.FID  ");
            for (i = 0; i < this.sortState.getOppAsstActTypeList().size(); ++i) {
                item = (AsstActType)this.sortState.getOppAsstActTypeList().get(i);
                tableAlias = "Op" + this.validateTableAlias(item.number);
                sql.append(" inner join ").append(item.realtionDataObject).append(" A_AsstType").append(tableAlias).append(" on A_Hg.").append(item.mappingFieldName).append(" = ").append("A_AsstType").append(tableAlias).append(".FID   \n");
            }
            if (this.sortState.getGroupMap() != null) {
                for (AsstActType itemType : this.sortState.getOppAsstActTypeList()) {
                    AssistantGroup[] groups = (AssistantGroup[])this.sortState.getGroupMap().get(itemType.number);
                    if (groups == null || groups.length <= 0) continue;
                    this.buildAssistantGroupFromPart(sql, itemType, groups, "Op");
                }
            }
        }
        return sql.toString();
    }

    public String validateTableAlias(String alias) {
        alias = alias.replaceAll("-", "_");
        alias = alias.replaceAll("\\.", "_");
        return alias;
    }

    public String limitTableAliasLength(String alias) {
        if (alias.length() > 30) {
            alias = alias.substring(0, 30);
        }
        return alias;
    }

    private void buildAssistantGroupFromPart(StringBuffer sql, AsstActType itemType, AssistantGroup[] groups, String alias) {
        String tableAlias = alias + this.validateTableAlias(itemType.number);
        if ("T_BD_CUSTOMER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_SUPPLIER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
            String group = null;
            String groupTable = null;
            String groupDetail = null;
            if ("T_BD_CUSTOMER".equalsIgnoreCase(itemType.realtionDataObject)) {
                group = "Customer";
                groupTable = "T_BD_CSSPGroup";
                groupDetail = "GroupDetail";
            } else if ("T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
                group = "Material";
                groupTable = "T_BD_MaterialGroup";
                groupDetail = "GroupDetial";
            } else {
                group = "Supplier";
                groupTable = "T_BD_CSSPGroup";
                groupDetail = "GroupDetail";
            }
            for (int gi = 0; gi < groups.length; ++gi) {
                AssistantGroup g = groups[gi];
                sql.append(" inner join T_BD_").append(group).append(groupDetail);
                sql.append(" groupDtl").append(tableAlias).append(gi).append(" on groupDtl").append(tableAlias).append(gi).append(".F").append(group).append("ID = A_AsstType").append(tableAlias).append(".FID ");
                String groupTableAlias = this.limitTableAliasLength("group" + tableAlias + "_" + g.standardNumber);
                sql.append(" inner join ").append(groupTable).append(" ").append(groupTableAlias);
                sql.append(" on groupDtl").append(tableAlias).append(gi).append(".F").append(group).append("GroupID = ").append(groupTableAlias).append(".FID ");
            }
        } else {
            sql.append(" inner join ").append(itemType.groupTableName).append(" Group").append(tableAlias);
            sql.append(" on ").append("A_AsstType").append(tableAlias).append(itemType.groupMappingFieldName);
            sql.append(" = ").append(" Group").append(tableAlias).append(".FID ");
        }
    }

    private void buildAssistanGroupWherePart(StringBuffer sql, List params, AsstActType itemType, AssistantGroup[] groups, String alias) {
        String tableAlias = alias + this.validateTableAlias(itemType.number);
        if ("T_BD_CUSTOMER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_SUPPLIER".equalsIgnoreCase(itemType.realtionDataObject) || "T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
            for (int gi = 0; gi < groups.length; ++gi) {
                AssistantGroup group = groups[gi];
                String gp = this.limitTableAliasLength("group" + tableAlias + "_" + group.standardNumber);
                if (groups[gi].isSingleGroup()) {
                    sql.append(" and (").append(gp).append(".fnumber = ? or ").append(gp).append(".fnumber like ?)");
                    params.add(group.getStartGroup().number);
                    params.add(group.getStartGroup().number + "!%");
                } else {
                    sql.append("and (").append(gp).append(".fnumber >= ? and ").append(gp).append(".fnumber <= ?)");
                    params.add(group.getStartGroup().number);
                    params.add(group.getEndGroup().number);
                }
                if ("T_BD_Material".equalsIgnoreCase(itemType.realtionDataObject)) {
                    sql.append(" AND ").append(gp).append(".FGroupStandard = ? ");
                } else {
                    sql.append(" AND ").append(gp).append(".FCSSPGroupStandardID = ? ");
                }
                params.add(group.standardID);
            }
        } else {
            AssistantGroup group = groups[0];
            if (group.isSingleGroup()) {
                sql.append(" and ( Group").append(tableAlias).append(".fnumber = ? or Group").append(tableAlias).append(".fnumber like ? )");
                params.add(group.getStartGroup().number);
                params.add(group.getStartGroup().number + "!%");
            } else {
                if (group.getStartGroup().longNumber.length() > 0) {
                    sql.append(" and  Group").append(tableAlias).append(".fnumber >= ? ");
                    params.add(group.getStartGroup().number);
                }
                if (group.getEndGroup().longNumber.length() > 0) {
                    sql.append(" and  Group").append(tableAlias).append(".fnumber <= ? ");
                    params.add(group.getEndGroup().number);
                }
            }
        }
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(this.constantWherePart.getSQLString());
        params.addAll(this.constantWherePart.getParams());
    }

    private SQLStringWrapper innerBuildConstantWherePart() {
        AssistantGroup[] groups;
        String tableAlias;
        AsstActType item;
        int i;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append(" Where voucher.FBizStatus <>0 and  voucher.FBizStatus <>2 ");
        if (this.sortState.isMultiCurrency() || this.sortState.getCurrencyNumber() != null) {
            sql.append(" and voucher.fid = Cash.Fvoucherid ");
        }
        if (!this.sortState.isIncludingUnPosted()) {
            sql.append(" and voucher.FBizStatus=5 ");
        }
        this.buildPeriodSQL(sql, params);
        if (this.sortState.isUseTempTableScheme()) {
            if (!this.sortState.isBizCompany()) {
                sql.append(" and company.FLongNumber like ? and company.FIsbizunit = 1 ");
                params.add(this.sortState.getCompanyNumber() + "!%");
            } else {
                sql.append(" and voucher.FCompanyID = ? ");
                params.add(this.sortState.getCompanyNumber());
            }
            if (this.sortState.getCurrencyNumber() != null) {
                sql.append(" and Currency.FNumber = ? ");
                params.add(this.sortState.getCurrencyNumber());
            }
        } else {
            if (this.sortState.getCompanyNumber() != null) {
                if (this.sortState.getCompanyIDList().size() == 1) {
                    sql.append(" and voucher.FCompanyID = ? ");
                    params.add((String)this.sortState.getCompanyIDList().get(0));
                } else {
                    sql.append(" and voucher.FCompanyID in ( ");
                    for (int i2 = 0; i2 < this.sortState.getCompanyIDList().size(); ++i2) {
                        if (i2 != 0) {
                            sql.append(" , ");
                        }
                        sql.append(" ? ");
                        params.add((String)this.sortState.getCompanyIDList().get(i2));
                    }
                    sql.append(" ) ");
                }
            }
            if (!this.sortState.isMultiCurrency() && this.sortState.getCurrencyNumber() != null) {
                sql.append(" and Currency.FNumber = ? ");
                params.add(this.sortState.getCurrencyNumber());
            }
        }
        if (this.sortState.getOppAccount() != null) {
            sql.append(" and A_Acct.Fnumber >= ? and  A_Acct.Fnumber <= ? ");
            params.add(this.sortState.getOppAccount()[0]);
            params.add(this.sortState.getOppAccount()[1]);
        }
        HashSet<String> nullLongNumberSet = null;
        if (this.sortState.getCashFlowAsstActTypeList() != null) {
            for (i = 0; i < this.sortState.getCashFlowAsstActTypeList().size(); ++i) {
                item = (AsstActType)this.sortState.getCashFlowAsstActTypeList().get(i);
                tableAlias = this.validateTableAlias(item.number);
                if (item.realtionDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                    if (nullLongNumberSet == null) {
                        nullLongNumberSet = new HashSet<String>();
                    }
                    nullLongNumberSet.add(item.number);
                    sql.append(" and A_AsstType").append(tableAlias).append(".FGroupID=? ");
                    params.add(item.glAsstActTypeGrpID);
                    continue;
                }
                if (!item.realtionDataObject.equalsIgnoreCase("T_ORG_Admin") && !item.realtionDataObject.equalsIgnoreCase("T_BD_CashFlowItem") && !item.realtionDataObject.equalsIgnoreCase("T_ORG_CostCenter")) continue;
                if (nullLongNumberSet == null) {
                    nullLongNumberSet = new HashSet();
                }
                nullLongNumberSet.add(item.number);
            }
        }
        if (this.sortState.getCashFlowAsstActItems() != null) {
            for (String[] asstActItem : this.sortState.getCashFlowAsstActItems()) {
                tableAlias = this.validateTableAlias(asstActItem[0]);
                if (nullLongNumberSet != null && nullLongNumberSet.contains(asstActItem[0])) {
                    if (asstActItem[1].equals(asstActItem[2])) {
                        sql.append(" and (A_AsstType").append(tableAlias).append(".FLongNumber = ? or A_AsstType").append(tableAlias).append(".FLongNumber like ? ) ");
                        params.add(asstActItem[1]);
                        params.add(asstActItem[1] + "!%");
                        continue;
                    }
                    sql.append(" and A_AsstType").append(tableAlias).append(".FLongNumber >= ? and A_AsstType").append(tableAlias).append(".FLongNumber <= ?  ");
                    params.add(asstActItem[1]);
                    params.add(asstActItem[2]);
                    continue;
                }
                if (asstActItem[1].equals(asstActItem[2])) {
                    sql.append(" and A_AsstType").append(tableAlias).append(".FNumber = ? ");
                    params.add(asstActItem[1]);
                    continue;
                }
                sql.append(" and A_AsstType").append(tableAlias).append(".FNumber >= ? and A_AsstType").append(tableAlias).append(".FNumber <= ?  ");
                params.add(asstActItem[1]);
                params.add(asstActItem[2]);
            }
        }
        if (this.sortState.getCashFlowAsstActTypeList() != null && this.sortState.getCashFlowGroupMap() != null) {
            for (AsstActType itemType : this.sortState.getCashFlowAsstActTypeList()) {
                groups = (AssistantGroup[])this.sortState.getCashFlowGroupMap().get(itemType.number);
                if (groups == null || groups.length <= 0) continue;
                this.buildAssistanGroupWherePart(sql, params, itemType, groups, NULL_STRING_PARAM);
            }
        }
        nullLongNumberSet = null;
        if (this.sortState.getOppAsstActTypeList() != null) {
            for (i = 0; i < this.sortState.getOppAsstActTypeList().size(); ++i) {
                item = (AsstActType)this.sortState.getOppAsstActTypeList().get(i);
                if (!item.realtionDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) continue;
                if (nullLongNumberSet == null) {
                    nullLongNumberSet = new HashSet();
                }
                nullLongNumberSet.add(item.number);
                tableAlias = "Op" + this.validateTableAlias(item.number);
                sql.append(" and A_AsstType").append(tableAlias).append(".FGroupID=? ");
                params.add(item.glAsstActTypeGrpID);
            }
        }
        if (this.sortState.getOppAsstActItems() != null) {
            for (String[] asstActItem : this.sortState.getOppAsstActItems()) {
                tableAlias = "Op" + this.validateTableAlias(asstActItem[0]);
                if (nullLongNumberSet != null && nullLongNumberSet.contains(asstActItem[0])) {
                    if (asstActItem[1].equals(asstActItem[2])) {
                        sql.append(" and (A_AsstType").append(tableAlias).append(".FLongNumber = ? or A_AsstType").append(tableAlias).append(".FLongNumber like ? ) ");
                        params.add(asstActItem[1]);
                        params.add(asstActItem[1] + "!%");
                        continue;
                    }
                    sql.append(" and A_AsstType").append(tableAlias).append(".FLongNumber >= ? and A_AsstType").append(tableAlias).append(".FLongNumber <= ?  ");
                    params.add(asstActItem[1]);
                    params.add(asstActItem[2]);
                    continue;
                }
                if (asstActItem[1].equals(asstActItem[2])) {
                    sql.append(" and A_AsstType").append(tableAlias).append(".FNumber = ? ");
                    params.add(asstActItem[1]);
                    continue;
                }
                sql.append(" and A_AsstType").append(tableAlias).append(".FNumber >= ? and A_AsstType").append(tableAlias).append(".FNumber <= ?  ");
                params.add(asstActItem[1]);
                params.add(asstActItem[2]);
            }
        }
        if (this.sortState.getOppAsstActTypeList() != null && this.sortState.getGroupMap() != null) {
            for (AsstActType itemType : this.sortState.getOppAsstActTypeList()) {
                groups = (AssistantGroup[])this.sortState.getGroupMap().get(itemType.number);
                if (groups == null || groups.length <= 0) continue;
                this.buildAssistanGroupWherePart(sql, params, itemType, groups, "Op");
            }
        }
        if (!this.sortState.isUseTempTableScheme()) {
            sql.append(" and ( ");
        }
        return new SQLStringWrapper(sql.toString(), params);
    }

    private void buildPeriodSQL(StringBuffer sql, List params) {
        ITimeCondition timeCondition = this.sortState.getTimeCondition();
        IBaseAcctCashHandler conditionHandler = timeCondition.getConditionHandler();
        Map tcFields = this.getPeriodFields();
        StringBuffer tcSql = conditionHandler.getTimeConditionSQL(timeCondition, tcFields, params);
        sql.append(" and ");
        sql.append(tcSql);
        sql.append(" ");
    }

    private Map getPeriodFields() {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("FPERIODYEAR", "period.FPeriodYear");
        fields.put("FPERIODNUMBER", "period.FPeriodNumber");
        fields.put("FBOOKEDDATE", "VOUCHER.FBookedDate");
        return fields;
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        AssistantItem assistantItem;
        String tableAlias;
        int i;
        AcctCash acctCash = (AcctCash)formula;
        sql.append(" ( ");
        if (this.sortState.getMaxCashItemLevel() == 1) {
            sql.append("  CashItem.FID = ? ");
            params.add(acctCash.cashFlowItemList.get(0));
        } else {
            sql.append("  CashItem.FID in ( ");
            for (i = 0; i < this.sortState.getMaxCashItemLevel(); ++i) {
                if (i != 0) {
                    sql.append(" , ");
                }
                sql.append(" ? ");
                if (i < acctCash.cashFlowItemList.size()) {
                    params.add(acctCash.cashFlowItemList.get(i));
                    continue;
                }
                params.add(NULL_STRING_PARAM);
            }
            sql.append(" ) ");
        }
        if (this.sortState.getCompanyNumber() == null) {
            if (this.sortState.getMaxCompanyLevel() == 1) {
                sql.append(" and voucher.FCompanyID = ? ");
                params.add(acctCash.companyList.get(0));
            } else {
                sql.append(" and voucher.FCompanyID in ( ");
                for (i = 0; i < this.sortState.getMaxCompanyLevel(); ++i) {
                    if (i != 0) {
                        sql.append(" , ");
                    }
                    sql.append(" ? ");
                    if (i < acctCash.companyList.size()) {
                        params.add(acctCash.companyList.get(i));
                        continue;
                    }
                    params.add(NULL_STRING_PARAM);
                }
                sql.append(" ) ");
            }
        }
        if (this.sortState.getSingleCashFlowAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                tableAlias = this.validateTableAlias(itemType[0]);
                assistantItem = acctCash.cashFlowItem.getItem(itemType[0]);
                if (!this.sortState.isForIncashFlow()) {
                    if (assistantItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number)) continue;
                    if (itemType[1] == "FLongNumber") {
                        sql.append(" and  (A_AsstType").append(tableAlias).append(".").append("FLongNumber").append(" = ? ");
                        sql.append(" or  A_AsstType").append(tableAlias).append(".").append("FLongNumber").append(" like ? )");
                        params.add(assistantItem.startItem.longNumber);
                        params.add(assistantItem.startItem.longNumber + "!%");
                        continue;
                    }
                    sql.append(" and A_AsstType").append(tableAlias).append(".FNumber = ? ");
                    params.add(assistantItem.startItem.number);
                    continue;
                }
                if (this.sortState.isQueryAllInnerCompany() || assistantItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number)) continue;
                sql.append(" and InnerCompany.FNumber = ? ");
                params.add(assistantItem.startItem.number);
            }
        }
        if (this.sortState.isNeedAccount() && this.sortState.getOppAccount() == null) {
            sql.append(" and A_Acct.Fnumber LIKE ? ");
            params.add(acctCash.oppAccountItem.getAccountAsstItem().startNumber + "%");
        }
        if (this.sortState.getSingleOppAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleOppAsstActItem()) {
                tableAlias = "Op" + this.validateTableAlias(itemType[0]);
                assistantItem = acctCash.oppAccountItem.getItem(itemType[0]);
                if (assistantItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number)) continue;
                sql.append(" and A_AsstType").append(tableAlias).append(".FNumber = ? ");
                params.add(assistantItem.startItem.number);
            }
        }
        if (this.sortState.isMultiCurrency()) {
            sql.append(" and Currency.FNumber = ? ");
            params.add(acctCash.currencyNumber);
        }
        sql.append(" ) ");
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(this.getGroupByPart());
    }

    private String innerBuildGroupByPart() {
        String tableAlias;
        StringBuffer sql = new StringBuffer();
        if (!this.sortState.isUseTempTableScheme()) {
            sql.append(" ) ");
        }
        sql.append(" Group by CashItem.FID ");
        if (this.sortState.getCompanyNumber() == null) {
            sql.append(" , voucher.FCompanyID   ");
        }
        if (!this.sortState.isForIncashFlow()) {
            if (this.sortState.getSingleCashFlowAsstActItem() != null) {
                for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                    tableAlias = this.validateTableAlias(itemType[0]);
                    sql.append(" , A_AsstType").append(tableAlias).append(".");
                    if (itemType[1] == "FLongNumber") {
                        sql.append("FLongNumber");
                        continue;
                    }
                    sql.append("FNumber");
                }
            }
        } else {
            sql.append(" , InnerCompany.FNumber  ");
        }
        if (this.sortState.isNeedAccount() && this.sortState.getOppAccount() == null) {
            sql.append(" , A_Acct.Fnumber  ");
        }
        if (this.sortState.getSingleOppAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleOppAsstActItem()) {
                tableAlias = "Op" + this.validateTableAlias(itemType[0]);
                sql.append(" , A_AsstType").append(tableAlias).append(".FNumber ");
            }
        }
        if (this.sortState.isMultiCurrency()) {
            sql.append(" , Currency.FNumber  ");
        }
        return sql.toString();
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combineState;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        AcctCash acctCash = (AcctCash)formula;
        List companyList = acctCash.companyList;
        List cashList = acctCash.cashFlowItemList;
        ArrayList<String> condition = new ArrayList<String>();
        int index = 0;
        boolean isUseCompany = this.sortState.getCompanyNumber() == null;
        int count = isUseCompany ? companyList.size() : 1;
        Object[][] result = new Object[count * cashList.size()][];
        String companyID = null;
        this.indexCompareStyle = 1;
        for (int i = 0; i < count; ++i) {
            if (isUseCompany) {
                companyID = (String)companyList.get(i);
            }
            for (int j = 0; j < cashList.size(); ++j) {
                AssistantItem assistantItem;
                String cashItemID = (String)cashList.get(j);
                if (isUseCompany) {
                    condition.add(companyID);
                }
                condition.add(cashItemID);
                if (this.sortState.getSingleCashFlowAsstActItem() != null && !this.sortState.isQueryAllInnerCompany()) {
                    for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                        assistantItem = acctCash.cashFlowItem.getItem(itemType[0]);
                        if (assistantItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number) || itemType[1] == "FLongNumber") continue;
                        condition.add(assistantItem.startItem.number);
                    }
                }
                if (this.sortState.isNeedAccount() && this.sortState.getOppAccount() == null) {
                    condition.add(acctCash.oppAccountItem.getAccountAsstItem().startNumber + REGEX_SEPARATOR_LEFT + ".*" + REGEX_SEPARATOR_RIGHT);
                    this.indexCompareStyle = 2;
                }
                if (this.sortState.getSingleOppAsstActItem() != null) {
                    for (String[] itemType : this.sortState.getSingleOppAsstActItem()) {
                        assistantItem = acctCash.oppAccountItem.getItem(itemType[0]);
                        if (assistantItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number)) continue;
                        condition.add(assistantItem.startItem.number);
                    }
                }
                if (this.sortState.isMultiCurrency()) {
                    condition.add(acctCash.currencyNumber);
                }
                result[index++] = condition.toArray();
                condition.clear();
            }
        }
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        return this.IndexResultSetFields;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        AcctCashCombineState acctCashState = (AcctCashCombineState)combineState;
        acctCashState.refresh();
        acctCashState.setLocal(rs.getBigDecimal("LocalAmount"));
        acctCashState.setReporting(rs.getBigDecimal("ReportingAmount"));
        acctCashState.setOriginal(rs.getBigDecimal("OriginalAmount"));
        if (this.sortState.getSingleCashFlowAsstActItem() != null) {
            Iterator iterator = this.sortState.getSingleCashFlowAsstActItem().iterator();
            while (iterator.hasNext()) {
                StringBuffer sb = new StringBuffer();
                String[] itemType = (String[])iterator.next();
                String tableAlias = this.validateTableAlias(itemType[0]);
                if (itemType[1] != "FLongNumber") continue;
                sb.append("ASSTACTITEM").append(tableAlias);
                acctCashState.putAsstNumber(itemType[0], rs.getString(sb.toString()));
            }
        }
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return this.batchSize;
    }

    @Override
    public Set getAllowedNullFields() {
        return null;
    }

    @Override
    public List getFormulaCalculators() {
        return this.sortState.getFormulaList();
    }

    public IBatchSQLSortState getSortState() {
        return this.sortState;
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = (AcctCashSortState)sortState;
        if (this.isUseTempTableScheme()) {
            this.tempTableField = this.innerGetTempTableField();
            this.tempTableValueInsertProcessor = new DefaultTempTableValueInsertProcessor();
        }
        this.refreshSQLBySortState();
    }

    private void refreshSQLBySortState() {
        this.initIndexResultSetFields();
        this.setSelectPart(this.innerBuildSelectPart());
        this.setFromPart(this.innerBuildFromPart());
        this.setConstantWherePart(this.innerBuildConstantWherePart());
        this.setGroupByPart(this.innerBuildGroupByPart());
    }

    private void initIndexResultSetFields() {
        String tableAlias;
        ArrayList<String> result = new ArrayList<String>();
        if (this.sortState.getCompanyNumber() == null) {
            result.add("OrgID");
        }
        result.add("CashItemID");
        if (this.sortState.getSingleCashFlowAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                tableAlias = this.validateTableAlias(itemType[0]);
                if (!this.sortState.isForIncashFlow()) {
                    if (itemType[1] == "FLongNumber") continue;
                    result.add("AsstActItem" + tableAlias);
                    continue;
                }
                if (itemType[1] == "FLongNumber") continue;
                result.add("CashFlowItemAsstNumber");
            }
        }
        if (this.sortState.isNeedAccount() && this.sortState.getOppAccount() == null) {
            result.add("AccountNumber");
        }
        if (this.sortState.getSingleOppAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleOppAsstActItem()) {
                tableAlias = "Op" + this.validateTableAlias(itemType[0]);
                result.add("AsstActItem" + tableAlias);
            }
        }
        if (this.sortState.isMultiCurrency()) {
            result.add("CurrencyNumber");
        }
        this.IndexResultSetFields = new String[result.size()];
        result.toArray(this.IndexResultSetFields);
    }

    public String getSelectPart() {
        return this.selectPart;
    }

    public void setSelectPart(String selectPart) {
        this.selectPart = selectPart;
    }

    public String getFromPart() {
        return this.fromPart;
    }

    public void setFromPart(String fromPart) {
        this.fromPart = fromPart;
    }

    public SQLStringWrapper getConstantWherePart() {
        return this.constantWherePart;
    }

    public void setConstantWherePart(SQLStringWrapper constantWherePart) {
        this.constantWherePart = constantWherePart;
    }

    public String getGroupByPart() {
        return this.groupByPart;
    }

    public void setGroupByPart(String groupByPart) {
        this.groupByPart = groupByPart;
    }

    public void setIndexResultSetFields(String[] indexResultSetFields) {
        this.IndexResultSetFields = indexResultSetFields;
    }

    @Override
    public int getIndexCompareStyle() {
        return this.indexCompareStyle;
    }

    @Override
    public boolean isUseTempTableScheme() {
        return this.sortState.isUseTempTableScheme();
    }

    @Override
    public ITempTableValue insertTempTableValues(IFormulaCalculator formula) {
        AcctCash acctCash = (AcctCash)formula;
        TempTableValue tempTableValue = new TempTableValue();
        tempTableValue.addTempTableItem(new TempTableValueItem("CashItem.FID", acctCash.cashFlowItemInfo.getId().toString()));
        if (this.sortState.getSingleCashFlowAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                String tableAlias = this.validateTableAlias(itemType[0]);
                AssistantItem assistantItem = acctCash.cashFlowItem.getItem(itemType[0]);
                if (!this.sortState.isForIncashFlow()) {
                    if (assistantItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number)) continue;
                    if (itemType[1] == "FLongNumber") {
                        tempTableValue.addTempTableItem(new TempTableValueItem("A_AsstType" + tableAlias + ".FLongNumber", assistantItem.startItem.longNumber));
                        continue;
                    }
                    tempTableValue.addTempTableItem(new TempTableValueItem("A_AsstType" + tableAlias + ".FNumber", assistantItem.startItem.number));
                    continue;
                }
                if (this.sortState.isQueryAllInnerCompany() || assistantItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number)) continue;
                tempTableValue.addTempTableItem(new TempTableValueItem("InnerCompany.FNumber", assistantItem.startItem.number));
            }
        }
        return tempTableValue;
    }

    @Override
    public void buildInnerJoinTempTable(StringBuffer sql, String tempTableName, ITempTableField tempTableField) {
        sql.append("\n inner join ");
        sql.append(tempTableName).append(" tempTable");
        sql.append(" on ");
        Iterator it = tempTableField.getTempTableFieldItems().iterator();
        while (it.hasNext()) {
            TempTableFieldItem tempTableFieldItem = (TempTableFieldItem)it.next();
            Boolean join = (Boolean)tempTableFieldItem.getProperty("join");
            if (join != null && !join.booleanValue()) continue;
            String fieldName = tempTableFieldItem.getField();
            String tempTableFieldName = tempTableFieldItem.getTempTableField();
            tempTableFieldName = "tempTable." + tempTableFieldName;
            sql.append("(");
            sql.append(fieldName).append(" = ").append(tempTableFieldName);
            if (fieldName.matches("A_AsstType.+\\.FLongNumber")) {
                sql.append(" or charindex(concat(").append(tempTableFieldName).append(",'!')").append(",").append(fieldName).append(") = 1");
            }
            sql.append(")");
            if (!it.hasNext()) continue;
            sql.append(" and ");
        }
    }

    @Override
    public ITempTableField getTempTableField() {
        return this.innerGetTempTableField();
    }

    private TempTableField innerGetTempTableField() {
        TempTableField tempTableField = new TempTableField();
        if (this.sortState.isLeafCashFlowItem()) {
            tempTableField.addTempTableItem(new TempTableFieldItem("CashItem.FID"));
        } else {
            TempTableFieldItem tempTableFieldItem = new TempTableFieldItem("CashItem.FID");
            tempTableField.addTempTableItem(tempTableFieldItem);
            this.tempTableValueInsertProcessor = new AcctCashTempTableValueInsertProcessor();
        }
        if (this.sortState.getSingleCashFlowAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleCashFlowAsstActItem()) {
                String tableAlias = this.validateTableAlias(itemType[0]);
                TempTableFieldItem fieldItem = null;
                if (!this.sortState.isForIncashFlow()) {
                    if (itemType[1] == "FLongNumber") {
                        fieldItem = new TempTableFieldItem("A_AsstType" + tableAlias + ".FLongNumber", new SqlParameter("FLongNumber", 12, NVARCHAR_250));
                        tempTableField.addTempTableItem(fieldItem);
                        continue;
                    }
                    fieldItem = new TempTableFieldItem("A_AsstType" + tableAlias + ".FNumber", new SqlParameter("FNumber", 12, NVARCHAR_80));
                    tempTableField.addTempTableItem(fieldItem);
                    continue;
                }
                if (this.sortState.isQueryAllInnerCompany()) continue;
                fieldItem = new TempTableFieldItem("InnerCompany.FNumber", new SqlParameter("FNumber", 12, NVARCHAR_80));
                tempTableField.addTempTableItem(fieldItem);
            }
        }
        return tempTableField;
    }

    @Override
    public void buildDivisionalVariableWherePart(Set nullSet, StringBuffer sql, List params) {
    }

    @Override
    public ITempTableValueInsertProcessor getTempTableValueInsertProcessor() {
        return this.tempTableValueInsertProcessor;
    }
}

