/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCash;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashTimeCondition;
import com.kingdee.eas.fi.rpt.batch.acctcash.IBaseAcctCashHandler;
import com.kingdee.eas.fi.rpt.batch.acctcash.ITimeCondition;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AcctCashHandler
implements IBaseAcctCashHandler {
    @Override
    public void checkIsNeedInitValue(Context ctx, Map companyNumber2StartPeriodMap, AcctCash acctCash) throws BOSException, EASBizException {
        PeriodInfo initPeriodInfo;
        if (StringUtils.isEmpty((String)acctCash.oppAccountString) && (initPeriodInfo = (PeriodInfo)companyNumber2StartPeriodMap.get(acctCash.fiOrgUnit)) != null) {
            AcctCashTimeCondition timeCondition = (AcctCashTimeCondition)acctCash.getTimeCondition();
            if (timeCondition.getStartYear() < initPeriodInfo.getPeriodYear()) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"30_AcctCashBatchCalculator", (Locale)ctx.getOriginLocale())});
            }
            if (timeCondition.getStartYear() == initPeriodInfo.getPeriodYear() && timeCondition.getStartPeriod() > 1 && timeCondition.getStartPeriod() < initPeriodInfo.getPeriodNumber() && (timeCondition.getStartPeriod() == timeCondition.getEndPeriod() || timeCondition.getEndPeriod() < initPeriodInfo.getPeriodNumber())) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"30_AcctCashBatchCalculator", (Locale)ctx.getOriginLocale())});
            }
            int startYear = timeCondition.getStartYear();
            int startPeriod = timeCondition.getStartPeriod();
            int initYear = initPeriodInfo.getPeriodYear();
            acctCash.needCombineInitValue = 1 == startPeriod && startYear == initYear;
        }
    }

    @Override
    public boolean dealTimeConditionForFillAcctCash(AcctCash acctCash, Map maxPeriodMap, ICalculateContextProvider contextProvider) throws ReportException {
        ITimeCondition timeCondition = acctCash.getTimeCondition();
        AcctCashTimeCondition acctCashTC = (AcctCashTimeCondition)timeCondition;
        int year = acctCashTC.getYear();
        int startPeriod = acctCashTC.getStartPeriod();
        int endPeriod = acctCashTC.getEndPeriod();
        int startYear = 0;
        int endYear = 0;
        PeriodCollection periods = acctCash.periods;
        boolean isMergeByFiscalPeriod = acctCash.isMergeByFiscalPeriod;
        int[] start = RPTDateUtil.getYearAndPeriod((boolean)true, (Map)maxPeriodMap, (int)year, (int)startPeriod, (String)acctCash.getSheetName(), (ReportVariables)contextProvider.getReportVariables(), (IReportPropertyAdapter)contextProvider.getReportAdapter(), (String)acctCash.company.getAccountPeriodType().getId().toString(), (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
        int[] end = RPTDateUtil.getYearAndPeriod((boolean)false, (Map)maxPeriodMap, (int)year, (int)endPeriod, (String)acctCash.getSheetName(), (ReportVariables)contextProvider.getReportVariables(), (IReportPropertyAdapter)contextProvider.getReportAdapter(), (String)acctCash.company.getAccountPeriodType().getId().toString(), (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
        if (start == null || end == null) {
            throw new ReportException(ReportException.PRERROR);
        }
        startYear = start[0];
        startPeriod = start[1];
        endYear = end[0];
        endPeriod = end[1];
        acctCashTC.setStartYear(startYear);
        acctCashTC.setStartPeriod(startPeriod);
        acctCashTC.setEndYear(endYear);
        acctCashTC.setEndPeriod(endPeriod);
        if (startYear > endYear || startYear == endYear && startPeriod > endPeriod) {
            acctCash.getParameter().setValue((Object)CslConstant.BGZERO);
            return false;
        }
        return true;
    }

    @Override
    public ITimeCondition getTimeConditionInstance() {
        return new AcctCashTimeCondition();
    }

    @Override
    public int getTimeConditionType() {
        return 1;
    }

    @Override
    public StringBuffer getTimeConditionSQL(ITimeCondition timeCondition, Map tcFieldNames, List params) {
        String periodYearFieldName = (String)tcFieldNames.get("FPERIODYEAR");
        String periodNumFieldName = (String)tcFieldNames.get("FPERIODNUMBER");
        StringBuffer sql = new StringBuffer();
        sql.append(" ( ");
        AcctCashTimeCondition acTimeCondition = (AcctCashTimeCondition)timeCondition;
        if (acTimeCondition.isSameYearAndPeriod()) {
            sql.append(periodYearFieldName).append(" = ? ");
            sql.append("and ");
            sql.append(periodNumFieldName).append(" = ? ");
            params.add(new Integer(acTimeCondition.getStartYear()));
            params.add(new Integer(acTimeCondition.getStartPeriod()));
        } else if (acTimeCondition.isSameYear()) {
            sql.append(periodYearFieldName).append(" = ? ");
            sql.append("and ");
            sql.append(periodNumFieldName).append(" >= ? ");
            sql.append("and ");
            sql.append(periodNumFieldName).append(" <= ? ");
            params.add(new Integer(acTimeCondition.getStartYear()));
            params.add(new Integer(acTimeCondition.getStartPeriod()));
            params.add(new Integer(acTimeCondition.getEndPeriod()));
        } else {
            sql.append("( ");
            sql.append(periodYearFieldName).append(" = ? and ");
            sql.append(periodNumFieldName).append(" >= ? ) ");
            sql.append("or ");
            sql.append("( ");
            sql.append(periodYearFieldName).append(" > ? and ");
            sql.append(periodYearFieldName).append(" < ? ) ");
            sql.append("or ");
            sql.append("( ");
            sql.append(periodYearFieldName).append(" = ? and ");
            sql.append(periodNumFieldName).append(" <= ? ) ");
            params.add(new Integer(acTimeCondition.getStartYear()));
            params.add(new Integer(acTimeCondition.getStartPeriod()));
            params.add(new Integer(acTimeCondition.getStartYear()));
            params.add(new Integer(acTimeCondition.getEndYear()));
            params.add(new Integer(acTimeCondition.getEndYear()));
            params.add(new Integer(acTimeCondition.getEndPeriod()));
        }
        sql.append(") ");
        return sql;
    }
}

