/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.AssistantGroupComparator;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCash;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashInitSortState;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AcctCashInitRegister
implements IBatchSQLSorterRegister {
    private List sortStateList = new LinkedList();
    private Map sortMap = new HashMap();
    private AcctCashInitSortState acctCashSortState = new AcctCashInitSortState();
    private boolean isCompanyChanges;
    private boolean isCurrencyChanges;
    private boolean isForIncashFlow;
    private static Comparator groupComparator = new AssistantGroupComparator();

    @Override
    public List getSortStates() {
        return this.sortStateList;
    }

    @Override
    public void register(IFormulaCalculator formula) {
        AcctCash acctCash = (AcctCash)formula;
        this.setSortState(acctCash);
        String key = this.acctCashSortState.generateKey();
        AcctCashInitSortState state = (AcctCashInitSortState)this.sortMap.get(key);
        if (state == null) {
            state = (AcctCashInitSortState)this.acctCashSortState.clone();
            state.setForIncashFlow(this.isForIncashFlow());
            state.setMaxCashItemLevel(acctCash.cashFlowItemList.size());
            state.setMaxCompanyLevel(acctCash.initCompanyList.size());
            this.sortStateList.add(state);
            this.sortMap.put(key, state);
        } else {
            if (state.getMaxCashItemLevel() < acctCash.cashFlowItemList.size()) {
                state.setMaxCashItemLevel(acctCash.cashFlowItemList.size());
            }
            if (state.getMaxCompanyLevel() < acctCash.initCompanyList.size()) {
                state.setMaxCompanyLevel(acctCash.initCompanyList.size());
            }
        }
        state.addFormula(formula);
    }

    private void setSortState(AcctCash acctCash) {
        this.acctCashSortState.reset();
        if (!this.isCompanyChanges) {
            this.acctCashSortState.setCompanyIDList(acctCash.initCompanyList);
            this.acctCashSortState.setCompanyNumber(acctCash.fiOrgUnit);
        }
        if (acctCash.cashTypeEnum == null || !CashTypeEnum.AS.equals((Object)acctCash.cashTypeEnum) && !CashTypeEnum.AZ.equals((Object)acctCash.cashTypeEnum)) {
            if (this.isCurrencyChanges) {
                this.acctCashSortState.setNeedCurrency(true);
            } else {
                this.acctCashSortState.setNeedCurrency(false);
                this.acctCashSortState.setCurrencyNumber(acctCash.currencyNumber);
            }
        }
        this.acctCashSortState.setLeafCashFlowItem(acctCash.cashFlowItemInfo.isIsLeaf());
        this.acctCashSortState.setCashFlowDirection(acctCash.cashFlowItemInfo.getDirection());
        if (acctCash.cashFlowItem.hasItem() && acctCash.sorttedCashFlowAsstActTypeList != null) {
            List assistantItemExtList;
            ArrayList<String[]> numberList = null;
            ArrayList<String[]> singleNumberList = null;
            HashMap<String, AssistantGroup[]> groupMap = null;
            AcctountAsstItemParser.AccountAsstItem asstItem = acctCash.cashFlowItem.getAccountAsstItem();
            this.acctCashSortState.setCashFlowAsstActTypeList(acctCash.sorttedCashFlowAsstActTypeList);
            if (asstItem != null && asstItem.asstItems.length > 0 && asstItem.asstItems[0].startNumber != null && (assistantItemExtList = acctCash.assistantItemExtList) != null) {
                int size = assistantItemExtList.size();
                for (int i = 0; i < size; ++i) {
                    AssistantItemExt assistantItem = (AssistantItemExt)assistantItemExtList.get(i);
                    AsstActType itemType = assistantItem.itemType;
                    if (assistantItem != null && assistantItem.startItem != null && !StringUtils.isEmpty((String)assistantItem.startItem.number) && assistantItem.endItem != null && !StringUtils.isEmpty((String)assistantItem.endItem.number)) {
                        String endNumber;
                        String tableName = itemType.realtionDataObject;
                        boolean isGeneralasstacttype = RptUtil.isUseLongNumber(itemType.useLongNumber, tableName);
                        String startNumber = isGeneralasstacttype ? assistantItem.startItem.longNumber : assistantItem.startItem.number;
                        String string = endNumber = isGeneralasstacttype ? assistantItem.endItem.longNumber : assistantItem.endItem.number;
                        if (startNumber.equals(endNumber)) {
                            if (singleNumberList == null) {
                                singleNumberList = new ArrayList<String[]>();
                            }
                            singleNumberList.add(new String[]{itemType.number, isGeneralasstacttype ? "FLongNumber" : "FNumber"});
                        } else {
                            if (numberList == null) {
                                numberList = new ArrayList<String[]>();
                            }
                            numberList.add(new String[]{itemType.number, startNumber, endNumber, isGeneralasstacttype ? "FLongNumber" : "FNumber"});
                        }
                    }
                    if (assistantItem.getGroups() != null && assistantItem.getGroups().length > 0) {
                        if (groupMap == null) {
                            groupMap = new HashMap<String, AssistantGroup[]>();
                        }
                        AssistantGroup[] groups = assistantItem.getGroups();
                        Arrays.sort(groups, groupComparator);
                        groupMap.put(itemType.number, groups);
                    }
                    this.acctCashSortState.setSingleCashFlowAsstActItem(singleNumberList);
                    this.acctCashSortState.setCashFlowAsstActItems(numberList);
                    this.acctCashSortState.setCashFlowGroupMap(groupMap);
                }
            }
        }
    }

    public boolean isCompanyChanges() {
        return this.isCompanyChanges;
    }

    public void setCompanyChanges(boolean isCompanyChanges) {
        this.isCompanyChanges = isCompanyChanges;
    }

    public boolean isCurrencyChanges() {
        return this.isCurrencyChanges;
    }

    public void setCurrencyChanges(boolean isCurrencyChanges) {
        this.isCurrencyChanges = isCurrencyChanges;
    }

    public boolean isForIncashFlow() {
        return this.isForIncashFlow;
    }

    public void setForIncashFlow(boolean isForIncashFlow) {
        this.isForIncashFlow = isForIncashFlow;
    }
}

