/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashHandler;
import com.kingdee.eas.fi.rpt.batch.acctcash.IBaseAcctCashHandler;
import com.kingdee.eas.fi.rpt.batch.acctcash.ITimeCondition;
import com.kingdee.util.StringUtils;
import java.util.Map;

public class AcctCashTimeCondition
implements ITimeCondition {
    private static final int NOT_NUMBER = -999;
    private int year;
    private int startPeriod;
    private int endPeriod;
    private int startYear;
    private int endYear;
    private final IBaseAcctCashHandler conditionHandler = new AcctCashHandler();

    @Override
    public boolean isExistAnyNull() {
        return this.year == -999 || this.startPeriod == -999 || this.endPeriod == -999;
    }

    private int initNumberParam(Variant variant) {
        if (variant == null) {
            return -999;
        }
        if (variant.getValue() instanceof Number) {
            return ((Number)variant.getValue()).intValue();
        }
        try {
            String value = variant.getValue().toString();
            return StringUtils.isEmpty((String)value) ? 0 : Integer.parseInt(value);
        }
        catch (Exception ex) {
            return -999;
        }
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void init(Map timeVals) {
        Variant year = (Variant)timeVals.get("name.year");
        Variant startPeriod = (Variant)timeVals.get("name.startPeriod");
        Variant endPeriod = (Variant)timeVals.get("name.endPeriod");
        this.year = this.initNumberParam(year);
        this.startPeriod = this.initNumberParam(startPeriod);
        this.endPeriod = this.initNumberParam(endPeriod);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AcctCashTimeCondition newInst = new AcctCashTimeCondition();
        newInst.setStartPeriod(this.startPeriod);
        newInst.setEndPeriod(this.endPeriod);
        newInst.setStartYear(this.startYear);
        newInst.setEndYear(this.endYear);
        newInst.setYear(this.year);
        return newInst;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getStartPeriod() {
        return this.startPeriod;
    }

    public void setStartPeriod(int startPeriod) {
        this.startPeriod = startPeriod;
    }

    public int getEndPeriod() {
        return this.endPeriod;
    }

    public void setEndPeriod(int endPeriod) {
        this.endPeriod = endPeriod;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    @Override
    public void reset() {
        this.year = 0;
        this.startPeriod = 0;
        this.endPeriod = 0;
        this.startYear = 0;
        this.endYear = 0;
    }

    public boolean isSameYearAndPeriod() {
        return this.startYear == this.endYear && this.startPeriod == this.endPeriod;
    }

    public boolean isSameYear() {
        return this.startYear == this.endYear;
    }

    @Override
    public int whatSame() {
        if (this.isSameYearAndPeriod()) {
            return 2;
        }
        if (this.isSameYear()) {
            return 1;
        }
        return -1;
    }

    @Override
    public ITimeCondition getNewInstance() {
        return new AcctCashTimeCondition();
    }

    @Override
    public IBaseAcctCashHandler getConditionHandler() {
        return this.conditionHandler;
    }
}

