/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IMultiOrgContext;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AcctextAccrualSortState
implements IBatchSQLSortState,
IMultiOrgContext {
    private String accountTableID;
    private List formulaList = new LinkedList();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private List asstActTypeList;
    private String userDefineFilter;
    private boolean includingUnPosted;
    private List asstActItems;
    private GregorianCalendar startDate;
    private GregorianCalendar endDate;
    private PeriodInfo endPeriod;
    private String[] accounts;
    private String singleCompanyID;
    private String unionCompanyID;
    private boolean isNeedCurrency;
    private String singleCurrencyID;
    private Integer DC;
    private List singleAsstActItem;
    private StringBuffer temp = new StringBuffer();
    private boolean isAccrual;
    protected OrgType rptOrgType;

    @Override
    public void addFormula(IFormulaCalculator acctext) {
        this.formulaList.add(acctext);
    }

    @Override
    public List getFormulaList() {
        return this.formulaList;
    }

    @Override
    public Object clone() {
        AcctextAccrualSortState newOne = new AcctextAccrualSortState();
        newOne.asstActTypeList = this.asstActTypeList;
        newOne.userDefineFilter = this.userDefineFilter;
        newOne.includingUnPosted = this.includingUnPosted;
        newOne.asstActItems = this.asstActItems;
        newOne.startDate = this.startDate;
        newOne.endDate = this.endDate;
        newOne.accounts = this.accounts;
        newOne.singleCompanyID = this.singleCompanyID;
        newOne.unionCompanyID = this.unionCompanyID;
        newOne.singleCurrencyID = this.singleCurrencyID;
        newOne.DC = this.DC;
        newOne.singleAsstActItem = this.singleAsstActItem;
        newOne.accountTableID = this.accountTableID;
        newOne.isNeedCurrency = this.isNeedCurrency;
        newOne.isAccrual = this.isAccrual;
        newOne.endPeriod = this.endPeriod;
        newOne.rptOrgType = this.rptOrgType;
        return newOne;
    }

    @Override
    public void reset() {
        this.asstActTypeList = null;
        this.userDefineFilter = null;
        this.includingUnPosted = false;
        this.asstActItems = null;
        this.startDate = null;
        this.endDate = null;
        this.accounts = null;
        this.singleCompanyID = null;
        this.unionCompanyID = null;
        this.singleCurrencyID = null;
        this.DC = null;
        this.singleAsstActItem = null;
        this.accountTableID = null;
        this.isNeedCurrency = false;
        this.isAccrual = false;
        this.endPeriod = null;
    }

    @Override
    public String generateKey() {
        this.temp.setLength(0);
        this.temp.append("[").append(this.rptOrgType != null ? this.rptOrgType.getValue() + "" : "").append("]");
        this.temp.append("[").append(this.includingUnPosted ? "1" : "0").append("]");
        this.temp.append("[").append(this.isNeedCurrency ? "1" : "0").append("]");
        if (this.isAccrual) {
            this.temp.append("[").append(this.DC).append("]");
            this.temp.append("[").append(dateFormat.format(this.startDate.getTime())).append("]");
        } else {
            this.temp.append("[").append(this.endPeriod == null ? "" : this.endPeriod.getId().toString()).append("]");
        }
        this.temp.append("[").append(dateFormat.format(this.endDate.getTime())).append("]");
        this.temp.append("[").append(this.singleCompanyID == null ? "" : this.singleCompanyID).append("]");
        this.temp.append("[").append(this.unionCompanyID == null ? "" : this.unionCompanyID).append("]");
        this.temp.append("[").append(this.singleCurrencyID == null ? "" : this.singleCurrencyID).append("]");
        this.temp.append("[").append(this.userDefineFilter == null ? "" : this.userDefineFilter).append("]");
        if (this.accounts == null) {
            this.temp.append("[]");
        } else {
            this.temp.append("[").append(this.accounts[0]).append(":").append(this.accounts[1]).append("]");
        }
        if (this.asstActTypeList != null) {
            for (AsstActType itemType : this.asstActTypeList) {
                this.temp.append("[").append(itemType.number).append("]");
            }
            if (this.singleAsstActItem != null) {
                for (String[] asstItems : this.singleAsstActItem) {
                    this.temp.append("[").append(asstItems[0]).append("|").append(asstItems[1]).append("]");
                }
            }
            if (this.asstActItems != null) {
                for (String[] asstItems : this.asstActItems) {
                    this.temp.append("[").append(asstItems[1]).append(":").append(asstItems[2]).append("|").append(asstItems[3]).append("]");
                }
            }
        }
        return this.temp.toString();
    }

    public List getAsstActTypeList() {
        return this.asstActTypeList;
    }

    public String getUserDefineFilter() {
        return this.userDefineFilter;
    }

    public boolean isIncludingUnPosted() {
        return this.includingUnPosted;
    }

    public List getAsstActItems() {
        return this.asstActItems;
    }

    public GregorianCalendar getStartDate() {
        return this.startDate;
    }

    public GregorianCalendar getEndDate() {
        return this.endDate;
    }

    public String[] getAccounts() {
        return this.accounts;
    }

    public String getSingleCompanyID() {
        return this.singleCompanyID;
    }

    public String getSingleCurrencyID() {
        return this.singleCurrencyID;
    }

    public String getSingleAccountTableID() {
        return this.accountTableID;
    }

    public Integer getDC() {
        return this.DC;
    }

    public void setAsstActTypeList(List asstActTypeList) {
        this.asstActTypeList = asstActTypeList;
    }

    public void setUserDefineFilter(String userDefineFilter) {
        this.userDefineFilter = this.reviseFilter(userDefineFilter);
    }

    private String reviseFilter(String filter) {
        if (StringUtils.isEmpty((String)filter)) {
            return null;
        }
        filter = filter.replaceAll("VoucherNumber", "voucher.FNumber").replaceAll("AttachementNumber", "voucher.FAttachments").replaceAll("CountAmount", "voucher.FLocalDebitAmount").replaceAll("RecNum", "voucher.FEntryCount").replaceAll("RecSrcNumber", "voucherEntry.FOriginalAmount").replaceAll("VoucherType", "VoucherType.FNumber").replaceAll("RefInformation", "ISNULL(voucher.FDescription,'NULL')").replaceAll("Summary", "ISNULL(voucherEntry.FDescription,'NULL')");
        return filter;
    }

    public String getAccountTableID() {
        return this.accountTableID;
    }

    public void setAccountTableID(String accountTableID) {
        this.accountTableID = accountTableID;
    }

    public void setFormulaList(List formulaList) {
        this.formulaList = formulaList;
    }

    public void setIncludingUnPosted(boolean includingUnPosted) {
        this.includingUnPosted = includingUnPosted;
    }

    public void setAsstActItems(List asstActItems) {
        this.asstActItems = asstActItems;
    }

    public void setStartDate(GregorianCalendar startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(GregorianCalendar endDate) {
        this.endDate = endDate;
    }

    public void setAccounts(String[] accounts) {
        this.accounts = accounts;
    }

    public void setSingleCompanyID(String singleCompanyNumber) {
        this.singleCompanyID = singleCompanyNumber;
    }

    public void setSingleCurrencyID(String singleCurrencyID) {
        this.singleCurrencyID = singleCurrencyID;
    }

    public void setDC(Integer dc) {
        this.DC = dc;
    }

    public boolean isNeedCurrency() {
        return this.isNeedCurrency;
    }

    public void setNeedCurrency(boolean isNeedCurrency) {
        this.isNeedCurrency = isNeedCurrency;
    }

    public List getSingleAsstActItem() {
        return this.singleAsstActItem;
    }

    public void setSingleAsstActItem(List singleAsstActItem) {
        this.singleAsstActItem = singleAsstActItem;
    }

    public String getUnionCompanyLongNumber() {
        return this.unionCompanyID;
    }

    public void setUnionCompanyLongNumber(String unionCompanyID) {
        this.unionCompanyID = unionCompanyID;
    }

    public PeriodInfo getEndPeriod() {
        return this.endPeriod;
    }

    public void setEndPeriod(PeriodInfo endPeriod) {
        this.endPeriod = endPeriod;
    }

    public boolean isAccrual() {
        return this.isAccrual;
    }

    public void setAccrual(boolean isAccrual) {
        this.isAccrual = isAccrual;
    }

    @Override
    public void setState(IFormulaCalculator formula) {
    }

    @Override
    public void setContext(Map context) {
    }

    @Override
    public OrgType getRptOrgType() {
        return this.rptOrgType;
    }

    @Override
    public void setRptOrgType(OrgType rptOrgType) {
        this.rptOrgType = rptOrgType;
    }
}

