/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctitem;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.acctitem.AcctItem;
import com.kingdee.eas.fi.rpt.batch.acctitem.AcctItemBatchProcessor;
import com.kingdee.eas.fi.rpt.batch.acctitem.AcctItemMapFieldSortState;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctItemBatchCalculator
extends AbstractCalculator {
    public static final Logger logger = Logger.getLogger(AcctItemBatchCalculator.class);
    private static final String ACCTITEM_SORT_STATE = "com.kingdee.eas.fi.rpt.batch.acctitem.AcctItemSortState";
    private static final String ACCTITEM_MAP_FIELD_SORT_STATE = "com.kingdee.eas.fi.rpt.batch.acctitem.AcctItemMapFieldSortState";
    private IBatchSQLSorterRegister sortRegister;
    private IBatchSQLSorterRegister mappedFieldSortRegister;
    private AcctItemBatchProcessor batchProcessor;
    public static final int NORMAL = 1;
    public static final int CHECK_ITEM = 2;
    public static final int CHECK_ACCTITEM = 3;
    int calcType = 1;
    private Set orgTreeNumberSet;
    private List adjustedItemList;
    private Map dataCollectPermissionMap;
    private Map orgTreeMap;
    private boolean isSupport13Period = false;
    private boolean isSupportOtherDS = false;
    public PeriodCollection periods = null;
    public boolean isMergeByFiscalPeriod = false;
    private int acctItemMaxSqlParamSize = 100;
    private boolean isCheckPermission = true;
    private boolean isParamadjustSeparate;
    private static final String ACCTITEM_USE_TEMP_TABLE_SCHEME = "ACCTITEM_USE_TEMP_TABLE_SCHEME";
    private static final String ACCTITEM_USE_TEMP_TABLE_SCHEME_DEBUG = "ACCTITEM_USE_TEMP_TABLE_SCHEME_DEBUG";
    private boolean isUseTempTableScheme;
    private boolean isTempTableSchemeDebug;

    public AcctItemBatchCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
        boolean[] values = CSLParamUtil.batchGetParam((Context)this.serverContext, (String[])new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period", "GR_CSL_SupportOtherDS", "GR_CSL_ChkUnitPermissionWhenCalc", "GR_CSL_AdjustSeparate"});
        try {
            Map paramsMap = RptUtil.getCslParams(this.serverContext, new String[]{"KEY_CSLPARAM_ACCTITEM_BATCH_SIZE", ACCTITEM_USE_TEMP_TABLE_SCHEME, ACCTITEM_USE_TEMP_TABLE_SCHEME_DEBUG});
            if (paramsMap.get("KEY_CSLPARAM_ACCTITEM_BATCH_SIZE") != null) {
                this.acctItemMaxSqlParamSize = Integer.valueOf((String)paramsMap.get("KEY_CSLPARAM_ACCTITEM_BATCH_SIZE"));
            }
            this.isUseTempTableScheme = RptUtil.isTrue(paramsMap.get(ACCTITEM_USE_TEMP_TABLE_SCHEME));
            this.isTempTableSchemeDebug = RptUtil.isTrue(paramsMap.get(ACCTITEM_USE_TEMP_TABLE_SCHEME_DEBUG));
        }
        catch (Exception e) {
            logger.error((Object)"getCslParams", (Throwable)e);
        }
        this.isMergeByFiscalPeriod = values[0];
        if (this.isMergeByFiscalPeriod) {
            this.periods = FiscalPeriodHelper.initFormualFiscalPeriods((Context)this.serverContext, (ICalculateContextProvider)context);
        }
        this.isSupport13Period = values[1];
        this.isSupportOtherDS = values[2];
        this.isCheckPermission = values[3];
        this.isParamadjustSeparate = values[4];
    }

    private void addToAcctItemFromToMap(Map acctItemMap, AcctItem.ItemFieldMapped ItemFieldMapped2, AcctItemMapFieldSortState sortState) {
        if (sortState.isSameItemNumber()) {
            List itemList = (List)acctItemMap.get(ItemFieldMapped2.number);
            for (AcctItem acctItem : itemList) {
                acctItem.itemFromToList.add(ItemFieldMapped2);
            }
        } else {
            for (Map.Entry entry : acctItemMap.entrySet()) {
                List itemList = (List)entry.getValue();
                for (AcctItem acctItem : itemList) {
                    if (ItemFieldMapped2.number.compareTo(acctItem.startItemNumber) < 0 || ItemFieldMapped2.number.compareTo(acctItem.endItemNumber) > 0) continue;
                    acctItem.itemFromToList.add(ItemFieldMapped2);
                }
            }
        }
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        this.executeCalculate();
    }

    @Override
    protected void clear() {
    }

    private void executeCalculate() throws BOSException, EASBizException {
        logger.info((Object)("acctItem formula size: " + this.getFormulaCalculatorParameterList().size()));
        long startCalculate = System.currentTimeMillis();
        this.batchHelper.setTempTableSchemeDebug(this.isTempTableSchemeDebug);
        this.batchProcessor = new AcctItemBatchProcessor(this.isUseTempTableScheme);
        this.batchProcessor.setMaxSQLVaribleSize(this.getMaxSqlParamSize());
        this.batchHelper.batchCalculateBigDecimalBySorter(this.batchProcessor, this.sortRegister);
        logger.info((Object)("acctItem calculate time: " + new Long(System.currentTimeMillis() - startCalculate)));
    }

    private int getMaxSqlParamSize() {
        return this.acctItemMaxSqlParamSize;
    }

    private int getAcctItemMaxSqlParamSize(Context ctx) {
        int size = 1000;
        if (ctx == null) {
            return size;
        }
        String sql = " Select FValue From T_Csl_CslParam where FKey = ? ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{"KEY_CSLPARAM_ACCTITEM_BATCH_SIZE"});
            if (rowSet.next()) {
                size = rowSet.getInt("FValue");
            }
        }
        catch (Exception e) {
            size = 1000;
        }
        return size;
    }

    public int getCalcType() {
        return this.calcType;
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.initSortRegister();
        this.initAcctItem(params);
        this.initOrgBound();
        this.QueryMapField();
        this.submitFormula();
    }

    private void initAcctItem(SortedParameterArray params) {
        this.orgTreeNumberSet = new HashSet();
        this.adjustedItemList = new ArrayList();
        this.dataCollectPermissionMap = new HashMap();
        this.orgTreeMap = new HashMap();
        int count = params.size();
        for (int i = 0; i < count; ++i) {
            AcctItem acctItem = new AcctItem(params.getParameter(i), this.batchHelper, this.calcType, this.periods, this.isMergeByFiscalPeriod);
            acctItem.setDataCollectPermissionMap(this.dataCollectPermissionMap);
            acctItem.setSupportOtherDS(this.isSupportOtherDS);
            acctItem.setOrgTreeMap(this.orgTreeMap);
            acctItem.setSupport13Period(this.isSupport13Period);
            acctItem.setCheckPermission(this.isCheckPermission);
            acctItem.setParamadjustSeparate(this.isParamadjustSeparate);
            acctItem.initFormulaParam();
            if (acctItem.isException()) {
                this.addToErrorList(acctItem);
                continue;
            }
            if (!acctItem.isNeedCalculate) continue;
            List formulaCalculatorParameterList = this.getFormulaCalculatorParameterList();
            if (!StringUtils.isEmpty((String)acctItem.orgUnitNumbers) && acctItem.orgUnitNumbers.split("\\||\\,|\\;").length > 1) {
                String[] orgUnitNumbers = acctItem.orgUnitNumbers.split("\\||\\,|\\;");
                int length = orgUnitNumbers.length;
                for (int x = 0; x < length; ++x) {
                    String orgNumber;
                    acctItem.orgUnitNumbers = orgNumber = orgUnitNumbers[x];
                    if (acctItem.isAdjusted) {
                        this.adjustedItemList.add(acctItem);
                    }
                    formulaCalculatorParameterList.add(acctItem);
                    if (x >= length - 1) continue;
                    acctItem = acctItem.copy();
                }
            } else {
                if (acctItem.isAdjusted) {
                    this.adjustedItemList.add(acctItem);
                }
                formulaCalculatorParameterList.add(acctItem);
            }
            this.orgTreeNumberSet.add(acctItem.orgBoundNumber);
        }
    }

    private void initOrgBound() throws BOSException {
        if (this.orgTreeNumberSet.size() == 0) {
            return;
        }
        HashMap<String, OrgTreeCollection> orgBoundMap = new HashMap<String, OrgTreeCollection>();
        StringBuffer kql = new StringBuffer();
        kql.append("SELECT FID, FNumber, FStartDate, FEndDate FROM T_ORG_Tree \n");
        kql.append(" WHERE FNumber IN ").append(this.batchHelper.createInSql(this.orgTreeNumberSet.iterator()));
        kql.append(" AND (FStatus IN (1, 2)) ORDER BY FstartDate DESC, FendDate DESC  \n");
        IRowSet row = DbUtil.executeQuery((Context)this.serverContext, (String)kql.toString());
        try {
            while (row.next()) {
                OrgTreeInfo treeInfo = new OrgTreeInfo();
                treeInfo.setId(BOSUuid.read((String)row.getString("FID")));
                String number = row.getString("FNumber");
                treeInfo.setNumber(number);
                treeInfo.setStartDate(row.getTimestamp("FStartDate"));
                treeInfo.setEndDate(row.getTimestamp("FEndDate"));
                OrgTreeCollection collection = (OrgTreeCollection)orgBoundMap.get(number);
                if (collection == null) {
                    collection = new OrgTreeCollection();
                    orgBoundMap.put(number, collection);
                }
                collection.add(treeInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.initOrgTreeByRptDate(orgBoundMap);
    }

    public void initOrgTreeByRptDate(Map orgBoundMap) {
        List formulaList = this.getFormulaCalculatorParameterList();
        Iterator iterator = formulaList.iterator();
        while (iterator.hasNext()) {
            AcctItem acctItem = (AcctItem)iterator.next();
            if (acctItem.int_periodType == 0) {
                acctItem.int_periodType = 3;
            }
            RptPeriodTypeEnum periodType = RptPeriodTypeEnum.getEnum((int)acctItem.int_periodType);
            OrgTreeCollection orgTreeCL = (OrgTreeCollection)orgBoundMap.get(acctItem.orgBoundNumber);
            if (orgTreeCL != null && !orgTreeCL.isEmpty()) {
                int startPeriod = acctItem.startPeriod;
                int endPeriod = acctItem.endPeriod;
                for (int iYear = acctItem.endYear; iYear >= acctItem.startYear; --iYear) {
                    if (acctItem.startYear != acctItem.endYear) {
                        Map adjustPeriodMap = this.adjustPeriod(acctItem, iYear, periodType, this.isSupport13Period);
                        startPeriod = (Integer)adjustPeriodMap.get("startPeriod");
                        endPeriod = (Integer)adjustPeriodMap.get("endPeriod");
                    }
                    this.findOrgTreeByPeriod(orgTreeCL, acctItem, periodType, iYear, startPeriod, endPeriod);
                }
                if (acctItem.orgBoundIDSet.size() != 0) continue;
                acctItem.getParameter().setValue((Object)CslConstant.BGZERO);
                iterator.remove();
                continue;
            }
            acctItem.getParameter().setValue((Object)CslConstant.BGZERO);
            iterator.remove();
        }
    }

    private Map adjustPeriod(AcctItem acctItem, int year, RptPeriodTypeEnum periodType, boolean isSupport13Period) {
        HashMap<String, Integer> adjustPeriodMap = new HashMap<String, Integer>();
        int startPeriod = 0;
        int endPeriod = 0;
        int maxPeriodNum = 0;
        maxPeriodNum = this.periods != null && this.periods.size() > 0 ? FiscalPeriodHelper.getMaxPeriodNumber((PeriodCollection)this.periods, (int)year) : RPTDate13Util.getPeriods((int)year, (RptPeriodTypeEnum)periodType, (boolean)isSupport13Period);
        if (year == acctItem.endYear) {
            startPeriod = 1;
            endPeriod = acctItem.endPeriod;
        } else if (year == acctItem.startYear) {
            startPeriod = acctItem.startPeriod;
            endPeriod = maxPeriodNum;
        } else {
            startPeriod = 1;
            endPeriod = maxPeriodNum;
        }
        adjustPeriodMap.put("startPeriod", new Integer(startPeriod));
        adjustPeriodMap.put("endPeriod", new Integer(endPeriod));
        return adjustPeriodMap;
    }

    private void findOrgTreeByPeriod(OrgTreeCollection orgTreeCL, AcctItem acctItem, RptPeriodTypeEnum periodType, int year, int startPeriod, int endPeriod) {
        block0: for (int iPeriod = endPeriod; iPeriod >= startPeriod; --iPeriod) {
            Date curDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.periods, (int)year, (int)iPeriod, (RptPeriodTypeEnum)periodType, (boolean)this.isMergeByFiscalPeriod);
            for (int i = 0; curDate != null && i < orgTreeCL.size(); ++i) {
                String strOrgTreeID = orgTreeCL.get(i).getId().toString();
                Timestamp sDate = orgTreeCL.get(i).getStartDate();
                if (sDate.compareTo(new Timestamp(curDate.getTime())) > 0) continue;
                acctItem.orgBoundIDSet.add(strOrgTreeID);
                continue block0;
            }
        }
    }

    private void initSortRegister() {
        this.sortRegister = new BatchSQLSorterRegister(new HashMap(), ACCTITEM_SORT_STATE);
        this.mappedFieldSortRegister = new BatchSQLSorterRegister(new HashMap(), ACCTITEM_MAP_FIELD_SORT_STATE);
    }

    private void QueryMapField() throws BOSException {
        for (AcctItem acctItem : this.getFormulaCalculatorParameterList()) {
            this.mappedFieldSortRegister.register(acctItem);
        }
        StringBuffer kqlBuffer = new StringBuffer();
        int batchSize = this.getMaxSqlParamSize();
        ArrayList<String> paramList = new ArrayList<String>();
        kqlBuffer.append("SELECT mapped.FTableName tableName,mapped.FFieldName fieldName,item.FNumber number     \n").append(" FROM T_CSL_Rptitem item INNER JOIN T_CSL_ItemFieldMapped mapped ON item.FID = mapped.FItemID   \n").append(" WHERE item.FIsfreezed = 0 AND (                        \n");
        boolean isAddOr = false;
        StringBuffer variableBuffer = new StringBuffer();
        for (AcctItemMapFieldSortState sortState : this.mappedFieldSortRegister.getSortStates()) {
            HashMap<String, ArrayList<AcctItem>> acctItemMap = new HashMap<String, ArrayList<AcctItem>>();
            Iterator iter = sortState.getFormulaList().iterator();
            while (iter.hasNext()) {
                AcctItem acctItem = (AcctItem)iter.next();
                String key = acctItem.startItemNumber;
                if (!sortState.isSameItemNumber()) {
                    key = key + "|" + acctItem.endItemNumber;
                }
                boolean hasContain = true;
                ArrayList<AcctItem> itemList = (ArrayList<AcctItem>)acctItemMap.get(key);
                if (acctItemMap.get(key) == null) {
                    hasContain = false;
                    itemList = new ArrayList<AcctItem>();
                    acctItemMap.put(key, itemList);
                }
                itemList.add(acctItem);
                if (!hasContain) {
                    if (isAddOr) {
                        variableBuffer.append(" OR ");
                    }
                    if (!sortState.isSameItemNumber()) {
                        variableBuffer.append(" (item.FNumber >= ? AND item.FNumber <= ?) \n");
                        paramList.add(acctItem.startItemNumber);
                        paramList.add(acctItem.endItemNumber);
                    } else {
                        variableBuffer.append(" item.FNumber = ?  \n");
                        paramList.add(acctItem.startItemNumber);
                    }
                    isAddOr = true;
                }
                if (paramList.size() <= batchSize && iter.hasNext()) continue;
                String executeKql = kqlBuffer.toString() + variableBuffer.toString() + ")";
                IRowSet rowSet = DbUtil.executeQuery((Context)this.serverContext, (String)executeKql, (Object[])paramList.toArray());
                try {
                    while (rowSet.next()) {
                        String tableName = rowSet.getObject("tableName").toString();
                        String fieldName = rowSet.getObject("fieldName").toString();
                        String number = rowSet.getObject("number").toString();
                        AcctItem.ItemFieldMapped itemFieldMapped = acctItem.new AcctItem.ItemFieldMapped();
                        itemFieldMapped.number = number;
                        itemFieldMapped.tableName = tableName;
                        itemFieldMapped.fieldName = fieldName;
                        this.addToAcctItemFromToMap(acctItemMap, itemFieldMapped, sortState);
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                variableBuffer.delete(0, variableBuffer.length());
                isAddOr = false;
                acctItemMap.clear();
                paramList.clear();
            }
        }
    }

    public void setCalcType(int calcType) {
        this.calcType = calcType;
    }

    private void submitFormula() {
        for (AcctItem acctItem : this.getFormulaCalculatorParameterList()) {
            HashSet<String> nullFieldsSet = new HashSet<String>();
            if (StringUtils.isEmpty((String)acctItem.sourceCurrencyNumber)) {
                nullFieldsSet.add("sourceCurrencyNumber");
            }
            acctItem.setNullFields(nullFieldsSet);
            this.sortRegister.register(acctItem);
        }
    }
}

