/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctitem;

import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.acctitem.AcctItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AcctItemSortState
implements IBatchSQLSortState {
    private Map context;
    private List fromulaList = new ArrayList();
    private List tableList;
    private Set orgBoundIDSet;
    private Set baseOrgTreeIdSet;
    private int startYear = 0;
    private int startPeriod = 0;
    private int endYear = 0;
    private int endPeriod = 0;
    private int periodType;
    private int[] dataSourceArray;
    private boolean isGroupUnCommited;
    private boolean isAdjusted;
    private boolean isCaliber;
    private String dataCollectNumber;
    private String mergeSchmNum;
    private boolean isParamadjustSeparate;
    private String currencyNumber;
    private String sourceCurrencyNumber;
    private String orgNumbers;
    private boolean isUseTempTableScheme;

    @Override
    public void addFormula(IFormulaCalculator formula) {
        this.fromulaList.add(formula);
    }

    @Override
    public String generateKey() {
        StringBuffer keyBuffer = new StringBuffer();
        keyBuffer.append(this.buildSortKey(this.tableList));
        ArrayList orgBoundIdList = new ArrayList(this.orgBoundIDSet);
        keyBuffer.append(this.buildSortKey(orgBoundIdList));
        ArrayList baseOrgTreeIdList = new ArrayList(this.baseOrgTreeIdSet);
        keyBuffer.append(this.buildSortKey(baseOrgTreeIdList));
        keyBuffer.append("[").append(this.startYear).append("]");
        keyBuffer.append("[").append(this.startPeriod).append("]");
        keyBuffer.append("[").append(this.endYear).append("]");
        keyBuffer.append("[").append(this.endPeriod).append("]");
        keyBuffer.append("[").append(this.periodType).append("]");
        if (this.dataSourceArray.length > 1) {
            keyBuffer.append("[");
            for (int i = 0; i < this.dataSourceArray.length; ++i) {
                keyBuffer.append(this.dataSourceArray[i]).append("|");
            }
            keyBuffer.append("]");
        } else if (this.dataSourceArray[0] == 1 || this.dataSourceArray[0] == 7) {
            keyBuffer.append("[").append(1).append("|").append(7).append("]");
        } else if (this.dataSourceArray[0] == 4) {
            keyBuffer.append("[").append(4).append("]");
        } else {
            keyBuffer.append("[").append(this.dataSourceArray[0]).append("]");
        }
        if (this.dataSourceArray[0] != 4) {
            keyBuffer.append("[").append(this.isGroupUnCommited ? "1" : "0").append("]");
        }
        keyBuffer.append("[").append(this.isCaliber || this.isAdjusted ? "1" : "0").append("]");
        keyBuffer.append("[").append(this.dataCollectNumber).append("]");
        keyBuffer.append("[").append(this.mergeSchmNum).append("]");
        if (this.isUseTempTableScheme() && !StringUtils.isEmpty((String)this.currencyNumber)) {
            keyBuffer.append("[").append(this.currencyNumber).append("]");
        }
        if (this.isUseTempTableScheme() && !StringUtils.isEmpty((String)this.orgNumbers) && this.orgNumbers.indexOf("\\||\\,|\\;") < 0) {
            keyBuffer.append("[").append(this.orgNumbers).append("]");
        }
        return keyBuffer.toString();
    }

    @Override
    public List getFormulaList() {
        return this.fromulaList;
    }

    @Override
    public void reset() {
        this.tableList = null;
        this.orgBoundIDSet = null;
        this.baseOrgTreeIdSet = null;
        this.startYear = 0;
        this.startPeriod = 0;
        this.endYear = 0;
        this.endPeriod = 0;
        this.periodType = 0;
        this.dataSourceArray = null;
        this.isGroupUnCommited = true;
        this.isAdjusted = false;
        this.isCaliber = false;
        this.dataCollectNumber = null;
        this.mergeSchmNum = null;
        this.isParamadjustSeparate = false;
        this.currencyNumber = null;
        this.sourceCurrencyNumber = null;
    }

    @Override
    public Object clone() {
        AcctItemSortState acctItemSortState = new AcctItemSortState();
        acctItemSortState.tableList = this.tableList;
        acctItemSortState.orgBoundIDSet = this.orgBoundIDSet;
        acctItemSortState.baseOrgTreeIdSet = this.baseOrgTreeIdSet;
        acctItemSortState.startYear = this.startYear;
        acctItemSortState.startPeriod = this.startPeriod;
        acctItemSortState.endYear = this.endYear;
        acctItemSortState.endPeriod = this.endPeriod;
        acctItemSortState.periodType = this.periodType;
        acctItemSortState.dataSourceArray = this.dataSourceArray;
        acctItemSortState.isGroupUnCommited = this.isGroupUnCommited;
        acctItemSortState.isAdjusted = this.isAdjusted;
        acctItemSortState.isCaliber = this.isCaliber;
        acctItemSortState.dataCollectNumber = this.dataCollectNumber;
        acctItemSortState.mergeSchmNum = this.mergeSchmNum;
        acctItemSortState.isParamadjustSeparate = this.isParamadjustSeparate;
        acctItemSortState.currencyNumber = this.currencyNumber;
        acctItemSortState.sourceCurrencyNumber = this.sourceCurrencyNumber;
        acctItemSortState.orgNumbers = this.orgNumbers;
        return acctItemSortState;
    }

    public Map getContext() {
        return this.context;
    }

    @Override
    public void setContext(Map context) {
        this.context = context;
    }

    @Override
    public void setState(IFormulaCalculator formula) {
        AcctItem acctItem = (AcctItem)formula;
        ArrayList<String> tableList = new ArrayList<String>();
        for (AcctItem.ItemFieldMapped itemFieldMapped : acctItem.itemFromToList) {
            if (tableList.contains(itemFieldMapped.tableName)) continue;
            tableList.add(itemFieldMapped.tableName);
        }
        Collections.sort(tableList);
        this.setTableList(tableList);
        this.setOrgBoundIDSet(acctItem.orgBoundIDSet);
        this.setBaseOrgTreeIdSet(acctItem.baseOrgTreeIdSet);
        this.setAdjusted(acctItem.isAdjusted);
        this.setStartYear(acctItem.startYear);
        this.setStartPeriod(acctItem.startPeriod);
        this.setEndYear(acctItem.endYear);
        this.setEndPeriod(acctItem.endPeriod);
        this.setPeriodType(acctItem.int_periodType);
        this.setDataSourceArray(acctItem.dataSourceArray);
        this.setGroupUnCommited(acctItem.isGroupUnCommited);
        this.setCaliber(acctItem.isCaliber);
        this.setDataCollectNumber(acctItem.dataCollectNumber);
        this.setMergeSchmNum(acctItem.mergeSchmNum);
        this.setParamadjustSeparate(acctItem.isParamadjustSeparate());
        this.setCurrencyNumber(acctItem.convertCurrencyNumber);
        this.setSourceCurrencyNumber(acctItem.sourceCurrencyNumber);
        this.setOrgNumbers(acctItem.orgUnitNumbers);
    }

    private void setMergeSchmNum(String mergeSchmNum) {
        this.mergeSchmNum = mergeSchmNum;
    }

    private String buildSortKey(List list) {
        StringBuffer key = new StringBuffer();
        key.append("[");
        for (String elementName : list) {
            key.append(elementName).append("|");
        }
        key.append("]");
        return key.toString();
    }

    public boolean isSameYear() {
        return this.startYear == this.endYear;
    }

    public boolean isSamePeriod() {
        return this.startYear == this.endYear && this.startPeriod == this.endPeriod;
    }

    public List getTableList() {
        return this.tableList;
    }

    public void setTableList(List tableList) {
        this.tableList = tableList;
    }

    public Set getOrgBoundIDSet() {
        return this.orgBoundIDSet;
    }

    public void setOrgBoundIDSet(Set orgBoundIDSet) {
        this.orgBoundIDSet = orgBoundIDSet;
    }

    public Set getBaseOrgTreeIdSet() {
        return this.baseOrgTreeIdSet;
    }

    public void setBaseOrgTreeIdSet(Set baseOrgTreeIdSet) {
        this.baseOrgTreeIdSet = baseOrgTreeIdSet;
    }

    public int[] getDataSourceArray() {
        return this.dataSourceArray;
    }

    public void setDataSourceArray(int[] dataSourceArray) {
        this.dataSourceArray = dataSourceArray;
    }

    public boolean isGroupUnCommited() {
        return this.isGroupUnCommited;
    }

    public void setGroupUnCommited(boolean isGroupUnCommited) {
        this.isGroupUnCommited = isGroupUnCommited;
    }

    public boolean isAdjusted() {
        return this.isAdjusted;
    }

    public void setAdjusted(boolean isAdjusted) {
        this.isAdjusted = isAdjusted;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getStartPeriod() {
        return this.startPeriod;
    }

    public void setStartPeriod(int startPeriod) {
        this.startPeriod = startPeriod;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public int getEndPeriod() {
        return this.endPeriod;
    }

    public void setEndPeriod(int endPeriod) {
        this.endPeriod = endPeriod;
    }

    public int getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(int periodType) {
        this.periodType = periodType;
    }

    public boolean isCaliber() {
        return this.isCaliber;
    }

    public void setCaliber(boolean isCaliber) {
        this.isCaliber = isCaliber;
    }

    public void setDataCollectNumber(String dataCollectNumber) {
        this.dataCollectNumber = dataCollectNumber;
    }

    public String getDataCollectNumber() {
        return this.dataCollectNumber;
    }

    public String getMergeSchmNum() {
        return this.mergeSchmNum;
    }

    public boolean isParamadjustSeparate() {
        return this.isParamadjustSeparate;
    }

    public void setParamadjustSeparate(boolean isParamadjustSeparate) {
        this.isParamadjustSeparate = isParamadjustSeparate;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public boolean isUseTempTableScheme() {
        return this.isUseTempTableScheme;
    }

    public void setUseTempTableScheme(boolean isUseTempTableScheme) {
        this.isUseTempTableScheme = isUseTempTableScheme;
    }

    public String getSourceCurrencyNumber() {
        return this.sourceCurrencyNumber;
    }

    public void setSourceCurrencyNumber(String sourceCurrencyNumber) {
        this.sourceCurrencyNumber = sourceCurrencyNumber;
    }

    public String getOrgNumbers() {
        return this.orgNumbers;
    }

    public void setOrgNumbers(String orgNumbers) {
        this.orgNumbers = orgNumbers;
    }
}

