/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age;

import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.AsstActTypeComarator;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.age.Age;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableSortState;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AgeSortState
implements TempTableSortState {
    private static Comparator itemComparator = new AsstActTypeComarator();
    private boolean includingUnPosted;
    private boolean isGeneralCurrency;
    private String noGeneralCurrencyId;
    private String companyId;
    private String companyIdsForOnlyUnion;
    private boolean isBizUnit;
    private String accountTableId;
    private String currencyId;
    private String balType;
    private String ageType;
    private Date fromDate;
    private Date toDate;
    private Date endDate;
    private Date accountDate;
    private String amountField;
    private boolean isCalcAll;
    private List asstActTypeList;
    private boolean isSingleAccount;
    private String[] accounts;
    private List asstActItems;
    private List singleAsstActItem;
    private List formulaList = new ArrayList();

    @Override
    public void addFormula(IFormulaCalculator formula) {
        this.formulaList.add(formula);
    }

    @Override
    public String generateKey() {
        StringBuffer sortKey = new StringBuffer();
        sortKey.append("[").append(this.companyId).append("]");
        sortKey.append("[").append(this.accountTableId).append("]");
        sortKey.append("[").append(this.currencyId).append("]");
        sortKey.append("[").append(this.includingUnPosted ? "1" : "0").append("]");
        sortKey.append("[").append(this.balType).append("]");
        if (!this.isCalcAll) {
            sortKey.append("[").append(this.fromDate != null ? BatchHelper.dateFormat.format(this.fromDate) : "").append("]");
            sortKey.append("[").append(this.toDate != null ? BatchHelper.dateFormat.format(this.toDate) : "").append("]");
        }
        sortKey.append("[").append(this.accountDate != null ? BatchHelper.dateFormat.format(this.accountDate) : "").append("]");
        sortKey.append("[").append(this.amountField).append("]");
        sortKey.append("[").append(this.isCalcAll ? "1" : "0").append("]");
        sortKey.append("[").append(this.isSingleAccount ? "1" : "0").append("]");
        if (this.accounts != null) {
            sortKey.append("[").append(this.accounts[0]).append("|").append(this.accounts[1]).append("]");
        }
        if (this.asstActTypeList != null) {
            for (AsstActType itemType : this.asstActTypeList) {
                sortKey.append("[").append(itemType.number).append("]");
            }
        }
        return sortKey.toString();
    }

    @Override
    public List getFormulaList() {
        return this.formulaList;
    }

    @Override
    public void reset() {
        this.includingUnPosted = false;
        this.isGeneralCurrency = false;
        this.noGeneralCurrencyId = null;
        this.companyId = null;
        this.currencyId = null;
        this.accountTableId = null;
        this.balType = null;
        this.ageType = null;
        this.fromDate = null;
        this.toDate = null;
        this.endDate = null;
        this.accountDate = null;
        this.amountField = null;
        this.isCalcAll = false;
        this.asstActTypeList = null;
        this.isSingleAccount = true;
        this.singleAsstActItem = null;
        this.asstActItems = null;
        this.accounts = null;
        this.companyIdsForOnlyUnion = null;
        this.isBizUnit = false;
    }

    @Override
    public void setContext(Map context) {
    }

    @Override
    public void setState(IFormulaCalculator formula) {
        Age age = (Age)formula;
        this.setIncludingUnPosted(age.includingUnPosted);
        this.setGeneralCurrency(age.isGeneralCurrency);
        this.setNoGeneralCurrencyId(age.noGeneralCurrencyId);
        this.setCompanyId(age.companyId);
        this.setCompanyIdsForOnlyUnion(age.companyIdsForOnlyUnion);
        this.setBizUnit(age.isBizunit);
        this.setAccountTableId(age.accountTableId);
        this.setCurrencyId(age.currencyid);
        this.setBalType(age.balType);
        this.setAgeType(age.ageType);
        this.setFromDate(age.fromDate);
        this.setToDate(age.toDate);
        this.setEndDate(age.endDate);
        this.setAccountDate(age.accountDate);
        this.setAmountField(age.amountField);
        this.setCalcAll(age.isCalcAll);
        this.setSingleAccount(this.isSingleAccount(age));
        if (!age.accountItem.isSingleAccount()) {
            String level = null;
            if (age.accountItem.startAccount.account != null) {
                level = "" + age.accountItem.startAccount.account.level;
            }
            this.setAccounts(new String[]{age.accountItem.startAccount.getAccountNumber(), age.accountItem.endAccount.getAccountNumber(), level});
        }
        if (age.accountItem.hasItem()) {
            ArrayList<AsstActType> asstActTypeList = new ArrayList<AsstActType>();
            for (AssistantItem asst : age.accountItem.getItemTypes().values()) {
                asstActTypeList.add(asst.itemType);
            }
            Collections.sort(asstActTypeList, itemComparator);
            this.setAsstActTypeList(asstActTypeList);
            ArrayList<String[]> asstItems = null;
            AcctountAsstItemParser.AccountAsstItem asstItem = age.accountItem.getAccountAsstItem();
            if (asstItem != null && asstItem.asstItems.length > 0 && asstItem.asstItems[0].startNumber != null) {
                for (AsstActType itemType : asstActTypeList) {
                    AssistantItem assistantItem = age.accountItem.getItem(itemType.number);
                    if (assistantItem == null || assistantItem.startItem == null || assistantItem.endItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number) || StringUtils.isEmpty((String)assistantItem.endItem.number)) continue;
                    String asstItemStartNumber = assistantItem.startItem.number;
                    String asstItemEndNumber = assistantItem.endItem.number;
                    if (asstItems == null) {
                        asstItems = new ArrayList<String[]>();
                    }
                    asstItems.add(new String[]{itemType.number, asstItemStartNumber, asstItemEndNumber});
                }
                this.setAsstActItems(asstItems);
            }
        }
    }

    @Override
    public Object clone() {
        AgeSortState sortState = this.getSortState();
        sortState.includingUnPosted = this.includingUnPosted;
        sortState.isGeneralCurrency = this.isGeneralCurrency;
        sortState.noGeneralCurrencyId = this.noGeneralCurrencyId;
        sortState.companyId = this.companyId;
        sortState.companyIdsForOnlyUnion = this.companyIdsForOnlyUnion;
        sortState.isBizUnit = this.isBizUnit;
        sortState.accountTableId = this.accountTableId;
        sortState.currencyId = this.currencyId;
        sortState.fromDate = this.fromDate;
        sortState.toDate = this.toDate;
        sortState.endDate = this.endDate;
        sortState.accountDate = this.accountDate;
        sortState.amountField = this.amountField;
        sortState.balType = this.balType;
        sortState.ageType = this.ageType;
        sortState.asstActTypeList = this.asstActTypeList;
        sortState.isCalcAll = this.isCalcAll;
        sortState.isSingleAccount = this.isSingleAccount;
        sortState.singleAsstActItem = this.singleAsstActItem;
        sortState.asstActItems = this.asstActItems;
        sortState.accounts = this.accounts;
        return sortState;
    }

    public AgeSortState getSortState() {
        return new AgeSortState();
    }

    private boolean isSingleAccount(Age age) {
        return age.accountItem.startAccount.getAccountNumber().equals(age.accountItem.endAccount.getAccountNumber());
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getBalType() {
        return this.balType;
    }

    public void setBalType(String balType) {
        this.balType = balType;
    }

    public Date getAccountDate() {
        return this.accountDate;
    }

    public void setAccountDate(Date accountDate) {
        this.accountDate = accountDate;
    }

    public String getAmountField() {
        return this.amountField;
    }

    public void setAmountField(String amountField) {
        this.amountField = amountField;
    }

    public boolean isCalcAll() {
        return this.isCalcAll;
    }

    public void setCalcAll(boolean isCalcAll) {
        this.isCalcAll = isCalcAll;
    }

    public List getAsstActTypeList() {
        return this.asstActTypeList;
    }

    public void setAsstActTypeList(List asstActTypeList) {
        this.asstActTypeList = asstActTypeList;
    }

    @Override
    public boolean isUseTempTableScheme() {
        return false;
    }

    public boolean isIncludingUnPosted() {
        return this.includingUnPosted;
    }

    public void setIncludingUnPosted(boolean includingUnPosted) {
        this.includingUnPosted = includingUnPosted;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isSingleAccount() {
        return this.isSingleAccount;
    }

    public void setSingleAccount(boolean isSingleAccount) {
        this.isSingleAccount = isSingleAccount;
    }

    public List getSingleAsstActItem() {
        return this.singleAsstActItem;
    }

    public void setSingleAsstActItem(List singleAsstActItem) {
        this.singleAsstActItem = singleAsstActItem;
    }

    public List getAsstActItems() {
        return this.asstActItems;
    }

    public void setAsstActItems(List asstActItems) {
        this.asstActItems = asstActItems;
    }

    public String getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(String accountTableId) {
        this.accountTableId = accountTableId;
    }

    public String[] getAccounts() {
        return this.accounts;
    }

    public void setAccounts(String[] accounts) {
        this.accounts = accounts;
    }

    public boolean isGeneralCurrency() {
        return this.isGeneralCurrency;
    }

    public void setGeneralCurrency(boolean isGeneralCurrency) {
        this.isGeneralCurrency = isGeneralCurrency;
    }

    public String getNoGeneralCurrencyId() {
        return this.noGeneralCurrencyId;
    }

    public void setNoGeneralCurrencyId(String noGeneralCurrencyId) {
        this.noGeneralCurrencyId = noGeneralCurrencyId;
    }

    public String getCompanyIdsForOnlyUnion() {
        return this.companyIdsForOnlyUnion;
    }

    public void setCompanyIdsForOnlyUnion(String companyIdsForOnlyUnion) {
        this.companyIdsForOnlyUnion = companyIdsForOnlyUnion;
    }

    public boolean isBizUnit() {
        return this.isBizUnit;
    }

    public void setBizUnit(boolean isBizUnit) {
        this.isBizUnit = isBizUnit;
    }

    public String getAgeType() {
        return this.ageType;
    }

    public void setAgeType(String ageType) {
        this.ageType = ageType;
    }
}

