/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AccountAgeParam;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.age.Age;
import com.kingdee.eas.fi.rpt.batch.age.BalanceCalcSort;
import com.kingdee.eas.fi.rpt.batch.age.BalanceCalcSortRegister;
import com.kingdee.eas.fi.rpt.batch.age.balance.AgeQueryParam;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.AgeQueryParamConvertor;
import com.kingdee.eas.fi.rpt.batch.age.balance.gl.GetAccountParam;
import com.kingdee.eas.fi.rpt.batch.age.balance.gl.QueryAsstItems;
import com.kingdee.eas.fi.rpt.batch.age.balanceByInterface.QueryAgeBalanceByInterface;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BalanceCalcProcessor {
    private static final Logger log = Logger.getLogger(BalanceCalcProcessor.class);
    private Context ctx;
    private Map<String, Map<AccountViewInfo, List<HashMap<String, Object>>>> asstActTypeMap = null;
    private Map<String, String> acctTableIdTemp = new HashMap<String, String>();
    private Map<String, String> accountIdCatch = new HashMap<String, String>();

    public BalanceCalcProcessor(Context ctx) {
        this.ctx = ctx;
    }

    public BalanceCalcProcessor(Context ctx, Map<String, Map<AccountViewInfo, List<HashMap<String, Object>>>> asstActTypeMap) {
        this.ctx = ctx;
        this.asstActTypeMap = asstActTypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(BalanceCalcSortRegister balanceCalcSortRegister) throws EASBizException, BOSException {
        Collection sorts = balanceCalcSortRegister.getSorts();
        Object accountBalances = null;
        Object debugModel = null;
        HashMap<String, Object> calMaps = new HashMap<String, Object>();
        HashMap<Date, Map> queryMap = new HashMap<Date, Map>();
        HashMap<Date, Map> queryMap_Rel = new HashMap<Date, Map>();
        StringBuffer companyidssb = new StringBuffer();
        HashSet<Date> dateSet = new HashSet<Date>();
        HashMap<String, CompanyOrgUnitInfo> companyCatch = null;
        try {
            companyCatch = new HashMap<String, CompanyOrgUnitInfo>();
            for (BalanceCalcSort sort : sorts) {
                AgeQueryParam param = sort.buildAgeQueryParam(this.ctx);
                String companyId = param.getCompany();
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)companyCatch.get(companyId);
                if (companyInfo == null) {
                    companyInfo = GlUtils.getCompanyById((Context)this.ctx, (String)companyId);
                    companyCatch.put(companyId, companyInfo);
                }
                param.setCompanyInfo(companyInfo);
                Map params = new AgeQueryParamConvertor(this.ctx).exec(param);
                params.put("companyInfo", companyInfo);
                int[] days = (int[])params.get("days");
                days = this.getDays(days);
                AccountAgeParam accountAgeParam = this.getAccountAgeParam(this.ctx, params);
                Date historyDate = accountAgeParam.getHistoryDate();
                dateSet.add(historyDate);
                if (accountAgeParam.isIncludeVerifyVch()) {
                    this.getDetailCompanyidAndAccountid(queryMap, accountAgeParam, historyDate);
                    this.constructCalculateMaps(sort, queryMap, days, accountAgeParam);
                } else {
                    this.getDetailCompanyidAndAccountid(queryMap_Rel, accountAgeParam, historyDate);
                    this.constructCalculateMaps(sort, queryMap_Rel, days, accountAgeParam);
                }
                String companyid = accountAgeParam.getCompanyId();
                companyid = companyid.contains("'") ? companyid : "'" + companyid + "'";
                companyidssb.append(companyid + ",");
            }
            this.accountIdCatch.clear();
            if (sorts != null && sorts.size() > 0) {
                String companyids = companyidssb.toString();
                companyids = companyids.substring(0, companyids.length() - 1);
                calMaps.put("historyDate", dateSet);
                calMaps.put("companyids", companyids);
                calMaps.put("queryParam", queryMap);
                calMaps.put("queryParam_Rel", queryMap_Rel);
                try {
                    QueryAgeBalanceByInterface query = new QueryAgeBalanceByInterface();
                    query.exec(this.ctx, calMaps, sorts);
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
        finally {
            companyCatch.clear();
        }
    }

    private void getDetailCompanyidAndAccountid(Map<Date, Map> queryMap, AccountAgeParam accountAgeParam, Date historyDate) {
        HashSet<String> accountidsSet = new HashSet<String>();
        HashSet<String> companyidsSet = new HashSet<String>();
        String accountids = accountAgeParam.getAccountid();
        if ((accountids = accountids.replaceAll("'", "")).contains(",")) {
            for (String accountid : accountids.split(",")) {
                accountidsSet.add(accountid);
            }
        } else {
            accountidsSet.add(accountids);
        }
        String companyids = accountAgeParam.getCompanyId();
        companyids = companyids.replaceAll("'", "");
        if (companyids.contains(",")) {
            for (String companyid : companyids.split(",")) {
                companyidsSet.add(companyid);
            }
        } else {
            companyidsSet.add(companyids);
        }
        if (queryMap.containsKey(historyDate)) {
            Map map = queryMap.get(historyDate);
            Set companySet = (Set)map.get("companyids");
            companySet.addAll(companyidsSet);
            Set accountSet = (Set)map.get("accountids");
            accountSet.addAll(accountidsSet);
            map.put("companyids", companySet);
            map.put("accountids", accountSet);
        } else {
            HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
            map.put("companyids", companyidsSet);
            map.put("accountids", accountidsSet);
            queryMap.put(historyDate, map);
        }
    }

    private void constructCalculateMaps(BalanceCalcSort sort, Map calMaps, int[] days, AccountAgeParam accountAgeParam) {
        List formulas = sort.getFormulas();
        Date historyDate = accountAgeParam.getHistoryDate();
        Map dMap = (Map)calMaps.get(historyDate);
        for (Age age : formulas) {
            String key = this.generateKey(age, sort);
            ArrayList<String> newKeys = new ArrayList<String>();
            newKeys.add(key);
            dMap.put(key, accountAgeParam);
            dMap.put("isIncludeVerifyVch", accountAgeParam.isIncludeVerifyVch());
            age.setKeys(newKeys);
            age.setDays(days);
        }
    }

    private String generateKey(Age age, BalanceCalcSort sort) {
        AcctountAsstItemParser.AccountAsstItem asstItem;
        StringBuffer key = new StringBuffer();
        key.append("[").append(age.companyId).append("]");
        key.append("[").append(age.accountItem.startAccount.getAccountNumber()).append("]");
        key.append("[").append(age.accountItem.endAccount.getAccountNumber()).append("]");
        List asstActTypeList = sort.buildAsstActTypeList(age);
        if (asstActTypeList != null) {
            for (AsstActType itemType : asstActTypeList) {
                key.append("[").append(itemType.number).append("]");
            }
        }
        if ((asstItem = age.accountItem.getAccountAsstItem()) != null && asstItem.asstItems != null && asstItem.asstItems.length > 0 && asstItem.asstItems[0].startNumber != null) {
            for (AsstActType itemType : asstActTypeList) {
                AssistantItem assistantItem = age.accountItem.getItem(itemType.number);
                if (assistantItem == null || assistantItem.startItem == null || StringUtils.isEmpty((String)assistantItem.startItem.number) || assistantItem.endItem == null || StringUtils.isEmpty((String)assistantItem.endItem.number)) continue;
                String asstItemStartNumber = assistantItem.startItem.number;
                String asstItemEndNumber = assistantItem.endItem.number;
                key.append("[").append(asstItemStartNumber).append("|").append(asstItemEndNumber).append("]");
            }
        }
        key.append("[").append(age.currencyid).append("]");
        key.append("[").append(age.balType).append("]");
        key.append("[").append(age.ageType).append("]");
        key.append("[").append(age.calcType).append("]");
        key.append("[").append(age.from).append("]");
        key.append("[").append(age.to).append("]");
        key.append("[").append(age.accountDateStr).append("]");
        key.append("[").append(age.endDateString).append("]");
        return key.toString();
    }

    private AccountAgeParam getAccountAgeParam(Context ctx, Map param) throws EASBizException, BOSException {
        AccountAgeParam paramAge = new AccountAgeParam();
        paramAge.setCtx(ctx);
        String accountid = (String)param.get("accountid");
        paramAge.setAccountid(accountid);
        String currencyid = (String)param.get("currencyid");
        paramAge.setCurrencyid(currencyid);
        int[] days = (int[])param.get("days");
        boolean ageType = (Boolean)param.get("ageType");
        if (ageType) {
            paramAge.setDays(this.getDays(days));
            int[] undays = new int[]{};
            paramAge.setUndays(undays);
            paramAge.setUndaylen(0);
        } else {
            int[] ds = this.getDays(days);
            int[] newDs = new int[2];
            if (ds.length == 2) {
                newDs[0] = ds[0];
                newDs[1] = ds[1];
            } else if (ds.length == 1) {
                newDs = new int[]{ds[0]};
            }
            paramAge.setUndays(newDs);
            int[] overDays = new int[]{};
            paramAge.setDays(overDays);
            paramAge.setDaylen(0);
        }
        boolean isShowUmexpired = (Boolean)param.get("ageType") == false;
        paramAge.setShowUmexpired(isShowUmexpired);
        Date endDate = (Date)param.get("endDate");
        paramAge.setEndDate(endDate);
        Date historyDate = (Date)param.get("historyDate");
        paramAge.setHistoryDate(historyDate);
        boolean isIncludeUnPosted = (Boolean)param.get("includeUnPosted");
        paramAge.setIncludeUnPosted(isIncludeUnPosted);
        boolean isIncludeInit = (Boolean)param.get("includeInit");
        paramAge.setIncludeInit(isIncludeInit);
        boolean isIncludeVerifyVch = param.get("includeVerifyVch") == null ? false : (Boolean)param.get("includeVerifyVch");
        paramAge.setIncludeVerifyVch(isIncludeVerifyVch);
        boolean isBizCode = param.get("isBizCode") != null && (Boolean)param.get("isBizCode") != false;
        paramAge.setBizCode(isBizCode);
        String companyId = (String)param.get("companyid");
        paramAge.setCompanyId(companyId);
        int dateType = (Integer)param.get("dateType");
        dateType = dateType == 0 ? 1 : 0;
        paramAge.setDateType(dateType);
        int indexType = (Integer)param.get("indexType");
        Object accountFrom = param.get("accountFrom");
        paramAge.setAccountFrom(accountFrom);
        Object accountTo = param.get("accountTo");
        paramAge.setAccountTo(accountTo);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("companyInfo");
        paramAge.setCompany(company);
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company);
        paramAge.setIsOnlyUnion(isIsOnlyUnion);
        String acctTableId = null;
        if (param.get("accountTable") instanceof String) {
            acctTableId = (String)param.get("accountTable");
        } else if (param.get("accountTable") instanceof BOSUuid) {
            acctTableId = ((BOSUuid)param.get("accountTable")).toString();
        }
        if (acctTableId == null) {
            acctTableId = company.getAccountTable().getId().toString();
        }
        paramAge.setAcctTableId(acctTableId);
        String companyIdsForOnlyUnion = (String)param.get("companyIdsForOnlyUnion");
        HashMap<Object, Object> hmItems = (HashMap<Object, Object>)param.get("hmItems");
        String[] asstTypes = (String[])param.get("asstTypes");
        if (asstTypes != null) {
            indexType = 0;
            HashMap<String, String> othersParam = null;
            if (isIsOnlyUnion) {
                othersParam = new HashMap<String, String>();
                othersParam.put("companyIds", companyIdsForOnlyUnion);
                othersParam.put("accountTableid", acctTableId);
            }
            hmItems = this.asstActTypeMap == null ? QueryAsstItems.exec(ctx, (String)accountFrom, (String)accountTo, company, indexType, historyDate, othersParam, asstTypes) : this.getHMItems(ctx, (String)accountFrom, (String)accountTo, company, historyDate, othersParam, asstTypes, isIsOnlyUnion);
        } else {
            indexType = 0;
        }
        paramAge.setIndexType(indexType);
        paramAge.setHmItems((HashMap)hmItems);
        StringBuffer key = new StringBuffer();
        key.append(accountFrom).append(accountTo).append(acctTableId).append(isIsOnlyUnion).append(isIsOnlyUnion ? companyIdsForOnlyUnion : companyId);
        String keyStr = key.toString();
        if (this.accountIdCatch.containsKey(keyStr)) {
            accountid = this.accountIdCatch.get(keyStr);
        } else {
            accountid = isIsOnlyUnion ? this.getAccountids(ctx, accountFrom, accountTo, acctTableId, companyIdsForOnlyUnion, isIsOnlyUnion) : this.getAccountids(ctx, accountFrom, accountTo, acctTableId, companyId, isIsOnlyUnion);
            this.accountIdCatch.put(keyStr, accountid);
        }
        paramAge.setAccountid(accountid);
        if (isIsOnlyUnion) {
            paramAge.setCompanyId(companyIdsForOnlyUnion);
            int companyLevel = (Integer)param.get("curLevel");
            paramAge.setCompanyLevel(companyLevel);
            String curCompanyid = (String)param.get("curCompanyid");
            if (param.get("companyIds") != null) {
                curCompanyid = (String)param.get("companyIds");
            }
            paramAge.setCurCompanyid(curCompanyid);
            HashMap otherInfo = (HashMap)param.get("otherInfo");
            paramAge.setOtherInfo(otherInfo);
            boolean isfirstload = param.get("firstLoad").toString().equals("true");
            paramAge.setIsfirstload(isfirstload);
            String accountViewNumber = null;
            if (param.get("accountViewNumber") != null) {
                accountViewNumber = (String)param.get("accountViewNumber");
                accountid = null;
                paramAge.setAccountid(accountid);
            } else {
                if (otherInfo != null && otherInfo.get("accountViewNumber") != null) {
                    accountViewNumber = otherInfo.get("accountViewNumber").toString();
                }
                otherInfo = null;
            }
            paramAge.setAccountViewNumber(accountViewNumber);
        } else {
            if (!isBizCode || indexType != 1) {
                accountid = accountid != null && accountid.indexOf("'") == -1 ? "'" + accountid + "'" : accountid;
            }
            String accountViewNumber = null;
            if (indexType == 0 && param.get("accountViewNumber") != null) {
                accountViewNumber = (String)param.get("accountViewNumber");
                accountid = null;
            }
            paramAge.setAccountid(accountid);
            paramAge.setAccountViewNumber(accountViewNumber);
            CompanyOrgUnitInfo curCompany = company;
            paramAge.setCurCompanyid(companyId);
            paramAge.setCompany(curCompany);
        }
        return paramAge;
    }

    public HashMap<Object, Object> getHMItems(Context ctx, String accountFrom, String accountTo, CompanyOrgUnitInfo company, Date bizDate, HashMap othersParam, String[] asstTypes, boolean isIsOnlyUnion) throws BOSException, EASBizException {
        HashMap<Object, Object> asstTypeRangesExt = new HashMap<Object, Object>();
        Map accountParams = GetAccountParam.exec(accountFrom, accountTo);
        accountFrom = (String)accountParams.get("accountFrom");
        accountTo = (String)accountParams.get("accountTo");
        String acctTableId = null;
        String companyIds = company.getId().toString();
        if (isIsOnlyUnion) {
            acctTableId = othersParam.get("accountTableid").toString();
            companyIds = othersParam.get("companyIds").toString();
        } else if (bizDate == null) {
            acctTableId = company.getAccountTable().getId().toString();
        } else {
            String key = company.getCU().getId().toString() + bizDate.getTime() + company.getId().toString();
            acctTableId = this.acctTableIdTemp.get(key);
            if (acctTableId == null) {
                PeriodInfo _period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)company);
                int _periodYear = _period == null ? bizDate.getYear() + 1900 : _period.getPeriodYear();
                int _periodNumber = _period == null ? (bizDate.getMonth() + 3) / 3 : _period.getPeriodNumber();
                acctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)company.getCU().getId().toString(), (String)company.getAccountTable().getId().toString(), (int)_periodYear, (int)_periodNumber);
                this.acctTableIdTemp.put(key, acctTableId);
            }
        }
        String[] asstType = null;
        String[] asstTypeNumbs = null;
        Object accountViewInfo = null;
        Map<AccountViewInfo, List<HashMap<String, Object>>> accountViewAcctTypeMap = null;
        List<HashMap<String, Object>> oneAccountViewList = null;
        String typeNumber = null;
        Set<AccountViewInfo> accountViewKetSet = null;
        String accountNumber = null;
        int size = asstTypes.length;
        for (int i = 0; i < size; ++i) {
            String[] numbs;
            asstType = asstTypes[i].split("\\|");
            typeNumber = asstType[0];
            accountViewAcctTypeMap = this.asstActTypeMap.get(typeNumber);
            if (accountViewAcctTypeMap == null) {
                throw new EASBizException(new NumericExceptionSubItem("001", EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"371_QueryAsstItems") + typeNumber + EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"372_QueryAsstItems")));
            }
            asstTypeNumbs = asstType.length == 1 ? new String[]{null, null, null} : ((numbs = asstType[1].split("\\:")).length == 1 ? new String[]{numbs[0], numbs[0], null} : new String[]{numbs[0], numbs[1], null});
            accountViewKetSet = accountViewAcctTypeMap.keySet();
            for (AccountViewInfo accountInfo : accountViewKetSet) {
                accountNumber = accountInfo.getNumber();
                boolean isGet = (accountFrom.compareTo(accountNumber) <= 0 && accountTo.compareTo(accountNumber) >= 0 || accountNumber.startsWith(accountFrom) || accountNumber.startsWith(accountTo)) && acctTableId.equals(accountInfo.get("accounttableid")) && companyIds.contains((CharSequence)accountInfo.get("accountOrgId"));
                if (!isGet) continue;
                oneAccountViewList = accountViewAcctTypeMap.get(accountInfo);
                for (HashMap<String, Object> item : oneAccountViewList) {
                    asstTypeRangesExt.put(item, asstTypeNumbs);
                }
            }
        }
        return asstTypeRangesExt;
    }

    private String getAccountids(Context ctx, Object accountFrom, Object accountTo, String accountTableid, String companyid, boolean isUnion) throws BOSException {
        StringBuffer sqlIdsParam = new StringBuffer();
        Map accountNumbermap = this.getAccountParam((String)accountFrom, (String)accountTo);
        StringBuffer sql = new StringBuffer();
        String sqlAccountParams = null;
        if (accountNumbermap.get("accountIns") != null && accountNumbermap.get("accountIns") != "") {
            sqlAccountParams = (String)accountNumbermap.get("accountIns");
        }
        sql.append("select Fid id \r\n");
        sql.append("from T_BD_ACCOUNTVIEW \r\n");
        sql.append("where FAccountTableid = '" + accountTableid + "' \r\n");
        if (isUnion) {
            sql.append("and FCompanyid in (" + companyid + ") \r\n");
        } else {
            sql.append("and FCompanyid = '" + companyid + "' \r\n");
        }
        if (sqlAccountParams != null) {
            sql.append(" and (");
            String[] nums = sqlAccountParams.split(",");
            for (int i = 0; i < nums.length; ++i) {
                sql.append(" FNumber like " + nums[i] + " \n");
                if (i >= nums.length - 1) continue;
                sql.append(" or \n");
            }
            sql.append(" ) \n");
        } else if (accountFrom.equals(accountTo)) {
            String from = accountFrom + "%";
            sql.append(" and FNumber like '").append(from).append("' \n");
        } else {
            String to = accountTo + "%";
            sql.append(" and FNumber >= '" + accountFrom + "'").append(" and (FNumber <= '" + accountTo + "'").append(" or FNumber like '" + to + "') \n");
        }
        sql.append(" and FISLEAF = 1 \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String id = rs.getString("id");
                sqlIdsParam.append("'").append(id).append("'").append(",");
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (sqlIdsParam.length() > 0) {
            sqlIdsParam.deleteCharAt(sqlIdsParam.length() - 1);
        }
        return sqlIdsParam.toString();
    }

    private Map getAccountParam(String accountFrom, String accountTo) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] acctFroms = new String[]{};
        if (accountFrom != null) {
            acctFroms = accountFrom.split(";");
        }
        String[] acctTos = new String[]{};
        if (accountTo != null) {
            acctTos = accountTo.split(";");
        }
        String acctIns = "";
        if (acctFroms.length > 0 && acctTos.length > 0) {
            if (acctFroms[acctFroms.length - 1].compareTo(acctTos[0]) > 0) {
                int i;
                for (i = 0; i < acctFroms.length; ++i) {
                    String from = acctFroms[i] + "%";
                    acctIns = acctIns + "'" + from + "',";
                }
                for (i = 0; i < acctTos.length; ++i) {
                    String to = acctTos[i] + "%";
                    acctIns = acctIns + "'" + to + "',";
                }
                accountFrom = null;
                accountTo = null;
            } else {
                int i;
                for (i = 0; i < acctFroms.length - 1; ++i) {
                    String from = acctFroms[i] + "%";
                    acctIns = acctIns + "'" + from + "',";
                }
                for (i = 1; i < acctTos.length; ++i) {
                    String to = acctTos[i] + "%";
                    acctIns = acctIns + "'" + to + "',";
                }
                accountFrom = acctFroms[acctFroms.length - 1];
                accountTo = acctTos[0];
            }
        } else if (acctFroms.length > 0) {
            for (int i = 0; i < acctFroms.length - 1; ++i) {
                String from = acctFroms[i] + "%";
                acctIns = acctIns + "'" + from + "',";
            }
            accountFrom = acctFroms[acctFroms.length - 1];
        } else if (acctTos.length > 0) {
            for (int i = 1; i < acctTos.length; ++i) {
                String to = acctTos[i] + "%";
                acctIns = acctIns + "'" + to + "',";
            }
            accountTo = acctTos[0];
        }
        result.put("accountFrom", accountFrom);
        result.put("accountTo", accountTo);
        result.put("accountIns", acctIns.length() > 0 ? acctIns.substring(0, acctIns.length() - 1) : "");
        return result;
    }

    private int[] getDays(int[] days) {
        if (days != null && days.length > 0 && (days[days.length - 1] == Integer.MAX_VALUE || days[days.length - 1] == Integer.MIN_VALUE)) {
            int[] daysForRemoveMaxNumber = new int[days.length - 1];
            System.arraycopy(days, 0, daysForRemoveMaxNumber, 0, days.length - 1);
            days = daysForRemoveMaxNumber;
            if (days[0] > 0) {
                days[0] = days[0] - 1;
            } else if (days[0] < 0) {
                days[0] = days[0] + 1;
            }
        } else if (days.length == 2) {
            int from = days[0];
            if (from <= 0) {
                if (from < 0) {
                    if (from == -1) {
                        ++from;
                    }
                } else {
                    from = 0;
                }
            }
            int to = days[1];
            days = new int[days.length];
            days[0] = --from;
            days[1] = to;
        }
        return days;
    }
}

