/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age.balance.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.common.client.SysContext;
import org.apache.log4j.Logger;

public class QuerySubOrgByGLRule {
    private static final Logger LOG = Logger.getLogger(QuerySubOrgByGLRule.class);
    private OrgStructureCollection orgStructure = null;

    public String exec(Context ctx, CompanyOrgUnitInfo company) throws BOSException {
        OrgStructureCollection orgs;
        this.orgStructure = new OrgStructureCollection();
        this.orgStructure = orgs = this.getOrgStructureCollection(ctx, company);
        StringBuffer sb = new StringBuffer();
        int size = orgs.size();
        for (int i = 0; i < size; ++i) {
            if (company.getId().equals((Object)orgs.get(i).getUnit().getId()) || !orgs.get(i).isIsLeaf()) continue;
            sb.append(",'");
            sb.append(orgs.get(i).getUnit().getId().toString());
            sb.append("'");
        }
        if (sb.length() > 0) {
            LOG.debug((Object)("company{" + company + "}'s subOrg is {" + sb.substring(1) + "}"));
            return sb.substring(1);
        }
        LOG.warn((Object)("company{" + company + "}'s subOrg be not found,only set this company!"), (Throwable)new Exception());
        return "'" + company + "'";
    }

    public OrgStructureCollection getOrgStructureCollection(Context ctx, CompanyOrgUnitInfo company) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        String cpIdSql = this.getFIUnitIDSQL(company, false);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)cpIdSql, CompareType.INNER));
        fic.add(new FilterItemInfo("unit.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("tree.id", (Object)"00000000-0000-0000-0000-0000000000024F2827FD"));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isleaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isvalid"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.longNumber"));
        sic.add(new SelectorItemInfo("unit.isCU"));
        sic.add(new SelectorItemInfo("unit.CU.id"));
        sic.add(new SelectorItemInfo("tree.id"));
        sic.add(new SelectorItemInfo("tree.type"));
        sic.add(new SelectorItemInfo("tree.number"));
        view.getSorter().add(new SorterItemInfo("longNumber"));
        IOrgStructure orgDao = this.getOrgDao(ctx);
        OrgStructureCollection orgs = orgDao.getOrgStructureCollection(view);
        return orgs;
    }

    protected IOrgStructure getOrgDao(Context ctx) throws BOSException {
        IOrgStructure orgDao = null;
        orgDao = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
        return orgDao;
    }

    private String getFIUnitIDSQL(CompanyOrgUnitInfo company, boolean force) {
        String periodTypeID = company.getAccountPeriodType().getId().toString();
        StringBuffer cpIdSql = new StringBuffer();
        cpIdSql.append(" SELECT pcp.fid ");
        cpIdSql.append(" from t_bd_systemstatusctrol ssc ");
        cpIdSql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        cpIdSql.append(" inner join t_org_company cp on cp.fid = ssc.fcompanyid ");
        cpIdSql.append(" left outer join T_BD_AcctRefContrast c on c.fcompanyid = cp.fid and c.freftype = 1 ");
        cpIdSql.append(" inner join t_org_company pcp on charindex(pcp.flongnumber||'!', cp.flongnumber) = 1 or pcp.fid = cp.fid ");
        cpIdSql.append(" where ssc.fstartperiodid is not null and cp.faccountperiodid= '").append(periodTypeID).append("'");
        if (force) {
            cpIdSql.append(" and cp.fbasecurrencyid = '").append(SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId()).append("'");
        }
        cpIdSql.append(" and cp.fisAssistantOrg = 0 and pcp.fisBizUnit = 1 ");
        String accountTableID = company.getAccountTable().getId().toString();
        cpIdSql.append(" and (cp.faccounttableid = '").append(company.getAccountTable().getId().toString()).append("' or c.fdisabledaccttableid = '").append(accountTableID).append("' or c.fenabledaccttableid ='").append(accountTableID).append("') ");
        cpIdSql.append(" and (pcp.flongnumber like '").append(company.getLongNumber()).append("!%' or pcp.fid = '").append(company.getId().toString()).append("')");
        return cpIdSql.toString();
    }

    public OrgStructureCollection getOrgStructure() {
        return this.orgStructure;
    }
}

