/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.dyitem;

import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.dyitem.DyItemCalculator;
import com.kingdee.eas.fi.rpt.batch.dyitem.DyItemCombineState;
import com.kingdee.eas.fi.rpt.batch.dyitem.DyItemSortState;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdjustProccessor
implements IBatchSQLSorterProcessor {
    private static Logger logger = Logger.getLogger(AdjustProccessor.class);
    private int batchSize;
    protected DyItemSortState sortState;
    protected DyItemCombineState combineState = new DyItemCombineState();
    private String[] IndexResultSetFields;

    public AdjustProccessor(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append("Select sum(DyItem.fvalue) AS  Value    \t\t \t \t\t\n");
        sql.append(",rptItem.FNumber AS ItemNumber\t\t\t\t\t\t\t\n");
        sql.append(",DyItem.FKeyLongNumber AS DyItemNumber\t\t\t\t\t\n");
        sql.append(",AdjustEntry.FDataElement AS DataElement\t\t\t\t\n");
        sql.append(",Adjust.FDataCollectNumber AS DataCollectNumber\t\t\t\t\n");
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append("From T_CSL_Adjust Adjust     \t\t\t\t\t \t\t\t\t\t\t\t\t\t\n");
        sql.append("inner join T_CSL_AdjustEntry AdjustEntry on Adjust.FID=AdjustEntry.fadjustid      \t\n");
        sql.append("inner join T_Csl_Adjustdynamicitem DyItem on AdjustEntry.FID=DyItem.FAdjustEntryID  \n");
        sql.append("inner join T_CSL_RptItem rptItem on DyItem.FRptItemID=rptItem.FID     \t\t\t\t\n");
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append("where Adjust.FCheckedStatus=?        \t\n");
        params.add(new Integer(2));
        sql.append("and Adjust.FOrgUnit = ?\t\t\t\t\t\n");
        params.add(this.sortState.getOrgUnitID());
        try {
            sql.append("and Adjust.FOrgBoundID in ");
            sql.append(RptUtilForServer.createInSql(this.sortState.getOrgBoundIdSet().iterator(), params));
        }
        catch (SQLDataException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        sql.append("and Adjust.FSourceCurrencyID = ?\t\t \n");
        params.add(this.sortState.getSourceCurrecy());
        sql.append("and Adjust.FCurrencyID = ?\t\t\t\t \n");
        params.add(this.sortState.getCurrency());
        if (this.sortState.isSamePeriod()) {
            sql.append("and Adjust.FYear = ?                 \n");
            sql.append("and Adjust.FPeriod = ?               \n");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getStartPeriod()));
        } else if (this.sortState.isSameYear()) {
            sql.append("and Adjust.FYear = ?                 \n");
            params.add(new Integer(this.sortState.getStartYear()));
            sql.append("and Adjust.FPeriod >= ?              \n");
            sql.append("and Adjust.FPeriod <= ?          \t \n");
            params.add(new Integer(this.sortState.getStartPeriod()));
            params.add(new Integer(this.sortState.getEndPeriod()));
        } else {
            sql.append("and ((Adjust.FYear = ? and Adjust.FPeriod >= ? ) or  \n");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getStartPeriod()));
            sql.append("( Adjust.FYear > ?  and Adjust.FYear < ?  ) or       \n");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getEndYear()));
            sql.append("(Adjust.FYear = ? and Adjust.FPeriod <=  ? ) )       \n");
            params.add(new Integer(this.sortState.getEndYear()));
            params.add(new Integer(this.sortState.getEndPeriod()));
        }
        sql.append("and Adjust.FPeriodType = ?\t\t\t\t \n");
        params.add(new Integer(this.sortState.getPeriodType()));
        sql.append("and Adjust.FDataSource = ?\t\t\t\t \n");
        params.add(new Integer(this.sortState.getDataSource() - 9));
        sql.append("and Adjust.FValueType = ?\t\t\t\t \n");
        params.add(new Integer(this.sortState.getValueType()));
        sql.append("and Adjust.FDataCollectNumber = ?\t\t\t\t \n");
        params.add(this.sortState.getDataCollectNumber());
        sql.append("and(");
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        DyItemCalculator.DyItem dyItem = (DyItemCalculator.DyItem)formula;
        sql.append("(rptItem.FNumber = ?                     \n");
        params.add(dyItem.itemNumber);
        if (!StringUtils.isEmpty((String)dyItem.dyItemNumber)) {
            if (dyItem.isShortNum) {
                sql.append("and (DyItem.FKeyLongNumber like ? ");
                params.add("%" + dyItem.dyItemNumber);
                sql.append("or DyItem.FKeyLongNumber = ?)     \n");
                params.add(dyItem.dyItemNumber);
            } else {
                sql.append("and DyItem.FKeyLongNumber = ?\t \n");
                params.add(dyItem.dyItemNumber);
            }
        }
        sql.append("and AdjustEntry.FDataElement = ? \t)    \n");
        params.add(new Integer(dyItem.int_dataElement));
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(")");
        sql.append("group by rptItem.FNumber");
        sql.append(",DyItem.FKeyLongNumber");
        sql.append(",AdjustEntry.FDataElement ");
        sql.append(",Adjust.FDataCollectNumber ");
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = (DyItemSortState)sortState;
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combineState;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        DyItemCalculator.DyItem dyItem = (DyItemCalculator.DyItem)formula;
        ArrayList<Object> fieldList = new ArrayList<Object>();
        fieldList.add(dyItem.itemNumber);
        if (!StringUtils.isEmpty((String)dyItem.dyItemNumber) && !dyItem.isShortNum) {
            fieldList.add(dyItem.dyItemNumber);
        }
        fieldList.add(new Integer(dyItem.int_dataElement));
        fieldList.add(dyItem.dataCollectNumber);
        Object[][] result = new Object[1][fieldList.size()];
        result[0] = fieldList.toArray();
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        ArrayList<String> indexFields = new ArrayList<String>();
        indexFields.add("ItemNumber");
        if (!this.sortState.dyItemNumIsNull() && !this.sortState.isShortNum()) {
            indexFields.add("DyItemNumber");
        }
        indexFields.add("DataElement");
        indexFields.add("DataCollectNumber");
        this.IndexResultSetFields = new String[indexFields.size()];
        indexFields.toArray(this.IndexResultSetFields);
        return this.IndexResultSetFields;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return this.batchSize;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        DyItemCombineState state = (DyItemCombineState)combineState;
        state.setValue(rs.getObject("Value"));
        state.setDyItemNum(rs.getString("DyItemNumber"));
    }

    @Override
    public Set getAllowedNullFields() {
        return null;
    }

    @Override
    public List getFormulaCalculators() {
        return this.sortState.getFormulaList();
    }
}

