/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.dyitem;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.dyitem.DyItemCalculator;
import com.kingdee.eas.fi.rpt.batch.dyitem.DyItemCombineState;
import com.kingdee.eas.fi.rpt.batch.dyitem.DyItemSortState;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DyItemProccessor
implements IBatchSQLSorterProcessor {
    private static Logger logger = Logger.getLogger(DyItemProccessor.class);
    private int batchSize;
    protected DyItemSortState sortState;
    protected DyItemCombineState combineState;
    private boolean isIncludeUnCommit = false;
    private String[] IndexResultSetFields;
    protected Context ctx = null;
    protected String[] dyItemTables = null;

    public DyItemProccessor() {
        this.combineState = new DyItemCombineState();
    }

    public DyItemProccessor(Context ctx, int batchSize, boolean isIncludeUnCommit) {
        this.batchSize = batchSize;
        this.combineState = new DyItemCombineState();
        this.isIncludeUnCommit = isIncludeUnCommit;
        this.ctx = ctx;
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        if (this.sortState.getValueType() == 3) {
            sql.append("select ItemDataEntry.FTextValue as  Value       \n");
        } else {
            sql.append("select sum(ItemDataEntry.FValue) as Value\t    \n");
        }
        sql.append(",ItemDataEntry.FItemID AS ItemNumber\t\t\t\t\n");
        sql.append(",ItemDataEntry.FKeyNumber AS DyItemNumber\t\t\t\n");
        sql.append(",ItemDataEntry.FDataElement AS DataElement\t\t\t\n");
        sql.append(",ItemData.FDataCollectNumber AS DataCollectNumber\t\n");
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(" from ").append(this.dyItemTables[0]).append("  ItemData \n");
        sql.append("inner join ").append(this.dyItemTables[1]).append(" ItemDataEntry on ItemData.FID=ItemDataEntry.FItemDataID\t \n");
        sql.append("inner join T_CSL_RptReceived RptReceived on ItemData.FReportID=RptReceived.FReportID\t\t \n");
        sql.append(" inner join  T_CSL_CslReport report on rptReceived.FReportID=report.FID\t  \n");
        sql.append(" inner join  T_RPT_Template template on template.FID=report.FTemplateID\t  \n");
        sql.append("inner join T_ORG_BaseUnit org on ItemData.FOrgUnitID = org.FID                               \n");
        sql.append(" LEFT OUTER JOIN T_CSL_FastMergeSolu mergeSchm ON itemdata.FFastMergeSoluID = mergeSchm.FID  \n");
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append("Where ItemData.FDataType = ?   \t\t\t \n");
        if (this.sortState.isAdjusted()) {
            params.add(new Integer(2));
        } else {
            params.add(new Integer(0));
        }
        try {
            sql.append("and RptReceived.FOrgTreeID in ").append(RptUtilForServer.createInStringSql(this.sortState.getOrgBoundIdSet().iterator(), null)).append(" \n");
        }
        catch (SQLDataException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        sql.append(" and ItemData.FDataSource=").append(this.sortState.getDataSource());
        sql.append(" and ItemData.fdynatype = ");
        sql.append("1  \n");
        sql.append("and org.FNumber = ?\t\t  \t    \n");
        params.add(this.sortState.getOrgUnitNumber());
        sql.append("and ItemData.FCurrencyID = ?           \t\n");
        params.add(this.sortState.getCurrency());
        sql.append("and ItemData.FSourceCurrencyID = ?      \n");
        params.add(this.sortState.getSourceCurrecy());
        sql.append("and ItemData.FPeriodType = ?         \t\n");
        params.add(new Integer(this.sortState.getPeriodType()));
        if (this.sortState.isSamePeriod()) {
            sql.append("and ItemDataEntry.FYear = ?         \n");
            sql.append("and ItemDataEntry.FPeriod = ?       \n");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getStartPeriod()));
        } else if (this.sortState.isSameYear()) {
            sql.append("and ItemDataEntry.FYear = ?         \n");
            params.add(new Integer(this.sortState.getStartYear()));
            sql.append("and ItemDataEntry.FPeriod >= ?      \n");
            sql.append("and ItemDataEntry.FPeriod <= ?      \n");
            params.add(new Integer(this.sortState.getStartPeriod()));
            params.add(new Integer(this.sortState.getEndPeriod()));
        } else {
            sql.append("and ((ItemDataEntry.FYear = ? and ItemDataEntry.FPeriod >= ? ) or  \n");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getStartPeriod()));
            sql.append("( ItemDataEntry.FYear > ?  and ItemDataEntry.FYear < ?  ) or       \n");
            params.add(new Integer(this.sortState.getStartYear()));
            params.add(new Integer(this.sortState.getEndYear()));
            sql.append("(ItemDataEntry.FYear = ? and ItemDataEntry.FPeriod <=  ? ) )       \n");
            params.add(new Integer(this.sortState.getEndYear()));
            params.add(new Integer(this.sortState.getEndPeriod()));
        }
        if (!this.isIncludeUnCommit && this.sortState.isNeedCommitStatus()) {
            sql.append("and ItemData.FCommitStatus = 3    \t\n");
        }
        if (this.sortState.dyItemNumIsNull()) {
            sql.append("and ItemDataEntry.FGradeIsleaf = ?  \n");
            params.add(new Integer(1));
        }
        if (!StringUtils.isEmpty((String)this.sortState.getMergeSchm())) {
            sql.append(" AND mergeSchm.FNumber = ?          \n");
            params.add(this.sortState.getMergeSchm());
        }
        sql.append("and ItemDataEntry.FValueType = ? \t\t\n");
        params.add(new Integer(this.sortState.getValueType()));
        sql.append("and ItemData.FDataCollectNumber = ?      \n");
        params.add(this.sortState.getDataCollectNumber());
        sql.append("and (");
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        DyItemCalculator.DyItem dyItem = (DyItemCalculator.DyItem)formula;
        sql.append("(ItemDataEntry.FItemID = ?                    \n");
        params.add(dyItem.itemNumber);
        if (!StringUtils.isEmpty((String)dyItem.dyItemNumber)) {
            if (dyItem.isShortNum) {
                sql.append("and (ItemDataEntry.FKeyNumber like ? ");
                params.add("%!" + dyItem.dyItemNumber);
                sql.append("or ItemDataEntry.FKeyNumber = ?)     \n");
                params.add(dyItem.dyItemNumber);
            } else {
                sql.append("and ItemDataEntry.FKeyNumber = ?\t \n");
                params.add(dyItem.dyItemNumber);
            }
        }
        sql.append("and ItemDataEntry.FDataElement = ?          \n");
        params.add(new Integer(dyItem.int_dataElement));
        sql.append(" )\n");
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(")");
        if (this.sortState.getValueType() != 3) {
            sql.append(" group by ItemDataEntry.FItemID");
            sql.append(",ItemDataEntry.FKeyNumber");
            sql.append(",ItemDataEntry.FDataElement ");
            sql.append(",ItemData.FDataCollectNumber ");
        }
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = (DyItemSortState)sortState;
        try {
            this.dyItemTables = CslRptUtil.getDyItemTables((Context)this.ctx, (int)new Integer(this.sortState.getStartYear()), (int)new Integer(this.sortState.getStartPeriod()), (int)new Integer(this.sortState.getEndYear()), (int)new Integer(this.sortState.getEndPeriod()));
        }
        catch (Exception ex) {
            this.dyItemTables = new String[]{"t_csl_dynaitemdata", "t_csl_dynaitemdataentry"};
            logger.error((Object)"getDyItemTables error.", (Throwable)ex);
        }
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combineState;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        DyItemCalculator.DyItem dyItem = (DyItemCalculator.DyItem)formula;
        ArrayList<Object> fieldList = new ArrayList<Object>();
        fieldList.add(dyItem.itemNumber);
        if (!StringUtils.isEmpty((String)dyItem.dyItemNumber) && !dyItem.isShortNum) {
            fieldList.add(dyItem.dyItemNumber);
        }
        fieldList.add(new Integer(dyItem.int_dataElement));
        fieldList.add(dyItem.dataCollectNumber);
        Object[][] result = new Object[1][fieldList.size()];
        result[0] = fieldList.toArray();
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        ArrayList<String> indexFields = new ArrayList<String>();
        indexFields.add("ItemNumber");
        if (!this.sortState.dyItemNumIsNull() && !this.sortState.isShortNum()) {
            indexFields.add("DyItemNumber");
        }
        indexFields.add("DataElement");
        indexFields.add("DataCollectNumber");
        this.IndexResultSetFields = new String[indexFields.size()];
        indexFields.toArray(this.IndexResultSetFields);
        return this.IndexResultSetFields;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return this.batchSize;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        DyItemCombineState state = (DyItemCombineState)combineState;
        state.setValue(rs.getObject("Value"));
        state.setDyItemNum(rs.getString("DyItemNumber"));
    }

    @Override
    public Set getAllowedNullFields() {
        return null;
    }

    @Override
    public List getFormulaCalculators() {
        return this.sortState.getFormulaList();
    }
}

