/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.esp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.util.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Esp
extends AbstractFormulaCalculatorParameter {
    public static final String DATE_FORMAT_STR = "yyyy-MM-dd";
    private PeriodCollection fiscalPeriods = null;
    private boolean isMergeByFiscalPeriod = false;
    private boolean isSupport13Period = false;
    private BatchHelper batchHelper;
    private String periodType;
    private int yearOffset;
    private int periodOffset;
    String orgBoundNumber;
    String orgUnitInvest;
    String orgUnitInvested;
    int rptPeriodType;
    int rptYear;
    int rptPeriod;
    Date effectDate;
    String orgBoundId;
    int year;
    int period;
    String strDate;

    Esp(Parameter param, BatchHelper batchHelper, PeriodCollection fiscalPeriods, boolean isMergeByFiscalPeriod, boolean isSupport13Period) {
        this.fiscalPeriods = fiscalPeriods;
        this.isMergeByFiscalPeriod = isMergeByFiscalPeriod;
        this.isSupport13Period = isSupport13Period;
        this.batchHelper = batchHelper;
        this.setParameter(param);
        try {
            this.initArgs();
            this.verifyArgs();
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    public Object[] getFields() {
        return null;
    }

    @Override
    protected void verifyArgs() throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)this.orgBoundNumber)) {
            this.orgBoundNumber = this.batchHelper.getOrgTreeNumber();
        }
        if (StringUtils.isEmpty((String)this.orgBoundNumber)) {
            throw new ReportException(ReportException.ORGBOUND_PARAM_NULL);
        }
        if (StringUtils.isEmpty((String)this.orgUnitInvest)) {
            throw new ReportException(ReportException.INVEST_COMPANY_NULL);
        }
        if (StringUtils.isEmpty((String)this.orgUnitInvested)) {
            throw new ReportException(ReportException.INVESTED_COMPANY_NULL);
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)this.batchHelper.getServerContext());
        FullOrgUnitCollection orgUnitInvestCollection = iFullOrgUnit.getFullOrgUnitCollection("where number = '" + this.orgUnitInvest + "'");
        if (orgUnitInvestCollection.size() == 0) {
            throw new ReportException(ReportException.ORGUNITINVEST_NOT_EXISTS, new Object[]{this.orgUnitInvest});
        }
        FullOrgUnitCollection orgUnitInvestedCollection = iFullOrgUnit.getFullOrgUnitCollection("where number = '" + this.orgUnitInvested + "'");
        if (orgUnitInvestedCollection.size() == 0) {
            throw new ReportException(ReportException.ORGUNITINVESTED_NOT_EXISTS, new Object[]{this.orgUnitInvested});
        }
    }

    @Override
    protected void initArgs() throws BOSException, EASBizException {
        int argsCount;
        Object[] args = this.getParameter().getArgs();
        if (((Variant)args[argsCount = 0]).getValue() != null) {
            this.orgBoundNumber = ((Variant)args[argsCount]).getValue().toString();
        }
        if (((Variant)args[++argsCount]).getValue() != null) {
            this.orgUnitInvest = ((Variant)args[argsCount]).getValue().toString();
        }
        if (((Variant)args[++argsCount]).getValue() != null) {
            this.orgUnitInvested = ((Variant)args[argsCount]).getValue().toString();
        }
        this.periodType = ((Variant)args[++argsCount]).getValue() == null ? null : ((Variant)args[argsCount]).getValue().toString();
        ++argsCount;
        if (RptPeriodTypeEnum.getEnum((String)this.periodType) == null || RptPeriodTypeEnum.getEnum((String)this.periodType).getValue() != 3) {
            throw new ReportException(ReportException.REPORT_PERIOD_ERROR);
        }
        this.rptPeriodType = FormulaAdapter.getRptPeriodType((String)this.periodType);
        this.year = Integer.parseInt(((Variant)args[argsCount]).getValue().toString());
        this.yearOffset = this.year > 0 ? 0 : this.year;
        this.period = Integer.parseInt(((Variant)args[++argsCount]).getValue().toString());
        this.periodOffset = this.period > 0 ? 0 : this.period;
        ++argsCount;
        int rptCurrentYear = this.batchHelper.getReport_Year();
        int rptCurrentPeriod = this.batchHelper.getReport_Period();
        int[] rptDate = null;
        rptDate = this.isSupport13Period ? RPTDate13Util.getRptYearAndPeriod((int)rptCurrentYear, (int)rptCurrentPeriod, (int)this.rptPeriodType, (int)this.yearOffset, (int)this.periodOffset, (Context)this.batchHelper.getServerContext()) : FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)this.fiscalPeriods, (int)rptCurrentYear, (int)rptCurrentPeriod, (int)this.rptPeriodType, (int)this.yearOffset, (int)this.periodOffset, (boolean)this.isMergeByFiscalPeriod);
        this.rptYear = this.year > 0 ? this.year : rptDate[0];
        int n = this.rptPeriod = this.period > 0 ? this.period : rptDate[1];
        if (!StringUtils.isEmpty((String)((String)((Variant)args[argsCount]).getValue()))) {
            this.strDate = ((Variant)args[argsCount]).getValue().toString();
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STR);
                DateFormat format = CslRptUtil.getNationalDateFormat((Context)this.batchHelper.getServerContext());
                dateFormat.setLenient(false);
                if (format != null) {
                    this.effectDate = dateFormat.parse(dateFormat.format(format.parse(this.strDate)));
                }
                this.effectDate = dateFormat.parse(this.strDate);
            }
            catch (ParseException e) {
                throw new ReportException(ReportException.INVDATE_INVALID);
            }
        } else {
            this.effectDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.fiscalPeriods, (int)this.rptYear, (int)this.rptPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.rptPeriodType), (boolean)this.isMergeByFiscalPeriod);
            if (this.effectDate == null) {
                throw new ReportException(ReportException.NOT_YEARORPERIOD);
            }
        }
    }

    public BatchHelper getBatchHelper() {
        return this.batchHelper;
    }

    public void setBatchHelper(BatchHelper batchHelper) {
        this.batchHelper = batchHelper;
    }
}

