/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.esp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.esp.Esp;
import com.kingdee.eas.fi.rpt.batch.esp.EspBatchSQLProcessor;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class EspBatchCalculator
extends AbstractCalculator {
    private List espList;
    private Set orgTreeNumberSet;
    public PeriodCollection fiscalPeriods = null;
    public boolean isMergeByFiscalPeriod = false;
    public boolean isSupport13Period = false;
    private EspBatchSQLProcessor batchSqlProcessor = new EspBatchSQLProcessor();

    private void executeCalculate() throws BOSException, EASBizException {
        this.batchHelper.batchCalculateBigDecimal(this.batchSqlProcessor);
    }

    private void initEsp(SortedParameterArray params) {
        this.orgTreeNumberSet = new HashSet();
        int count = params.size();
        for (int i = 0; i < count; ++i) {
            Esp esp = new Esp(params.getParameter(i), this.batchHelper, this.fiscalPeriods, this.isMergeByFiscalPeriod, this.isSupport13Period);
            if (esp.isException()) {
                this.addToErrorList(esp);
                continue;
            }
            this.espList.add(esp);
            this.orgTreeNumberSet.add(esp.orgBoundNumber);
        }
        this.batchSqlProcessor.setFormulaList(this.espList);
    }

    private void initOrgBound() throws BOSException {
        HashMap<String, OrgTreeCollection> orgBoundMap = new HashMap<String, OrgTreeCollection>();
        if (this.orgTreeNumberSet.size() == 0) {
            return;
        }
        StringBuffer kql = new StringBuffer();
        kql.append("select Fid,FNumber,FStartDate,FEndDate from T_ORG_Tree \n");
        kql.append("where FNumber in         \n");
        kql.append(this.batchHelper.createInSql(this.orgTreeNumberSet.iterator()));
        kql.append(" and (FStatus in (1,2))  \n");
        kql.append(" order by FstartDate desc,FendDate desc");
        IRowSet row = DbUtil.executeQuery((Context)this.serverContext, (String)kql.toString());
        try {
            while (row.next()) {
                OrgTreeInfo info = new OrgTreeInfo();
                info.setId(BOSUuid.read((String)row.getString("Fid")));
                String number = row.getString("FNumber");
                info.setNumber(number);
                info.setStartDate(row.getTimestamp("FStartDate"));
                info.setEndDate(row.getTimestamp("FEndDate"));
                OrgTreeCollection collection = (OrgTreeCollection)orgBoundMap.get(number);
                if (collection == null) {
                    collection = new OrgTreeCollection();
                }
                collection.add(info);
                orgBoundMap.put(number, collection);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.initOrgTreeByRptDate(orgBoundMap);
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        this.executeCalculate();
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.initFiscalPeriod();
        this.initEsp(params);
        this.initOrgBound();
    }

    public EspBatchCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
        this.espList = this.getFormulaCalculatorParameterList();
    }

    private void initFiscalPeriod() throws BOSException, EASBizException {
        this.isSupport13Period = CslRptUtil.isSupport13Period((Context)this.serverContext);
        this.isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod((Context)this.serverContext);
        if (this.isMergeByFiscalPeriod) {
            this.fiscalPeriods = FiscalPeriodHelper.initFormualFiscalPeriods((Context)this.serverContext, (ICalculateContextProvider)this.calCulateContext);
        }
    }

    public void initOrgTreeByRptDate(Map orgBoundMap) {
        List formulaList = this.getFormulaCalculatorParameterList();
        block2: for (Esp esp : formulaList) {
            try {
                RptPeriodTypeEnum rptPeriodType = RptPeriodTypeEnum.getEnum((int)esp.rptPeriodType);
                Date rptDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.fiscalPeriods, (int)esp.rptYear, (int)esp.rptPeriod, (RptPeriodTypeEnum)rptPeriodType, (boolean)this.isMergeByFiscalPeriod);
                if (rptDate == null) continue;
                OrgTreeCollection orgTreeColl = (OrgTreeCollection)orgBoundMap.get(esp.orgBoundNumber);
                if (null == orgTreeColl || 0 == orgTreeColl.size()) {
                    this.addToErrorList(esp, (Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"47_AdjustDataCalculator", (Locale)this.batchHelper.getServerContext().getLocale()))));
                    continue;
                }
                for (int i = 0; i < orgTreeColl.size(); ++i) {
                    String orgTreeId = orgTreeColl.get(i).getId().toString();
                    Timestamp startDate = orgTreeColl.get(i).getStartDate();
                    if (startDate.compareTo(new Timestamp(rptDate.getTime())) > 0) continue;
                    esp.orgBoundId = orgTreeId;
                    continue block2;
                }
            }
            catch (Exception e) {
                esp.setException(e);
            }
        }
    }
}

