/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.esp;

import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.esp.Esp;
import com.kingdee.eas.fi.rpt.batch.esp.EspCombinestate;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class EspBatchSQLProcessor
implements IBatchSQLProcessor {
    public static final Logger logger = Logger.getLogger(EspBatchSQLProcessor.class);
    private static int maxsqlvar = 200;
    protected Set nullFields = new HashSet();
    protected List formulaList;
    protected EspCombinestate combinestate = new EspCombinestate();
    protected static String[] IndexResultSetFields = new String[]{"FORGBOUNDID", "TARNUM", "COMNUM", "FYEAR", "FPERIOD"};

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combinestate;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return maxsqlvar;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        Object[][] result = new Object[1][];
        Esp esp = (Esp)formula;
        ArrayList<Object> fileds = new ArrayList<Object>();
        fileds.add(esp.orgBoundId);
        fileds.add(esp.orgUnitInvested);
        fileds.add(esp.orgUnitInvest);
        fileds.add(new Integer(esp.rptYear));
        fileds.add(new Integer(esp.rptPeriod));
        result[0] = fileds.toArray();
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        return IndexResultSetFields;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        EspCombinestate state = (EspCombinestate)combineState;
        state.setRate(rs.getBigDecimal("FRATE"));
        state.setEffectDate(rs.getTimestamp("FDATE"));
    }

    @Override
    public List getFormulaCalculators() {
        return this.formulaList;
    }

    @Override
    public Set getAllowedNullFields() {
        return this.nullFields;
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append(" SELECT FORGBOUNDID,TARGETCOMPANY.FNUMBER TARNUM,    \n");
        sql.append(" COMPANY.FNUMBER COMNUM,CASE WHEN FEQUIVRATE IS NULL THEN ISNULL(FRATE,0) \n");
        sql.append(" ELSE FEQUIVRATE END AS FRATE,FYEAR,FPERIOD,FDATE    \n");
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(" FROM T_CSL_ELIMINVESTRATE ELIMINVESTRATE           \n");
        sql.append(" JOIN T_ORG_BASEUNIT TARGETCOMPANY ON               \n");
        sql.append(" ELIMINVESTRATE.FTARGETCOMPANY = TARGETCOMPANY.FID  \n");
        sql.append(" JOIN T_ORG_BASEUNIT COMPANY ON                     \n");
        sql.append(" ELIMINVESTRATE.FCOMPANY = COMPANY.FID              \n");
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(" WHERE");
    }

    @Override
    public void buildVariableWherePart(StringBuffer sqlPara, List paramsPara, IFormulaCalculator formula) {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            Esp esp = (Esp)formula;
            sql.append("  ELIMINVESTRATE.FDATE= ");
            sql.append(" (select  max(a.FDATE) from T_CSL_ELIMINVESTRATE a  ");
            sql.append(" JOIN T_ORG_BASEUNIT TARGETCOMPANY1 ON               \n");
            sql.append(" a.FTARGETCOMPANY = TARGETCOMPANY1.FID  \n");
            sql.append(" JOIN T_ORG_BASEUNIT COMPANY1 ON                     \n");
            sql.append(" a.FCOMPANY = COMPANY1.FID              \n");
            sql.append("  where a.FYEAR = ?               \n");
            params.add(new Integer(esp.rptYear));
            sql.append(" AND a.FPERIOD = ?         \n");
            params.add(new Integer(esp.rptPeriod));
            sql.append(" AND a.FORGBOUNDID = ?     \n");
            params.add(esp.orgBoundId);
            sql.append(" AND TARGETCOMPANY1.FNUMBER = ?          \n");
            params.add(esp.orgUnitInvested);
            sql.append(" AND COMPANY1.FNUMBER = ?                \n");
            params.add(esp.orgUnitInvest);
            sql.append(" AND a.FDATE <= ? ) \n ");
            Date t = new Date(esp.effectDate.getTime());
            params.add(t);
            sql.append(" AND ELIMINVESTRATE.FPERIOD = ?   \n ");
            params.add(new Integer(esp.rptPeriod));
            sql.append(" AND ELIMINVESTRATE.FORGBOUNDID =  ?");
            params.add(esp.orgBoundId);
            sql.append(" AND ELIMINVESTRATE.FYEAR = ?               \n");
            params.add(new Integer(esp.rptYear));
            sql.append(" AND TARGETCOMPANY.FNUMBER = ?          \n");
            params.add(esp.orgUnitInvested);
            sql.append(" AND COMPANY.FNUMBER = ?                \n");
            params.add(esp.orgUnitInvest);
            sql.append("   \n");
            sqlPara.append(sql);
            paramsPara.addAll(params);
        }
        catch (Exception e) {
            ((Esp)formula).setException(e);
            sqlPara.append(" 1 != 2 \n");
        }
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(" ORDER BY FORGBOUNDID ASC,FDATE DESC");
    }

    public void setFormulaList(List formulaList) {
        this.formulaList = formulaList;
    }
}

