/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.hint;

import com.kingdee.bos.Context;
import com.kingdee.eas.fi.rpt.batch.hint.ISQLHintSource;
import com.kingdee.eas.fi.rpt.batch.hint.SQLHintProvider;
import org.apache.log4j.Logger;

public class SQLHintMatcher {
    private static final Logger log = Logger.getLogger(SQLHintMatcher.class);
    protected Context ctx;

    public SQLHintMatcher(Context ctx) {
        this.ctx = ctx;
    }

    public String addHint(String sql, ISQLHintSource source) {
        try {
            if (source == null) {
                return sql;
            }
            String hint = this.getSQLHintProvider().find(source);
            if (!"".equals(hint) && hint != null) {
                log.info((Object)("find hint '" + hint + "',start to insert hint string to sql"));
                String newSQL = source.insertHint(sql, hint);
                if (!newSQL.equals(sql) && log.isDebugEnabled()) {
                    log.debug((Object)("after insert hint string,sql is '" + newSQL + "'"));
                }
                return newSQL;
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return sql;
    }

    protected SQLHintProvider getSQLHintProvider() {
        return new SQLHintProvider(this.ctx);
    }
}

