/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.invdata;

import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.invdata.InvData;
import com.kingdee.eas.fi.rpt.batch.invdata.InvDataCombineState;
import com.kingdee.eas.fi.rpt.batch.invdata.InvDataFormulaDynaItemHelp;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstracteInvDataSQLProcessor
implements IBatchSQLProcessor {
    protected static int maxsqlvar = 200;
    protected Set nullFields;
    protected List formulaList;
    protected String QueryField;
    protected String _itemName;
    protected InvDataCombineState combineState;

    public AbstracteInvDataSQLProcessor(String itemName) {
        this._itemName = itemName;
        this.QueryField = InvDataFormulaDynaItemHelp.getInstance().getField(itemName);
        this.nullFields = new HashSet();
        this.combineState = new InvDataCombineState();
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combineState;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return maxsqlvar;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        InvDataCombineState state = (InvDataCombineState)combineState;
        state.setValue(rs.getBigDecimal(this.QueryField));
        state.setChgDate(rs.getDate("chgDate"));
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(" order by chgDate DESC");
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(" where ");
    }

    @Override
    public Set getAllowedNullFields() {
        return this.nullFields;
    }

    @Override
    public List getFormulaCalculators() {
        return this.formulaList;
    }

    protected void buildMappingSelectPart(Set nullSet, StringBuffer sql) {
        sql.append(" ,Com.fnumber Num, targetCom.fnumber targNum,currency.fnumber curNum,InvData.fchangeDate chgDate \n");
    }

    protected void buildCommonFromPart(Set nullSet, StringBuffer sql) {
        sql.append(" from t_csl_InvestDay InvData join t_org_baseUnit targetCom \t\t\n");
        sql.append(" on InvData.ftargetcompanyid = targetCom.fid \t\t\t\t\t\t\t\n");
        sql.append(" join t_org_baseUnit Com on InvData.fcompanyid = Com.fid \t\t\t\t\n");
        sql.append(" join t_bd_currency currency on InvData.fcurrencyid = currency.fid \n");
    }

    protected void buildWhereMaxChgDateSQL(StringBuffer sql, InvData invData, Date date, List params) {
        sql.append("(select  max(InvData2.fchangedate) from t_csl_investDay InvData2 \n");
        sql.append(" join t_org_baseunit com2 on com2.fid = InvData2.fcompanyid \n");
        sql.append(" join t_org_baseunit targetcom2 on targetcom2.fid = InvData2.ftargetcompanyid \n");
        sql.append(" join t_bd_currency currency2 on currency2.fid = InvData2.fcurrencyid \n");
        sql.append(" where com2.fnumber = ? \n");
        params.add(invData.orgUnitInvest);
        sql.append(" and targetcom2.fnumber = ? \n");
        params.add(invData.orgUnitInvested);
        sql.append(" and currency2.fnumber = ? \n");
        params.add(invData.currencyNum);
        sql.append(" and InvData2.fchangeDate <= ? ) \n");
        params.add(date);
    }

    protected void buildVariableCommonWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        InvData invData = (InvData)formula;
        sql.append(" targetCom.fnumber = ? \t\n");
        params.add(invData.orgUnitInvested);
        sql.append(" and Com.fnumber = ? \t\t\n");
        params.add(invData.orgUnitInvest);
        sql.append(" and InvData.fchangeDate =\t\n");
        Date date = new Date(invData.InvDate.getTime());
        this.buildWhereMaxChgDateSQL(sql, invData, date, params);
        sql.append(" and currency.fnumber = ?\t\t\n");
        params.add(invData.currencyNum);
    }

    protected List getFormulaList() {
        return this.formulaList;
    }

    protected void setFormulaList(List formulaList) {
        this.formulaList = formulaList;
    }

    protected String getRealNum(IFormulaCalculator formula) {
        String ItemNum = ((InvData)formula).ItemType;
        return InvDataFormulaDynaItemHelp.getInstance().getrealItemNum(ItemNum);
    }

    protected String getFlagByItemNum(IFormulaCalculator formula) {
        String ItemNum = ((InvData)formula).ItemType;
        return InvDataFormulaDynaItemHelp.getInstance().getFlagByItemNum(ItemNum);
    }
}

