/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.invdata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.invdata.InvDataFormulaDynaItemHelp;
import com.kingdee.util.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class InvData
extends AbstractFormulaCalculatorParameter {
    private static final Logger log = Logger.getLogger((String)InvData.class.getName());
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private BatchHelper batchHelper;
    String orgUnitInvest;
    String orgUnitInvested;
    String ItemType;
    Date InvDate;
    String currencyNum;
    String FassistanFlag;
    boolean isMergeByFiscalPeriod = false;
    PeriodCollection periods = null;

    InvData(Parameter param, BatchHelper batchHelper, PeriodCollection periods, boolean isMergeByFiscalPeriod) {
        this.isMergeByFiscalPeriod = isMergeByFiscalPeriod;
        this.periods = periods;
        this.batchHelper = batchHelper;
        this.setParameter(param);
        try {
            this.initArgs();
            this.verifyArgs();
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    @Override
    protected void initArgs() throws BOSException, EASBizException {
        Object[] args = this.getParameter().getArgs();
        this.orgUnitInvest = StringUtils.isEmpty((String)((Variant)args[0]).getValue().toString()) ? this.batchHelper.getCompany_Number() : ((Variant)args[0]).getValue().toString();
        this.orgUnitInvested = ((Variant)args[1]).getValue() == null ? null : ((Variant)args[1]).getValue().toString();
        String string = this.ItemType = ((Variant)args[4]).getValue() == null ? null : ((Variant)args[4]).getValue().toString();
        if (!StringUtils.isEmpty((String)((Variant)args[2]).getValue().toString())) {
            String date = ((Variant)args[2]).getValue().toString();
            try {
                dateFormat.setLenient(false);
                DateFormat format = CslRptUtil.getNationalDateFormat((Context)this.batchHelper.getServerContext());
                if (format != null) {
                    this.InvDate = dateFormat.parse(dateFormat.format(format.parse(date)));
                }
                this.InvDate = dateFormat.parse(date);
            }
            catch (ParseException e) {
                throw new ReportException(ReportException.INVDATE_INVALID);
            }
        } else {
            int rptYear = this.batchHelper.getReport_Year();
            int rptPeriod = this.batchHelper.getReport_Period();
            int rptPeriodType = this.batchHelper.getReport_PeriodType();
            this.InvDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.periods, (int)rptYear, (int)rptPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)rptPeriodType), (boolean)this.isMergeByFiscalPeriod);
        }
        this.currencyNum = !StringUtils.isEmpty((String)((Variant)args[3]).getValue().toString()) ? ((Variant)args[3]).getValue().toString() : this.batchHelper.getCorrect_Currency_Number(this.getSheetName());
        this.FassistanFlag = InvDataFormulaDynaItemHelp.getInstance().getFlagByItemNum(this.ItemType);
    }

    @Override
    protected void verifyArgs() throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)this.orgUnitInvest)) {
            throw new ReportException(ReportException.INVEST_COMPANY_NULL);
        }
        if (StringUtils.isEmpty((String)this.orgUnitInvested)) {
            throw new ReportException(ReportException.INVESTED_COMPANY_NULL);
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)this.batchHelper.getServerContext());
        FullOrgUnitCollection orgUnitInvestCollection = iFullOrgUnit.getFullOrgUnitCollection("where number = '" + this.orgUnitInvest + "'");
        if (orgUnitInvestCollection.size() == 0) {
            throw new ReportException(ReportException.ORGUNITINVEST_NOT_EXISTS, new Object[]{this.orgUnitInvest});
        }
        FullOrgUnitCollection orgUnitInvestedCollection = iFullOrgUnit.getFullOrgUnitCollection("where number = '" + this.orgUnitInvested + "'");
        if (orgUnitInvestedCollection.size() == 0) {
            throw new ReportException(ReportException.ORGUNITINVESTED_NOT_EXISTS, new Object[]{this.orgUnitInvested});
        }
        if (this.InvDate == null) {
            throw new ReportException(ReportException.INVDATE_INVALID);
        }
        if (InvDataFormulaDynaItemHelp.getInstance().isavailability(this.ItemType)) {
            throw new ReportException(ReportException.INVITEM_ERROR);
        }
    }

    public String toString() {
        Object[] args = this.getParameter().getArgs();
        StringBuffer formulaStr = new StringBuffer("InvData(");
        for (int k = 0; k < args.length; ++k) {
            formulaStr.append("\"").append(args[k]).append("\",");
        }
        return formulaStr.deleteCharAt(formulaStr.length() - 1).append(")").toString();
    }

    public static void main(String[] args) {
        Object[] args2 = new Object[]{"", "", "2009-05-04", "BB001", "0009"};
        StringBuffer formulaStr = new StringBuffer("InvData(");
        for (int k = 0; k < args2.length; ++k) {
            formulaStr.append("\"").append(args2[k]).append("\",");
        }
    }
}

