/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.iref;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.iref.IRef;
import com.kingdee.eas.fi.rpt.batch.iref.IRefBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.iref.IRefSortState;
import java.util.HashMap;

public class IRefBatchCalculator
extends AbstractCalculator {
    private IBatchSQLSorterRegister sortRegister;
    private IRefBatchSQLProcessor batchProcessor;

    public IRefBatchCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        this.executeCalculate();
    }

    private void executeCalculate() throws BOSException, EASBizException {
        this.batchProcessor = new IRefBatchSQLProcessor(this.serverContext);
        this.batchHelper.batchCalculateBigDecimalBySorter(this.batchProcessor, this.sortRegister);
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.initSortRegister();
        this.initIRef(params);
    }

    @Override
    protected void handleAllException() {
        for (IRef ref : this.formulaCalculatorList) {
            if (ref.isException() || ref.getParameter().getValue() != null || !ref.isTxtValueType()) continue;
            ref.getParameter().setValue((Object)Variant.emptyVariant);
        }
        super.handleAllException();
    }

    private void initIRef(SortedParameterArray params) {
        int count = params.size();
        for (int i = 0; i < count; ++i) {
            IRef ref = new IRef(params.getParameter(i), this.batchHelper);
            if (ref.isException()) {
                this.addToErrorList(ref);
                continue;
            }
            this.getFormulaCalculatorParameterList().add(ref);
            this.sortRegister.register(ref);
        }
    }

    private void initSortRegister() {
        this.sortRegister = new BatchSQLSorterRegister(new HashMap(), IRefSortState.class.getName());
    }
}

