/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.log;

import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class LogService {
    private List<LogItem> logItems = new ArrayList<LogItem>(0);
    private Logger _logger;
    private boolean _forceLog = false;

    public LogService(Logger logger) {
        this._logger = logger;
    }

    public LogService(Logger logger, boolean forceLog) {
        this._logger = logger;
        this._forceLog = forceLog;
    }

    public synchronized void addLogItem(String title, String message) {
        if (this.isLogState()) {
            this.logItems.add(new LogItem(title, message));
        }
    }

    public synchronized void addLogItem(String title, Object[] messages) {
        if (this.isLogState()) {
            StringBuffer messagesBuffer = new StringBuffer();
            for (int i = 0; i < messages.length; ++i) {
                messagesBuffer.append("[" + messages[i] + "]");
            }
            this.logItems.add(new LogItem(title, messagesBuffer.toString()));
        }
    }

    public synchronized String builderLogMessage() {
        if (this.logItems.size() > 0) {
            StringBuffer sb = new StringBuffer(100);
            Iterator<LogItem> it = this.logItems.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                sb.append("\r\n");
            }
            return sb.toString();
        }
        return "";
    }

    public synchronized void logIt() {
        if (this.isLogState()) {
            this._logger.error((Object)this.builderLogMessage());
        }
    }

    public synchronized void reset() {
        this.logItems.clear();
    }

    private boolean isLogState() {
        return this._logger == null ? false : this._logger.isDebugEnabled() || DebugLogger.isDebug || this._forceLog;
    }

    private class LogItem {
        protected String _title;
        protected String _message;

        LogItem(String title, String message) {
            this._title = title;
            this._message = message;
        }

        public String toString() {
            return (StringUtils.isEmpty((String)this._title) ? "" : this._title) + (StringUtils.isEmpty((String)this._title) ? "" : ": ") + this._message;
        }
    }
}

