/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.temptablescheme;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.rpt.TransactionCtrlFacadeFactory;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableFieldItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.eas.fi.rpt.jdbc.SqlParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class TempTableUtil {
    private static final Logger log = Logger.getLogger(TempTableUtil.class);
    private static final String NVARCHAR_44 = "nvarchar(44)";
    private static final String NVARCHAR_200 = "nvarchar(200)";

    public static String createDBSystemTempTable(TempTableJdbcTemplate tempTableJdbcTemplate, ITempTableField tempTableField, String tableName, boolean isTempTableSchemeDebug) throws BOSException {
        String tempTableName;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("create table ").append(tableName).append(" (");
        StringBuffer indexFieldBuffer = new StringBuffer();
        Iterator it = tempTableField.getTempTableFieldItems().iterator();
        while (it.hasNext()) {
            TempTableFieldItem tempTableFieldItem = (TempTableFieldItem)it.next();
            String tempTableFieldName = tempTableFieldItem.getTempTableField();
            sqlBuffer.append(tempTableFieldName);
            indexFieldBuffer.append(tempTableFieldName);
            if (tempTableFieldItem.getSqlParameter() != null) {
                SqlParameter sqlParameter = tempTableFieldItem.getSqlParameter();
                sqlBuffer.append(" ").append(sqlParameter.getTypeName());
            } else {
                sqlBuffer.append(" ").append(NVARCHAR_44);
            }
            if (!it.hasNext()) continue;
            sqlBuffer.append(", ");
            indexFieldBuffer.append(", ");
        }
        sqlBuffer.append(")");
        if (isTempTableSchemeDebug) {
            tempTableName = tempTableJdbcTemplate.createTempTable(sqlBuffer.toString());
            tempTableJdbcTemplate.createIndex(tempTableName, indexFieldBuffer.toString(), false, false);
            return tempTableName;
        }
        tempTableName = tempTableJdbcTemplate.createDBSystemTempTable(sqlBuffer.toString());
        tempTableJdbcTemplate.createDBSystemTempTableIndex(tempTableName, indexFieldBuffer.toString(), false, false);
        return tempTableName;
    }

    public static String createDBSystemTempTable(TempTableJdbcTemplate tempTableJdbcTemplate, ITempTableField tempTableField, String tableName, boolean isTempTableSchemeDebug, boolean isMoveJoinToLastIndexField) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("create table ").append(tableName).append(" (");
        StringBuffer indexFieldBuffer = new StringBuffer();
        List tempTableFieldItems = tempTableField.getTempTableFieldItems();
        boolean isMoveToLast = isMoveJoinToLastIndexField;
        ArrayList<String> indexFieldNames = new ArrayList<String>(tempTableFieldItems.size());
        int indexFieldIndex = 0;
        Iterator it = tempTableFieldItems.iterator();
        while (it.hasNext()) {
            TempTableFieldItem tempTableFieldItem = (TempTableFieldItem)it.next();
            String tempTableFieldName = tempTableFieldItem.getTempTableField();
            sqlBuffer.append(tempTableFieldName);
            Boolean join = (Boolean)tempTableFieldItem.getProperty("join");
            boolean bl = isMoveToLast = isMoveToLast && join != null && join == false;
            if (!isMoveToLast) {
                indexFieldNames.add(indexFieldIndex, tempTableFieldName);
                ++indexFieldIndex;
            } else {
                indexFieldNames.add(tempTableFieldName);
            }
            if (tempTableFieldItem.getSqlParameter() != null) {
                SqlParameter sqlParameter = tempTableFieldItem.getSqlParameter();
                sqlBuffer.append(" ").append(sqlParameter.getTypeName());
            } else if ("dyItemNumber".equals(tempTableFieldName)) {
                sqlBuffer.append(" ").append(NVARCHAR_200);
            } else {
                sqlBuffer.append(" ").append(NVARCHAR_44);
            }
            if (!it.hasNext()) continue;
            sqlBuffer.append(", ");
        }
        for (int i = 0; i < indexFieldNames.size(); ++i) {
            indexFieldBuffer.append(indexFieldNames.get(i));
            indexFieldBuffer.append(",");
        }
        indexFieldBuffer.deleteCharAt(indexFieldBuffer.length() - 1);
        sqlBuffer.append(")");
        if (isTempTableSchemeDebug) {
            String tempTableName = tempTableJdbcTemplate.createTempTable(sqlBuffer.toString());
            tempTableJdbcTemplate.createIndex(tempTableName, indexFieldBuffer.toString(), false, false);
            return tempTableName;
        }
        String tempTableName = tempTableJdbcTemplate.createDBSystemTempTable(sqlBuffer.toString());
        tempTableJdbcTemplate.createDBSystemTempTableIndex(tempTableName, indexFieldBuffer.toString(), false, false);
        return tempTableName;
    }

    public static String createDBSystemTempTable(TempTableJdbcTemplate tempTableJdbcTemplate, ITempTableField tempTableField, boolean isTempTableSchemeDebug) throws BOSException {
        return TempTableUtil.createDBSystemTempTable(tempTableJdbcTemplate, tempTableField, "T_RPT_VarTempTable", isTempTableSchemeDebug, true);
    }

    public static String createDBSystemTempTableByNewTx(Context ctx, final TempTableJdbcTemplate tempTableJdbcTemplate, final ITempTableField tempTableField, final String tableName, final boolean isTempTableSchemeDebug) throws BOSException {
        HasReturnRunnable createTableRunnable = new HasReturnRunnable(){

            @Override
            public void run() {
                try {
                    if (!isTempTableSchemeDebug) {
                        tempTableJdbcTemplate.initConnection();
                    }
                    this.result = TempTableUtil.createDBSystemTempTable(tempTableJdbcTemplate, tempTableField, tableName, isTempTableSchemeDebug);
                }
                catch (BOSException e) {
                    log.error((Object)"", (Throwable)e);
                    this.excp = e;
                }
            }
        };
        createTableRunnable = (HasReturnRunnable)TransactionCtrlFacadeFactory.getLocalInstance(ctx).runByRequiresNewTx(createTableRunnable);
        return (String)createTableRunnable.getReturn();
    }

    public static void releaseDBSystemTempTable(TempTableJdbcTemplate tempTableJdbcTemplate, String tableName) throws BOSException {
        tempTableJdbcTemplate.releaseDBSystemTempTable(tableName);
    }

    public static void releaseTempTableByNewTx(final Context ctx, final TempTableJdbcTemplate tempTableJdbcTemplate, final boolean isTempTableSchemeDebug, final String tableName) throws BOSException {
        HasReturnRunnable runnable = new HasReturnRunnable(){

            @Override
            public void run() {
                try {
                    if (isTempTableSchemeDebug) {
                        TempTableJdbcTemplate localTempTableJdbcTemplate = new TempTableJdbcTemplate(ctx);
                        localTempTableJdbcTemplate.initConnection();
                        localTempTableJdbcTemplate.releaseTempTable(tableName);
                    } else {
                        tempTableJdbcTemplate.releaseDBSystemTempTable(tableName);
                    }
                }
                catch (BOSException e) {
                    log.error((Object)"", (Throwable)e);
                    this.excp = e;
                }
            }
        };
        runnable = (HasReturnRunnable)TransactionCtrlFacadeFactory.getLocalInstance(ctx).runByRequiresNewTx(runnable);
        runnable.getReturn();
    }

    public static void analyzeTableByNewTx(final Context ctx, final String tableName) throws BOSException {
        HasReturnRunnable runnable = new HasReturnRunnable(){

            @Override
            public void run() {
                try {
                    TempTableJdbcTemplate tempTableJdbcTemplate = new TempTableJdbcTemplate(ctx);
                    tempTableJdbcTemplate.initConnection();
                    tempTableJdbcTemplate.analyzeTable(tableName);
                }
                catch (BOSException e) {
                    log.error((Object)"", (Throwable)e);
                    this.excp = e;
                }
            }
        };
        runnable = (HasReturnRunnable)TransactionCtrlFacadeFactory.getLocalInstance(ctx).runByRequiresNewTx(runnable);
        runnable.getReturn();
    }

    static abstract class HasReturnRunnable
    implements Runnable {
        protected Object result;
        protected BOSException excp;

        HasReturnRunnable() {
        }

        public Object getReturn() throws BOSException {
            if (this.excp != null) {
                throw this.excp;
            }
            return this.result;
        }
    }
}

