/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.check;

import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ParseException;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public final class CheckExpressionParser {
    private static final char DONE = '\uffff';
    protected String _line;
    protected int _pos = 0;
    protected int _end = 0;
    protected List tokens = new ArrayList(6);
    protected ConditionExpr condition;
    protected static final int ROWLIKE = 1;
    protected static final int COLLIKE = 2;
    private int type = 0;

    protected CheckExpressionParser(String expr) {
        this._line = expr;
        this._pos = 0;
        this._end = expr.length();
    }

    protected void parse() throws ParseException {
        char c = '\uffff';
        while ((c = (char)this.next()) != '\uffff') {
            if (c == '\"' || c == '\'') {
                this.skipString(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                this.skipWhitespace();
                continue;
            }
            if (c == '[') {
                this.readSite();
                continue;
            }
            if (c != 123) continue;
            this.readContidion();
        }
    }

    private void readSite() throws ParseException {
        char c = '\uffff';
        int start = this._pos;
        SiteExpr site = null;
        this.skipWhitespace();
        do {
            if ((c = (char)this.next()) == '\uffff') {
                throw new ParseException("Except punctuation ] at " + this._pos);
            }
            if (c == ']') {
                throw new ParseException("Except number or letter at " + this._pos);
            }
            if (!CheckExpressionParser.isNumberOrLetter(c)) {
                throw new ParseException("Except number or letter at " + this._pos);
            }
            if (!CheckExpressionParser.isNumber(c)) continue;
            this.testType(1);
            this.readNumbers();
            String s = this._line.substring(start, this._pos);
            site = new RowExpr();
            site.start = start - 1;
            site.index = Integer.parseInt(s.trim()) - 1;
            site.end = this._pos + 1;
            this.tokens.add(site);
            return;
        } while (!CheckExpressionParser.isLetter(c));
        this.testType(2);
        this.readLetters();
        String s = this._line.substring(start, this._pos);
        site = new ColExpr();
        site.start = start - 1;
        site.end = this._pos + 1;
        ((ColExpr)site).index = TableToolkit.pos2int(s);
        this.tokens.add(site);
    }

    private void readContidion() throws ParseException {
        char c = '\uffff';
        this.condition = new ConditionExpr();
        this.condition.start = this._pos - 1;
        this.skipWhitespace();
        while (true) {
            if ((c = (char)this.next()) == '|') {
                this.readExclude();
                continue;
            }
            if (!CheckExpressionParser.isNumberOrLetter(c)) break;
            this.unget();
            this.readInclude();
        }
        if (c == '}') {
            this.condition.end = this._pos;
            return;
        }
        throw new ParseException("Except punctuation } at " + this._pos);
    }

    private void readInclude() throws ParseException {
        int c = 65535;
        int start = this._pos;
        do {
            if ((c = (int)this.next()) != 65535) continue;
            throw new ParseException("Except punctuation } at " + this._pos);
        } while (c != 124 && c != 125);
        this.unget();
        String s = this._line.substring(start, this._pos);
        this.parseCondition(s, this.condition.includeRange);
    }

    private void parseCondition(String s, List list) throws ParseException {
        String[] toks = s.split(",");
        for (int i = 0; i < toks.length; ++i) {
            String tok = toks[i];
            String[] ts = tok.split(":");
            if (ts.length > 2) {
                throw new ParseException("Unexcepted punctuation : at " + this._pos);
            }
            RangeExpr r = new RangeExpr();
            String st = ts[0].trim();
            String ed = null;
            if (ts.length == 2) {
                ed = ts[1];
            }
            ed = ed != null ? ed.trim() : st;
            list.add(r);
            if (st.length() < 1 && ed.length() < 1) {
                return;
            }
            if (CheckExpressionParser.isLetter(st.charAt(0))) {
                this.testType(1);
                r.startRange = new ColExpr();
                ((ColExpr)r.startRange).index = TableToolkit.pos2int(st);
                if (((ColExpr)r.startRange).index == -1) {
                    throw new ParseException("Expect letter at " + this._pos);
                }
            } else if (CheckExpressionParser.isNumber(st.charAt(0))) {
                this.testType(2);
                r.startRange = new RowExpr();
                try {
                    ((RowExpr)r.startRange).index = Integer.parseInt(st.trim()) - 1;
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Expect number at " + this._pos);
                }
            }
            if (CheckExpressionParser.isLetter(ed.charAt(0))) {
                this.testType(1);
                r.endRange = new ColExpr();
                ((ColExpr)r.endRange).index = TableToolkit.pos2int(ed);
                if (((ColExpr)r.endRange).index != -1) continue;
                throw new ParseException("Expect letter at " + this._pos);
            }
            if (!CheckExpressionParser.isNumber(st.charAt(0))) continue;
            this.testType(2);
            r.endRange = new RowExpr();
            try {
                ((RowExpr)r.endRange).index = Integer.parseInt(ed.trim()) - 1;
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParseException("Expect number at " + this._pos);
            }
        }
    }

    private void readExclude() throws ParseException {
        int c = 65535;
        int start = this._pos;
        do {
            if ((c = (int)this.next()) != 65535) continue;
            throw new ParseException("Expect punctuation } at " + this._pos);
        } while (c != 125);
        this.unget();
        String s = this._line.substring(start, this._pos);
        this.parseCondition(s, this.condition.excludeRange);
    }

    private void readNumbers() throws ParseException {
        char c = '\uffff';
        while (CheckExpressionParser.isNumber(c = (char)this.next())) {
        }
        if (CheckExpressionParser.isPunction(c)) {
            this.unget();
            return;
        }
        if (Character.isWhitespace(c)) {
            this.skipWhitespace();
            return;
        }
        throw new ParseException("Expect number at " + this._pos);
    }

    private void readLetters() throws ParseException {
        char c = '\uffff';
        c = this.next();
        if (!CheckExpressionParser.isLetter(c)) {
            if (CheckExpressionParser.isPunction(c)) {
                this.unget();
                return;
            }
            if (Character.isWhitespace(c)) {
                this.skipWhitespace();
                return;
            }
            throw new ParseException("Expect letter at " + this._pos);
        }
    }

    private static final boolean isPunction(char c) {
        return c == '[' || c == ']' || c == ',' || c == '|' || c == ':' || c == '|' || c == '{' || c == '}';
    }

    private static final boolean isNumberOrLetter(char c) {
        return CheckExpressionParser.isLetter(c) || CheckExpressionParser.isNumber(c);
    }

    public static final boolean isLetter(char c) {
        return Character.isLowerCase(c) || Character.isUpperCase(c);
    }

    public static final boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private char next() {
        if (this._pos < this._end) {
            return this._line.charAt(this._pos++);
        }
        this._pos = this._end;
        return '\uffff';
    }

    private void skipString(char c2) throws ParseException {
        char c;
        do {
            if ((c = this.next()) != '\uffff') continue;
            throw new ParseException("Expect punctuation \" at " + this._pos);
        } while (c != c2 || this._line.charAt(this._pos - 1) == '\\');
    }

    private void skipWhitespace() {
        char c;
        do {
            if ((c = this.next()) != '\uffff') continue;
            return;
        } while (Character.isWhitespace(c));
        this.unget();
    }

    public void unget() {
        --this._pos;
    }

    public static void main(String[] args) throws ParseException {
        String expr = "[a]+[c]=[e]{1:22|1,5,8}";
        CheckExpressionParser p = new CheckExpressionParser(expr);
        p.parse();
        for (int i = 0; i < p.tokens.size(); ++i) {
            SiteExpr siteExpr = (SiteExpr)p.tokens.get(i);
        }
    }

    public boolean testType(int type2) throws ParseException {
        if (this.type == 0) {
            this.type = type2;
        } else if (this.type != type2) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"74_CheckExpressionParser");
            throw new ParseException(MessageFormat.format(msg, msg));
        }
        return true;
    }

    protected int getType() {
        return this.type;
    }

    class RangeExpr
    extends BaseExpr {
        SiteExpr startRange;
        SiteExpr endRange;

        RangeExpr() {
        }

        public String toString() {
            if (this.startRange == null && this.endRange == null) {
                return "";
            }
            if (this.startRange == null) {
                return this.endRange.toString();
            }
            if (this.endRange == null) {
                return this.startRange.toString();
            }
            return this.startRange.toString() + ":" + this.endRange.toString();
        }
    }

    class ConditionExpr
    extends BaseExpr {
        List includeRange;
        List excludeRange;

        ConditionExpr() {
            this.includeRange = new ArrayList(5);
            this.excludeRange = new ArrayList(5);
        }

        public String toString() {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            for (i = 0; i < this.includeRange.size(); ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(this.includeRange.get(i).toString());
            }
            for (i = 0; i < this.excludeRange.size(); ++i) {
                if (i != 0) {
                    sb.append(',');
                } else {
                    sb.append('|');
                }
                sb.append(this.excludeRange.get(i).toString());
            }
            sb.append('}');
            return sb.toString();
        }

        public boolean isEmpty() {
            return this.includeRange.size() < 1 && this.excludeRange.size() < 1;
        }
    }

    class ColExpr
    extends SiteExpr {
        ColExpr() {
        }

        public String toString() {
            return TableToolkit.int2pos(this.index);
        }
    }

    class RowExpr
    extends SiteExpr {
        RowExpr() {
        }

        public String toString() {
            return String.valueOf(this.index);
        }
    }

    abstract class SiteExpr
    extends BaseExpr {
        protected int index;

        SiteExpr() {
        }
    }

    abstract class BaseExpr {
        int start;
        int end;

        BaseExpr() {
        }
    }
}

