/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.excelformula;

import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.AreaExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.EmptyArgExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NameExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NumberExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.ptg.AddPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.Area3DPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.AreaPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.BoolPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.ConcatPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.DividePtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.EmptyArgPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.EqualPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.FuncVarPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.GreaterEqualPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.GreaterThanPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.IntPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.LessEqualPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.LessThanPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.MultiplyPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.NamePtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.NotEqualPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.NumberPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.OperationPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.PercentPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.PowerPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.Ptg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.Ref3DPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.ReferencePtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.StringPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.SubtractPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.UnaryMinusPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.UnaryPlusPtg;
import java.util.List;
import java.util.Stack;

public class ExcelFormulaParser {
    private final List tokens;

    public ExcelFormulaParser(List tokens) {
        this.tokens = tokens;
    }

    public Expression parse() throws Exception {
        if (this.tokens == null || 0 == this.tokens.size()) {
            return null;
        }
        Stack<Object> stack = new Stack<Object>();
        int numPtgs = this.tokens.size();
        for (int i = 0; i < numPtgs; ++i) {
            Ptg p;
            Expression e;
            Object object = this.tokens.get(i);
            if (object instanceof OperationPtg) {
                if (object instanceof AddPtg) {
                    this.buildBinaryOp(stack, 7);
                    continue;
                }
                if (object instanceof SubtractPtg) {
                    this.buildBinaryOp(stack, 8);
                    continue;
                }
                if (object instanceof MultiplyPtg) {
                    this.buildBinaryOp(stack, 5);
                    continue;
                }
                if (object instanceof DividePtg) {
                    this.buildBinaryOp(stack, 6);
                    continue;
                }
                if (object instanceof PowerPtg) {
                    this.buildBinaryOp(stack, 4);
                    continue;
                }
                if (object instanceof LessEqualPtg) {
                    this.buildBinaryOp(stack, 13);
                    continue;
                }
                if (object instanceof EqualPtg) {
                    this.buildBinaryOp(stack, 10);
                    continue;
                }
                if (object instanceof LessThanPtg) {
                    this.buildBinaryOp(stack, 14);
                    continue;
                }
                if (object instanceof NotEqualPtg) {
                    this.buildBinaryOp(stack, 15);
                    continue;
                }
                if (object instanceof GreaterEqualPtg) {
                    this.buildBinaryOp(stack, 11);
                    continue;
                }
                if (object instanceof GreaterThanPtg) {
                    this.buildBinaryOp(stack, 12);
                    continue;
                }
                if (object instanceof ConcatPtg) {
                    this.buildBinaryOp(stack, 9);
                    continue;
                }
                if (object instanceof FuncVarPtg) {
                    FunctionExpr bop = new FunctionExpr(((FuncVarPtg)object).getName());
                    int numOperands = ((FuncVarPtg)object).getNumberOfOperands();
                    for (int j = 0; j < numOperands; ++j) {
                        bop.parameters.add(0, stack.pop());
                    }
                    stack.push(bop);
                    continue;
                }
                if (!(object instanceof UnaryMinusPtg) && !(object instanceof UnaryPlusPtg) && !(object instanceof PercentPtg)) continue;
                Expression expr = (Expression)stack.pop();
                int type = 3;
                if (object instanceof UnaryPlusPtg) {
                    type = 1;
                } else if (object instanceof UnaryMinusPtg) {
                    type = 2;
                } else if (object instanceof PercentPtg) {
                    type = 3;
                }
                UnaryOperationExpr e2 = new UnaryOperationExpr(type);
                e2.operand = expr;
                stack.push(e2);
                continue;
            }
            if (object instanceof IntPtg) {
                e = new IntExpr();
                e.value = ((IntPtg)object).getValue();
                stack.push(e);
                continue;
            }
            if (object instanceof NumberPtg) {
                e = new NumberExpr(((NumberPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof StringPtg) {
                e = new StringExpr(((StringPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof BoolPtg) {
                e = new BoolExpr(((BoolPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof AreaPtg) {
                p = (AreaPtg)object;
                AreaExpr exp = new AreaExpr(((AreaPtg)p).getFirstRow(), ((AreaPtg)p).getFirstColumn(), ((AreaPtg)p).getLastRow(), ((AreaPtg)p).getLastColumn());
                exp.setFirstColRel(((AreaPtg)p).isFirstColRelative());
                exp.setLastColRel(((AreaPtg)p).isLastColRelative());
                exp.setFirstRowRel(((AreaPtg)p).isFirstRowRelative());
                exp.setLastRowRel(((AreaPtg)p).isLastRowRelative());
                stack.push((Object)exp);
                continue;
            }
            if (object instanceof ReferencePtg) {
                p = (ReferencePtg)object;
                ReferenceExpr exp = new ReferenceExpr();
                exp.col = ((ReferencePtg)p).getColumn();
                exp.row = ((ReferencePtg)p).getRow();
                exp.setColRel(((ReferencePtg)p).isColRelative());
                exp.setRowRel(((ReferencePtg)p).isRowRelative());
                stack.push((Object)exp);
                continue;
            }
            if (object instanceof Area3DPtg) {
                p = (Area3DPtg)object;
                Area3DExpr exp = new Area3DExpr();
                exp.sheetName = ((Area3DPtg)p).getSheetName();
                AreaExpr area = new AreaExpr(((Area3DPtg)p).getFirstRow(), ((Area3DPtg)p).getFirstColumn(), ((Area3DPtg)p).getLastRow(), ((Area3DPtg)p).getLastColumn());
                area.setFirstColRel(((Area3DPtg)p).isFirstColRelative());
                area.setLastColRel(((Area3DPtg)p).isLastColRelative());
                area.setFirstRowRel(((Area3DPtg)p).isFirstRowRelative());
                area.setLastRowRel(((Area3DPtg)p).isLastRowRelative());
                exp.area = area;
                stack.push((Object)exp);
                continue;
            }
            if (object instanceof Ref3DPtg) {
                p = (Ref3DPtg)object;
                Ref3DExpr expr = new Ref3DExpr();
                expr.sheetName = ((Ref3DPtg)p).getSheetName();
                ReferenceExpr ref = new ReferenceExpr();
                ref.row = ((Ref3DPtg)p).getRow();
                ref.col = ((Ref3DPtg)p).getColumn();
                ref.setColRel(((Ref3DPtg)p).isColRelative());
                ref.setRowRel(((Ref3DPtg)p).isRowRelative());
                expr.ref = ref;
                stack.push((Object)expr);
                continue;
            }
            if (object instanceof NamePtg) {
                stack.push((Object)new NameExpr(((NamePtg)object).getText()));
                continue;
            }
            if (!(object instanceof EmptyArgPtg)) continue;
            stack.push((Object)new EmptyArgExpr());
        }
        return (Expression)stack.pop();
    }

    public void buildBinaryOp(Stack stack, int type) {
        BinaryOperationExpr bop = new BinaryOperationExpr(type);
        bop.right = (Expression)stack.pop();
        bop.left = (Expression)stack.pop();
        stack.push(bop);
    }
}

