/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.jdbc;

import com.kingdee.eas.fi.rpt.jdbc.JdbcUtils;
import com.kingdee.eas.fi.rpt.jdbc.RowMapper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ColumnMapRowMapper
implements RowMapper {
    @Override
    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        Map mapOfColValues = this.createColumnMap(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String key = this.getColumnKey(rsmd.getColumnName(i));
            Object obj = this.getColumnValue(rs, i);
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    protected Map createColumnMap(int columnCount) {
        return new LinkedHashMap(columnCount);
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index);
    }
}

