/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.jdbc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.jdbc.BatchPreparedStatementSetter;
import com.kingdee.eas.fi.rpt.jdbc.ColumnMapRowMapper;
import com.kingdee.eas.fi.rpt.jdbc.ConnectionCallback;
import com.kingdee.eas.fi.rpt.jdbc.ConnectionProxy;
import com.kingdee.eas.fi.rpt.jdbc.JdbcOperations;
import com.kingdee.eas.fi.rpt.jdbc.PreparedStatementCallback;
import com.kingdee.eas.fi.rpt.jdbc.PreparedStatementCreator;
import com.kingdee.eas.fi.rpt.jdbc.PreparedStatementSetter;
import com.kingdee.eas.fi.rpt.jdbc.ResultReader;
import com.kingdee.eas.fi.rpt.jdbc.ResultSetExtractor;
import com.kingdee.eas.fi.rpt.jdbc.RowCallbackHandler;
import com.kingdee.eas.fi.rpt.jdbc.RowMapper;
import com.kingdee.eas.fi.rpt.jdbc.RowMapperResultReader;
import com.kingdee.eas.fi.rpt.jdbc.SingleColumnRowMapper;
import com.kingdee.eas.fi.rpt.jdbc.SqlProvider;
import com.kingdee.eas.fi.rpt.jdbc.SqlRowSetResultSetExtractor;
import com.kingdee.eas.fi.rpt.jdbc.StatementCallback;
import com.kingdee.eas.fi.rpt.jdbc.StatementCreatorUtils;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class JdbcTemplate
implements JdbcOperations {
    private static Logger logger = Logger.getLogger(JdbcTemplate.class);
    protected Context ctx;
    protected Connection connection;
    private int fetchSize = 0;
    private int maxRows = 0;

    public JdbcTemplate() {
    }

    public JdbcTemplate(Context ctx) {
        this.setContext(ctx);
    }

    public Context getContext() {
        return this.ctx;
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public Object execute(ConnectionCallback action) throws BOSException {
        Object object;
        Connection con = null;
        try {
            Connection conToUse = null;
            conToUse = this.connection == null ? (con = EJBFactory.getConnection((Context)this.ctx)) : this.connection;
            object = action.doInConnection(conToUse);
        }
        catch (SQLException ex) {
            try {
                throw new SQLDataException(ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        return object;
    }

    protected Connection createConnectionProxy(Connection con) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(con));
    }

    @Override
    public Object execute(StatementCallback action) throws BOSException {
        Object object;
        Connection con = null;
        Statement stmt = null;
        try {
            Object result;
            Connection conToUse = null;
            conToUse = this.connection == null ? (con = EJBFactory.getConnection((Context)this.ctx)) : this.connection;
            stmt = conToUse.createStatement();
            this.applyStatementSettings(stmt);
            object = result = action.doInStatement(stmt);
        }
        catch (SQLException ex) {
            try {
                throw new SQLDataException(ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        return object;
    }

    @Override
    public void execute(final String sql) throws BOSException {
        DebugLogger.info(logger, "Executing SQL statement", "[" + sql + "]");
        class ExecuteStatementCallback
        implements StatementCallback,
        SqlProvider {
            ExecuteStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException {
                stmt.execute(sql);
                return null;
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        this.execute(new ExecuteStatementCallback());
    }

    @Override
    public Object query(final String sql, final ResultSetExtractor rse) throws BOSException {
        DebugLogger.info(logger, "Executing SQL statement", "[" + sql + "]");
        class QueryStatementCallback
        implements StatementCallback,
        SqlProvider {
            QueryStatementCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doInStatement(Statement stmt) throws SQLException {
                try {
                    ResultSet rs = stmt.executeQuery(sql);
                    Object object = rse.extractData(rs);
                    return object;
                }
                finally {
                    SQLUtils.cleanup((Statement)stmt);
                }
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return this.execute(new QueryStatementCallback());
    }

    @Override
    public List query(String sql, RowCallbackHandler rch) throws BOSException {
        return (List)this.query(sql, (ResultSetExtractor)new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public List query(String sql, RowMapper rowMapper) throws BOSException {
        return this.query(sql, (RowCallbackHandler)new RowMapperResultReader(rowMapper));
    }

    @Override
    public Map queryForMap(String sql) throws BOSException {
        return (Map)this.queryForObject(sql, this.getColumnMapRowMapper());
    }

    @Override
    public Object queryForObject(String sql, RowMapper rowMapper) throws BOSException {
        int size;
        List results = this.query(sql, rowMapper);
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        return results.iterator().next();
    }

    @Override
    public Object queryForObject(String sql, Class requiredType) throws BOSException {
        return this.queryForObject(sql, this.getSingleColumnRowMapper(requiredType));
    }

    @Override
    public long queryForLong(String sql) throws BOSException {
        Number number = (Number)this.queryForObject(sql, Long.class);
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public int queryForInt(String sql) throws BOSException {
        Number number = (Number)this.queryForObject(sql, Integer.class);
        return number != null ? number.intValue() : 0;
    }

    @Override
    public List queryForList(String sql, Class elementType) throws BOSException {
        return this.query(sql, this.getSingleColumnRowMapper(elementType));
    }

    @Override
    public List queryForList(String sql) throws BOSException {
        return this.query(sql, this.getColumnMapRowMapper());
    }

    @Override
    public IRowSet queryForRowSet(String sql, Object[] args, int[] argTypes) throws BOSException {
        return (IRowSet)this.query(sql, args, argTypes, new SqlRowSetResultSetExtractor());
    }

    @Override
    public IRowSet queryForRowSet(String sql, Object[] args) throws BOSException {
        return (IRowSet)this.query(sql, args, (ResultSetExtractor)new SqlRowSetResultSetExtractor());
    }

    @Override
    public int update(final String sql) throws BOSException {
        DebugLogger.info(logger, "Executing SQL statement", "[" + sql + "]");
        class UpdateStatementCallback
        implements StatementCallback,
        SqlProvider {
            UpdateStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException {
                int rows = 0;
                try {
                    rows = stmt.executeUpdate(sql);
                }
                catch (SQLException e) {
                    logger.debug((Object)e.getMessage());
                }
                DebugLogger.info(logger, "SQL update affected", "[" + rows + "]");
                return new Integer(rows);
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return (Integer)this.execute(new UpdateStatementCallback());
    }

    @Override
    public int[] batchUpdate(final String[] sql) throws BOSException {
        DebugLogger.info(logger, "", "Executing SQL batch update of " + sql.length + " statements");
        class BatchUpdateStatementCallback
        implements StatementCallback,
        SqlProvider {
            private String currSql;

            BatchUpdateStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException {
                int[] rowsAffected = new int[sql.length];
                for (int i = 0; i < sql.length; ++i) {
                    this.currSql = sql[i];
                    stmt.addBatch(sql[i]);
                }
                rowsAffected = stmt.executeBatch();
                return rowsAffected;
            }

            @Override
            public String getSql() {
                return this.currSql;
            }
        }
        return (int[])this.execute(new BatchUpdateStatementCallback());
    }

    @Override
    public Object execute(PreparedStatementCreator psc, PreparedStatementCallback action) throws BOSException {
        Object object;
        Connection con = null;
        PreparedStatement ps = null;
        try {
            Object result;
            Connection conToUse = null;
            conToUse = this.connection == null ? (con = EJBFactory.getConnection((Context)this.ctx)) : this.connection;
            ps = psc.createPreparedStatement(conToUse);
            this.applyStatementSettings(ps);
            object = result = action.doInPreparedStatement(ps);
        }
        catch (SQLException ex) {
            try {
                throw new SQLDataException(ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return object;
    }

    @Override
    public Object execute(String sql, PreparedStatementCallback action) throws BOSException {
        return this.execute(new SimplePreparedStatementCreator(sql), action);
    }

    public Object query(PreparedStatementCreator psc, final PreparedStatementSetter pss, final ResultSetExtractor rse) throws BOSException {
        String sql = null;
        if (DebugLogger.isDebug) {
            sql = JdbcTemplate.getSql(psc);
            DebugLogger.info(logger, "Executing SQL query", "[" + sql + "]");
        }
        long time = System.currentTimeMillis();
        Object result = this.execute(psc, new PreparedStatementCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                Object object;
                ResultSet rs = null;
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    rs = ps.executeQuery();
                    object = rse.extractData(rs);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs);
                return object;
            }
        });
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog((Context)this.ctx, (String)sql, (Object[])pss.getArgs(), (long)(System.currentTimeMillis() - time));
        }
        return result;
    }

    @Override
    public Object query(PreparedStatementCreator psc, ResultSetExtractor rse) throws BOSException {
        return this.query(psc, null, rse);
    }

    @Override
    public Object query(String sql, PreparedStatementSetter pss, ResultSetExtractor rse) throws BOSException {
        return this.query(new SimplePreparedStatementCreator(sql), pss, rse);
    }

    @Override
    public Object query(String sql, Object[] args, int[] argTypes, ResultSetExtractor rse) throws BOSException {
        return this.query(sql, (PreparedStatementSetter)new ArgTypePreparedStatementSetter(args, argTypes), rse);
    }

    @Override
    public Object query(String sql, Object[] args, ResultSetExtractor rse) throws BOSException {
        return this.query(sql, (PreparedStatementSetter)new ArgPreparedStatementSetter(args), rse);
    }

    @Override
    public List query(PreparedStatementCreator psc, RowCallbackHandler rch) throws BOSException {
        return (List)this.query(psc, (ResultSetExtractor)new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public List query(String sql, PreparedStatementSetter pss, RowCallbackHandler rch) throws BOSException {
        return (List)this.query(sql, pss, (ResultSetExtractor)new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public List query(String sql, Object[] args, int[] argTypes, RowCallbackHandler rch) throws BOSException {
        return this.query(sql, (PreparedStatementSetter)new ArgTypePreparedStatementSetter(args, argTypes), rch);
    }

    @Override
    public List query(String sql, Object[] args, RowCallbackHandler rch) throws BOSException {
        return this.query(sql, (PreparedStatementSetter)new ArgPreparedStatementSetter(args), rch);
    }

    @Override
    public List query(PreparedStatementCreator psc, RowMapper rowMapper) throws BOSException {
        return this.query(psc, (RowCallbackHandler)new RowMapperResultReader(rowMapper));
    }

    @Override
    public List query(String sql, PreparedStatementSetter pss, RowMapper rowMapper) throws BOSException {
        return this.query(sql, pss, (RowCallbackHandler)new RowMapperResultReader(rowMapper));
    }

    @Override
    public List query(String sql, Object[] args, int[] argTypes, RowMapper rowMapper) throws BOSException {
        return this.query(sql, args, argTypes, new RowMapperResultReader(rowMapper));
    }

    @Override
    public List query(String sql, Object[] args, RowMapper rowMapper) throws BOSException {
        return this.query(sql, args, (RowCallbackHandler)new RowMapperResultReader(rowMapper));
    }

    @Override
    public Object queryForObject(String sql, Object[] args, int[] argTypes, RowMapper rowMapper) throws BOSException {
        int size;
        List results = this.query(sql, args, argTypes, new RowMapperResultReader(rowMapper, 1));
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        return results.iterator().next();
    }

    @Override
    public Object queryForObject(String sql, Object[] args, RowMapper rowMapper) throws BOSException {
        int size;
        List results = this.query(sql, args, (RowCallbackHandler)new RowMapperResultReader(rowMapper, 1));
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        return results.iterator().next();
    }

    @Override
    public Object queryForObject(String sql, Object[] args, int[] argTypes, Class requiredType) throws BOSException {
        return this.queryForObject(sql, args, argTypes, this.getSingleColumnRowMapper(requiredType));
    }

    @Override
    public Object queryForObject(String sql, Object[] args, Class requiredType) throws BOSException {
        return this.queryForObject(sql, args, this.getSingleColumnRowMapper(requiredType));
    }

    @Override
    public Map queryForMap(String sql, Object[] args, int[] argTypes) throws BOSException {
        return (Map)this.queryForObject(sql, args, argTypes, this.getColumnMapRowMapper());
    }

    @Override
    public Map queryForMap(String sql, Object[] args) throws BOSException {
        return (Map)this.queryForObject(sql, args, this.getColumnMapRowMapper());
    }

    @Override
    public long queryForLong(String sql, Object[] args, int[] argTypes) throws BOSException {
        Number number = (Number)this.queryForObject(sql, args, argTypes, Long.class);
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, Object[] args) throws BOSException {
        Number number = (Number)this.queryForObject(sql, args, Long.class);
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public int queryForInt(String sql, Object[] args, int[] argTypes) throws BOSException {
        Number number = (Number)this.queryForObject(sql, args, argTypes, Integer.class);
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, Object[] args) throws BOSException {
        Number number = (Number)this.queryForObject(sql, args, Integer.class);
        return number != null ? number.intValue() : 0;
    }

    @Override
    public List queryForList(String sql, Object[] args, int[] argTypes, Class elementType) throws BOSException {
        return this.query(sql, args, argTypes, this.getSingleColumnRowMapper(elementType));
    }

    @Override
    public List queryForList(String sql, Object[] args, Class elementType) throws BOSException {
        return this.query(sql, args, this.getSingleColumnRowMapper(elementType));
    }

    @Override
    public List queryForList(String sql, Object[] args, int[] argTypes) throws BOSException {
        return this.query(sql, args, argTypes, this.getColumnMapRowMapper());
    }

    @Override
    public List queryForList(String sql, Object[] args) throws BOSException {
        return this.query(sql, args, this.getColumnMapRowMapper());
    }

    protected int update(PreparedStatementCreator psc, final PreparedStatementSetter pss) throws BOSException {
        if (DebugLogger.isDebug) {
            String sql = JdbcTemplate.getSql(psc);
            DebugLogger.info(logger, "Executing SQL update", "[" + sql + "]");
        }
        Integer result = (Integer)this.execute(psc, new PreparedStatementCallback(){

            @Override
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                if (pss != null) {
                    pss.setValues(ps);
                }
                int rows = ps.executeUpdate();
                if (DebugLogger.isDebug) {
                    DebugLogger.info(logger, "SQL update affected " + rows + " rows");
                }
                return new Integer(rows);
            }
        });
        return result;
    }

    @Override
    public int update(PreparedStatementCreator psc) throws BOSException {
        return this.update(psc, (PreparedStatementSetter)null);
    }

    @Override
    public int update(String sql, PreparedStatementSetter pss) throws BOSException {
        return this.update(new SimplePreparedStatementCreator(sql), pss);
    }

    @Override
    public int update(String sql, Object[] args, int[] argTypes) throws BOSException {
        return this.update(sql, (PreparedStatementSetter)new ArgTypePreparedStatementSetter(args, argTypes));
    }

    @Override
    public int update(String sql, Object[] args) throws BOSException {
        return this.update(sql, (PreparedStatementSetter)new ArgPreparedStatementSetter(args));
    }

    @Override
    public int[] batchUpdate(String sql, final BatchPreparedStatementSetter pss) throws BOSException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing SQL batch update [" + sql + "]"));
        }
        return (int[])this.execute(sql, new PreparedStatementCallback(){

            @Override
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                int batchSize = pss.getBatchSize();
                for (int i = 0; i < batchSize; ++i) {
                    pss.setValues(ps, i);
                    ps.addBatch();
                }
                return ps.executeBatch();
            }
        });
    }

    protected RowMapper getColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected RowMapper getSingleColumnRowMapper(Class requiredType) {
        return new SingleColumnRowMapper(requiredType);
    }

    protected void applyStatementSettings(Statement stmt) throws SQLException {
        int maxRows;
        int fetchSize = this.getFetchSize();
        if (fetchSize > 0) {
            stmt.setFetchSize(fetchSize);
        }
        if ((maxRows = this.getMaxRows()) > 0) {
            stmt.setMaxRows(maxRows);
        }
    }

    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rch) {
            this.rch = rch;
        }

        @Override
        public Object extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                this.rch.processRow(rs);
            }
            if (this.rch instanceof ResultReader) {
                return ((ResultReader)this.rch).getResults();
            }
            return null;
        }
    }

    private static class ArgTypePreparedStatementSetter
    implements PreparedStatementSetter {
        private final Object[] args;
        private final int[] argTypes;

        public ArgTypePreparedStatementSetter(Object[] args, int[] argTypes) throws BOSException {
            if (args != null && argTypes == null || args == null && argTypes != null || args != null && args.length != argTypes.length) {
                throw new BOSException("args and argTypes parameters must match");
            }
            this.args = args;
            this.argTypes = argTypes;
        }

        @Override
        public void setValues(PreparedStatement ps) throws SQLException {
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    StatementCreatorUtils.setParameterValue(ps, i + 1, this.argTypes[i], null, this.args[i]);
                }
            }
        }

        @Override
        public Object[] getArgs() {
            return this.args;
        }
    }

    private static class ArgPreparedStatementSetter
    implements PreparedStatementSetter {
        private final Object[] args;

        public ArgPreparedStatementSetter(Object[] args) {
            this.args = args;
        }

        @Override
        public void setValues(PreparedStatement ps) throws SQLException {
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    StatementCreatorUtils.setParameterValue(ps, i + 1, Integer.MIN_VALUE, null, this.args[i]);
                }
            }
        }

        @Override
        public Object[] getArgs() {
            return this.args;
        }
    }

    private static class SimplePreparedStatementCreator
    implements PreparedStatementCreator,
    SqlProvider {
        private final String sql;

        public SimplePreparedStatementCreator(String sql) {
            this.sql = sql;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            return con.prepareStatement(this.sql);
        }

        @Override
        public String getSql() {
            return this.sql;
        }
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Statement) {
                    JdbcTemplate.this.applyStatementSettings((Statement)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

